; Lorna Ellis
; 1/8/2006
; This must be run in SolarSoft IDL


PRO science_overview
COMMON share1, read_whole_file, start_time, stop_time, time_st, plot_dir, esa, energy, ind_pha, cdf_base, cdf_id, epoch_info, epoch, error1, esa_st, channel_st

num_bins = [4, 2, 8, 8, 16, 1, 16, 1, 1, 1, 4, 1]

openr, settings_lun, "science_overview.settings", /GET_LUN

line = " "
readf, settings_lun, line     ; read past first line

; read bin limits and find bins
readf, settings_lun, line
limit_filename = line
read_limits, limit_filename, num_bins, limits

; read classification constants
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
constants_filename = line
read_constants, constants_filename, a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d2, e_max, e_min, $
                mass_max, mass_min, mq_max, mq_min, n_max, nq_max, t_max, t_min
find_bins_dpu, limits, num_bins, mass_max, mass_min, mq_max, mq_min, n_max, nq_max, $
           bins, mass_low_bound, mq_low_bound

; get file for energy lookup 
readf, settings_lun, line 
readf, settings_lun, line 
readf, settings_lun, line 
energy_file = line

; get PAC
readf, settings_lun, line 
readf, settings_lun, line 
pac = 0
readf, settings_lun, PAC 

; get plot directory
readf, settings_lun, line 
readf, settings_lun, line 
plot_dir = ' '
readf, settings_lun, plot_dir

; get whether to read from maui
readf, settings_lun, line 
readf, settings_lun, line 
read_from_maui = -1
readf, settings_lun, read_from_maui
IF read_from_maui NE 0 AND read_from_maui NE 1 THEN print, "ERROR: Invalid value for whether to read from maui."

; if not reading from maui, get cdf dir
readf, settings_lun, line 
readf, settings_lun, line 
cdf_dir = ' '
readf, settings_lun, cdf_dir

; get ind_pha (flag for memory problems)
readf, settings_lun, line 
readf, settings_lun, line 
ind_pha = 0
readf, settings_lun, ind_pha
IF ind_pha NE 0 AND ind_pha NE 1 THEN print, 'Error reading ind_pha'

; read individual file data
FOR ii = 0, 9 DO BEGIN 
    readf, settings_lun, line 
ENDFOR 
readf, settings_lun, line 
parts = strsplit(line, /extract, count = count)
WHILE count GT 0 DO BEGIN 
    IF n_elements(full_lines) EQ 0 THEN full_lines = [line] ELSE full_lines = [full_lines, line]
    IF eof(settings_lun) EQ 0 THEN BEGIN 
        readf, settings_lun, line 
        parts = strsplit(line, /extract, count = count)    
    ENDIF ELSE count = 0
ENDWHILE
; parse them
num_cdf = n_elements(full_lines)
cdfs = strarr(num_cdf)
esas = intarr(num_cdf)
read_whole_files = intarr(num_cdf)
start_times = dblarr(num_cdf)
stop_times = dblarr(num_cdf)
time_sts = strarr(num_cdf)
channels = intarr(num_cdf)
cycles = intarr(num_cdf)
FOR ii = 0, num_cdf-1 DO BEGIN 
    line = full_lines[ii]
    parts = strsplit(line, /extract, count = count)
    IF count NE 8 THEN BEGIN 
        print, 'Error: invalid num arguments in line: ', line
        stop
    ENDIF 
    sat = parts[0]
    year = fix(parts[1])
    doy = fix(parts[2])
    daytim = doy2ex(doy, year)
    IF read_from_maui EQ 1 THEN cdf_dir = '/mauidata1/Spacecraft_'+sat+'/Level1/CDFs/'+parts[1]
    cdf_prefix = cdf_dir+'/ST'+sat+'_L1_PLA_'+parts[1]+string(daytim[5], format = '(I2.2)')+string(daytim[4], format = '(I2.2)')+'_'+string(doy, format = '(I3.3)')+'_V'
    more = 1 
    version = 99                ; largest expected version number
    file_found = 0
    WHILE (more EQ 1) AND (version GT 0) DO BEGIN ; stop looking if there isn't a version 1 file
        file_string = cdf_prefix+string(version, format = '(I2.2)')+'.cdf'
        file_found = file_test(file_string, /read) ; returns 1 if file exists
        IF file_found EQ 1 THEN BEGIN
            more = 0            ; the most recent version has been found, stop looking for lower version numbers
        ENDIF ELSE BEGIN
            version = version - 1 ; try the next lower version number
        ENDELSE 
    ENDWHILE
    IF file_found EQ 0 THEN print, 'Missing file ', file_string ELSE cdfs[ii] = file_string
    esas[ii] = fix(parts[3])
    start_time_st = parts[4]
    IF start_time_st EQ '-1' THEN read_whole_files[ii] = 1 ELSE BEGIN 
        start_times[ii] = anytim2cdf(start_time_st)
        stop_times[ii] = anytim2cdf(parts[5])
        time_sts[ii] = '_'+strmid(start_time_st, 11, 8)+'_'+strmid(parts[5], 11, 8)
    ENDELSE 
    channels[ii] = fix(parts[6])
    cycles[ii] = fix(parts[7])
ENDFOR 

; close settings file
close, settings_lun
free_lun, settings_lun


; loop through files
FOR ii = 0, num_cdf-1 DO BEGIN
    cdf = cdfs[ii]
    esa = esas[ii]
    IF esa EQ -1 THEN esa_st = '' ELSE BEGIN 
        esa_st = '_'+string(esa, format = '(I3.3)')
        find_energy, esa, energy_file, energy
    ENDELSE 
    read_whole_file = read_whole_files[ii]
    IF read_whole_file EQ 0 THEN BEGIN 
        start_time = start_times[ii]
        stop_time = stop_times[ii]
        time_st = time_sts[ii]
    ENDIF ELSE time_st = ''
    channel = channels[ii]
    CASE channel OF 
        0: channel_st = '_m'
        1: channel_st = '_s'
        2: channel_st = '_b'
        ELSE: print, 'error, invalid channel:', channel
    ENDCASE 
    cdf_base = file_basename(cdf, '.cdf')
    file_found = file_test(cdf, /read) ; returns 1 if file exists
    IF file_found EQ 1 THEN BEGIN 
        cdf_id = cdf_open(cdf)
        cdf_control, cdf_id, get_var_info = epoch_info, var = 'epoch1', /zvariable
        IF epoch_info.maxrec GE 0 THEN BEGIN 
            cdf_varget, cdf_id, 'epoch1', epoch, rec_count = epoch_info.maxrec, /zvariable
            cdf_control, cdf_id, get_var_info = error1_info, var = 'error1', /zvariable
            IF error1_info.maxrec NE epoch_info.maxrec THEN print, "Error with error1_info.maxrec"
            cdf_varget, cdf_id, 'error1', error1, rec_count = epoch_info.maxrec, /zvariable
            plot_pha_cdf, limits, bins, num_bins, a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d2, $
                      e_max, e_min, mass_max, mass_min, t_max, t_min, $
                      pac, mass_low_bound, mq_low_bound
            print, "finished plot_pha"
            plot_contours_cdf
                                ; now look for proton cdf
            temp1 = strmid(cdf, 0, strlen(cdf)-20)
            temp2 = strmid(cdf, strlen(cdf)-20, 20)    
            clcdf = temp1+'CL_'+temp2
            clcdf_base = file_basename(clcdf, '.cdf')
            file_found = file_test(clcdf, /read) ; returns 1 if file exists
            IF file_found EQ 1 THEN BEGIN 
                clcdf_id = cdf_open(clcdf)
                plot_proton_mode_cdf, clcdf_base, clcdf_id
                plot_classification_cdf, clcdf_id, channel, limits ; keep this last, alters epoch
                cdf_close, clcdf_id
                temp_string = 'finished '+clcdf_base
                print, temp_string
            ENDIF ELSE print, "File not found. ", clcdf
        ENDIF 
        temp_string = 'finished '+full_lines[ii]
        print, temp_string
        cdf_close, cdf_id
    ENDIF ELSE print, "File not found. ", cdf
ENDFOR 

END
