; Lorna Ellis
; Jan. 10, 2007
; read_pha_ind.pro
; 02/24/2007 Now have count in each place, not just 1

PRO read_pha_ind, valid_pha, full_bins, full_num_bins, $
                  a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d2, e_max, e_min, mass_max, mass_min, t_max, t_min, $
                  pac, mass_low_bound, mq_low_bound, n, counts_raw, swpha_raw, wappha_ssd_raw, wappha_nossd_raw, $
                  supranoe_ssd_raw, supranoe_nossd_raw, suprawide_raw, swz_raw, swhalpha_raw
; in:  valid_pha     : array (9 x num valid events)
;      full_bins     : array of limits as bins (12 x 16 x 5)
;      full_num_bins : array (size 12) of num bins per category
;      a1            : constant from file
;      a2            : constant from file
;      a3            : constant from file
;      a4            : constant from file
;      a5            : constant from file
;      a6            : constant from file
;      a_e           : constant from file
;      a_t           : constant from file
;      b_e           : constant from file
;      b_t           : constant from file
;      c2            : constant from file
;      d             : constant from file
;      d1            : constant from file
;      d2            : constant from file
;      e_max         : constant from file
;      e_min         : constant from file
;      mass_max      : constant from file
;      mass_min      : constant from file
;      t_max         : constant from file
;      t_min         : constant from file
;      pac           : from settings file
;      mass_low_bound: from find_bins
;      mq_low_bound  : from find_bins
;      n             : num graphs
; out: counts_raw         : [n,16] each plot, counts per bin (not all used)
;      swpha_raw          : (4, 1000, 1000, 4) priority, 1000 x 1000, each bin (not all used)
;      wappha_ssd_raw     : (4, 1000, 1000, 4)
;      wappha_nossd_raw   : (4, 1000, 1000, 2)
;      supranoe_ssd_raw   : (4, 1000, 1000, 8)
;      supranoe_nossd_raw : (4, 1000, 1000, 8)
;      suprawide_raw      : (4, 1000, 1000, 16)
;      swz_raw            : (4, 1000, 1000, 16)
;      swhalpha_raw       : (4, 1000, 1000, 4)
COMMON share1

;data_raw = FLTARR(n, 4, 1000, 1000, 16)  ; each plot, priority, 1000 x 1000, each bin (not all used)
swpha_raw = fltarr(4, 1000, 1000, 4)
wappha_ssd_raw = fltarr(4, 1000, 1000, 4)
wappha_nossd_raw = fltarr(4, 1000, 1000, 2)
supranoe_ssd_raw = fltarr(4, 1000, 1000, 8)
supranoe_nossd_raw = fltarr(4, 1000, 1000, 8)
suprawide_raw = fltarr(4, 1000, 1000, 16)
swz_raw = fltarr(4, 1000, 1000, 16)
swhalpha_raw = fltarr(4, 1000, 1000, 4)
counts_raw = FLTARR(n, 16)               ; each plot, counts per bin (not all used)

FOR ii = 0L, n_elements(valid_pha[0, *])-1 DO BEGIN 
    swpe     = long(valid_pha[0, ii])      ; convert to a long
    swpd     = long(valid_pha[1, ii])
    quadrant = long(valid_pha[2, ii]) ; no-SSD half has PHA quadrants 3 & 4
    ssd_id   = long(valid_pha[3, ii])
    ssde_un  = long(valid_pha[4, ii])
    tof      = long(valid_pha[5, ii])
    position = long(valid_pha[6, ii])
    section  = long(valid_pha[7, ii])
    priority = long(valid_pha[8, ii])
    IF section EQ 3 THEN half = 1L ELSE half = 0L

; Calculate NQ table
; Convert time channels (Tch) to nanoseconds (Tns)
    tns =  tof * a_t + b_t      ; Tch is TOF
; Convert E/Q steps to keV
    s = 127 - swpe
    e_per_q =  d1 * d2^s
; Calculate Mass per charge for each T -- E/Q pair
    c1 = (4.38E7)^2/(1E9)^2/d^2
    m_per_q = c1 * (pac + e_per_q - c2) * (tns)^2
    IF half EQ 0 THEN m_per_q = m_per_q * 0.525626 ; SSD 5.8^2 / 8^2 for different flight path
; get bin 
    bin = 0
    IF half EQ 0 THEN mq_index = 1 ELSE mq_index = 0  
    while (bin gt -1) and (bin lt 255) do begin
        if m_per_q ge mq_low_bound[mq_index, bin] and m_per_q le mq_low_bound[mq_index, bin+1] then begin
            nq = bin
            bin = -1
        endif else bin = bin + 1
    endwhile
    if bin eq 255 then begin
        nq = bin
    endif

; Calculate NM 
; Convert uncompressed energy channel to keV
    e_meas = ssde_un*a_e + b_e
; Calculate mass
    x = alog(e_meas)
    y = alog(tns)
    mass = EXP(a1 + a2*X + a3*y + a4*x*y + a5*x^2 + a6*y^3)
; Convert to a bin number
    if e_meas le e_min then bin = 0 $ ; get bin
    else if e_meas ge e_max then bin = 93 $
         else if tns le t_min then bin = 94 $
              else if tns ge t_max then bin = 95 $
                   else if mass ge mass_max then bin = 91 $
                        else IF mass le mass_min then bin = 92 $
                             else begin
        found = 0
        bin = 1
        while found eq 0 do begin
            if mass ge mass_low_bound[bin] and mass le mass_low_bound[bin+1] then begin
                found = 1
            endif else bin = bin + 1
        endwhile
        if found eq 0 then print, 'Error determining mass for ssde, tof', ssde_com, tof
    ENDELSE 
    nm = bin

; Calculate the bin_dat_word
; Create bin_dat_words
    value = 0L
    find_bindatword2, half, nm, nq, full_bins, full_num_bins, pha_pri, supra_no_e, supra_wide, swz2, sw_all, $
                      sw_h_alpha, bin_dat_word
    bin = bin_dat_word

; find address that will be incremented.
; If no address, then bin won't be incremented.
; Addresses end in 0, but the corresponding address that ends in 1
; also needs to be checked.
; First find POS (*not* position)
    IF section EQ 0 OR section EQ 1 THEN POS = position - 16 $
    ELSE BEGIN
        IF quadrant EQ 0 THEN POS = (ishft(position, -3) AND '3'X) $
        ELSE POS = (ishft((quadrant AND '1'X), 2) OR (ishft(position, -4) AND '3'X))
    ENDELSE 
; pha_pri_addr
    IF (section AND '2'X) EQ 0 THEN pha_pri_addr = ('2F00'X OR (ishft((pha_pri AND '3'X), 6)) OR $
                                                    (ishft((swpd AND '1F'X), 1))) $
    ELSE pha_pri_addr = ('3200'X OR (ishft((pha_pri AND '1'X), 2)) OR (ishft((section AND '1'X), 1)))
; supra_no_e_addr
    IF ((section AND '2'X) EQ 0) OR (supra_no_e EQ '7'X) THEN supra_no_e_addr = 0 $
    ELSE supra_no_e_addr = ('3100'X OR (ishft((supra_no_e AND '7'X), 5)) OR (ishft((POS AND '7'X), 2)) $
                            OR (ishft((section AND '1'), 1)))
; supra_wide_addr
    IF (section NE 2) OR (supra_wide EQ 'F'X) THEN supra_wide_addr = 0 $
    ELSE supra_wide_addr = ('3000'X OR (ishft((supra_wide AND 'F'X), 4)) OR (ishft((POS AND '7'X), 1)))
;swz2_addr
    IF ((section AND '2'X) EQ 2) OR (swz2 EQ 'F'X) THEN swz2_addr = 0 $
    ELSE swz2_addr = ('2000'X OR (ishft((swz2 AND 'F'X), 8)) OR (ishft((POS AND '1E'X), 3)) $
                      OR (ishft((swpd AND '1C'X), -1)))
; sw_all_addr
    IF ((section AND '2'X) EQ 2) OR (sw_all EQ 1) THEN sw_all_addr = 0 $
    ELSE sw_all_addr = ('1800'X OR (ishft((POS AND '1F'X), 6)) OR (ishft((swpd AND '1F'X), 1)))
;sw_h_alpha_addr
    IF ((section AND '2'X) EQ 2) OR (sw_h_alpha EQ 3) THEN sw_h_alpha_addr = 0  $
    ELSE sw_h_alpha_addr = ((ishft((sw_h_alpha AND '3'X), 11)) OR (ishft((POS AND '1F'X), 6)) $
                            OR (ishft((swpd AND '1F'X), 1)))

; collect data for plotting
    IF esa EQ -1 OR swpe EQ esa OR (swpe-128) EQ esa THEN BEGIN 
        plot_mass = round(mass*10)
        IF plot_mass LT 0 THEN plot_mass = 2
        IF plot_mass GE 1000 THEN plot_mass = 999
        plot_m_q = round(m_per_q*10)
        IF plot_m_q GE 1000 THEN plot_m_q = 999
        IF half EQ 0 THEN BEGIN ; SSD
            IF section EQ 2 THEN BEGIN ; Wap SSD
                pha_pri_msb = ISHFT(pha_pri, -1) ; get MSB of pha_pri
                IF pha_pri_addr NE 0 THEN $
                  wappha_ssd_raw[priority, plot_m_q, plot_mass, (pha_pri_msb*2)] = $ ; index 0&1 for bin 0, 2&3 for bin 1
                    wappha_ssd_raw[priority, plot_m_q, plot_mass, (pha_pri_msb*2)] + 1
                IF pha_pri_addr NE 0 THEN wappha_ssd_raw[priority, plot_m_q, plot_mass, (pha_pri_msb*2)+1] =  $
                  wappha_ssd_raw[priority, plot_m_q, plot_mass, (pha_pri_msb*2)+1] + 1
                IF pha_pri_addr NE 0 THEN counts_raw[1, (pha_pri_msb*2)] = counts_raw[1, (pha_pri_msb*2)] + 1
                IF pha_pri_addr NE 0 THEN counts_raw[1, (pha_pri_msb*2)+1] = counts_raw[1, (pha_pri_msb*2)+1] + 1
            ENDIF ELSE BEGIN
                IF pha_pri_addr NE 0 THEN swpha_raw[priority, plot_m_q, plot_mass, pha_pri] = $
                  swpha_raw[priority, plot_m_q, plot_mass, pha_pri] + 1
                IF pha_pri_addr NE 0 THEN counts_raw[0, pha_pri] = counts_raw[0, pha_pri] + 1
            ENDELSE 
            IF supra_no_e_addr NE 0 THEN supranoe_ssd_raw[priority, plot_m_q, plot_mass, supra_no_e] = $
              supranoe_ssd_raw[priority, plot_m_q, plot_mass, supra_no_e] + 1
            IF supra_wide_addr NE 0 THEN suprawide_raw[priority, plot_m_q, plot_mass, supra_wide] = $
              suprawide_raw[priority, plot_m_q, plot_mass, supra_wide] + 1
            IF swz2_addr       NE 0 THEN swz_raw[priority, plot_m_q, plot_mass, swz2] = $
              swz_raw[priority, plot_m_q, plot_mass, swz2] + 1
            IF sw_h_alpha_addr NE 0 THEN swhalpha_raw[priority, plot_m_q, plot_mass, sw_h_alpha] = $
              swhalpha_raw[priority, plot_m_q, plot_mass, sw_h_alpha] + 1
            IF supra_no_e_addr NE 0 THEN counts_raw[3, supra_no_e] = counts_raw[3, supra_no_e] + 1
            IF supra_wide_addr NE 0 THEN counts_raw[5, supra_wide] = counts_raw[5, supra_wide] + 1
            IF swz2_addr       NE 0 THEN counts_raw[6, swz2] = counts_raw[6, swz2] + 1
            IF sw_h_alpha_addr NE 0 THEN counts_raw[7, sw_h_alpha] = counts_raw[7, sw_h_alpha] + 1
        ENDIF ELSE BEGIN        ; non-SSD
            IF section EQ 3 THEN BEGIN ; Wap noSSD
                pha_pri_msb = ISHFT(pha_pri, -1) ; get MSB of pha_pri
                IF pha_pri_addr    NE 0 THEN wappha_nossd_raw[priority, plot_m_q, plot_mass, pha_pri_msb] = $
                  wappha_nossd_raw[priority, plot_m_q, plot_mass, pha_pri_msb] + 1
                IF pha_pri_addr    NE 0 THEN counts_raw[2, pha_pri_msb] = counts_raw[2, pha_pri_msb] + 1
            ENDIF ELSE BEGIN 
                IF pha_pri_addr    NE 0 THEN wappha_nossd_raw[priority, plot_m_q, plot_mass, pha_pri] = $
                  wappha_nossd_raw[priority, plot_m_q, plot_mass, pha_pri] + 1
                IF pha_pri_addr    NE 0 THEN counts_raw[2, pha_pri] = counts_raw[2, pha_pri] + 1
            ENDELSE 
            IF supra_no_e_addr NE 0 THEN supranoe_nossd_raw[priority, plot_m_q, plot_mass, supra_no_e] = $
              supranoe_nossd_raw[priority, plot_m_q, plot_mass, supra_no_e] + 1
            IF supra_no_e_addr NE 0 THEN counts_raw[4, supra_no_e] = counts_raw[4, supra_no_e] + 1
        ENDELSE 
    ENDIF 
ENDFOR 
print, "finished reading individual pha"
END 
