; Lorna Ellis
; Jan. 10, 2007
; read_pha_data.pro

; 01/25/07 Added limit by esa.

PRO read_pha_data, valid_pha, temp_epoch
; out: valid_pha : array[9, num_valid_pha]
COMMON share1

cdf_control, cdf_id, get_var_info = pha_info, var = 'pha', /zvariable
IF pha_info.maxrec NE epoch_info.maxrec THEN print, "Error with pha_info.maxrec"
cdf_varget, cdf_id, 'pha', pha, rec_count = epoch_info.maxrec, /zvariable

; limit by esa
IF esa NE -1 THEN BEGIN 
    unwanted_index = where(pha[*, 0, *] NE esa, count)
    IF count GT 0 THEN BEGIN 
        unwanted2 = array_indices(pha[*, 0, *], unwanted_index)
        FOR ii = 0L, count-1 DO BEGIN 
            pha[unwanted2[0, ii], *, unwanted2[2, ii]] = -1 
        ENDFOR 
    ENDIF 
ENDIF 

; remove error cases
valid_index = where(error1 EQ 0, count) 
temp_epoch = epoch
IF count GT 0 THEN BEGIN 
    temp_epoch = temp_epoch[valid_index]
    pha = pha[*, *, valid_index]
ENDIF 

IF read_whole_file EQ 0 THEN BEGIN 
    time_found = where(temp_epoch GE start_time AND temp_epoch LE stop_time, count)
    IF count GT 0 THEN BEGIN 
        temp_epoch = temp_epoch[time_found]
        pha = pha[*, *, time_found]
    ENDIF 
ENDIF 

; remove fill
temp_data = reform(pha[*, 0, *])
valid = where(temp_data NE -1, valid_count)
IF valid_count GT 0 THEN BEGIN 
    valid_2 = array_indices(temp_data, valid)
    valid_pha = intarr(9, valid_count)
    FOR ii = 0L, valid_count-1 DO BEGIN 
        valid_pha[*, ii]= pha[valid_2[0, ii], *, valid_2[1, ii]]
    ENDFOR 
ENDIF ELSE valid_pha = intarr(9, 1)

END 
