; Lorna Ellis
; 2/9/05
; read_limits.pro
; This reads in the limits for the bins for classification

; in : file_name: the name of the limit file
;      num_bins : array (size 12) with the number of bins for each category
; out: limits   : an array for the limits 
;                 [rate, bin_num(as index), (bin_num, m/q min, m/q max, mass min, mass max)]


PRO read_limits, file_name, num_bins, limits

; read in bounds for bin_dat_word
openr, binfile_lun, file_name, /get_lun
line = " "
readf, binfile_lun, line   ; read past header
readf, binfile_lun, line

limits = FLTARR(12, 16, 5)

FOR i = 0, 11 DO BEGIN ; number of rates
    readf, binfile_lun, line    ; read rate title
    FOR j = 0, num_bins[i]-1 DO BEGIN 
        readf, binfile_lun, line
        parts = strsplit(line, /EXTRACT)
        FOR k = 0, 4 DO BEGIN 
            limits[i, j, k] = parts[k] 
        ENDFOR 
    ENDFOR 
ENDFOR 
print, 'Finished reading input files'
close, binfile_lun
free_lun, binfile_lun
END 
