; Lorna Ellis
; 2/10/05
; read_constants.pro

; This reads the constants associated with classification
; in : constants_filename: the name of the file from which to read
;                          constants
; out: a1                : used for finding ln(M)
;      a2                : used for finding ln(M)
;      a3                : used for finding ln(M)
;      a4                : used for finding ln(M)
;      a5                : used for finding ln(M)
;      a6                : used for finding ln(M)
;      a_e                : Emeas = Eun * A + B
;      a_t                : Tns = Tch * A + B
;      b_e                : Emeas = Eun * A + B
;      b_t                : Tns = Tch * A + B
;      c2                : M/q = C1 * [PAC + (E/q)-C2]*Tns^2
;      d                 : C1 = f(d) -- d = flight path in cm (but not in SSD)
;      d1                : E/q = D1 * D2^S
;      d_2                : E/q = D1 * D2^S
;      e_max              : keV -- for binning Nm
;      e_min              : keV -- for binning Nm
;      mass_max              : for finding the bins for Mass
;      mass_min              : for finding the bins for Mass
;      mq_max             : for finding the bins for Mass/Charge
;      mq_min             : for finding the bins for Mass/Charge
;      n_max              : for finding the bins for Mass
;      nq_max             : for finding the bins for Mass/Charge
;      t_max              : nsec -- for binning Nm
;      t_min              : nsec -- for binning Nm

; 3/23/05 Removed c2b
; 3/22/05 Added c2b for when m/q >= 11

PRO read_constants, constants_filename, a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d_2, e_max, e_min, $
                    mass_max, mass_min, mq_max, mq_min, n_max, nq_max, t_max, t_min

; read in constants
openr, infile_lun, constants_filename, /get_lun
lines = strarr(24)       ; there are 24 lines of constants
names = strarr(24)
const_val = strarr(24)
line = ''
readf, infile_lun, line  ; read past comment line
for i = 0, 23 do begin
    readf, infile_lun, line
    lines[i] = line
    parts = str_sep(strcompress(line), ' ')
    names[i] = parts[0]
    const_val[i] = parts[1]
endfor
IF names[0]  NE 'A1'    THEN print, 'ERROR, did not read a1'       ELSE a1       = float(const_val[0])
IF names[1]  NE 'A2'    THEN print, 'ERROR, did not read a2'       ELSE a2       = float(const_val[1])
IF names[2]  NE 'A3'    THEN print, 'ERROR, did not read a3'       ELSE a3       = float(const_val[2])
IF names[3]  NE 'A4'    THEN print, 'ERROR, did not read a4'       ELSE a4       = float(const_val[3])
IF names[4]  NE 'A5'    THEN print, 'ERROR, did not read a5'       ELSE a5       = float(const_val[4])
IF names[5]  NE 'A6'    THEN print, 'ERROR, did not read a6'       ELSE a6       = float(const_val[5])
IF names[6]  NE 'Ae'    THEN print, 'ERROR, did not read a_e'      ELSE a_e      = float(const_val[6])
IF names[7]  NE 'At'    THEN print, 'ERROR, did not read a_t'      ELSE a_t      = float(const_val[7])
IF names[8]  NE 'Be'    THEN print, 'ERROR, did not read b_e'      ELSE b_e      = float(const_val[8])
IF names[9]  NE 'Bt'    THEN print, 'ERROR, did not read b_t'      ELSE b_t      = float(const_val[9])
IF names[10] NE 'C2'    THEN print, 'ERROR, did not read c2'       ELSE c2       = float(const_val[10])
IF names[11] NE 'd'     THEN print, 'ERROR, did not read d'        ELSE d        = float(const_val[11])
IF names[12] NE 'D1'    THEN print, 'ERROR, did not read d1'       ELSE d1       = float(const_val[12])
IF names[13] NE 'D2'    THEN print, 'ERROR, did not read d_2'      ELSE d_2      = float(const_val[13])
IF names[14] NE 'Emax'  THEN print, 'ERROR, did not read e_max'    ELSE e_max    = float(const_val[14])
IF names[15] NE 'Emin'  THEN print, 'ERROR, did not read e_min'    ELSE e_min    = float(const_val[15])
IF names[16] NE 'Mmax'  THEN print, 'ERROR, did not read mass_max' ELSE mass_max = float(const_val[16])
IF names[17] NE 'Mmin'  THEN print, 'ERROR, did not read mass_min' ELSE mass_min = float(const_val[17])
IF names[18] NE 'MQmax' THEN print, 'ERROR, did not read mq_max'   ELSE mq_max   = float(const_val[18])
IF names[19] NE 'MQmin' THEN print, 'ERROR, did not read mq_min'   ELSE mq_min   = float(const_val[19])
IF names[20] NE 'NMAX'  THEN print, 'ERROR, did not read n_max'    ELSE n_max    = float(const_val[20])
IF names[21] NE 'NQMAX' THEN print, 'ERROR, did not read nq_max'   ELSE nq_max   = float(const_val[21])
IF names[22] NE 'Tmax'  THEN print, 'ERROR, did not read t_max'    ELSE t_max    = float(const_val[22])
IF names[23] NE 'Tmin'  THEN print, 'ERROR, did not read t_min'    ELSE t_min    = float(const_val[23])
close, infile_lun
free_lun, infile_lun

END 
