; Lorna Ellis
; Jan 9, 2007
; plot_proton_mode_cdf.pro
; 
; Adapted from plot_proton_mode.pro
; This program is similar to plot_contours_dpu, but takes it data from
; apids 328 and 329.

; Feb. 5, 2007. Debugged.

PRO plot_proton_mode_cdf, clcdf_base, clcdf_id
; in : clcdf_base       : base of CDF name (for title)
;      clcdf_id         : file unit
COMMON share1

mydevice = !D.NAME
SET_PLOT, 'PS'
outname = plot_dir+'/protonmode_'+clcdf_base+time_st+esa_st+'.ps'
!NOERAS = 1
DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
loadct,39
xyouts, .1, .96, clcdf_base+time_st, /NORMAL, size = 1.5
esa_string = STRING(esa, FORMAT = '(I3)')
IF esa EQ -1 THEN subtitle = "Protonmode. ESA:"+esa_string ELSE $
  subtitle = "Protonmode. ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
xyouts, .3, .94, subtitle, /NORMAL, size = 1.2

file_sub_array = ['Sw_H', 'Sw_alphaD', 'Sw_alphaT', 'Sw_all']
x_left = [.1, .1, .55, .55]        ; coordinate for left x position
x_right = [.45, .45, .9, .9]
y_bottom = [.6, .16, .6, .16]
y_top = [.9, .46, .9, .46]
data = lonarr(4, 32, 32)        ; numgraphs, position, deflection

; read in data
cdf_control, clcdf_id, get_var_info = clepoch_info, var = 'epoch_classifier', /zvariable
IF clepoch_info.maxrec GE 0 THEN BEGIN 
    ; get epoch
    cdf_varget, clcdf_id, 'epoch_classifier', clepoch, rec_count = clepoch_info.maxrec, /zvariable
    ; get block_id
    cdf_control, clcdf_id, get_var_info = block_id_info, var = 'block_id_classifier', /zvariable
    IF block_id_info.maxrec NE clepoch_info.maxrec THEN print, "Error with block_id_info.maxrec"
    cdf_varget, clcdf_id, 'block_id_classifier', block_id, rec_count = clepoch_info.maxrec, /zvariable
    ; get esa_steps
    cdf_control, clcdf_id, get_var_info = esa_step_info, var = 'esa_step', /zvariable
    IF esa_step_info.maxrec NE clepoch_info.maxrec THEN print, "Error with esa_step_info.maxrec"
    cdf_varget, clcdf_id, 'esa_step', esa_step, rec_count = clepoch_info.maxrec, /zvariable
    ; get data
    cdf_control, clcdf_id, get_var_info = classifier_data_info, var = 'classifier_data', /zvariable
    IF classifier_data_info.maxrec NE clepoch_info.maxrec THEN print, "Error with classifier_data_info.maxrec"
    cdf_varget, clcdf_id, 'classifier_data', classifier_data, rec_count = clepoch_info.maxrec, /zvariable

    IF esa NE -1 THEN BEGIN
        esa_found = where(esa_step EQ esa)
        clepoch = clepoch[esa_found]
        esa_step = esa_step[esa_found]
        classifier_data = classifier_data[esa_found]
    ENDIF 
    IF read_whole_file EQ 0 THEN BEGIN 
        time_found = where(clepoch GE start_time AND clepoch LE stop_time)
        clepoch = clepoch[time_found]
        esa_step = esa_step[time_found]
        classifier_data = classifier_data[time_found]
    ENDIF 

    temp_array = lonarr(32, 4) ; defl x pos, because idl is column major
    FOR ii = 0, 3 DO BEGIN ; for each graph
        CASE ii OF
            0: BEGIN
                temp_index0 = where(block_id EQ '00'x, count0)
                temp_index1 = where(block_id EQ '01'x, count1)
                temp_index2 = where(block_id EQ '02'x, count2)
                temp_index3 = where(block_id EQ '03'x, count3)
                temp_index4 = where(block_id EQ '04'x, count4)
                temp_index5 = where(block_id EQ '05'x, count5)
                temp_index6 = where(block_id EQ '06'x, count6)
                temp_index7 = where(block_id EQ '07'x, count7)
            END 
            1: BEGIN
                temp_index0 = where(block_id EQ '08'x, count0)
                temp_index1 = where(block_id EQ '09'x, count1)
                temp_index2 = where(block_id EQ '0A'x, count2)
                temp_index3 = where(block_id EQ '0B'x, count3)
                temp_index4 = where(block_id EQ '0C'x, count4)
                temp_index5 = where(block_id EQ '0D'x, count5)
                temp_index6 = where(block_id EQ '0E'x, count6)
                temp_index7 = where(block_id EQ '0F'x, count7)
            END 
            2: BEGIN
                temp_index0 = where(block_id EQ '10'x, count0)
                temp_index1 = where(block_id EQ '11'x, count1)
                temp_index2 = where(block_id EQ '12'x, count2)
                temp_index3 = where(block_id EQ '13'x, count3)
                temp_index4 = where(block_id EQ '14'x, count4)
                temp_index5 = where(block_id EQ '15'x, count5)
                temp_index6 = where(block_id EQ '16'x, count6)
                temp_index7 = where(block_id EQ '17'x, count7)
            END 
            3: BEGIN
                temp_index0 = where(block_id EQ '18'x, count0)
                temp_index1 = where(block_id EQ '19'x, count1)
                temp_index2 = where(block_id EQ '1A'x, count2)
                temp_index3 = where(block_id EQ '1B'x, count3)
                temp_index4 = where(block_id EQ '1C'x, count4)
                temp_index5 = where(block_id EQ '1D'x, count5)
                temp_index6 = where(block_id EQ '1E'x, count6)
                temp_index7 = where(block_id EQ '1F'x, count7)
            END 
        ENDCASE
        ;stop                    ; need to check this -- want to sum 
        FOR jj = 0, 7 DO BEGIN ; seven blocks per graph
            CASE jj OF 
                0: temp_index = temp_index0
                1: temp_index = temp_index1
                2: temp_index = temp_index2
                3: temp_index = temp_index3
                4: temp_index = temp_index4
                5: temp_index = temp_index5
                6: temp_index = temp_index6
                7: temp_index = temp_index7
            ENDCASE 
            CASE jj OF 
                0: count = count0
                1: count = count1
                2: count = count2
                3: count = count3
                4: count = count4
                5: count = count5
                6: count = count6
                7: count = count7
            ENDCASE 
            IF count GT 0 THEN BEGIN 
                temp_array1 = total(classifier_data[*, temp_index], 2) ; sum across time, keep as 128 array
                temp_array[*, *] = temp_array1 ; change to 32 x 4 array
                data[ii, (jj*4):(jj*4+3), *] = transpose(temp_array) ; change to 4 x 32
            ENDIF 
        ENDFOR 
    ENDFOR 
ENDIF 

max = lonarr(4)
FOR ii = 0, 3 DO BEGIN 
    max[ii] = max(data[ii, *, *])
ENDFOR 

; plot data
FOR j = 0, 3 DO BEGIN 
    mytitle = file_sub_array[j]
    myxrange = intarr(2)
    myxrange[0] = 0
    myxrange[1] = 32
    myyrange = intarr(2)
    myyrange[0] = 0
    myyrange[1] = 32
    temp_data = REFORM(data[j, *, *])   ; make 2D array from 3D array
    IF max[j] LE 6 THEN BEGIN 
        PLOT, data, /NODATA, TITLE = mytitle, XTITLE = 'Position Step', YTITLE = 'Deflection Step', $
              XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, $
              POSITION = [x_left[j], y_bottom[j]+.06, x_right[j], y_top[j]]
        FOR s = 0, 31 DO BEGIN
            FOR t = 0, 31 DO BEGIN
                IF data[j, s, t] NE 0 THEN BEGIN
                    OPLOT, [s], [t], PSYM = data[j, s, t]
                ENDIF
            ENDFOR
        ENDFOR 
        xyouts, x_left[j]+(0*.05), y_bottom[j]-.02, "+:1", /NORMAL
        xyouts, x_left[j]+(0*.05), y_bottom[j]-.04, "*:2", /NORMAL
        xyouts, x_left[j]+(0*.05), y_bottom[j]-.06, ".:3", /NORMAL
        xyouts, x_left[j]+(2*.05), y_bottom[j]-.02, "diamond:4", /NORMAL
        xyouts, x_left[j]+(2*.05), y_bottom[j]-.04, "triangle:5", /NORMAL
        xyouts, x_left[j]+(2*.05), y_bottom[j]-.06, "square :6", /NORMAL
    ENDIF ELSE BEGIN 
        delta = max[j]/3
        CONTOUR, temp_data, /Fill, TITLE = mytitle, XTITLE = 'Position Step', YTITLE = 'Deflection Step', $
                 XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = 4, $
                 C_COLORS = [25, 50, 100, 150], LEVELS = [1, delta, 2*delta, 3*delta+1], $
                 POSITION = [x_left[j], y_bottom[j]+.06, x_right[j], y_top[j]]
        CONTOUR, temp_data, /OVERPLOT, NLEVELS = 4, C_LABELS = [0, 0, 0, 0], $
                 LEVELS = [delta, 2*delta, 3*delta, 4*delta]

        legend_data = fltarr(5, 2)
        myticks = STRARR(5)
        FOR k = 0, 4 DO BEGIN
            FOR l = 0, 1 DO BEGIN
                legend_data[k, l] = (k)*delta
            ENDFOR
            amount = k*delta
            IF amount LE 9999 THEN myticks[k] = STRING(amount, FORMAT = '(F5.0)') ELSE myticks[k] = STRING(amount, FORMAT = '(E7.1)')
        ENDFOR
        myxrange[1] = 4
        myyrange[1] = 1
        CONTOUR, legend_data, /FILL, /NORMAL, TITLE = ' ', XTITLE = 'Number of Counts', $
                 XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = 4, $
                 C_COLORS = [25, 50, 100, 150], LEVELS = [1, delta, 2*delta, 3*delta+1], $
                 YTICKS = 1, YTICKINTERVAL = 5, XTICKNAME = myticks, POSITION = [x_left[j], y_bottom[j], x_right[j], y_top[j]-.28]
    ENDELSE 
ENDFOR

plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
temp_name = outname
command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
spawn, command_string
END 
