; Lorna Ellis
; Jan. 9, 2007
; plot_pha_cdf.pro

; This is a rewrite of plot_pha.pro
; This is meant as part of the make_plots_cdf routine

PRO plot_data, data, plot_name, num_bins, limit_array, mycolors, x_left, x_right, y_bottom, y_top, combo_plot, x_title
; in : data        : the data array: priority, 1000x1000, numbins
;      plot_name   : the prefix of the plot being plotted
;      num_bins    : the number of bins
;      limit_array : the array of limits (16 x 4)
;      mycolors    : array of colors for 4 priorities
;      pos_x_left  : used for setting the plot on the page
;      pos_x_right : used for setting the plot on the page
;      pos_y_bottom: used for setting the plot on the page
;      pos_y_top   : used for setting the plot on the page
;      combo_plot  : 0 if only plot hist for 0 mass, 1 if also have
;                    full plot, 2 if no hist
;      x_title     : title for x axis for histogram

myxrange = lonarr(2)
myxrange[0] = 1
myxrange[1] = 1000
myyrange = lonarr(2)
myyrange[0] = 1
myyrange[1] = 1000

; histograms
IF combo_plot LT 2 THEN BEGIN 
    temp_data1 = reform(data[*, *, 2, *])
    temp_data = total(temp_data1, 3)
    myyrange[1] = MAX(temp_data)
    FOR i = 0, num_bins-1 DO BEGIN 
        IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .2 ; check for -2 in mass
        IF limit_array[i, 2] EQ -1 THEN BEGIN ; check for -1 in mass
            IF limit_array[i, 3] NE -1 THEN BEGIN
                print, "Error with limits"
            ENDIF 
            limit_array[i, 2] = .2
        ENDIF
        IF limit_array[i, 0] EQ -1 THEN BEGIN ; check for -1 in m/q
            IF limit_array[i, 1] NE -1 THEN BEGIN
                print, "Error with limits"
            ENDIF 
            limit_array[i, 0] = .5
            limit_array[i, 1] = 99
        ENDIF
    ENDFOR 
    IF combo_plot EQ 0 THEN BEGIN
        temp_title = plot_name 
        temp_y_top = y_top
    ENDIF ELSE BEGIN 
        temp_title = '  '
        temp_y_top = y_top-.13
    ENDELSE 
    plot, temp_data, /nodata, xrange = myxrange, yrange = myyrange, xstyle = 5, ystyle = 4, /ylog, /xlog, ytick_get = y_ticks
    y_ticklabels = strarr(n_elements(y_ticks))
    IF combo_plot EQ 1 THEN BEGIN 
        y_ticklabels[0] = string(y_ticks[0], format = '(E8.2)')
        FOR ii = 1, n_elements(y_ticks)-2 DO BEGIN 
            y_ticklabels[ii] = ' '
        ENDFOR
        y_ticklabels[n_elements(y_ticks)-1] = string(y_ticks[n_elements(y_ticks)-1], format = '(E8.2)')
    ENDIF ELSE BEGIN 
        FOR ii = 0, n_elements(y_ticks)-1 DO BEGIN 
            y_ticklabels[ii] = ''
        ENDFOR
    ENDELSE 
    PLOT, temp_data, /NODATA, TITLE = temp_title, XTITLE = x_title, YTITLE = 'Count', $
          XRANGE = myxrange, YRANGE = myyrange, xstyle = 1, $
          XTICKNAME = ['0.1', '1.0', '10.0', '100.0'], ytickname = y_ticklabels, BACKGROUND = 255, COLOR = 0, $
          POSITION = [x_left, y_bottom+.025, x_right, temp_y_top], /xlog, /ylog

    FOR j = 0, 3 DO BEGIN       ; priorities
        oplot, temp_data[j, *], color = mycolors[j]
    ENDFOR 
    FOR i = 0, num_bins-1 DO BEGIN
        IF limit_array[i, 2] EQ .2 THEN BEGIN 
            OPLOT, [limit_array[i, 0]*10, limit_array[i, 0]*10], [1, myyrange[1]]
            OPLOT, [limit_array[i, 1]*10, limit_array[i, 1]*10], [1, myyrange[1]]
        ENDIF 
    ENDFOR 
ENDIF 

IF combo_plot GT 0 THEN BEGIN ; point plot
    myyrange[1] = 1000
    IF combo_plot EQ 1 THEN temp_y_bottom = y_top-.14 ELSE temp_y_bottom = y_bottom + .025
    IF combo_plot EQ 1 THEN temp_x_style = 5 ELSE temp_x_style = 9 ; skip x axis if combo plot
    IF combo_plot EQ 1 THEN temp_y_ticks = ['  ', '1.0', '10.0', '100.0'] ELSE temp_y_ticks = ['0.1', '1.0', '10.0', '100.0']
    PLOT, data, /NODATA, TITLE = plot_name, XTITLE = ' ', YTITLE = 'Mass', $
          XRANGE = myxrange, YRANGE = myyrange, XSTYLE = temp_x_style,  YSTYLE = 9, /XLOG, /YLOG, $
          XTICKNAME = ['  ', '  ', '  ', '  '], YTICKNAME = temp_y_ticks, BACKGROUND = 255, COLOR = 0, $
          POSITION = [x_left, temp_y_bottom, x_right, y_top]
    data[*, *, 2, *] = 0 ; get rid of counts with 0 mass

    FOR j = 0, 3 DO BEGIN       ; priorities
        non_zero = WHERE(reform(data[j, *, *, *]), num_non_zero)
        FOR i = 0L, num_non_zero-1 DO BEGIN 
            temp_index = non_zero[i]
            temp_z = temp_index / 1000000
            temp_xy = temp_index MOD 1000000
            temp_y = temp_xy / 1000
            temp_x = temp_xy MOD 1000
            OPLOT, [temp_x], [temp_y], PSYM = 1, COLOR = mycolors[j]
        ENDFOR 
    ENDFOR 
    FOR i = 0, num_bins-1 DO BEGIN 
        IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .2 ; check for -2 in mass
        IF limit_array[i, 3] EQ -2 THEN limit_array[i, 3] = .5
        IF limit_array[i, 2] EQ -1 THEN BEGIN ; check for -1 in mass
            IF limit_array[i, 3] NE -1 THEN BEGIN
                print, "Error with limits"
            ENDIF 
            limit_array[i, 2] = .2
            limit_array[i, 3] = 99
        ENDIF
        IF limit_array[i, 0] EQ -1 THEN BEGIN ; check for -1 in m/q
            IF limit_array[i, 1] NE -1 THEN BEGIN
                print, "Error with limits"
            ENDIF 
            limit_array[i, 0] = .5
            limit_array[i, 1] = 99
        ENDIF
        FOR j = 0, 3 DO BEGIN
            IF limit_array[i, j] EQ 100 THEN limit_array[i, j] = 99 ; so see limit on graph
        ENDFOR 
    ENDFOR 
    FOR i = 0, num_bins-1 DO BEGIN
        OPLOT, [limit_array[i, 0]*10, limit_array[i, 1]*10], [limit_array[i, 2]*10, limit_array[i, 2]*10]
        OPLOT, [limit_array[i, 0]*10, limit_array[i, 1]*10], [limit_array[i, 3]*10, limit_array[i, 3]*10]
        OPLOT, [limit_array[i, 0]*10, limit_array[i, 0]*10], [limit_array[i, 2]*10, limit_array[i, 3]*10]
        OPLOT, [limit_array[i, 1]*10, limit_array[i, 1]*10], [limit_array[i, 2]*10, limit_array[i, 3]*10]
    ENDFOR 
ENDIF 

END


PRO plot_data2, file_name, limits, counts, num_bins, pos_x_left, pos_x_right, pos_y_bottom, pos_y_top
; in : file_name   : the prefix of the plot being plotted
;      limits      : the limits array: for each bin, limits 
;      counts      : array: for each bin, the count
;      num_bins    : the number of bins
;      pos_x_left  : used for setting the plot on the page
;      pos_x_right : used for setting the plot on the page
;      pos_y_bottom: used for setting the plot on the page
;      pos_y_top   : used for setting the plot on the page

; change form of data
data2 = FLTARR(1001, 1001)
FOR i = 0, num_bins-1 DO BEGIN
    IF limits[i, 2] EQ -2 THEN limits[i, 2] = .2  ; check for -2 in m/q
    IF limits[i, 3] EQ -2 THEN limits[i, 3] = .5
    IF limits[i, 2] EQ -1 THEN BEGIN            ; check for -1 in m/q
        IF limits[i, 3] NE -1 THEN BEGIN
            print, "Error with limits"
            stop
        ENDIF 
        limits[i, 2] = .2
        limits[i, 3] = 100
    ENDIF
    IF limits[i, 0] EQ -1 THEN BEGIN            ; check for -1 in mass
        IF limits[i, 1] NE -1 THEN BEGIN
            print, "Error with limits"
            stop
        ENDIF 
        limits[i, 0] = .5
        limits[i, 1] = 100
    ENDIF
ENDFOR
FOR i = 1, num_bins DO BEGIN         ; fill each bin, in reverse order (num_bins-i)
    m_q_min = limits[num_bins-i, 0] * 10
    m_q_max = limits[num_bins-i, 1] * 10
    mass_min = limits[num_bins-i, 2] * 10
    mass_max = limits[num_bins-i, 3] * 10
    FOR j = num_bins-i, num_bins-2 DO BEGIN   ; empty any overlapping bins (j+i)
        j_m_q_min = limits[j, 0] * 10
        j_m_q_max = limits[j, 1] * 10
        j_mass_min = limits[j, 2] * 10
        j_mass_max = limits[j, 3] * 10
        FOR k = j_m_q_min, j_m_q_max DO BEGIN
            FOR l = j_mass_min, j_mass_max DO BEGIN
                IF k GE m_q_min AND k LE m_q_max AND l GE mass_min AND l LE mass_max THEN data2[k, l] = 0
            ENDFOR
        ENDFOR
    ENDFOR
    data2[m_q_min:m_q_max, mass_min:mass_max] = counts[num_bins-i] ; fill full array
ENDFOR

; empty "throw-away" bins
counts[num_bins:15] = 0L

; determine the number of levels
level_array = SORT(counts)
temp = -1
num_levels = 0
FOR i = 0, 15 DO BEGIN         ; the data array has size 16 even though not all bins used
    IF (counts[level_array[i]] NE temp) AND (level_array[i] LT num_bins) THEN BEGIN
        num_levels = num_levels + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR
mylevels = LONARR(num_levels)
level = 0
temp = -1
FOR i = 0, 15 DO BEGIN
    IF counts[level_array[i]] NE temp AND level_array[i] LT num_bins THEN BEGIN
        mylevels[level] = counts[level_array[i]]
        level = level + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR

; plot data
mytitle = file_name
myxrange = intarr(2)
myxrange[0] = 1
myxrange[1] = 1000
myyrange = intarr(2)
myyrange[0] = 1
myyrange[1] = 1000
mycolors = FLTARR(num_levels)
FOR i = 0, num_levels-1 DO BEGIN
    mycolors[i] = (i * 250/num_levels) + 10
ENDFOR

;plot axis and first bin
xmin = limits[0, 0] * 10        ; get first min m/q
xmax = limits[0, 1] * 10
ymin = limits[0, 2] * 10
ymax = limits[0, 3] * 10
data3 = FLTARR(xmax-xmin+1, ymax-ymin+1)
data3 = data2[xmin:xmax, ymin:ymax]
x = FLTARR(xmax-xmin+1)
FOR i = 0, xmax-xmin DO BEGIN
    x[i] = xmin + i
ENDFOR
y = FLTARR(ymax-ymin+1)
FOR i = 0, ymax-ymin DO BEGIN
    y[i] = ymin + i
ENDFOR
CONTOUR, data3, x, y, /FILL, TITLE = mytitle, XTITLE = 'Mass/Charge [amu/q]', YTITLE = 'Mass', $
         XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
         C_COLORS = mycolors, LEVELS = mylevels, /XLOG, /YLOG, XTICKNAME = ['0.1', '1.0', '10.0', '100.0'], $
         YTICKNAME = ['0.1', '1.0', '10.0', '100.0'], BACKGROUND = 255, COLOR = 0, $
         POSITION = [pos_x_left, pos_y_bottom+.06, pos_x_right, pos_y_top]

;plot the rest of the bins
FOR j = 1, num_bins-1 DO BEGIN 
    xmin = limits[j, 0] * 10      ; get first min m/q
    xmax = limits[j, 1] * 10
    ymin = limits[j, 2] * 10
    ymax = limits[j, 3] * 10
    data3 = FLTARR(xmax-xmin+1, ymax-ymin+1)
    data3 = data2[xmin:xmax, ymin:ymax]
    x = FLTARR(xmax-xmin+1)
    FOR i = 0, xmax-xmin DO BEGIN
        x[i] = xmin + i
    ENDFOR
    y = FLTARR(ymax-ymin+1)
    FOR i = 0, ymax-ymin DO BEGIN
        y[i] = ymin + i
    ENDFOR
    CONTOUR, data3, x, y, /FILL, /OVERPLOT, NLEVELS = num_levels, $
             C_COLORS = mycolors, LEVELS = mylevels 
ENDFOR

legend_data = intarr(num_levels+1, 2)
legend_levels = intarr(num_levels+1)
myticks = STRARR(num_levels+1)
myticks[0] = STRING(0, FORMAT = '(F4.0)')
FOR k = 0, num_levels DO BEGIN
    legend_data[k, 0:1] = k
    legend_levels[k] = k
    IF k LT num_levels THEN BEGIN 
        IF mylevels[k] LE 9999 THEN myticks[k+1] = STRING(mylevels[k], FORMAT = '(F5.0)') ELSE myticks[k+1] = STRING(mylevels[k], FORMAT = '(E7.1)')
        mylevels[k] = strcompress(mylevels[k], /remove_all)
    ENDIF 
ENDFOR
IF (num_levels GT 4) AND (num_levels LE 8) THEN BEGIN
    FOR k = 0, num_levels-1 DO BEGIN 
        IF (k MOD 2 EQ 1) AND (strlen(myticks[k+1]) GT 4) THEN myticks[k+1] = '  '
    ENDFOR
ENDIF 
IF (num_levels GT 8) THEN BEGIN
    FOR k = 0, num_levels-1 DO BEGIN 
        IF (k MOD 3 NE 0) AND (strlen(myticks[k+1]) GT 4) THEN myticks[k+1] = '  '
    ENDFOR
ENDIF 
myticks[0] = STRING(mylevels[0], FORMAT = '(I5)')
myxrange[0] = 0
myxrange[1] = num_levels
myyrange[0] = 0
myyrange[1] = 1
CONTOUR, legend_data, /FILL, TITLE = ' ', XTITLE = 'Number of Counts', COLOR = 0, $
         XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
         C_COLORS = mycolors, LEVELS = legend_levels, YTICKS = 1, YTICKINTERVAL = 5, $
         XTICKNAME = myticks, XTICKINTERVAL = 1, POSITION = [pos_x_left, pos_y_bottom, pos_x_right, pos_y_top-.135]
END


PRO plot_pha_cdf, full_limits, full_bins, full_num_bins, $
  a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d2, e_max, e_min, mass_max, mass_min, t_max, t_min, $
  pac, mass_low_bound, mq_low_bound
; in:  full_limits   : array of limits as read (12 x 16 x 5) (last 4 are
;                      limits)
;      full_bins     : array of limits as bins (12 x 16 x 5)
;      full_num_bins : array (size 12) of num bins per category
;      a1            : constant from file
;      a2            : constant from file
;      a3            : constant from file
;      a4            : constant from file
;      a5            : constant from file
;      a6            : constant from file
;      a_e           : constant from file
;      a_t           : constant from file
;      b_e           : constant from file
;      b_t           : constant from file
;      c2            : constant from file
;      d             : constant from file
;      d1            : constant from file
;      d2            : constant from file
;      e_max         : constant from file
;      e_min         : constant from file
;      mass_max      : constant from file
;      mass_min      : constant from file
;      t_max         : constant from file
;      t_min         : constant from file
;      pac           : from settings file
;      mass_low_bound: from find_bins
;      mq_low_bound  : from find_bins
COMMON share1

; read pha data
read_pha_data, valid_pha

; pos_tof
plot_names = ['Priority 0', 'Priority 1', 'Priority 2', 'Priority 3']
data = FLTARR(4, 1024, 256)  ; priority, tof, pos (=position_in_quad+(64*quad))

FOR ii = 0L, n_elements(valid_pha[0, *])-1 DO BEGIN
    data[valid_pha[8, ii], valid_pha[5, ii], ((valid_pha[2, ii]*64)+valid_pha[6, ii])] = $
      data[valid_pha[8, ii], valid_pha[5, ii], ((valid_pha[2, ii]*64)+valid_pha[6, ii])] + 1
ENDFOR 

; plot data
mydevice = !D.NAME
SET_PLOT, 'PS'
outname = plot_dir+'/pha_pos_tof_'+cdf_base+time_st+esa_st+'.ps' 
DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
loadct, 39
!NOERAS = 1
file_string = cdf_base+time_st+' PHA data' 
xyouts, .1, .96, file_string, /NORMAL, size = 1.5
esa_string = STRING(esa, FORMAT = '(I3)')
IF esa EQ -1 THEN subtitle = "ESA:"+esa_string ELSE subtitle = "ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
xyouts, .25, .94, subtitle, /NORMAL, size = 1.2
x_left = [.1, .55, .1, .55]
x_right = [.45, .9, .45, .9]
y_bottom = [.55, .55, .1, .1]
y_top = [.9, .9, .45, .45]
FOR i = 0, 3 DO BEGIN ; one plot for each priority
    myxrange = intarr(2)
    myxrange[0] = 0
    myxrange[1] = 1025
    myyrange = fltarr(2)
    myyrange[0] = 0
    myyrange[1] = 257
    temp_data = reform(data[i, *, *])
    header = 'priority '+string(i, format = '(I1)')
    PLOT, data, /nodata, TITLE = header, XTITLE = 'tof', YTITLE = 'Position', XRANGE = myxrange, $
          YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [x_left[i], y_bottom[i], x_right[i], y_top[i]]
    max_value = max(temp_data)
    CASE max_value OF
        0: levels = [1, 1, 1, 1]
        1: levels = [1, 2, 2, 2]
        2: levels = [1, 2, 3, 3] 
        3: levels = [1, 2, 3, 4]
        4: levels = [1, 2, 3, 4]
        ELSE: BEGIN
            levels = lonarr(4)
            levels[0] = 1
            FOR j = 1, 3 DO BEGIN
                levels[j] = long(max_value/4 * j)
            ENDFOR 
        END
    ENDCASE 
    my_colors = intarr(4)
    FOR j = 0, 3 DO BEGIN 
        my_colors[j] = (j*250/4)+25
        temp_string = "<="
        IF j LT 3 THEN BEGIN 
            IF levels[j+1] LE 999 THEN temp_string = temp_string + string(levels[j+1], format = '(I3)') $
            ELSE temp_string = temp_string + string(levels[j+1], format = '(E7.1)')
        ENDIF ELSE BEGIN 
            IF max_value LE 999 THEN temp_string = temp_string + string(max_value, format = '(I3)') $
            ELSE temp_string = temp_string + string(max_value, format = '(E7.1)')
        ENDELSE 
        xyouts, x_left[i]-.05+(.1*j), y_bottom[i]-.05, temp_string, color = my_colors[j], /normal
    ENDFOR 
                
    FOR j = 0, 1023 DO BEGIN 
        FOR k = 0, 255 DO BEGIN
            temp = temp_data[j, k]
            CASE 1 OF
                temp GE levels[0] AND temp LT levels[1]: oplot, [j], [k], psym = 1, color = my_colors[0]
                temp GE levels[1] AND temp LT levels[2]: oplot, [j], [k], psym = 1, color = my_colors[1]
                temp GE levels[2] AND temp LT levels[3]: oplot, [j], [k], psym = 1, color = my_colors[2]
                temp GE levels[3]: oplot, [j], [k], psym = 1, color = my_colors[3]
                ELSE: break
            ENDCASE 
        ENDFOR 
    ENDFOR 
ENDFOR 
temp_data = 0
plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
!NOERAS = 0
temp_name = outname
command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
spawn, command_string
print, "finished pos_tof"

; histograms
plot_names = ['SwPha', 'WapPha_ssd', 'WapPha_nossd', 'SupraNoE_ssd', 'SupraNoE_nossd', 'SupraWide', 'Swz2', 'Sw_H_alpha']
num_bins = [4, 4, 2, 8, 8, 16, 16, 4]
full_limit_index = [0, 0, 1, 2, 3, 4, 6, 10]   ; index for these plots into full_limits array
n = N_ELEMENTS(plot_names)
limits = FLTARR(n, 16, 4)                ; each plot, for each bin level: m/q min, m/q max, mass min, mass max

; find limits for these plots
FOR i = 0, n-1 DO BEGIN 
    FOR j = 0, num_bins[i]-1 DO BEGIN ; for each bin
        FOR k = 0, 3 DO BEGIN         ; min, max, min, max
            limits[i, j, k] = full_limits[full_limit_index[i], j, k+1] ; k+1 because full_limits also has bin label
        ENDFOR
    ENDFOR
ENDFOR 

; plot data
                                ; plot histograms
FOR i = 0, 4 DO BEGIN
    CASE i OF 
        0: outname = plot_dir+'/hist_0-1_'+cdf_base+time_st+esa_st+'.ps' 
        1: outname = plot_dir+'/hist_0-1_y0_'+cdf_base+time_st+esa_st+'.ps' 
        2: outname = plot_dir+'/hist_0-1_n0_'+cdf_base+time_st+esa_st+'.ps' 
        ELSE: outname = plot_dir+'/hist_'+string(i-1, format = '(Z1)')+'_'+cdf_base+time_st+esa_st+'.ps'
    ENDCASE 
    mydevice = !D.NAME
    SET_PLOT, 'PS'
    DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
    loadct, 39
    !NOERAS = 1
    IF i LE 2 THEN file_string = cdf_base+time_st+' Sections 0/1' ELSE file_string = cdf_base+time_st+' Section '+string(i-1, format = '(Z1)')
    xyouts, .1, .96, file_string, /NORMAL, size = 1.5
    esa_string = STRING(esa, FORMAT = '(I3)')
    IF esa EQ -1 THEN subtitle = "ESA:"+esa_string ELSE subtitle = "ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
    IF i EQ 1 THEN subtitle = subtitle+", pos=0"
    IF i EQ 2 THEN subtitle = subtitle+", pos>0"
    xyouts, .25, .94, subtitle, /NORMAL, size = 1.2
    
    ; find right section
    CASE i OF 
        0: index_wanted = where((reform(valid_pha[7, *]) EQ 0) OR (reform(valid_pha[7, *]) EQ 1), count_wanted) 
        1: index_wanted = where(((reform(valid_pha[7, *]) EQ 0) OR (reform(valid_pha[7, *]) EQ 1)) AND $
                              (reform(valid_pha[6, *] EQ 0)), count_wanted) ; sec 0/1, pos == 0
        2: index_wanted = where(((reform(valid_pha[7, *]) EQ 0) OR (reform(valid_pha[7, *]) EQ 1)) AND $
                              (reform(valid_pha[6, *] NE 0)), count_wanted) ; sec 0/1, pos != 0
        ELSE: index_wanted = where(reform(valid_pha[7, *]) EQ i-1, count_wanted)
    ENDCASE 

                                ; tof
    myxrange = intarr(2)
    myxrange[0] = 0
    myxrange[1] = 1025
    myyrange = fltarr(2)
    myyrange[0] = .1
    data = fltarr(4, 1024)      
    FOR jj = 0L, count_wanted-1 DO BEGIN 
        temp_pri = valid_pha[8, index_wanted[jj]]
        temp_tof = valid_pha[5, index_wanted[jj]]
        data[temp_pri, temp_tof] = data[temp_pri, temp_tof] + 1
    ENDFOR 
    temp_index = where(data EQ 0, count)
    IF count GT 0 THEN data[temp_index] = .1
    myyrange[1] = MAX(data)
    PLOT, data, /nodata, TITLE = 'tof Histogram', XTITLE = 'tof', YTITLE = 'Count', XRANGE = myxrange, $
          YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.1, .55, .45, .9], /YLOG
    FOR j = 0, 3 DO BEGIN 
        oplot, data[j, *], color = (j * 250/4)+25
    ENDFOR 
    
                                ; tof vs. ssde
    myyrange[0] = 10
    myyrange[1] = 1200
    data = fltarr(4, 1024, 1024) ; priority, tof, ssde
    FOR jj = 0L, count_wanted-1 DO BEGIN 
        temp_pri = valid_pha[8, index_wanted[jj]]
        temp_tof = valid_pha[5, index_wanted[jj]]
        temp_ssde = valid_pha[4, index_wanted[jj]]
        data[temp_pri, temp_tof, temp_ssde] = data[temp_pri, temp_tof, temp_ssde] + 1
    ENDFOR 
    ; plot top
    dummy = replicate(' ', 7)
    PLOT, data, /NODATA, TITLE = 'tof vs. ssde', YTITLE = 'ssde', XRANGE = myxrange, ystyle = 1, xtickname = dummy, $
          YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.55, .61, .9, .9], /YLOG
    FOR ii = 0, 3 DO BEGIN ; color by priority
        temp_data = reform(data[ii, *, *])
        non_zero = WHERE(temp_data NE 0, num_non_zero)
        FOR j = 0L, num_non_zero-1 DO BEGIN
            temp_index = non_zero[j]
            temp_y = (temp_index / 1024)
            temp_x = temp_index MOD 1024
            IF temp_y EQ 0 THEN temp_y = .1
            OPLOT, [temp_x], [temp_y], PSYM = 1, color = (ii * 250/4)+25
        ENDFOR 
    ENDFOR 
    ; plot bottom, which is hist for when ssde=0
    no_energy = reform(data[*, *, 0]) ; want ssde=0
    temp_index = where(no_energy EQ 0, count)
    IF count GT 0 THEN no_energy[temp_index] = .1
    myyrange[0] = .1
    myyrange[1] = max(no_energy) 
    PLOT, no_energy, /NODATA, XTITLE = 'tof', YTITLE = 'count', yticks = 2, XRANGE = myxrange, $
          YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.55, .55, .9, .6], /YLOG
    FOR j = 0, 3 DO BEGIN ; color by priority
        oplot, no_energy[j, *], color = (j * 250/4)+25
    ENDFOR 

        ; pos
    myxrange[1] = 64
    myyrange[0] = .1
    data = fltarr(4, 64)
    FOR jj = 0L, count_wanted-1 DO BEGIN 
        temp_pri = valid_pha[8, index_wanted[jj]]
        temp_pos = valid_pha[6, index_wanted[jj]]
        data[temp_pri, temp_pos] = data[temp_pri, temp_pos] + 1
    ENDFOR 
    temp_index = where(data EQ 0, count)
    IF count GT 0 THEN data[temp_index] = .1
    myyrange[1] = MAX(data)
    PLOT, data, /nodata, TITLE = 'Position Histogram', XTITLE = 'Position', YTITLE = 'Count', XRANGE = myxrange, $
          YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.55, .1, .9, .45], /YLOG 
    FOR j = 0, 3 DO BEGIN ; color by priority
        oplot, data[j, *], color = (j * 250/4)+25
        xyouts, .25+(j*.1), .02, "+", COLOR = (j * 250/4)+25, /NORMAL
        temp_string = STRING(j)
        xyouts, .215+(j*.1), .02, temp_string, /NORMAL
    ENDFOR

        ; ssde
    mycolors = FLTARR(18)       ; 18 ssd_id values
    FOR j = 0, 17 DO BEGIN
        mycolors[j] = (j * 250/18) + 15
    ENDFOR
    myxrange[0] = 0
    myxrange[1] = 1024          ; was 13250
    myyrange[0] = 0.1
    data = fltarr(18, 1024)  ; ssd_id, ssde
    FOR jj = 0L, count_wanted-1 DO BEGIN 
        temp_ssd_id = valid_pha[3, index_wanted[jj]]
        temp_ssde = valid_pha[4, index_wanted[jj]]
        data[temp_ssd_id, temp_ssde] = data[temp_ssd_id, temp_ssde] + 1
    ENDFOR 
    temp_index = where(data EQ 0, count)
    IF count GT 0 THEN data[temp_index] = .1
    myyrange[1] = MAX(data)
    PLOT, data, /NODATA, TITLE = 'ssde Histogram', XTITLE = 'ssde', YTITLE = 'Count', XRANGE = myxrange, $
          YRANGE = myyrange, BACKGROUND = 255, COLOR = 0, POSITION = [.1, .1, .45, .45], /YLOG
    FOR j = 0, 17 DO BEGIN ; color by priority
        oplot, data[j, *], color = (j * 250/18)+15
        xyouts, .05+(j*.05), .05, "+", COLOR = (j * 250/18)+15, /NORMAL
        temp_string = STRING(j)
        xyouts, .015+(j*.05), .05, temp_string, /NORMAL
    ENDFOR
    plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
!NOERAS = 0
temp_name = outname
command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
spawn, command_string
ENDFOR 
print, "finished histograms"
data = 0

IF ind_pha EQ 1 THEN BEGIN ; skip this if worried about memory
; read individual data
    read_pha_ind, valid_pha, full_bins, full_num_bins, $
                  a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d2, e_max, e_min, mass_max, mass_min, t_max, t_min, $
                  pac, mass_low_bound, mq_low_bound, n, counts_raw, swpha_raw, wappha_ssd_raw, wappha_nossd_raw, $
                  supranoe_ssd_raw, supranoe_nossd_raw, suprawide_raw, swz_raw, swhalpha_raw

    valid_pha = 0 ; free memory
                                ; plot individual data
    mydevice = !D.NAME
    SET_PLOT, 'PS'
    outname = plot_dir+'/classpoints_'+cdf_base+time_st+esa_st+'.ps'
    DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
    loadct, 39
    !NOERAS = 1
    xyouts, .15, .96, cdf_base+time_st, /NORMAL, size = 1.5
    esa_string = STRING(esa, FORMAT = '(I3)')
    IF esa EQ -1 THEN subtitle = "ESA:"+esa_string ELSE subtitle = "ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
    xyouts, .25, .94, subtitle, /NORMAL, size = 1.2
    mycolors = FLTARR(16)
    FOR i = 0, 3 DO BEGIN
        mycolors[i] = (i * 250/4) + 10
    ENDFOR
    x_left = [.1, .1, .1, .1, .55, .55, .55, .55] ; coordinate for left x position
    x_right = [.45, .45, .45, .45, .9, .9, .9, .9]
    y_bottom = [.6975, .485, .2725, .06, .6975, .485, .2725, .06]
    y_top = [.89, .6775, .465, .2525, .89, .6775, .465, .2525]
    FOR i = 0, n-1 DO BEGIN 
        print, "starting classpoints part ", i
        CASE i OF 
            0: data = swpha_raw
            1: data = wappha_ssd_raw
            2: data = wappha_nossd_raw
            3: data = supranoe_ssd_raw
            4: data = supranoe_nossd_raw
            5: data = suprawide_raw
            6: data = swz_raw
            7: data = swhalpha_raw
        ENDCASE 
        CASE i OF 
            0: combo_plot = 1
            1: combo_plot = 1
            2: combo_plot = 0
            3: combo_plot = 0
            4: combo_plot = 0
            5: combo_plot = 2
            6: combo_plot = 1
            7: combo_plot = 1
        ENDCASE 
        CASE i OF 
            0: x_title = ' '
            1: x_title = ' '
            2: x_title = ' '
            3: x_title = 'Mass/Charge [amu/q]'
            4: x_title = ' '
            5: x_title = ' '
            6: x_title = ' '
            7: x_title = 'Mass/Charge [amu/q]'
        ENDCASE 
        plot_data, data, plot_names[i], num_bins[i], REFORM(limits[i, *, *]), mycolors, $
                   x_left[i], x_right[i], y_bottom[i], y_top[i], combo_plot, x_title
    ENDFOR
    FOR i = 0, 3 DO BEGIN
        xyouts, .05+(i*.05), .02, "+", COLOR = mycolors[i], /NORMAL
        temp_string = STRING(i)
        xyouts, .015+(i*.05), .02, temp_string, /NORMAL
    ENDFOR
    temp_string = "Color indicates priority"
    xyouts, .015+(5*.05), .02, temp_string, /NORMAL
    plot_stamp
    DEVICE, /CLOSE
    SET_PLOT, mydevice
    !NOERAS = 0
    temp_name = outname
    command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
    spawn, command_string
    
                                ; plot aggregated data
    mydevice = !D.NAME
    SET_PLOT, 'PS'
    outname = plot_dir+'/classbins_'+cdf_base+time_st+esa_st+'.ps'
    DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
    loadct, 39
    !NOERAS = 1
    xyouts, .15, .96, cdf_base+time_st, /NORMAL, size = 1.5
    esa_string = STRING(esa, FORMAT = '(I3)')
    IF esa EQ -1 THEN subtitle = "ESA:"+esa_string ELSE subtitle = "ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
    xyouts, .25, .94, subtitle, /NORMAL, size = 1.2
    file_array = ['SwPha_', 'WapPHA_SSD_', 'Wap_PHA_noSSD', 'SupraNoE_SSD_', 'SupraNoE_noSSD_', 'SupraWide_', 'Swz2_', 'Sw_H_alpha_']
    num_bins_array = [4, 4, 2, 7, 7, 15, 15, 3]
    x_left = [.1, .1, .1, .1, .55, .55, .55, .55] ; coordinate for left x position
    x_right = [.45, .45, .45, .45, .9, .9, .9, .9]
    y_bottom = [.75, .53, .31, .09, .75, .53, .31, .09]
    y_top = [.9, .68, .46, .24, .9, .68, .46, .24]
    n = N_ELEMENTS(file_array)
    FOR i = 0, n-1 DO BEGIN
        plot_data2, file_array[i], REFORM(limits[i, *, *]), REFORM(counts_raw[i, *]), num_bins_array[i], $
                    x_left[i], x_right[i], y_bottom[i], y_top[i]
    ENDFOR
    plot_stamp
    DEVICE, /CLOSE
    SET_PLOT, mydevice
    !NOERAS = 0
    temp_name = outname
    command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
    spawn, command_string
ENDIF 

END 
