; Lorna Ellis
; Jan. 9, 2006
; plot_contours_cdf.pro
; 
; This is rewrite of plot_contours_dpu.pro
; This program plots proton alpha data. It is a rewrite of plot_contours.pro.
; In particular, it plots SW-H, Sw_alphaD, Sw_alphaT, and Sw_all.

; 02/25/2007 Changed algorithm for positions.


PRO plot_contours_cdf
COMMON share1

mydevice = !D.NAME
SET_PLOT, 'PS'
outname = plot_dir+'/contour_'+cdf_base+time_st+esa_st+'.ps'
!NOERAS = 1
DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
loadct,39
xyouts, .3, .96, cdf_base+time_st, /NORMAL, size = 1.5
esa_string = STRING(esa, FORMAT = '(I3)')
IF esa EQ -1 THEN subtitle = "ESA:"+esa_string ELSE $
  subtitle = "ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
xyouts, .3, .94, subtitle, /NORMAL, size = 1.2

file_sub_array = ['Sw_H', 'Sw_alphaD', 'Sw_alphaT', 'Sw_all']
x_left = [.1, .1, .55, .55]        ; coordinate for left x position
x_right = [.45, .45, .9, .9]
y_bottom = [.6, .16, .6, .16]
y_top = [.9, .46, .9, .46]

; read in data
; get proton_peak
cdf_control, cdf_id, get_var_info = proton_peak_info, var = 'proton_peak', /zvariable
IF proton_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with proton_peak_info.maxrec"
cdf_varget, cdf_id, 'proton_peak', proton_peak, rec_count = epoch_info.maxrec, /zvariable
; get alpha_peak
cdf_control, cdf_id, get_var_info = alpha_peak_info, var = 'alpha_peak', /zvariable
IF alpha_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with alpha_peak_info.maxrec"
cdf_varget, cdf_id, 'alpha_peak', alpha_peak, rec_count = epoch_info.maxrec, /zvariable
; get h_alpha -- sw_all
cdf_control, cdf_id, get_var_info = h_alpha_info, var = 'h_alpha', /zvariable
IF h_alpha_info.maxrec NE epoch_info.maxrec THEN print, "Error with h_alpha_info.maxrec"
cdf_varget, cdf_id, 'h_alpha', h_alpha, rec_count = epoch_info.maxrec, /zvariable
; get h_peak -- sw_h
cdf_control, cdf_id, get_var_info = h_peak_info, var = 'h+peak', /zvariable
IF h_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with h_peak_info.maxrec"
cdf_varget, cdf_id, 'h+peak', h_peak, rec_count = epoch_info.maxrec, /zvariable
; get he_peak -- sw_alphaD
cdf_control, cdf_id, get_var_info = he_peak_info, var = 'he++peak', /zvariable
IF he_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with he_peak_info.maxrec"
cdf_varget, cdf_id, 'he++peak', he_peak, rec_count = epoch_info.maxrec, /zvariable
; get he_tcr -- sw_alphaT
cdf_control, cdf_id, get_var_info = he_tcr_info, var = 'he++tcr', /zvariable
IF he_tcr_info.maxrec NE epoch_info.maxrec THEN print, "Error with he_tcr_info.maxrec"
cdf_varget, cdf_id, 'he++tcr', he_tcr, rec_count = epoch_info.maxrec, /zvariable

; remove error cases
valid_index = where(error1 EQ 0, count) 
temp_epoch = epoch
IF count GT 0 THEN BEGIN 
    temp_epoch = temp_epoch[valid_index]
    error1 = error1[valid_index]
    proton_peak = proton_peak[*, valid_index]
    alpha_peak = alpha_peak[*, valid_index]
    h_alpha = h_alpha[*, *, *, valid_index]
    h_peak = h_peak[*, *, *, valid_index]
    he_peak = he_peak[*, *, *, valid_index]
    he_tcr = he_tcr[*, *, *, valid_index]
ENDIF 

IF read_whole_file EQ 0 THEN BEGIN 
    time_found = where(temp_epoch GE start_time AND temp_epoch LE stop_time, count)
    IF count GT 0 THEN BEGIN 
        temp_epoch = temp_epoch[time_found]
        proton_peak = proton_peak[*, time_found]
        alpha_peak = alpha_peak[*, time_found]
        h_alpha = h_alpha[*, *, *, time_found]
        h_peak = h_peak[*, *, *, time_found]
        he_peak = he_peak[*, *, *, time_found]
        he_tcr = he_tcr[*, *, *, time_found]
    ENDIF 
ENDIF 

; remove fill before summing
temp = where(h_alpha EQ -1, count) 
IF count GT 0 THEN h_alpha[temp] = 0
temp = where(h_peak EQ -1, count)
IF count GT 0 THEN h_peak[temp] = 0
temp = where(he_peak EQ -1, count)
IF count GT 0 THEN he_peak[temp] = 0
temp = where(he_tcr EQ -1, count)
IF count GT 0 THEN he_tcr[temp] = 0

data = lonarr(4, 8, 32)  ; numgraphs, position, deflection
FOR ii = 0, n_elements(temp_epoch)-1 DO BEGIN ; esa of h_alpha (sw_all)
    ep = proton_peak[0, ii]
    IF ep GT 123 THEN ep = 123
    IF ep LT 15 THEN ep = 15
    pp = proton_peak[1, ii]
    IF pp GT 27 THEN pp = 27
    IF pp LT 3 THEN pp = 3
    dp = proton_peak[2, ii]
    IF dp GT 27 THEN dp = 27
    IF dp LT 3 THEN dp = 3
    FOR jj = 0, 19 DO BEGIN     ; esa of h_alpha (sw_all)
        IF esa EQ -1 OR (esa EQ (ep - jj + 4)) THEN $
          data[3, *, (dp-3):(dp+4)] = data[3, *, (dp-3):(dp+4)] + h_alpha[jj, *, *, ii]
    ENDFOR
    IF ep LT 5 THEN ep = 5
    FOR jj = 0, 9 DO BEGIN      ; esa of h+_peak (sw_h)    
        IF esa EQ -1 OR (esa EQ (ep - jj + 4)) THEN $
          data[0, *, (dp-3):(dp+4)] = data[0, *, (dp-3):(dp+4)] + h_peak[jj, *, *, ii]
    ENDFOR

    ep = alpha_peak[0, ii]
    IF ep GT 123 THEN ep = 123
    IF ep LT 15 THEN ep = 15
    pp = alpha_peak[1, ii]
    IF pp GT 27 THEN pp = 27
    IF pp LT 3 THEN pp = 3
    dp = alpha_peak[2, ii]
    IF dp GT 27 THEN dp = 27
    IF dp LT 3 THEN dp = 3
    FOR jj = 0, 9 DO BEGIN      ; esa of he++peak (sw_alphaD)
        IF esa EQ -1 OR (esa EQ (ep - jj + 4)) THEN $
          data[1, *, (dp-3):(dp+4)] = data[1, *, (dp-3):(dp+4)] + he_peak[jj, *, *, ii]
    ENDFOR
    FOR jj = 0, 9 DO BEGIN      ; esa of he++tcr (sw_alphaT)
        IF esa EQ -1 OR (esa EQ (ep - jj + 4)) THEN $
          data[2, *, (dp-3):(dp+4)] = data[2, *, (dp-3):(dp+4)] + he_tcr[jj, *, *, ii]
    ENDFOR
ENDFOR 

; fix position
full_data = dblarr(4, 32, 32)  ; numgraphs, position, deflection
FOR ii = 0, 3 DO BEGIN 
    FOR jj = 0, 31 DO BEGIN 
        full_data[ii, 1:3, jj] = data[ii, 0, jj]/3
        full_data[ii, 4:7, jj] = data[ii, 1, jj]/4
        full_data[ii, 8:11, jj] = data[ii, 2, jj]/4
        full_data[ii, 12:15, jj] = data[ii, 3, jj]/4
        full_data[ii, 16:19, jj] = data[ii, 4, jj]/4
        full_data[ii, 20:23, jj] = data[ii, 5, jj]/4
        full_data[ii, 24:27, jj] = data[ii, 6, jj]/4
        full_data[ii, 28:31, jj] = data[ii, 7, jj]/4
    ENDFOR 
ENDFOR 
FOR j = 0, 3 DO BEGIN ; 3 plots
                                ; plot data
    mytitle = file_sub_array[j]
    myxrange = intarr(2)
    myxrange[0] = 0
    myxrange[1] = 32
    myyrange = intarr(2)
    myyrange[0] = 0
    myyrange[1] = 32
    temp_data = REFORM(full_data[j, *, *])   ; make 2D array from 3D array
    max = max(temp_data)
    IF max LE 6 THEN BEGIN 
        PLOT, full_data, /NODATA, TITLE = mytitle, XTITLE = 'Position Step', YTITLE = 'Deflection Step', $
              XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, $
              POSITION = [x_left[j], y_bottom[j]+.06, x_right[j], y_top[j]]
        FOR s = 0, 31 DO BEGIN
            FOR t = 0, 31 DO BEGIN
                IF full_data[j, s, t] NE 0 THEN BEGIN
                    OPLOT, [s], [t], PSYM = full_data[j, s, t]
                ENDIF
            ENDFOR
        ENDFOR 
        xyouts, x_left[j]+(0*.05), y_bottom[j]-.02, "+:1", /NORMAL
        xyouts, x_left[j]+(0*.05), y_bottom[j]-.04, "*:2", /NORMAL
        xyouts, x_left[j]+(0*.05), y_bottom[j]-.06, ".:3", /NORMAL
        xyouts, x_left[j]+(2*.05), y_bottom[j]-.02, "diamond:4", /NORMAL
        xyouts, x_left[j]+(2*.05), y_bottom[j]-.04, "triangle:5", /NORMAL
        xyouts, x_left[j]+(2*.05), y_bottom[j]-.06, "square :6", /NORMAL
    ENDIF ELSE BEGIN 
        delta = max/3
        CONTOUR, temp_data, /Fill, TITLE = mytitle, XTITLE = 'Position Step', YTITLE = 'Deflection Step', $
                 XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = 4, $
                 C_COLORS = [25, 50, 100, 150], LEVELS = [1, delta, 2*delta, 3*delta+1], $
                 POSITION = [x_left[j], y_bottom[j]+.06, x_right[j], y_top[j]]
        CONTOUR, temp_data, /OVERPLOT, NLEVELS = 4, C_LABELS = [0, 0, 0, 0], $
                 LEVELS = [delta, 2*delta, 3*delta, 4*delta]

        legend_data = fltarr(5, 2)
        myticks = STRARR(5)
        FOR k = 0, 4 DO BEGIN
            FOR l = 0, 1 DO BEGIN
                legend_data[k, l] = (k)*delta
            ENDFOR
            amount = k*delta
            IF amount LE 9999 THEN myticks[k] = STRING(amount, FORMAT = '(F5.0)') ELSE myticks[k] = STRING(amount, FORMAT = '(E7.1)')
        ENDFOR
        myxrange[1] = 4
        myyrange[1] = 1
        CONTOUR, legend_data, /FILL, /NORMAL, TITLE = ' ', XTITLE = 'Number of Counts', $
                 XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = 4, $
                 C_COLORS = [25, 50, 100, 150], LEVELS = [1, delta, 2*delta, 3*delta+1], $
                 YTICKS = 1, YTICKINTERVAL = 5, XTICKNAME = myticks, POSITION = [x_left[j], y_bottom[j], x_right[j], y_top[j]-.28]
    ENDELSE 
ENDFOR

plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
temp_name = outname
command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
spawn, command_string
END 
