; Lorna Ellis
; Jan. 9, 2007
; 
; Adapted from plot_classification_dpu.pro
; This program plots data read from the classifier.
; In particular, it looks at SW Z>2, SW PHA, Supra Wide,
; SupraNoE, WAP PHA. This is a rewrite of plot_classification

; 01/25/07 Fixed when limit by esa.

PRO plot_data_class, file_name, limits, counts, num_bins, pos_x_left, pos_x_right, pos_y_bottom, pos_y_top
; in : file_name   : the prefix of the plot being plotted
;      limits      : the limit array: for each bin, limits
;      counts      : the count array: for each bin, counts
;      num_bins   : the number of bins
;      pos_x_left  : used for setting the plot on the page
;      pos_x_right : used for setting the plot on the page
;      pos_y_bottom: used for setting the plot on the page
;      pos_y_top   : used for setting the plot on the page

; change form of data
data2 = LONARR(1001, 1001)
FOR i = 1, num_bins DO BEGIN         ; fill each bin, in reverse order (num_bins-i)
    m_q_min = limits[num_bins-i, 1] * 10
    m_q_max = limits[num_bins-i, 2] * 10
    mass_min = limits[num_bins-i, 3] * 10
    mass_max = limits[num_bins-i, 4] * 10
    FOR j = num_bins-i, num_bins-2 DO BEGIN   ; empty any overlapping bins (j+i)
        j_m_q_min = limits[j, 1] * 10
        j_m_q_max = limits[j, 2] * 10
        j_mass_min = limits[j, 3] * 10
        j_mass_max = limits[j, 4] * 10
        FOR k = j_m_q_min, j_m_q_max DO BEGIN
            FOR l = j_mass_min, j_mass_max DO BEGIN
                IF k GE m_q_min AND k LE m_q_max AND l GE mass_min AND l LE mass_max THEN data2[k, l] = 0
            ENDFOR
        ENDFOR
    ENDFOR
    data2[m_q_min:m_q_max, mass_min:mass_max] = counts[num_bins-i] ; fill full array
ENDFOR
        
; determine the number of levels
level_array = SORT(counts)
temp = counts[level_array[0]]
num_levels = 1
FOR i = 1, num_bins-1 DO BEGIN
    IF counts[level_array[i]] NE temp THEN BEGIN
        num_levels = num_levels + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR
mylevels = LONARR(num_levels)
level = 0
temp = -1
FOR i = 0, num_bins-1 DO BEGIN
    IF counts[level_array[i]] NE temp THEN BEGIN
        mylevels[level] = counts[level_array[i]]
        level = level + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR

; plot data
mytitle = file_name
myxrange = lonarr(2)
myxrange[0] = 1
myxrange[1] = 1000
myyrange = lonarr(2)
myyrange[0] = 1
myyrange[1] = 1000
mycolors = FLTARR(num_levels)
FOR i = 0, num_levels-1 DO BEGIN
    mycolors[i] = (i * 250/num_levels) + 10
ENDFOR

;plot axis and first bin
xmin = limits[0, 1] * 10        ; get first min m/q
xmax = limits[0, 2] * 10
ymin = limits[0, 3] * 10
ymax = limits[0, 4] * 10
data3 = LONARR(xmax-xmin+1, ymax-ymin+1)
data3 = data2[xmin:xmax, ymin:ymax]
x = LONARR(xmax-xmin+1)
FOR i = 0, xmax-xmin DO BEGIN
    x[i] = xmin + i
ENDFOR
y = LONARR(ymax-ymin+1)
FOR i = 0, ymax-ymin DO BEGIN
    y[i] = ymin + i
ENDFOR
CONTOUR, data3, x, y, /FILL, TITLE = mytitle, XTITLE = 'Mass/Charge [amu/q]', YTITLE = 'Mass', $
         XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
         C_COLORS = mycolors, LEVELS = mylevels, /XLOG, /YLOG, XTICKNAME = ['0.1', '1.0', '10.0', '100.0'], $
         YTICKNAME = ['0.1', '1.0', '10.0', '100.0'], BACKGROUND = 255, COLOR = 0, $
         POSITION = [pos_x_left, pos_y_bottom+.06, pos_x_right, pos_y_top]

;plot the rest of the bins
FOR j = 1, num_bins-1 DO BEGIN 
    xmin = limits[j, 1] * 10      ; get first min m/q
    xmax = limits[j, 2] * 10
    ymin = limits[j, 3] * 10
    ymax = limits[j, 4] * 10
    data3 = LONARR(xmax-xmin+1, ymax-ymin+1)
    data3 = data2[xmin:xmax, ymin:ymax]
    x = LONARR(xmax-xmin+1)
    FOR i = 0, xmax-xmin DO BEGIN
        x[i] = xmin + i
    ENDFOR
    y = LONARR(ymax-ymin+1)
    FOR i = 0, ymax-ymin DO BEGIN
        y[i] = ymin + i
    ENDFOR
    CONTOUR, data3, x, y, /FILL, /OVERPLOT, NLEVELS = num_levels, $
             C_COLORS = mycolors, LEVELS = mylevels 
ENDFOR
legend_data = lonarr(num_levels+1, 2)
legend_levels = lonarr(num_levels+1)
myticks = STRARR(num_levels+1)
FOR k = 0, num_levels DO BEGIN
    FOR l = 0, 1 DO BEGIN
        legend_data[k, l] = k
        legend_levels[k] = k
    ENDFOR
    IF k LT num_levels THEN BEGIN 
        IF mylevels[k] LE 9999 THEN myticks[k+1] = STRING(mylevels[k], FORMAT = '(F6.0)') ELSE myticks[k+1] = STRING(mylevels[k], FORMAT = '(E7.1)')
    ENDIF 
ENDFOR
IF mylevels[0] LE 9999 THEN myticks[0] = STRING(mylevels[0], FORMAT = '(F6.0)') ELSE myticks[0] = STRING(mylevels[0], FORMAT = '(E7.1)')
myxrange[0] = 0
myxrange[1] = num_levels
myyrange[0] = 0
myyrange[1] = 1
IF num_levels LE 4 THEN BEGIN 
    CONTOUR, legend_data, /FILL, TITLE = ' ', XTITLE = 'Number of Counts', COLOR = 0, $
             XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
             C_COLORS = mycolors, LEVELS = legend_levels, YTICKS = 1, YTICKINTERVAL = 5, $
             XTICKNAME = myticks, XTICKINTERVAL = 1, POSITION = [pos_x_left, pos_y_bottom, pos_x_right, pos_y_top-.135]
ENDIF ELSE BEGIN 
    interval = (num_levels+1)/4
    temp_ticks = strarr(num_levels+1)
    FOR i = 0, (n_elements(myticks)-1) DO BEGIN
        IF i MOD interval EQ 0 THEN temp_ticks[i] = myticks[i] ELSE temp_ticks[i] = ' '
    ENDFOR 
    CONTOUR, legend_data, /FILL, TITLE = ' ', XTITLE = ' ', COLOR = 0, $
             XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
             C_COLORS = mycolors, LEVELS = legend_levels, YTICKS = 1, YTICKINTERVAL = 5, $
             xtickname = temp_ticks, xtickinterval = 1, POSITION = [pos_x_left, pos_y_bottom, pos_x_right, pos_y_top-.135]
ENDELSE 
END


PRO check_limits, limits, num_bins
; in : limits    : array holding limits for each bin
;      num_bins  : the number of bins 

FOR i = 0, num_bins-1 DO BEGIN
    IF limits[i, 3] EQ -2 THEN limits[i, 3] = .2 ; check for -2 in m/q
    IF limits[i, 4] EQ -2 THEN limits[i, 4] = .5
    IF limits[i, 3] EQ -1 THEN BEGIN            ; check for -1 in m/q
        IF limits[i, 4] NE -1 THEN BEGIN
            print, "Error with limits"
            stop
        ENDIF 
        limits[i, 3] = .2
        limits[i, 4] = 100
    ENDIF
    IF limits[i, 1] EQ -1 THEN BEGIN            ; check for -1 in mass
        IF limits[i, 2] NE -1 THEN BEGIN
            print, "Error with limits"
            stop
        ENDIF 
        limits[i, 1] = .5
        limits[i, 2] = 100
    ENDIF
ENDFOR
END


PRO plot_classification_cdf, clcdf_id, channel_wanted, full_limits
; in : clcdf_id      : file pointer for proton CDF
;      channel_wanted: 0: Main, 1: S, 2: both
;      full_limits   : limit array (12x16x5) (last is bin label and limits)
COMMON share1

mydevice = !D.NAME
SET_PLOT, 'PS'
outname = plot_dir+'/heavies_'+cdf_base+time_st+esa_st+channel_st+'.ps'
DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8, ysize = 10, XOFFSET = 0, YOFFSET = 0
loadct,39
!NOERAS = 1
title = 'Heavies: '+cdf_base+time_st
xyouts, .1, .96, title, /NORMAL, size = 1.5
esa_string = STRING(esa, FORMAT = '(I3)')
IF esa EQ -1 THEN subtitle = "ESA:"+esa_string ELSE subtitle = "ESA:"+esa_string+","+string(energy, format = '(F6.2)')+" keV"
CASE channel_wanted OF
    0: temp_channel = ' Main Channel'
    1: temp_channel = ' S Channel'
    2: temp_channel = ' Main & S Channel'
ENDCASE 
subtitle = subtitle+temp_channel
xyouts, .3, .94, subtitle, /NORMAL, size = 1.2

title_array = ['SwPha', 'WapPHA_SSD', 'WapPHA_noSSD', 'SupraNoE_SSD', 'SupraNoE_noSSD', 'SupraWide_', 'Swz2_']
headers = [2, 2, 2, 2, 2, 2, 2]                      ; number of header lines in each data file
num_bins_array = [4, 4, 2, 7, 7, 15, 15]
full_limit_index = [0, 0, 1, 2, 3, 4, 6]
x_left = [.1, .1, .1, .1, .55, .55, .55, .55]        ; coordinate for left x position
x_right = [.45, .45, .45, .45, .9, .9, .9, .9]
y_bottom = [.75, .53, .31, .09, .75, .53, .31, .09]
y_top = [.9, .68, .46, .24, .9, .68, .46, .24]
n = N_ELEMENTS(file_array)
wap_ssd_limits = FLTARR(2, 5)

; read general variables
cdf_control, cdf_id, get_var_info = epoch5_info, var = 'epoch5_heavy', /zvariable
IF epoch5_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, cdf_id, 'epoch5_heavy', epoch5, rec_count = epoch5_info.maxrec, /zvariable
    cdf_control, cdf_id, get_var_info = error5_info, var = 'error5_heavy', /zvariable
    IF error5_info.maxrec NE epoch5_info.maxrec THEN print, "Error with error5_info.maxrec"
    cdf_varget, cdf_id, 'error5_heavy', error5, rec_count = epoch5_info.maxrec, /zvariable
    cdf_control, cdf_id, get_var_info = schan5_info, var = 's_chan5_heavy', /zvariable
    IF schan5_info.maxrec NE epoch5_info.maxrec THEN print, "Error with schan5_info.maxrec"
    cdf_varget, cdf_id, 's_chan5_heavy', schan5, rec_count = epoch5_info.maxrec, /zvariable

    ; remove error cases
    valid_error_index = where(error5 EQ 0, valid_error_count) 
    IF valid_error_count GT 0 THEN BEGIN 
        epoch5 = epoch5[valid_error_index]
        schan5 = schan5[valid_error_index]
    ENDIF 
    ; remove unwanted schan
    IF channel_wanted EQ 0 THEN BEGIN ; only want schan=0
        valid_schan_index = where(schan5 EQ 0, valid_schan_count) 
        IF valid_schan_count GT 0 THEN BEGIN 
            epoch5 = epoch5[valid_schan_index]
        ENDIF ELSE epoch5 = 0
    ENDIF
    IF channel_wanted EQ 1 THEN BEGIN ; only want schan>0
        valid_schan_index = where(schan5 NE 0, valid_schan_count) 
        IF valid_schan_count GT 0 THEN BEGIN 
            epoch5 = epoch5[valid_schan_index]
        ENDIF ELSE epoch5 = 0
    ENDIF
    ; remove unwanted times
    IF read_whole_file EQ 0 THEN BEGIN 
        valid_time_index = where(epoch5 GE start_time AND epoch5 LE stop_time, valid_time_count)
        IF valid_time_count GT 0 THEN BEGIN 
            epoch5 = epoch5[valid_time_index]
        ENDIF ELSE epoch5 = 0
    ENDIF 

    FOR i = 0, 6 DO BEGIN      
        limits = REFORM(full_limits[full_limit_index[i], *, *]) ; get 16x5 array, for each bin, bin_num and limits
        check_limits, limits, num_bins_array[i]
        counts = LONARR(num_bins_array[i])
        ; read data
        CASE i OF  
            0: BEGIN 
                cdf_control, cdf_id, get_var_info = data_info, var = 'sw_priority', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with sw_priority_info.maxrec"
                cdf_varget, cdf_id, 'sw_priority', data, rec_count = epoch5_info.maxrec, /zvariable
            END
            1: BEGIN 
                cdf_control, cdf_id, get_var_info = data_info, var = 'wap_priority_ssd', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with wap_priority_ssd_info.maxrec"
                cdf_varget, cdf_id, 'wap_priority_ssd', data, rec_count = epoch5_info.maxrec, /zvariable
            END
            2: BEGIN 
                cdf_control, cdf_id, get_var_info = data_info, var = 'wap_priority_no_ssd', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with wap_priority_no_ssd_info.maxrec"
                cdf_varget, cdf_id, 'wap_priority_no_ssd', data, rec_count = epoch5_info.maxrec, /zvariable
            END
            3: BEGIN 
                cdf_control, cdf_id, get_var_info = data_info, var = 'wap_ssd_dcr', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with wap_ssd_dcr_info.maxrec"
                cdf_varget, cdf_id, 'wap_ssd_dcr', data, rec_count = epoch5_info.maxrec, /zvariable
            END
            4: BEGIN 
                cdf_control, cdf_id, get_var_info = data_info, var = 'wap_no_ssd_dcr', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with wap_no_ssd_dcr_info.maxrec"
                cdf_varget, cdf_id, 'wap_no_ssd_dcr', data, rec_count = epoch5_info.maxrec, /zvariable
            END
            5: BEGIN 
                cdf_control, cdf_id, get_var_info = data_info, var = 'wap_ssd_tcr', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with wap_ssd_tcr_info.maxrec"
                cdf_varget, cdf_id, 'wap_ssd_tcr', data, rec_count = epoch5_info.maxrec, /zvariable
            END
            6: BEGIN 
                data = 0
                cdf_control, cdf_id, get_var_info = data_info, var = 'sw_z>2_h', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with sw_z>2_h_info.maxrec"
                cdf_varget, cdf_id, 'sw_z>2_h', data1, rec_count = epoch5_info.maxrec, /zvariable
                cdf_control, cdf_id, get_var_info = data_info, var = 'sw_z>2_l', /zvariable
                IF data_info.maxrec NE epoch5_info.maxrec THEN print, "Error with sw_z>2_l_info.maxrec"
                cdf_varget, cdf_id, 'sw_z>2_l', data2, rec_count = epoch5_info.maxrec, /zvariable
            END
        ENDCASE 
        ; remove error cases
        IF valid_error_count GT 0 THEN BEGIN 
            SWITCH i OF 
                0: 
                3: 
                4: 
                5: BEGIN
                    data = data[*, *, *, valid_error_index] ; 3 dim 
                    BREAK
                END 
                1: 
                2: BEGIN
                    data = data[*, *, valid_error_index] ; 2 dim 
                    BREAK
                END 
                6: BEGIN
                    data1 = data1[*, *, *, *, valid_error_index]
                    data2 = data2[*, *, *, valid_error_index]
                    BREAK
                END 
            ENDSWITCH 
        ENDIF ELSE data = 0
        ; remove unwanted schan
        IF channel_wanted NE 2 THEN BEGIN
            IF valid_schan_count GT 0 THEN BEGIN 
                SWITCH i OF 
                    0: 
                    3: 
                    4: 
                    5: BEGIN
                        data = data[*, *, *, valid_schan_index]
                        BREAK
                    END
                    1: 
                    2: BEGIN
                        data = data[*, *, valid_schan_index]
                        BREAK
                    END
                    6: BEGIN
                        data1 = data1[*, *, *, *, valid_schan_index]
                        data2 = data2[*, *, *, valid_schan_index]
                        BREAK
                    END
                ENDSWITCH 
            ENDIF ELSE data = 0
        ENDIF 
        ; removed unwanted times
        IF read_whole_file EQ 0 THEN BEGIN 
            IF valid_time_count GT 0 THEN BEGIN 
                SWITCH i OF 
                    0: 
                    3: 
                    4: 
                    5: BEGIN
                        data = data[*, *, *, valid_time_index]
                        BREAK
                    END 
                    1: 
                    2: BEGIN
                        data = data[*, *, valid_time_index]
                        BREAK
                    END 
                    6: BEGIN
                        data1 = data1[*, *, *, *, valid_time_index]
                        data2 = data2[*, *, *, valid_time_index]
                        BREAK
                    END 
                ENDSWITCH 
            ENDIF ELSE data = 0
        ENDIF
        ; limit esa
        IF esa NE -1 THEN BEGIN 
            SWITCH i OF
                0: 
                3: 
                4: 
                5: BEGIN
                    data = data[esa, *, *, *]
                    BREAK
                END 
                1: 
                2: BEGIN
                    data = data[esa, *, *]
                    BREAK
                END 
                6: BEGIN
                    data1 = data1[esa, *, *, *, *]
                    data2 = data2[esa, *, *, *]
                    BREAK
                END 
            ENDSWITCH 
        ENDIF 
        ; remove fill before summing
        IF (i NE 6 AND n_elements(data) GT 1) OR $
          (i EQ 6 AND (n_elements(data1) GT 1 OR n_elements(data2) GT 1)) THEN BEGIN            ; skip if no valid data
            temp = where(data EQ -1, count) 
            IF count GT 0 THEN data[temp] = 0
        ; sum data
            SWITCH i OF 
                0: BEGIN 
                    FOR jj = 0, 3 DO BEGIN ; sum by class
                        counts[jj] = total(data[*, *, jj, *])
                    ENDFOR 
                    BREAK 
                END 
                1: BEGIN        ; This one is strange!
                    counts[0] = total(data[*, 0, *])
                    counts[1] = total(data[*, 0, *])
                    counts[2] = total(data[*, 1, *])
                    counts[3] = total(data[*, 1, *])
                    BREAK 
                END 
                2: BEGIN 
                    FOR jj = 0, 1 DO BEGIN ; sum by class
                        counts[jj] = total(data[*, jj, *])
                    ENDFOR 
                    BREAK 
                END 
                3: 
                4: BEGIN 
                    FOR jj = 0, 6 DO BEGIN ; sum by class
                        counts[jj] = total(data[*, *, jj, *])
                    ENDFOR 
                    BREAK 
                END 
                5: BEGIN 
                    FOR jj = 0, 14 DO BEGIN ; sum by class
                        counts[jj] = total(data[*, *, jj, *])
                    ENDFOR 
                    BREAK 
                END 
                6: BEGIN 
                    FOR jj = 0, 1 DO BEGIN ; sum by class
                        counts[jj] = total(data1[*, *, *, jj, *])
                    ENDFOR 
                    FOR jj = 0, 12 DO BEGIN ; sum by class
                        counts[jj+2] = total(data2[*, *, jj, *])
                    ENDFOR 
                    BREAK 
                END 
            ENDSWITCH 
        ENDIF 
        plot_data_class, title_array[i], limits, counts, num_bins_array[i], x_left[i], x_right[i], y_bottom[i], y_top[i]
    ENDFOR
ENDIF 


limits = REFORM(full_limits[10, *, *])
check_limits, limits, 3
counts = LONARR( 3)

; read general variables
IF epoch_info.maxrec GE 0 THEN BEGIN 
    cdf_control, cdf_id, get_var_info = schan1_info, var = 's_chan1', /zvariable
    IF schan1_info.maxrec NE epoch_info.maxrec THEN print, "Error with schan1_info.maxrec"
    cdf_varget, cdf_id, 's_chan1', schan1, rec_count = epoch_info.maxrec, /zvariable
    ; remove error cases
    valid_error_index = where(error1 EQ 0, valid_error_count) 
    temp_epoch = epoch
    IF valid_error_count GT 0 THEN BEGIN 
        temp_epoch = temp_epoch[valid_error_index]
        schan1 = schan1[valid_error_index]
    ENDIF 
    ; remove unwanted schan
    IF channel_wanted EQ 0 THEN BEGIN ; only want schan=0
        valid_schan_index = where(schan1 EQ 0, valid_schan_count) 
        IF valid_schan_count GT 0 THEN BEGIN 
            temp_epoch = temp_epoch[valid_schan_index]
        ENDIF 
    ENDIF 
    IF channel_wanted EQ 1 THEN BEGIN ; only want schan>0
        valid_schan_index = where(schan1 NE 0, valid_schan_count) 
        IF valid_schan_count GT 0 THEN BEGIN 
            temp_epoch = temp_epoch[valid_schan_index]
        ENDIF 
    ENDIF 
    ; remove unwanted times
    IF read_whole_file EQ 0 THEN BEGIN 
        valid_time_index = where(temp_epoch GE start_time AND temp_epoch LE stop_time, valid_time_count)
        IF valid_time_count GT 0 THEN BEGIN 
            temp_epoch = temp_epoch[valid_time_index]
        ENDIF 
    ENDIF 

    FOR i = 0, 2 DO BEGIN 
        CASE i OF 
            0: BEGIN 
                cdf_control, cdf_id, get_var_info = h_peak_info, var = 'h+peak', /zvariable
                IF h_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with h_peak_info.maxrec"
                cdf_varget, cdf_id, 'h+peak', data, rec_count = epoch_info.maxrec, /zvariable
                cdf_control, cdf_id, get_var_info = proton_peak_info, var = 'proton_peak', /zvariable
                IF proton_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with proton_peak_info.maxrec"
                cdf_varget, cdf_id, 'proton_peak', peak_data, rec_count = epoch_info.maxrec, /zvariable
            END 
            1: BEGIN 
                cdf_control, cdf_id, get_var_info = he_peak_info, var = 'he++peak', /zvariable
                IF he_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with he_peak_info.maxrec"
                cdf_varget, cdf_id, 'he++peak', data, rec_count = epoch_info.maxrec, /zvariable
                cdf_control, cdf_id, get_var_info = alpha_peak_info, var = 'alpha_peak', /zvariable
                IF alpha_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with alpha_peak_info.maxrec"
                cdf_varget, cdf_id, 'alpha_peak', peak_data, rec_count = epoch_info.maxrec, /zvariable
            END
            2: BEGIN 
                cdf_control, cdf_id, get_var_info = he_tcr_info, var = 'he++tcr', /zvariable
                IF he_tcr_info.maxrec NE epoch_info.maxrec THEN print, "Error with he_tcr_info.maxrec"
                cdf_varget, cdf_id, 'he++tcr', data, rec_count = epoch_info.maxrec, /zvariable
                cdf_control, cdf_id, get_var_info = alpha_peak_info, var = 'alpha_peak', /zvariable
                IF alpha_peak_info.maxrec NE epoch_info.maxrec THEN print, "Error with alpha_peak_info.maxrec"
                cdf_varget, cdf_id, 'alpha_peak', peak_data, rec_count = epoch_info.maxrec, /zvariable
            END
        ENDCASE 
        ; remove error cases
        IF valid_error_count GT 0 THEN BEGIN 
            data = data[*, *, *, valid_error_index] ; 3 dim 
            peak_data = peak_data[*, valid_error_index] 
        ENDIF ELSE data = 0
        ; remove unwanted schan
        IF channel_wanted NE 2 THEN BEGIN
            IF valid_schan_count GT 0 THEN BEGIN 
                data = data[*, *, *, valid_schan_index]
                peak_data = peak_data[*, valid_schan_index] 
            ENDIF ELSE data = 0
        ENDIF 
        ; removed unwanted times
        IF read_whole_file EQ 0 THEN BEGIN 
            IF valid_time_count GT 0 THEN BEGIN 
                data = data[*, *, *, valid_time_index]
                peak_data = peak_data[*, valid_time_index] 
            ENDIF ELSE data = 0
        ENDIF
        ; remove fill before summing
        IF n_elements(data) GT 1 THEN BEGIN 
            temp = where(data EQ -1, count) 
            IF count GT 0 THEN data[temp] = 0
                                ; limit esa
            IF esa NE -1 THEN BEGIN   
                FOR j = 0, n_elements(temp_epoch)-1 DO BEGIN 
                    ep = peak_data[0, j]
                    IF ep GT 123 THEN ep = 123
                    IF ep LT 5 THEN ep = 5
                    FOR kk = 0, 9 DO BEGIN 
                        IF esa NE (ep - kk +4) THEN data[kk, *, *, j] = 0
                    ENDFOR 
                ENDFOR 
            ENDIF 
                                ; sum data
            counts[i] = total(data)
        ENDIF 
    ENDFOR 
    data = 0
ENDIF 

; get data from proton mode
cdf_control, clcdf_id, get_var_info = clepoch_info, var = 'epoch_classifier', /zvariable
IF clepoch_info.maxrec GE 0 THEN BEGIN 
    ; get epoch
    cdf_varget, clcdf_id, 'epoch_classifier', clepoch, rec_count = clepoch_info.maxrec, /zvariable
    ; get block_id
    cdf_control, clcdf_id, get_var_info = block_id_info, var = 'block_id_classifier', /zvariable
    IF block_id_info.maxrec NE clepoch_info.maxrec THEN print, "Error with block_id_info.maxrec"
    cdf_varget, clcdf_id, 'block_id_classifier', block_id, rec_count = clepoch_info.maxrec, /zvariable
    ; get esa_steps
    cdf_control, clcdf_id, get_var_info = esa_step_info, var = 'esa_step', /zvariable
    IF esa_step_info.maxrec NE clepoch_info.maxrec THEN print, "Error with esa_step_info.maxrec"
    cdf_varget, clcdf_id, 'esa_step', esa_step, rec_count = clepoch_info.maxrec, /zvariable
    ; get data
    cdf_control, clcdf_id, get_var_info = classifier_data_info, var = 'classifier_data', /zvariable
    IF classifier_data_info.maxrec NE clepoch_info.maxrec THEN print, "Error with classifier_data_info.maxrec"
    cdf_varget, clcdf_id, 'classifier_data', classifier_data, rec_count = clepoch_info.maxrec, /zvariable

    IF esa NE -1 THEN BEGIN
        esa_found = where(esa_step EQ esa)
        clepoch = clepoch[esa_found]
        esa_step = esa_step[esa_found]
        classifier_data = classifier_data[esa_found]
    ENDIF 

    IF read_whole_file EQ 0 THEN BEGIN 
        time_found = where(clepoch GE start_time AND clepoch LE stop_time)
        clepoch = clepoch[time_found]
        esa_step = esa_step[time_found]
        classifier_data = classifier_data[time_found]
    ENDIF 

    FOR ii = 0, 2 DO BEGIN ; for each graph
        CASE ii OF
            0: temp_index = where((block_id GE '00'x) AND (block_id LT '08'x))
            1: temp_index = where((block_id GE '08'x) AND (block_id LT '10'x))
            2: temp_index = where((block_id GE '10'x) AND (block_id LT '18'x))
        ENDCASE
        counts[ii] = counts[ii] + total(data)
    ENDFOR 
ENDIF 

plot_data_class, 'Sw_H_alpha_', limits, counts, 3, .55, .9, .09, .24

plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
!NOERAS = 0
temp_name = outname
command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + outname + ' ' + temp_name + '.png'
spawn, command_string
END 
