; Lorna Ellis
; 4/24/06
; normalized_pha.pro

; This is a rewrite of plot_pha.pro. It uses the rates to normalize
; the PHA.
; This is meant as part of the make_plots_dpu routine

PRO plot_data, data, plot_name, num_bins, limit_array, mycolors, x_left, x_right, y_bottom, y_top
; in : data        : the data array: plot, priority, 1000x1000, numbins
;      plot_name   : the prefix of the plot being plotted
;      num_bins    : the number of bins
;      limit_array : the array of limits (16 x 4)
;      mycolors    : array of colors for 4 priorities
;      pos_x_left  : used for setting the plot on the page
;      pos_x_right : used for setting the plot on the page
;      pos_y_bottom: used for setting the plot on the page
;      pos_y_top   : used for setting the plot on the page

myxrange = intarr(2)
myxrange[0] = 1
myxrange[1] = 1000
myyrange = intarr(2)
myyrange[0] = 1
myyrange[1] = 1000

PLOT, data, /NODATA, TITLE = plot_name, XTITLE = 'Mass/Charge [amu/q]', YTITLE = 'Mass', $
      XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 9,  YSTYLE = 9, /XLOG, /YLOG, $
      XTICKNAME = ['0.1', '1.0', '10.0', '100.0'], YTICKNAME = ['0.1', '1.0', '10.0', '100.0'], BACKGROUND = 255, COLOR = 0, $
      POSITION = [x_left, y_bottom+.06, x_right, y_top]

FOR j = 0, 3 DO BEGIN ; priorities
    temp_data = reform(data[j, *, *, *])
    non_zero = WHERE(temp_data, num_non_zero)
    FOR i = 0, num_non_zero-1 DO BEGIN
        temp_index = non_zero[i]
        temp_z = temp_index / 1000000
        temp_xy = temp_index MOD 1000000
        temp_y = temp_xy / 1000
        temp_x = temp_xy MOD 1000
        OPLOT, [temp_x], [temp_y], PSYM = 1, COLOR = mycolors[j]
    ENDFOR
ENDFOR 
FOR i = 0, num_bins-1 DO BEGIN 
    IF limit_array[i, 2] EQ -2 THEN limit_array[i, 2] = .2 ; check for -2 in m/q
    IF limit_array[i, 3] EQ -2 THEN limit_array[i, 3] = .5
    IF limit_array[i, 2] EQ -1 THEN BEGIN ; check for -1 in m/q
        IF limit_array[i, 3] NE -1 THEN BEGIN
            print, "Error with limits"
        ENDIF 
        limit_array[i, 2] = .2
        limit_array[i, 3] = 99
    ENDIF
    IF limit_array[i, 0] EQ -1 THEN BEGIN ; check for -1 in mass
        IF limit_array[i, 1] NE -1 THEN BEGIN
            print, "Error with limits"
        ENDIF 
        limit_array[i, 0] = .5
        limit_array[i, 1] = 99
    ENDIF
    FOR j = 0, 3 DO BEGIN
        IF limit_array[i, j] EQ 100 THEN limit_array[i, j] = 99  ; so see limit on graph
    ENDFOR 
ENDFOR 
FOR i = 0, num_bins-1 DO BEGIN
    OPLOT, [limit_array[i, 0]*10, limit_array[i, 1]*10], [limit_array[i, 2]*10, limit_array[i, 2]*10]
    OPLOT, [limit_array[i, 0]*10, limit_array[i, 1]*10], [limit_array[i, 3]*10, limit_array[i, 3]*10]
    OPLOT, [limit_array[i, 0]*10, limit_array[i, 0]*10], [limit_array[i, 2]*10, limit_array[i, 3]*10]
    OPLOT, [limit_array[i, 1]*10, limit_array[i, 1]*10], [limit_array[i, 2]*10, limit_array[i, 3]*10]
ENDFOR 
END


PRO plot_data2, file_name, limits, counts, num_bins, pos_x_left, pos_x_right, pos_y_bottom, pos_y_top
; in : file_name   : the prefix of the plot being plotted
;      limits      : the limits array: for each bin, limits 
;      counts      : array: for each bin, the count
;      num_bins    : the number of bins
;      pos_x_left  : used for setting the plot on the page
;      pos_x_right : used for setting the plot on the page
;      pos_y_bottom: used for setting the plot on the page
;      pos_y_top   : used for setting the plot on the page

; change form of data
data2 = FLTARR(1001, 1001)
FOR i = 0, num_bins-1 DO BEGIN
    IF limits[i, 2] EQ -2 THEN limits[i, 2] = .2  ; check for -2 in m/q
    IF limits[i, 3] EQ -2 THEN limits[i, 3] = .5
    IF limits[i, 2] EQ -1 THEN BEGIN            ; check for -1 in m/q
        IF limits[i, 3] NE -1 THEN BEGIN
            print, "Error with limits"
            stop
        ENDIF 
        limits[i, 2] = .2
        limits[i, 3] = 100
    ENDIF
    IF limits[i, 0] EQ -1 THEN BEGIN            ; check for -1 in mass
        IF limits[i, 1] NE -1 THEN BEGIN
            print, "Error with limits"
            stop
        ENDIF 
        limits[i, 0] = .5
        limits[i, 1] = 100
    ENDIF
ENDFOR
FOR i = 1, num_bins DO BEGIN         ; fill each bin, in reverse order (num_bins-i)
    m_q_min = limits[num_bins-i, 0] * 10
    m_q_max = limits[num_bins-i, 1] * 10
    mass_min = limits[num_bins-i, 2] * 10
    mass_max = limits[num_bins-i, 3] * 10
    FOR j = num_bins-i, num_bins-2 DO BEGIN   ; empty any overlapping bins (j+i)
        j_m_q_min = limits[j, 0] * 10
        j_m_q_max = limits[j, 1] * 10
        j_mass_min = limits[j, 2] * 10
        j_mass_max = limits[j, 3] * 10
        FOR k = j_m_q_min, j_m_q_max DO BEGIN
            FOR l = j_mass_min, j_mass_max DO BEGIN
                IF k GE m_q_min AND k LE m_q_max AND l GE mass_min AND l LE mass_max THEN data2[k, l] = 0
            ENDFOR
        ENDFOR
    ENDFOR
    data2[m_q_min:m_q_max, mass_min:mass_max] = counts[num_bins-i] ; fill full array
ENDFOR

; empty "throw-away" bins
;counts[num_bins:15] = 0L

; determine the number of levels
level_array = SORT(counts)
temp = -1
num_levels = 0
FOR i = 0, num_bins-1 DO BEGIN
    IF counts[level_array[i]] NE temp AND level_array[i] LT num_bins THEN BEGIN
        num_levels = num_levels + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR
mylevels = LONARR(num_levels)
level = 0
temp = -1
FOR i = 0, num_bins-1 DO BEGIN
    IF counts[level_array[i]] NE temp AND level_array[i] LT num_bins THEN BEGIN
        mylevels[level] = counts[level_array[i]]
        level = level + 1
        temp = counts[level_array[i]]
    ENDIF
ENDFOR

; plot data
mytitle = file_name
myxrange = intarr(2)
myxrange[0] = 1
myxrange[1] = 1000
myyrange = intarr(2)
myyrange[0] = 1
myyrange[1] = 1000
mycolors = FLTARR(num_levels)
FOR i = 0, num_levels-1 DO BEGIN
    mycolors[i] = (i * 250/num_levels) + 10
ENDFOR

;plot axis and first bin
xmin = limits[0, 0] * 10        ; get first min m/q
xmax = limits[0, 1] * 10
ymin = limits[0, 2] * 10
ymax = limits[0, 3] * 10
data3 = FLTARR(xmax-xmin+1, ymax-ymin+1)
data3 = data2[xmin:xmax, ymin:ymax]
x = FLTARR(xmax-xmin+1)
FOR i = 0, xmax-xmin DO BEGIN
    x[i] = xmin + i
ENDFOR
y = FLTARR(ymax-ymin+1)
FOR i = 0, ymax-ymin DO BEGIN
    y[i] = ymin + i
ENDFOR
CONTOUR, data3, x, y, /FILL, TITLE = mytitle, XTITLE = 'Mass/Charge [amu/q]', YTITLE = 'Mass', $
         XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
         C_COLORS = mycolors, LEVELS = mylevels, /XLOG, /YLOG, XTICKNAME = ['0.1', '1.0', '10.0', '100.0'], $
         YTICKNAME = ['0.1', '1.0', '10.0', '100.0'], BACKGROUND = 255, COLOR = 0, $
         POSITION = [pos_x_left, pos_y_bottom+.06, pos_x_right, pos_y_top]

;plot the rest of the bins
FOR j = 1, num_bins-1 DO BEGIN 
    xmin = limits[j, 0] * 10      ; get first min m/q
    xmax = limits[j, 1] * 10
    ymin = limits[j, 2] * 10
    ymax = limits[j, 3] * 10
    data3 = FLTARR(xmax-xmin+1, ymax-ymin+1)
    data3 = data2[xmin:xmax, ymin:ymax]
    x = FLTARR(xmax-xmin+1)
    FOR i = 0, xmax-xmin DO BEGIN
        x[i] = xmin + i
    ENDFOR
    y = FLTARR(ymax-ymin+1)
    FOR i = 0, ymax-ymin DO BEGIN
        y[i] = ymin + i
    ENDFOR
    CONTOUR, data3, x, y, /FILL, /OVERPLOT, NLEVELS = num_levels, $
             C_COLORS = mycolors, LEVELS = mylevels 
ENDFOR

legend_data = intarr(num_levels+1, 2)
legend_levels = intarr(num_levels+1)
myticks = STRARR(num_levels+1)
myticks[0] = STRING(0, FORMAT = '(F4.0)')
FOR k = 0, num_levels DO BEGIN
    legend_data[k, 0:1] = k
    legend_levels[k] = k
    IF k LT num_levels THEN myticks[k+1] = STRING(mylevels[k], FORMAT = '(I5)')
ENDFOR
myticks[0] = STRING(mylevels[0], FORMAT = '(I5)')
myxrange[0] = 0
myxrange[1] = num_levels
myyrange[0] = 0
myyrange[1] = 1
CONTOUR, legend_data, /FILL, TITLE = ' ', XTITLE = 'Number of Counts', COLOR = 0, $
         XRANGE = myxrange, YRANGE = myyrange, XSTYLE = 1,  YSTYLE = 1, NLEVELS = num_levels, $
         C_COLORS = mycolors, LEVELS = legend_levels, YTICKS = 1, YTICKINTERVAL = 5, $
         XTICKNAME = myticks, XTICKINTERVAL = 1, POSITION = [pos_x_left, pos_y_bottom, pos_x_right, pos_y_top-.135]
END


PRO normalized_pha, logname, energy, esa_wanted, species, full_limits, full_bins, full_num_bins, $
  a1, a2, a3, a4, a5, a6, a_e, a_t, b_e, b_t, c2, d, d1, d2, e_max, e_min, mass_max, mass_min, t_max, t_min, $
  pac, mass_low_bound, mq_low_bound, log_position
; in:  logname       : filename whose PHA data we will read
;      energy        : string with energy wanted (for titles)
;      esa_wanted    : esa step corresponding to energy -- -1 means
;                                                       accumulate all
;      species       : string with species targeted (for titles)
;      full_limits   : array of limits as read (12 x 16 x 5) (last 4 are
;                      limits)
;      full_bins     : array of limits as bins (12 x 16 x 5)
;      full_num_bins : array (size 12) of num bins per category
;      a1            : constant from file
;      a2            : constant from file
;      a3            : constant from file
;      a4            : constant from file
;      a5            : constant from file
;      a6            : constant from file
;      a_e           : constant from file
;      a_t           : constant from file
;      b_e           : constant from file
;      b_t           : constant from file
;      c2            : constant from file
;      d             : constant from file
;      d1            : constant from file
;      d2            : constant from file
;      e_max         : constant from file
;      e_min         : constant from file
;      mass_max      : constant from file
;      mass_min      : constant from file
;      t_max         : constant from file
;      t_min         : constant from file
;      pac           : from settings file
;      mass_low_bound: from find_bins
;      mq_low_bound  : from find_bins
;      log_position  : for title


tab = STRING(9B)
pha_line = ' '
sw_line = ' '
wap_ssd_line = ' '
wap_nossd_line = ' '
plot_names = ['SwPha', 'WapPha_ssd', 'WapPha_nossd']
num_bins = [4, 4, 2]
full_limit_index = [0, 0, 1]   ; index for these plots into full_limits array
n = N_ELEMENTS(plot_names)
limits = FLTARR(n, 4, 4)                 ; each plot, for each bin level: m/q min, m/q max, mass min, mass max
sw_pha_a = lonarr(4, 128, 16)  ; bins, esa, defl (summed every 2) -- gotten from priority in PHA word
sw_pha_b = lonarr(4)           ; bins  -- gotten from derived priority
wap_ssd_pha_a = lonarr(4, 128, 16) ; bins, esa, defl (summed every 2)
wap_ssd_pha_b = lonarr(4)      ; bins
wap_nossd_pha_a = lonarr(2, 128, 16) ; bins, esa, defl (summed every 2)
wap_nossd_pha_b = lonarr(2)    ; bins
pha_ended = 0

; find limits for these plots
FOR i = 0, n-1 DO BEGIN 
    FOR j = 0, num_bins[i]-1 DO BEGIN ; for each bin
        FOR k = 0, 3 DO BEGIN         ; min, max, min, max
            limits[i, j, k] = full_limits[full_limit_index[i], j, k+1] ; k+1 because full_limits also has bin label
        ENDFOR
    ENDFOR
ENDFOR 

pha_filename = 'Apid315_'+logname
sw_filename = 'Apid321_'+logname
wap_ssd_filename = 'Apid322_'+logname
wap_nossd_filename = 'Apid323_'+logname
pha_pathname = 'Output/'+pha_filename
sw_pathname = 'Output/'+sw_filename
wap_ssd_pathname = 'Output/'+wap_ssd_filename
wap_nossd_pathname = 'Output/'+wap_nossd_filename
openr, pha_lun, pha_pathname, /get_lun
readf, pha_lun, pha_line         ; read past first two lines
readf, pha_lun, pha_line
openr, sw_lun, sw_pathname, /get_lun
readf, sw_lun, sw_line         ; read past first two lines
readf, sw_lun, sw_line
openr, wap_ssd_lun, wap_ssd_pathname, /get_lun
readf, wap_ssd_lun, wap_ssd_line         ; read past first two lines
readf, wap_ssd_lun, wap_ssd_line
openr, wap_nossd_lun, wap_nossd_pathname, /get_lun
readf, wap_nossd_lun, wap_nossd_line         ; read past first two lines
readf, wap_nossd_lun, wap_nossd_line

num_cycles = 0
have_first_pha = 0
have_sw = 0
WHILE eof(sw_lun) EQ 0 DO BEGIN 
    IF have_sw EQ 0 THEN BEGIN 
        readf, sw_lun, sw_line
        sw_parts = strsplit(sw_line, /EXTRACT)
        sw_timestamp = sw_parts[0]+'T'+sw_parts[1]
        sw_utc = anytim2utc(sw_timestamp)
        sw_sec = utc2sec(sw_utc)
        readf, wap_ssd_lun, wap_ssd_line
        wap_ssd_parts = strsplit(wap_ssd_line, /EXTRACT)
        wap_ssd_timestamp = wap_ssd_parts[0]+'T'+wap_ssd_parts[1]
        wap_ssd_utc = anytim2utc(wap_ssd_timestamp)
        wap_ssd_sec = utc2sec(wap_ssd_utc)
        readf, wap_nossd_lun, wap_nossd_line
        wap_nossd_parts = strsplit(wap_nossd_line, /EXTRACT)
        wap_nossd_timestamp = wap_nossd_parts[0]+'T'+wap_nossd_parts[1]
        wap_nossd_utc = anytim2utc(wap_nossd_timestamp)
        wap_nossd_sec = utc2sec(wap_nossd_utc)
        IF wap_ssd_sec LT sw_sec THEN BEGIN ; get to next apid322 cycle
            FOR i = 0, 127 DO BEGIN ; read through rest of cycle
                readf, wap_ssd_lun, wap_ssd_line
            ENDFOR 
            wap_ssd_parts = strsplit(wap_ssd_line, /EXTRACT)
            wap_ssd_timestamp = wap_ssd_parts[0]+'T'+wap_ssd_parts[1]
            wap_ssd_utc = anytim2utc(wap_ssd_timestamp)
            wap_ssd_sec = utc2sec(wap_ssd_utc)
            IF wap_ssd_sec LT sw_sec THEN print, "error in wap_ssd_sec"
        ENDIF 
        IF wap_nossd_sec LT sw_sec THEN BEGIN ; get to next apid322 cycle
            FOR i = 0, 127 DO BEGIN ; read through rest of cycle
                readf, wap_nossd_lun, wap_nossd_line
            ENDFOR 
            wap_nossd_parts = strsplit(wap_nossd_line, /EXTRACT)
            wap_nossd_timestamp = wap_nossd_parts[0]+'T'+wap_nossd_parts[1]
            wap_nossd_utc = anytim2utc(wap_nossd_timestamp)
            wap_nossd_sec = utc2sec(wap_nossd_utc)
            IF wap_nossd_sec LT sw_sec THEN print, "error in wap_nossd_sec"
        ENDIF 

                                ; read sw_rates
        sw_rate = lonarr(4, 128, 16) ; bins, esa, defl(summed over 2)
        reads, sw_parts[6], sw_esa
        FOR i = 0, 3 DO BEGIN   ; 4 bins
            sw_rate[i, sw_esa, *] = sw_parts[(9+(i*16)):(24+(i*16))]
        ENDFOR 
        FOR j = 0, 126 DO BEGIN ; 127 more esa steps
            FOR i = 0, 3 DO BEGIN ; 4 bins
                sw_rate[i, sw_esa, *] = sw_parts[(9+(i*16)):(24+(i*16))]
            ENDFOR 
        ENDFOR 
                                ; read wap_ssd_rates
        wap_ssd_rate = lonarr(2, 128) ; bins, esa
        reads, wap_ssd_parts[6], wap_ssd_esa
        wap_ssd_rate[0, wap_ssd_esa] = wap_ssd_parts[9]
        wap_ssd_rate[1, wap_ssd_esa] = wap_ssd_parts[10]
        FOR j = 0, 126 DO BEGIN ; 127 more esa steps
            wap_ssd_rate[0, wap_ssd_esa] = wap_ssd_parts[9]
            wap_ssd_rate[1, wap_ssd_esa] = wap_ssd_parts[10]
        ENDFOR 
                                ; read wap_nossd_rates
        wap_nossd_rate = lonarr(2, 128) ; bins, esa
        reads, wap_nossd_parts[6], wap_nossd_esa
        wap_nossd_rate[0, wap_nossd_esa] = wap_nossd_parts[9]
        wap_nossd_rate[1, wap_nossd_esa] = wap_nossd_parts[10]
        FOR j = 0, 126 DO BEGIN ; 127 more esa steps
            wap_nossd_rate[0, wap_nossd_esa] = wap_nossd_parts[9]
            wap_nossd_rate[1, wap_nossd_esa] = wap_nossd_parts[10]
        ENDFOR 
        have_sw = 1
    ENDIF 

    ; read PHA
    IF have_first_pha EQ 0 THEN BEGIN 
        readf, pha_lun, pha_line
        pha_parts = strsplit(pha_line, /EXTRACT)
        pha_timestamp = pha_parts[0]+'T'+pha_parts[1]
        pha_utc = anytim2utc(pha_timestamp)
        pha_sec = utc2sec(pha_utc)
        have_first_pha = 1
    ENDIF 
    IF ((sw_sec-pha_sec GE -20) AND (sw_sec-pha_sec LE 20) AND (pha_ended EQ 0)) THEN BEGIN  ; in same cycle
        ;print, 'here', sw_timestamp, pha_timestamp
        sw_pha_a = lonarr(4, 128, 16) ; bins, esa, defl (summed every 2) -- gotten from priority in PHA word
        sw_pha_b = lonarr(4) ; bins  -- gotten from derived priority
        wap_ssd_pha_a = lonarr(4, 128, 16) ; bins, esa, defl (summed every 2)
        wap_ssd_pha_b = lonarr(4) ; bins
        wap_nossd_pha_a = lonarr(2, 128, 16) ; bins, esa, defl (summed every 2)
        wap_nossd_pha_b = lonarr(2) ; bins
        FOR i = 0, 4 DO BEGIN ; sum 5 cycles
            FOR j = 0, 768 DO BEGIN ; 768 events per cycle
                IF j NE 0 OR i NE 0 THEN BEGIN
                    IF eof(pha_lun) EQ 0 THEN readf, pha_lun, pha_line ELSE BEGIN 
                        IF pha_ended EQ 0 THEN BEGIN 
                            print, 'pha ended in middle of 5 minutes' 
                            pha_ended = 1
                        ENDIF
                    ENDELSE 
                ENDIF 
                IF pha_ended EQ 0 THEN BEGIN 
                    pha_parts = strsplit(pha_line, /EXTRACT)
                    day = pha_parts[0]
                    time = pha_parts[1]
                    swpe = long(pha_parts[15]) ; convert to a long
                    swpd = long(pha_parts[16])
                    quadrant = long(pha_parts[17]) ; no-SSD half has PHA quadrants 3 & 4
                    ssd_id = long(pha_parts[18])
                    ssde_un = long(pha_parts[19])
                    tof = long(pha_parts[20])
                    position = long(pha_parts[21])
                    section = long(pha_parts[22])
                    priority = long(pha_parts[23])
                    IF section EQ 3 THEN half = 1L ELSE half = 0L

; get counts based on given priority
                    IF swpe NE 0 OR swpd NE 0 OR quadrant NE 0 OR ssd_id NE 0 OR ssde_un NE 0 OR tof NE 0 $
                      OR position NE 0 OR section NE 0 OR priority NE 0 THEN BEGIN 
                        IF esa_wanted EQ -1 OR swpe EQ esa_wanted OR (swpe-128) EQ esa_wanted THEN BEGIN 
                            IF half EQ 0 THEN BEGIN ; SSD
                                IF section EQ 2 THEN BEGIN ; Wap SSD
                                    wap_ssd_pha_a[priority, swpe, (swpd/2)] = wap_ssd_pha_a[priority, swpe, (swpd/2)] + 1
                                ENDIF ELSE BEGIN ; SW SSD
                                    sw_pha_a[priority, swpe, (swpd/2)] = sw_pha_a[priority, swpe, (swpd/2)] + 1
                                ENDELSE 
                            ENDIF ELSE BEGIN ; WAP non-SSD
                                wap_nossd_pha_a[priority, swpe, (swpd/2)] = wap_nossd_pha_a[priority, swpe, (swpd/2)] + 1
                            ENDELSE 
                        ENDIF
                    ENDIF 

; Calculate NQ table
; Convert time channels (Tch) to nanoseconds (Tns)
                    tns =  tof * a_t + b_t ; Tch is TOF
; Convert E/Q steps to keV
                    s = 127 - swpe
                    e_per_q =  d1 * d2^s
; Calculate Mass per charge for each T -- E/Q pair
                    c1 = (4.38E7)^2/(1E9)^2/d^2
                    m_per_q = c1 * (pac + e_per_q - c2) * (tns)^2
                    IF half EQ 0 THEN m_per_q = m_per_q * 0.525626 ; SSD 5.8^2 / 8^2 for different flight path
; get bin 
                    bin = 0
                    IF half EQ 0 THEN mq_index = 1 ELSE mq_index = 0  
                    while (bin gt -1) and (bin lt 255) do begin
                        if m_per_q ge mq_low_bound[mq_index, bin] and m_per_q le mq_low_bound[mq_index, bin+1] then begin
                            nq = bin
                            bin = -1
                        endif else bin = bin + 1
                    endwhile
                    if bin eq 255 then begin
                        nq = bin
                    endif

; Calculate NM 
; Convert uncompressed energy channel to keV
                    e_meas = ssde_un*a_e + b_e
; Calculate mass
                    x = alog(e_meas)
                    y = alog(tns)
                    mass = EXP(a1 + a2*X + a3*y + a4*x*y + a5*x^2 + a6*y^3)
; Convert to a bin number
                    if e_meas le e_min then bin = 0 $ ; get bin
                    else if e_meas ge e_max then bin = 93 $
                         else if tns le t_min then bin = 94 $
                              else if tns ge t_max then bin = 95 $
                                   else if mass ge mass_max then bin = 91 $
                                        else IF mass le mass_min then bin = 92 $
                                             else begin
                        found = 0
                        bin = 1
                        while found eq 0 do begin
                            if mass ge mass_low_bound[bin] and mass le mass_low_bound[bin+1] then begin
                                found = 1
                            endif else bin = bin + 1
                        endwhile
                        if found eq 0 then print, 'Error determining mass for ssde, tof', ssde_com, tof
                    ENDELSE 
                    nm = bin

; Calculate the bin_dat_word
; Create bin_dat_words
                    value = 0L
                    find_bindatword2, half, nm, nq, full_bins, full_num_bins, pha_pri, supra_no_e, supra_wide, swz2, sw_all, $
                                      sw_h_alpha, bin_dat_word
                    bin = bin_dat_word

; find address that will be incremented.
; If no address, then bin won't be incremented.
; Addresses end in 0, but the corresponding address that ends in 1
; also needs to be checked.
; First find POS (*not* position)
                    IF section EQ 0 OR section EQ 1 THEN POS = position - 16 $
                    ELSE BEGIN
                        IF quadrant EQ 0 THEN POS = (ishft(position, -3) AND '3'X) $
                        ELSE POS = (ishft((quadrant AND '1'X), 2) OR (ishft(position, -4) AND '3'X))
                    ENDELSE 
; pha_pri_addr
                    IF (section AND '2'X) EQ 0 THEN pha_pri_addr = ('2F00'X OR (ishft((pha_pri AND '3'X), 6)) OR $
                                                                    (ishft((swpd AND '1F'X), 1))) $
                    ELSE pha_pri_addr = ('3200'X OR (ishft((pha_pri AND '1'X), 2)) OR (ishft((section AND '1'X), 1)))
; supra_no_e_addr
                    IF ((section AND '2'X) EQ 0) OR (supra_no_e EQ '7'X) THEN supra_no_e_addr = 0 $
                    ELSE supra_no_e_addr = ('3100'X OR (ishft((supra_no_e AND '7'X), 5)) OR (ishft((POS AND '7'X), 2)) $
                                            OR (ishft((section AND '1'), 1)))
; supra_wide_addr
                    IF (section NE 2) OR (supra_wide EQ 'F'X) THEN supra_wide_addr = 0 $
                    ELSE supra_wide_addr = ('3000'X OR (ishft((supra_wide AND 'F'X), 4)) OR (ishft((POS AND '7'X), 1)))
;swz2_addr
                    IF ((section AND '2'X) EQ 2) OR (swz2 EQ 'F'X) THEN swz2_addr = 0 $
                    ELSE swz2_addr = ('2000'X OR (ishft((swz2 AND 'F'X), 8)) OR (ishft((POS AND '1E'X), 3)) $
                                      OR (ishft((swpd AND '1C'X), -1)))
; sw_all_addr
                    IF ((section AND '2'X) EQ 2) OR (sw_all EQ 1) THEN sw_all_addr = 0 $
                    ELSE sw_all_addr = ('1800'X OR (ishft((POS AND '1F'X), 6)) OR (ishft((swpd AND '1F'X), 1)))
;sw_h_alpha_addr
                    IF ((section AND '2'X) EQ 2) OR (sw_h_alpha EQ 3) THEN sw_h_alpha_addr = 0  $
                    ELSE sw_h_alpha_addr = ((ishft((sw_h_alpha AND '3'X), 11)) OR (ishft((POS AND '1F'X), 6)) $
                                            OR (ishft((swpd AND '1F'X), 1)))

; collect data for plotting
                    IF swpe NE 0 OR swpd NE 0 OR quadrant NE 0 OR ssd_id NE 0 OR ssde_un NE 0 OR tof NE 0 $
                      OR position NE 0 OR section NE 0 OR priority NE 0 THEN BEGIN 
                        IF esa_wanted EQ -1 OR swpe EQ esa_wanted OR (swpe-128) EQ esa_wanted THEN BEGIN 
                            plot_mass = round(mass*10)
                            IF plot_mass LT 0 THEN plot_mass = 2
                            IF plot_mass GT 1000 THEN plot_mass = 999
                            plot_m_q = round(m_per_q*10)
                            IF plot_m_q GE 1000 THEN plot_m_q = 999
                            IF half EQ 0 THEN BEGIN ; SSD
                                IF section EQ 2 THEN BEGIN ; Wap SSD
                                    pha_pri_msb = ISHFT(pha_pri, -1) ; get MSB of pha_pri
                                    IF pha_pri_addr NE 0 THEN wap_ssd_pha_b[(pha_pri_msb*2)] = wap_ssd_pha_b[(pha_pri_msb*2)] + 1
                                ENDIF ELSE BEGIN ; SW SSD
                                    IF pha_pri_addr NE 0 THEN sw_pha_b[pha_pri] = sw_pha_b[pha_pri] + 1
                                ENDELSE 
                            ENDIF ELSE BEGIN ; Wap non-SSD
                                pha_pri_msb = ISHFT(pha_pri, -1) ; get MSB of pha_pri
                                IF pha_pri_addr NE 0 THEN wap_nossd_pha_b[(pha_pri_msb*2)] = wap_nossd_pha_b[(pha_pri_msb*2)] + 1
                            ENDELSE 
                        ENDIF 
                    ENDIF 
                ENDIF 
            ENDFOR 
        ENDFOR  
    ENDIF ELSE IF sw_sec GT pha_sec AND pha_ended EQ 0 THEN BEGIN ; need to try next pha cycle
        pha_eof = 0
        FOR i = 0, 767 DO BEGIN 
            IF eof(pha_lun) EQ 0 THEN readf, pha_lun, pha_line ELSE pha_eof = 1
        ENDFOR 
        have_first_pha = 0
        IF pha_eof EQ 0 THEN have_sw = 1 ELSE have_sw = 0
        ;print, 'sw_sec gt five_minutes', sw_timestamp, pha_timestamp
    ENDIF ELSE BEGIN            ; need to try next set of rates
        have_sw = 0
        ;print, 'sw_sec lt five_minutes', sw_timestamp, pha_timestamp
    ENDELSE  
ENDWHILE 

close, pha_lun
close, sw_lun
close, wap_ssd_lun
close, wap_nossd_lun
free_lun, pha_lun
free_lun, sw_lun
free_lun, wap_ssd_lun
free_lun, wap_nossd_lun

; plot data
mydevice = !D.NAME
SET_PLOT, 'PS'
outname = 'Output/norm_pha_'+pha_filename+'.ps'
DEVICE, FILENAME = outname, /COLOR, PORTRAIT = 1, /INCHES, xsize = 8.5, ysize = 10, XOFFSET = 0, YOFFSET = 0
loadct, 39
!NOERAS = 1
xyouts, .15, .96, pha_filename, /NORMAL, size = 1.5
esa_string = STRING(esa_wanted, FORMAT = '(I3)')
kev_string = STRING(energy, FORMAT = '(F6.2)')
subtitle = species+", ESA:"+esa_string+","+kev_string+" keV, "+log_position+" position"
xyouts, .25, .94, subtitle, /NORMAL, size = 1.2
file_array = ['Sw_PHA_', 'Wap_PHA_SSD_', 'Wap_PHA_noSSD']
num_bins_array = [4, 4, 2]
x_left = [.1, .1, .1]
x_right = [.45, .45, .45]
y_bottom = [.75, .53, .31]
y_top = [.9, .68, .46]
n = N_ELEMENTS(file_array)
FOR i = 0, n-1 DO BEGIN
    CASE i OF
        0: BEGIN
            a_array = sw_pha_a
            b_array = sw_pha_b
        END 
        1: BEGIN
            a_array = wap_ssd_pha_a
            b_array = wap_ssd_pha_b
        END 
        2: BEGIN
            a_array = wap_nossd_pha_a
            b_array = wap_nossd_pha_b
        END 
    ENDCASE 
    bins = num_bins[i]
    norm_counts = dblarr(bins)
    FOR j = 0, bins-1 DO BEGIN
        FOR k = 0, 127 DO BEGIN ; esa steps
            FOR m = 0, 15 DO BEGIN ; defl pairs
                norm_counts[j] = norm_counts[j] + (b_array[j] * sw_rate[j, k, m] / a_array[j, k, m])
            ENDFOR
        ENDFOR
    ENDFOR 
    plot_data2, file_array[i], REFORM(limits[i, *, *]), norm_counts, num_bins_array[i], $
                x_left[i], x_right[i], y_bottom[i], y_top[i]
ENDFOR
plot_stamp
DEVICE, /CLOSE
SET_PLOT, mydevice
!NOERAS = 0
stop
END 
