; Lorna Ellis
; 2/10/05
; find_bins.pro

; This is used by make_plots to find the bins for each category, given
; its limits

; in : limits        : array of limits -- 12 categories, 16 bins (not all
;                      used), 5 (bin number, m/q min, m/q max, mass min, mass max)
;      num_bins      : array (size 12) with the number of bins for each
;                      category
;      mass_max      : constant for Mmax
;      mass_min      : constant for Mmin
;      mq_max        : constant for MQmax
;      mq_min        : constant for MQmin
;      n_max         : constant for NMAX
;      nq_max        : constant for NQMAX
; out: bins          : array of bins -- also 12 x 16 x 5
;      mass_low_bound: array with low bounds for mass
;      mq_low_bound  : array with low bounds for m/q  (nonSSD and SSD)

PRO find_bins_dpu, limits, num_bins, mass_max, mass_min, mq_max, mq_min, n_max, nq_max, $
               bins, mass_low_bound, mq_low_bound

bins = INTARR(12, 16, 5)

; Convert the mass-per-charge to a bin number
mq_low_bound = fltarr(2, 256)   ; nonSSD, SSD -- 256 bins
mq_low_bound[0, 0] = 0.0
mq_low_bound[1, 0] = 0.0
k_q = (mq_max/mq_min)^(1/nq_max)
FOR i = 1, nq_max DO BEGIN       ; set min bounds for each bin
    mq_low_bound[0, i] = mq_min*(k_q^(i-1))
    mq_low_bound[1, i] = mq_low_bound[0, i] * 5.8 * 5.8 / 64 
ENDFOR 
mq_low_bound[0, 255] = 60
mq_low_bound[1, 255] = mq_low_bound[0, 255] * 5.8 * 5.8 / 64 
; Convert to a bin number
mass_low_bound = fltarr(92)
mass_low_bound[0] = 0.0
k_m = (mass_max/mass_min)^(1/n_max)
for i = 1, n_max do begin
    mass_low_bound[i] = mass_min*(k_m^(i-1))
endfor
mass_low_bound[91] = 95.0

; Convert the bounds to bins for bin_dat_word
FOR i = 0, 11 DO BEGIN   ; 12 categories
    IF i MOD 2 EQ 0 THEN mq_index = 1 ELSE mq_index = 0 ; 1:SSD, 0:noSSD
    FOR j = 0, num_bins[i]-1 DO BEGIN 
        bins[i, j, 0] = limits[i, j, 0]    ; copy bin number
        FOR k = 1, 2 DO BEGIN
            IF limits[i, j, k] EQ -1 THEN bins[i, j, k] = -1  $ ; -1 mean bin all
            ELSE BEGIN
                bin = 0
                WHILE (bin GT -1) AND (bin LT 255) DO BEGIN
                    IF limits[i, j, k] GE mq_low_bound[mq_index, bin] AND limits[i, j, k] LT mq_low_bound[mq_index, bin+1] THEN BEGIN
                        bins[i, j, k] = bin
                        bin = -1
                    ENDIF ELSE bin = bin + 1
                ENDWHILE
                IF bin EQ 255 THEN BEGIN
                    bins[i, j, k] = bin
                ENDIF
            ENDELSE 
        ENDFOR 

        FOR k = 3, 4 DO BEGIN 
            IF limits[i, j, k] EQ -1 THEN bin = -1  $ ; -1 means bin all
            ELSE IF limits[i, j, k] EQ -2 THEN bin =  0   $ ; -2 mean bin 0
                 ELSE  BEGIN 
                found = 0
                bin = 0
                WHILE found EQ 0 AND bin LT 91 DO BEGIN 
                    IF limits[i, j, k] GE mass_low_bound[bin] AND limits[i, j, k] LT mass_low_bound[bin+1] THEN BEGIN 
                        found = 1
                    ENDIF ELSE bin = bin + 1
                ENDWHILE 
                IF bin EQ 91 AND limits[i, j, k] GT mass_low_bound[91] $
                  then print, 'Error in find_bins: Mass out of bounds', limits[i, j, k], mass_low_bound[90]
            ENDELSE 
            bins[i, j, k] = bin
        ENDFOR

        IF bins[1] GT bins[2] THEN BEGIN 
            print, "ERROR in find_bins: invalid M/Q bounds (bin numbers):", bins[1], bins[2]
            stop
        ENDIF
        IF bins[3] GT bins[4] THEN BEGIN
            print, "ERROR in find_bins: invalid mass bounds (bin numbers):", bins[3], bins[4]
            stop
        ENDIF 
    ENDFOR
ENDFOR 

END 
