; Lorna Ellis
; 2/10/05
; find_bindatword2.pro

; This is a major rewrite of find_bindatword
; The indexes into the bounds arrays changed

; in: half       = 0 if ssd; 1 if no ssd
;     nm         = mass
;     nq         = mass per charge
;     limits     = array for limits: 12 categories, 16 bins (not all
;                  used), (bin_number, mq min, mq max, mass min, mass
;                  max)
;     num_bins   = array (12) with number of bins for each category
; out: pha_pri      = value for pha_pri bits
;      supra_no_e   = value for supra_no_e bits
;      supra_wide   = value for supra_wide bits
;      swz2         = value for the swz2 bits
;      sw_all       = value for the sw_all bits
;      sw_H_alpha   = value for the sw_h_alpha bits
;      bin_dat_word = the full bins_dat_word

PRO find_bindatword2, half, nm, nq, limits, num_bins, pha_pri, supra_no_e, supra_wide, swz2, sw_all, sw_h_alpha, bin_dat_word

bin_dat_word = 0L

IF half eq 0 THEN BEGIN     ; SSD
    pha_pri_index = 0
    supra_no_e_index = 2
    supra_wide_index = 4
    swz2_index = 6
    sw_all_index = 8
    sw_h_alpha_index = 10
ENDIF ELSE BEGIN 
    pha_pri_index = 1
    supra_no_e_index = 3
    supra_wide_index = 5
    swz2_index = 7
    sw_all_index = 9
    sw_h_alpha_index = 11
ENDELSE

;set pha bits
found = 0
pha_pri = 0L
k = num_bins[pha_pri_index] - 1
FOR i = 0, k DO BEGIN
    j = k - i   ; go backward
    IF limits[pha_pri_index, j, 1] EQ -1 THEN BEGIN
        found = 1
        pha_pri = long(limits[pha_pri_index, j, 0])
    ENDIF $
    ELSE IF (nq GE limits[pha_pri_index, j, 1]) AND $
      (nq LE limits[pha_pri_index, j, 2]) AND $
      (nm GE limits[pha_pri_index, j, 3]) AND $
      (nm LE limits[pha_pri_index, j, 4]) THEN BEGIN 
        found = 1
        pha_pri = long(limits[pha_pri_index, j, 0])
    ENDIF 
ENDFOR 
IF found EQ 0 THEN BEGIN 
    print, "Error in find_bindatword, pha_pri_rate not found"
ENDIF
bin_dat_word = bin_dat_word or (ishft(pha_pri, 14))

;set supra no E
found = 0
supra_no_e = 0L
FOR i = 0, 7 DO BEGIN
    j = 7 - i   ; go backward
    IF limits[supra_no_e_index, j, 1] EQ -1 THEN BEGIN
        found = 1
        supra_no_e = long(limits[supra_no_e_index, j, 0])
    ENDIF $
    ELSE IF (nq GE limits[supra_no_e_index, j, 1]) AND (nq LE limits[supra_no_e_index, j, 2]) AND $
      (nm GE limits[supra_no_e_index, j, 3]) AND (nm LE limits[supra_no_e_index, j, 4]) THEN BEGIN
        found = 1
        supra_no_e = long(limits[supra_no_e_index, j, 0])
    ENDIF
ENDFOR 
IF found EQ 0 THEN print, "Error in find_bindatword, supra_no_e not found"
bin_dat_word = bin_dat_word OR (ishft(supra_no_e, 11))

;set supra_wide bits
found = 0
supra_wide = 0L
k = num_bins[supra_wide_index] - 1
FOR i = 0, k DO BEGIN 
    j = k - i   ; go backward
    IF limits[supra_wide_index, j, 1] EQ -1 THEN BEGIN
        found = 1
        supra_wide = long(limits[supra_wide_index, j, 0])
    ENDIF $
    ELSE IF (nq GE limits[supra_wide_index, j, 1]) AND (nq LE limits[supra_wide_index, j, 2]) AND $
      (nm GE limits[supra_wide_index, j, 3]) AND (nm LE limits[supra_wide_index, j, 4]) THEN BEGIN
        found = 1
        supra_wide = long(limits[supra_wide_index, j, 0])
    ENDIF 
ENDFOR 
IF found EQ 0 THEN print, "Error in find_bindatword, supra_wide not found"
bin_dat_word = bin_dat_word OR (ishft(supra_wide, 7))

;set swz2 bits
found = 0
swz2 = 0L
k = num_bins[swz2_index] - 1
FOR i = 0, k DO BEGIN
    j = k - i   ; go backward
    IF limits[swz2_index, j, 1] EQ -1 THEN BEGIN
        found = 1
        swz2 = long(limits[swz2_index, j, 0])
    ENDIF $
    ELSE IF (nq GE limits[swz2_index, j, 1]) AND (nq LE limits[swz2_index, j, 2]) $
      AND (nm GE limits[swz2_index, j, 3]) AND (nm LE limits[swz2_index, j, 4]) THEN BEGIN 
        found = 1
        swz2 = long(limits[swz2_index, j, 0])
    ENDIF 
ENDFOR 
IF found EQ 0 THEN print, "Error in find_bindatword, swz2 not found"
bin_dat_word = bin_dat_word OR (ishft(swz2, 3))

;set sw_all bits
found = 0
sw_all = 0L
j = 0
IF limits[sw_all_index, j, 1] EQ -1 THEN BEGIN
    found = 1
    sw_all = long(limits[sw_all_index, j, 0])
ENDIF $
ELSE IF (nq GE limits[sw_all_index, j, 1]) AND (nq LE limits[sw_all_index, j, 2]) AND $
 (nm GE limits[sw_all_index, j, 3]) AND (nm LE limits[sw_all_index, j, 4]) THEN BEGIN 
    found = 1
    sw_all = long(limits[sw_all_index, j, 0])
ENDIF 
IF found EQ 0 THEN print, "Error in find_bindatword, sw_all not found"
bin_dat_word = bin_dat_word OR (ishft(sw_all, 3))

;set sw_h_alpha bits
found = 0
sw_h_alpha = 0L
k = num_bins[sw_h_alpha_index] - 1
FOR i = 0, k DO BEGIN
    j = k - i   ; go backward
    IF limits[sw_h_alpha_index, j, 1] EQ -1 THEN BEGIN
        found = 1
        sw_h_alpha = long(limits[sw_h_alpha_index, j, 0])
    ENDIF $
    ELSE IF (nq GE limits[sw_h_alpha_index, j, 1]) AND (nq LE limits[sw_h_alpha_index, j, 2]) AND $
      (nm GE limits[sw_h_alpha_index, j, 3]) AND (nm LE limits[sw_h_alpha_index, j, 4]) THEN BEGIN 
        found = 1
        sw_h_alpha = long(limits[sw_h_alpha_index, j, 0])
    ENDIF 
ENDFOR 
IF found EQ 0 THEN print, "Error in find_bindatword, sw_h_alpha not found"
bin_dat_word = bin_dat_word OR sw_h_alpha

END 
