; 11/28/2007 Removed concat_dir.

PRO read_spacecraft_cdf
COMMON read_cdf_com

read_spacecraft_indices, spacecraft_double_products, spacecraft_char_products

; open file
spacecraft_hk_st = 'spacecraft_hk_' + in_file
if n_elements(out_directory) eq 1 then out_spacecraft_hk_filename = out_directory+'/'+spacecraft_hk_st ELSE $
  out_spacecraft_hk_filename = spacecraft_hk_st
openw, out_spacecraft_lun, out_spacecraft_hk_filename, /get_lun
header = 'Spacecraft Housekeeping from file: '+in_file+$
         ' Instrument: '+instrument_id+$
         ' CdfReader Version: '+string(version)
printf, out_spacecraft_lun, header
header = 'Day'+tab+'Time'+tab+'PL_EBOX_TMP (deg C)'+tab+'PL_PWR_CUR (Amps)'+tab+'PL_SURV_PWR_CUR (Amps)'+tab+$
         'PL_TOF_TMP (deg C)'+tab+'PL_PWR_VT'+$
         tab+'PL_SURV_PWR_VT'+tab+'PL_INST_MSG_PWR_DWN_REQ'+tab+'PL_PWR_TT'+tab+'PL_SURV_PWR_TT'
printf, out_spacecraft_lun, header
    
                                ; get epoch
cdf_control, cdf_sp_id, get_var_info = epoch_sp_info, var = 'epoch', /zvariable
IF epoch_sp_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, cdf_sp_id, 'epoch', temp_epoch_sp, rec_count = epoch_sp_info.maxrec+1, /zvariable
    epoch_sp = cdf2utc(temp_epoch_sp, /ccsds)

; get data
    dbl_values = dblarr(n_elements(spacecraft_double_products), epoch_sp_info.maxrec+1)
    FOR ii = 0, n_elements(spacecraft_double_products)-1 DO BEGIN 
        dbl_name = spacecraft_double_products[ii]
        cdf_varget, cdf_sp_id, dbl_name, temp_dbl_values, rec_count = epoch_sp_info.maxrec+1, /zvariable
        dbl_values[ii, *] = temp_dbl_values
    ENDFOR
    char_values = strarr(n_elements(spacecraft_char_products), epoch_sp_info.maxrec+1)
    FOR ii = 0, n_elements(spacecraft_char_products)-1 DO BEGIN 
        char_name = spacecraft_char_products[ii]
        cdf_varget, cdf_sp_id, char_name, temp_char_values, rec_count = epoch_sp_info.maxrec+1, /zvariable
        temp_string_val = string(temp_char_values[0, *])
        FOR jj = 1, 31 DO BEGIN 
            temp_string_val = temp_string_val+string(temp_char_values[jj, *])
        ENDFOR 
        char_values[ii, *] = temp_string_val
    ENDFOR
; write data
    FOR ii = 0L, epoch_sp_info.maxrec DO BEGIN
        IF read_whole_file EQ 1 OR (epoch_sp[ii] GE start_time AND epoch_sp[ii]) LE stop_time THEN BEGIN 
            temp_string = strmid(epoch_sp[ii], 0, 10)+tab+strmid(epoch_sp[ii], 11, 12)
            FOR jj = 0, n_elements(spacecraft_double_products)-1 DO BEGIN
                IF dbl_values[jj, ii] EQ -1 THEN temp_string = temp_string+tab+' ' $
                ELSE temp_string = temp_string+tab+string(dbl_values[jj, ii])
            ENDFOR
            FOR jj = 0, n_elements(spacecraft_char_products)-1 DO BEGIN
                temp_string = temp_string+tab+string(char_values[jj, ii])
            ENDFOR
            printf, out_spacecraft_lun, temp_string
        ENDIF 
    ENDFOR 
ENDIF 
; close file
close, out_spacecraft_lun
free_lun, out_spacecraft_lun
END
