; Lorna Ellis
; 05/01/2007
; read_mom_conv_cdf

; This reads a moments calibration file in order to create reverse
; moments in the read_cdf program.


PRO read_mom_conv_cdf, filename
COMMON read_cdf_com

line = ' '
step_var = 0D
table_norm = dblarr(4) ; D,V,P,H
geom = dblarr(2) ; M,S
sw_h_eff = dblarr(32, 3) ; 32 lines, vel, energy, efficiency
sw_all_eff = dblarr(32, 3)
openr, cal_lun, filename, /get_lun
found_step = 0
WHILE eof(cal_lun) EQ 0 AND found_step EQ 0 DO BEGIN 
    readf, cal_lun, line
    parts = strsplit(line, /extract)
    IF parts[0] EQ 'step_variable' THEN BEGIN 
        step_var = double(parts[1])
        found_step = 1
    ENDIF
ENDWHILE 
found_table_norm = 0
WHILE eof(cal_lun) EQ 0 AND found_table_norm EQ 0 DO BEGIN 
    readf, cal_lun, line
    parts = strsplit(line, /extract)
    IF parts[0] EQ 'table_norm_values' THEN BEGIN 
        IF parts[1] NE 'D' THEN BEGIN
            print, 'Error in reading moments calibration'
            stop
        ENDIF ELSE table_norm[0] = double(parts[2])
        readf, cal_lun, line
        parts = strsplit(line, /extract)
        IF parts[0] NE 'table_norm_values' OR parts[1] NE 'V' THEN BEGIN
            print, 'Error in reading moments calibration'
            stop
        ENDIF ELSE table_norm[1] = double(parts[2])
        readf, cal_lun, line
        parts = strsplit(line, /extract)
        IF parts[0] NE 'table_norm_values' OR parts[1] NE 'P' THEN BEGIN
            print, 'Error in reading moments calibration'
            stop
        ENDIF ELSE table_norm[2] = double(parts[2])
        readf, cal_lun, line
        parts = strsplit(line, /extract)
        IF parts[0] NE 'table_norm_values' OR parts[1] NE 'H' THEN BEGIN
            print, 'Error in reading moments calibration'
            stop
        ENDIF ELSE table_norm[3] = double(parts[2])
        found_table_norm = 1
    ENDIF
ENDWHILE 
found_geom_factor = 0
WHILE eof(cal_lun) EQ 0 AND found_geom_factor EQ 0 DO BEGIN 
    readf, cal_lun, line
    parts = strsplit(line, /extract)
    IF parts[0] EQ 'geom_factor' THEN BEGIN 
        IF parts[1] NE 'S' THEN BEGIN
            print, 'Error in reading moments calibration'
            stop
        ENDIF ELSE geom[1] = double(parts[2])
        readf, cal_lun, line
        parts = strsplit(line, /extract)
        IF parts[0] NE 'geom_factor' OR parts[1] NE 'M' THEN BEGIN
            print, 'Error in reading moments calibration'
            stop
        ENDIF ELSE geom[0] = double(parts[2])
        found_geom_factor = 1
    ENDIF
ENDWHILE 
found_sw_h_eff = 0
WHILE eof(cal_lun) EQ 0 AND found_sw_h_eff EQ 0 DO BEGIN 
    readf, cal_lun, line
    parts = strsplit(line, /extract)
    IF parts[0] EQ 'sw_h' THEN BEGIN 
        sw_h_eff[0, *] = double(parts[1:3])
        FOR jj = 1, 31 DO BEGIN ; 32 lines total
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] NE  'sw_h' THEN BEGIN 
                print, "unexpected number of lines"
                stop
            ENDIF ELSE sw_h_eff[jj, *] = double(parts[1:3])
        ENDFOR
        found_sw_h_eff = 1
    ENDIF
ENDWHILE
found_sw_all_eff = 0
WHILE eof(cal_lun) EQ 0 AND found_sw_all_eff EQ 0 DO BEGIN 
    readf, cal_lun, line
    parts = strsplit(line, /extract)
    IF parts[0] EQ 'sw_all' THEN BEGIN 
        sw_all_eff[0, *] = double(parts[1:3])
        FOR jj = 1, 31 DO BEGIN ; 32 lines total
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] NE  'sw_all' THEN BEGIN 
                print, "unexpected number of lines"
                stop
            ENDIF ELSE sw_all_eff[jj, *] = double(parts[1:3])
        ENDFOR
        found_sw_all_eff = 1
    ENDIF
ENDWHILE
close, cal_lun
free_lun, cal_lun
END
