; Lorna Ellis
; 3/1/06
; read_cdf.pro

; This program reads a .cdf file and looks for the
; specified apids. It then writes out the data for these apids in a
; text file. 

; 2006 Dec. 7  version 1, initial release
; 2007 Jan. 25 version 2, added choice of esa steps for pha data
; 2007 Feb. 15 version 4, fixed order of moments
; 2007 March 7 version 5, added selections for pha data
; 2007 May 1   version 6, added reverse moments
; 2007 Oct. 24            Check for files before trying to open
; 2007 Nov. 27            added pha_time; removed from sswidl

PRO read_cdf
COMMON read_cdf_com, tab, cdf_id, cdf_sp_id, cdf_hk_id, cdf_cl_id, epoch1, epoch5_mon, epoch5_heavy, epoch1info, epoch5info_mon, epoch5info_heavy, cycle1, cycle5_mon, cycle5_heavy, schan1, schan5_mon, schan5_heavy, num5, proton_peak, alpha_peak, in_file, out_directory, instrument_id, version, start_time, stop_time, read_whole_file, error1, error5_mon, error5_heavy, cdf_version, pha_start_esa_wanted, pha_stop_esa_wanted, pha_separate_esa, start_swpd_wanted, stop_swpd_wanted, start_quad_wanted, stop_quad_wanted, start_ssd_id_wanted, stop_ssd_id_wanted, start_ssde_wanted, stop_ssde_wanted, start_tof_wanted, stop_tof_wanted, start_pos_wanted, stop_pos_wanted, start_portion_wanted, stop_portion_wanted, start_pri_wanted, stop_pri_wanted, step_var, table_norm, geom, sw_h_eff, sw_all_eff, apids_wanted, apid325_moment, apid325_reverse_moment, apid315_time, apid315_space

version = 6

tab = STRING(9B)
apids_wanted = intarr(27)
apid200 = 0
apid313 = 1
apid315_time = 2
apid315_space = 3
apid316 = 4
apid317 = 5
apid318 = 6
apid31a_b = 7
apid31c_d = 8
apid31e = 9
apid31f = 10
apid320 = 11
apid321 = 12
apid322 = 13
apid323 = 14
apid324 = 15
apid325 = 16
apid325_moment = 17
apid325_reverse_moment = 18
apid326 = 19
apid327 = 20
apid328_9 = 21
spacecraft_hk = 22
errors = 23

; read settings file
settings_file = 'read_cdf.settings'
openr, settings_lun, settings_file, /get_lun
line = ' '
FOR i = 0, 4 DO BEGIN 
    readf, settings_lun, line
ENDFOR 
readf, settings_lun, directory_mode
IF (directory_mode NE 2) AND (directory_mode NE 1) THEN BEGIN
    print, 'ERROR: invalid directory mode'
    stop
ENDIF 
IF directory_mode EQ 1 THEN BEGIN ; directory mode
    FOR i = 0, 2 DO BEGIN 
        readf, settings_lun, line
    ENDFOR 
    in_directory = line
    FOR i = 0, 5 DO BEGIN   ; ignore file name
        readf, settings_lun, line
    ENDFOR 
ENDIF ELSE BEGIN ; file mode
    FOR i = 0, 2 DO BEGIN 
        readf, settings_lun, line
    ENDFOR 
    in_directory = line
    FOR i = 0, 2 DO BEGIN  
        readf, settings_lun, line
    ENDFOR 
    in_file = line
    FOR i = 0, 2 DO BEGIN 
        readf, settings_lun, line
    ENDFOR 
ENDELSE 
out_directory = line
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, read_whole_file
IF (read_whole_file NE 0) AND (read_whole_file NE 1) THEN BEGIN
    print, 'ERROR: invalid entry for read whole file'
    stop
ENDIF 
FOR i = 0, 3 DO BEGIN 
    readf, settings_lun, line
ENDFOR 
start_time = line
readf, settings_lun, line
stop_time = line
; get swpe steps wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_swpe_wanted = fix(parts[0])
stop_swpe_wanted = fix(parts[1])
; get swpd steps wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_swpd_wanted = fix(parts[0])
stop_swpd_wanted = fix(parts[1])
; get quadrants wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_quad_wanted = fix(parts[0])
stop_quad_wanted = fix(parts[1])
; get ssd_id wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_ssd_id_wanted = fix(parts[0])
stop_ssd_id_wanted = fix(parts[1])
; get ssde wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_ssde_wanted = fix(parts[0])
stop_ssde_wanted = fix(parts[1])
; get tof wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_tof_wanted = fix(parts[0])
stop_tof_wanted = fix(parts[1])
; get position wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_pos_wanted = fix(parts[0])
stop_pos_wanted = fix(parts[1])
; get portion wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_portion_wanted = fix(parts[0])
stop_portion_wanted = fix(parts[1])
; get priorities wanted for pha
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
parts = strsplit(line, /extract)
start_pri_wanted = fix(parts[0])
stop_pri_wanted = fix(parts[1])
; get if want pha separated by esa
readf, settings_lun, line
readf, settings_lun, line
pha_separate_esa = -1
readf, settings_lun, pha_separate_esa
IF pha_separate_esa NE 0 AND pha_separate_esa NE 1 THEN print, 'ERROR: invalid entry for pha_separate_esa', pha_separate_esa
IF pha_separate_esa EQ 0 THEN BEGIN 
    pha_start_esa_wanted = [start_swpe_wanted]
    pha_stop_esa_wanted = [stop_swpe_wanted]
ENDIF ELSE BEGIN
    pha_start_esa_wanted = intarr(stop_swpe_wanted - start_swpe_wanted + 1)
    pha_stop_esa_wanted = intarr(stop_swpe_wanted - start_swpe_wanted + 1)
    FOR ii = start_swpe_wanted, stop_swpe_wanted DO BEGIN 
        pha_start_esa_wanted[ii] = ii
        pha_stop_esa_wanted[ii] = ii
    ENDFOR 
ENDELSE 
; get which products wanted
FOR i = 0, 26 DO BEGIN 
    readf, settings_lun, line
ENDFOR 
parts = strsplit(line, /extract)
FOR i = 0, n_elements(parts)-1 DO BEGIN
    apids_wanted[fix(parts[i])-1] = 1
ENDFOR 
readf, settings_lun, line
readf, settings_lun, line
readf, settings_lun, line
mom_con_file = line ; for table_norm etc for 325_reverse_moments
close, settings_lun
free_lun, settings_lun

IF apids_wanted[apid325_reverse_moment] EQ 1 THEN read_mom_conv_cdf, mom_con_file

IF directory_mode EQ 1 THEN BEGIN 
    cdf_files = file_search(in_directory, '*.cdf', /fully_qualify_path)
    IF (n_elements(cdf_files) GT 1) OR ((n_elements(cdf_files) EQ 1) AND (cdf_files[0] NE '')) THEN have_cdf = 1 ELSE have_cdf = 0
    IF (have_cdf EQ 1) THEN files = cdf_files ELSE BEGIN $
        print, 'Error: Directory has no .tlm, .cdf. or .fin files'
        stop
    ENDELSE 
    temp_names = file_basename(files)
    FOR ii = 0, n_elements(temp_names)-1 DO BEGIN
        IF strlen(temp_names[ii]) EQ 34 THEN temp_name = strmid(temp_names[ii], 0, 10)+strmid(temp_names[ii], 13, 17) $
          ELSE temp_name = strmid(temp_names[ii], 0, 27)
        IF ii EQ 0 THEN file_names = [temp_name] ELSE BEGIN 
            found = 0
            FOR jj = 0, n_elements(file_names)-1 DO BEGIN
                IF file_names[jj] EQ temp_name THEN found = 1 ELSE dummy = dummy
            ENDFOR
            IF found EQ 0 THEN file_names = [file_names, temp_name]
        ENDELSE 
    ENDFOR 
ENDIF ELSE file_names = [in_file]

FOR z = 0, n_elements(file_names)-1 DO BEGIN 
    in_file = file_names[z]
    instrument_id = strmid(in_file, 2, 1)
    cdf_version = fix(strmid(in_file, 25, 2))

    ; sp cdf
    IF (apids_wanted[spacecraft_hk] EQ 1) THEN BEGIN
        in_spfile = strmid(in_file, 0, 10)+'_SC'+strmid(in_file, 10, 17)
        in_spfile_path = in_directory+'/'+in_spfile
        temp_name = in_spfile_path+'.cdf'
        IF file_test(temp_name) EQ 1 THEN BEGIN 
            IF apids_wanted[spacecraft_hk] EQ 1 THEN BEGIN
                cdf_sp_id = cdf_open(in_spfile_path)
                read_spacecraft_cdf
                cdf_close, cdf_sp_id
            ENDIF
        ENDIF ELSE print, 'No such file: ', temp_name
    ENDIF 
    print, 'finished sphk'
    ; hk cdf
    IF (apids_wanted[apid200] EQ 1) OR (apids_wanted[apid313] EQ 1) THEN BEGIN
        in_hkfile = strmid(in_file, 0, 10)+'_HK'+strmid(in_file, 10, 17)
        in_hkfile_path = in_directory+'/'+in_hkfile
        temp_name = in_hkfile_path+'.cdf'
        IF file_test(temp_name) EQ 1 THEN BEGIN 
            cdf_hk_id = cdf_open(in_hkfile_path)
            IF apids_wanted[apid200] EQ 1 THEN read_200_cdf
            IF apids_wanted[apid313] EQ 1 THEN read_313_cdf
            cdf_close, cdf_hk_id
        ENDIF ELSE print, 'No such file: ', temp_name
    ENDIF 
    print, 'finished hk'
    ; data cdf
    IF (apids_wanted[apid315_time] EQ 1) OR (apids_wanted[apid315_space] EQ 1) OR $
      (apids_wanted[apid316] EQ 1) OR (apids_wanted[apid317] EQ 1) OR (apids_wanted[apid318] EQ 1) OR $
      (apids_wanted[apid31a_b] EQ 1) OR (apids_wanted[apid31c_d] EQ 1) OR (apids_wanted[apid31e] EQ 1) OR (apids_wanted[apid31f] EQ 1) OR $
      (apids_wanted[apid320] EQ 1) OR (apids_wanted[apid321] EQ 1) OR (apids_wanted[apid322] EQ 1) OR (apids_wanted[apid323] EQ 1) OR $
      (apids_wanted[apid324] EQ 1) OR (apids_wanted[apid325] EQ 1) OR (apids_wanted[apid325_moment] EQ 1) OR $
      (apids_wanted[apid325_reverse_moment] EQ 1) OR (apids_wanted[apid326] EQ 1) OR (apids_wanted[apid327] EQ 1) OR $
      (apids_wanted[errors] EQ 1) THEN BEGIN 
        in_file_path = in_directory+'/'+in_file
        temp_name = in_file_path+'.cdf'
        IF file_test(temp_name) EQ 1 THEN BEGIN 
            cdf_id = cdf_open(in_file_path)
        ; get data
            IF (apids_wanted[apid315_time] EQ 1) OR (apids_wanted[apid315_space] EQ 1) OR $
              (apids_wanted[apid316] EQ 1) OR (apids_wanted[apid317] EQ 1) OR $
              (apids_wanted[apid324] EQ 1) OR (apids_wanted[apid325] EQ 1) OR (apids_wanted[apid325_moment] EQ 1) OR $
              (apids_wanted[apid325_reverse_moment] EQ 1) OR (apids_wanted[apid326] EQ 1) OR $
              (apids_wanted[apid327] EQ 1) OR (apids_wanted[errors] EQ 1) THEN BEGIN 
                cdf_control, cdf_id, get_var_info = epoch1info, var = 'epoch1', /zvariable
                IF epoch1info.maxrec GE 0 THEN BEGIN 
                    cdf_varget, cdf_id, 'epoch1', temp_epoch1, rec_count = epoch1info.maxrec+1, /zvariable
                    epoch1 = cdf2utc(temp_epoch1, /ccsds)
                    cdf_varget, cdf_id, 'cycle1', cycle1, rec_count = epoch1info.maxrec+1, /zvariable
                    cdf_varget, cdf_id, 's_chan1', schan1, rec_count = epoch1info.maxrec+1, /zvariable
                    cdf_varget, cdf_id, 'error1', error1, rec_count = epoch1info.maxrec+1, /zvariable
                    IF (apids_wanted[apid324] EQ 1) OR (apids_wanted[apid325] EQ 1) THEN $
                      cdf_varget, cdf_id, 'proton_peak', proton_peak, rec_count = epoch1info.maxrec+1, /zvariable
                    IF (apids_wanted[apid326] EQ 1) OR (apids_wanted[apid327] EQ 1) THEN $
                      cdf_varget, cdf_id, 'alpha_peak', alpha_peak, rec_count = epoch1info.maxrec+1, /zvariable
                ENDIF 
                IF (apids_wanted[apid315_time] EQ 1) OR (apids_wanted[apid315_space] EQ 1) THEN read_315_cdf
                IF apids_wanted[apid317] EQ 1 THEN read_317_cdf
                IF apids_wanted[apid324] EQ 1 THEN read_324_cdf
                IF apids_wanted[apid325] EQ 1 THEN read_325_cdf
                IF (apids_wanted[apid325_moment] EQ 1) OR (apids_wanted[apid325_reverse_moment] EQ 1) THEN read_325_moment_cdf
                IF apids_wanted[apid326] EQ 1 THEN read_326_cdf
                IF apids_wanted[apid327] EQ 1 THEN read_327_cdf
            ENDIF 
            print, 'finished 1-min'
            IF (apids_wanted[apid31a_b] EQ 1) OR (apids_wanted[apid31c_d] EQ 1) OR (apids_wanted[apid31e] EQ 1) OR (apids_wanted[apid31f] EQ 1) OR $
              (apids_wanted[apid320] EQ 1) OR (apids_wanted[apid321] EQ 1) OR (apids_wanted[apid322] EQ 1) OR (apids_wanted[apid323] EQ 1) OR (apids_wanted[errors] EQ 1) THEN BEGIN 
                cdf_control, cdf_id, get_var_info = epoch5info_heavy, var = 'epoch5_heavy', /zvariable
                IF epoch5info_heavy.maxrec GE 0 THEN BEGIN 
                    cdf_varget, cdf_id, 'epoch5_heavy', temp_epoch5_heavy, rec_count = epoch5info_heavy.maxrec+1, /zvariable
                    epoch5_heavy = cdf2utc(temp_epoch5_heavy, /ccsds)
                    cdf_varget, cdf_id, 'cycle5_heavy', cycle5_heavy, rec_count = epoch5info_heavy.maxrec+1, /zvariable
                    cdf_varget, cdf_id, 's_chan5_heavy', schan5_heavy, rec_count = epoch5info_heavy.maxrec+1, /zvariable
                    cdf_varget, cdf_id, 'error5_heavy', error5_heavy, rec_count = epoch5info_heavy.maxrec+1, /zvariable
                    IF (apids_wanted[apid31a_b] EQ 1) OR (apids_wanted[apid31c_d] EQ 1) OR (apids_wanted[apid31e] EQ 1) OR $
                      (apids_wanted[apid31f] EQ 1) OR (apids_wanted[apid320] EQ 1) OR (apids_wanted[apid321] EQ 1) OR $
                      (apids_wanted[apid322] EQ 1) OR (apids_wanted[apid323] EQ 1) THEN $
                      cdf_varget, cdf_id, 'heavy_ion_num_summed5', num5, rec_count = epoch5info_heavy.maxrec+1, /zvariable
                ENDIF 
                IF apids_wanted[apid31a_b] EQ 1 THEN read_31a_b_cdf
                IF apids_wanted[apid31c_d] EQ 1 THEN read_31c_d_cdf
                IF apids_wanted[apid31e] EQ 1 THEN read_31e_cdf
                IF apids_wanted[apid31f] EQ 1 THEN read_31f_cdf
                IF apids_wanted[apid320] EQ 1 THEN read_320_cdf
                IF apids_wanted[apid321] EQ 1 THEN read_321_cdf
                IF apids_wanted[apid322] EQ 1 THEN read_322_cdf
                IF apids_wanted[apid323] EQ 1 THEN read_323_cdf
            ENDIF 
            print, 'finished heavy ions'
            IF (apids_wanted[apid316] EQ 1) OR (apids_wanted[errors] EQ 1) THEN BEGIN 
                cdf_control, cdf_id, get_var_info = epoch5info_mon, var = 'epoch5_mon', /zvariable
                IF epoch5info_mon.maxrec GE 0 THEN BEGIN 
                    cdf_varget, cdf_id, 'epoch5_mon', temp_epoch5_mon, rec_count = epoch5info_mon.maxrec+1, /zvariable
                    epoch5_mon = cdf2utc(temp_epoch5_mon, /ccsds)
                    cdf_varget, cdf_id, 'cycle5_mon', cycle5_mon, rec_count = epoch5info_mon.maxrec+1, /zvariable
                    cdf_varget, cdf_id, 's_chan5_mon', schan5_mon, rec_count = epoch5info_mon.maxrec+1, /zvariable
                    cdf_varget, cdf_id, 'error5_mon', error5_mon, rec_count = epoch5info_mon.maxrec+1, /zvariable
                ENDIF 
                read_316_cdf
            ENDIF 
            print, 'finished mon rates'
            IF apids_wanted[errors] EQ 1 THEN read_errors_cdf
            cdf_close, cdf_id
        ENDIF ELSE print, 'No such file: ', temp_name
    ENDIF 
    ; cl cdf
    IF (apids_wanted[apid318] EQ 1) OR (apids_wanted[apid328_9] EQ 1) THEN BEGIN
        in_clfile = strmid(in_file, 0, 10)+'_CL'+strmid(in_file, 10, 17)
        in_clfile_path = in_directory+'/'+in_clfile
        temp_name = in_clfile_path+'.cdf'
        IF file_test(temp_name) EQ 1 THEN BEGIN 
            cdf_cl_id = cdf_open(in_clfile_path)
            IF apids_wanted[apid318] EQ 1 THEN read_318_cdf
            IF apids_wanted[apid328_9] EQ 1 THEN read_328_9_cdf
            cdf_close, cdf_cl_id
        ENDIF ELSE print, 'No such file: ', temp_name
    ENDIF 

    print, "Finished reading file: ", in_file
ENDFOR  
END 
