; Lorna Ellis
; read_328_9_cdf

; Feb. 5, 2007, Changed loop to long.
; 11/28/2007 Removed concat_dir.

PRO read_328_9_cdf
COMMON read_cdf_com

; open file
apid328_9_st = 'Apid328_9_' + in_file
if n_elements(out_directory) eq 1 then out328_9_filename = out_directory+'/'+apid328_9_st ELSE $
  out328_9_filename = apid328_9_st
openw, out328_9_lun, out328_9_filename, /get_lun
header = 'Apid328_9 (Classifier) Data (decimal) from file: '+in_file+' Instrument: '+instrument_id+$
         ' CdfReader Version: '+string(version)
printf, out328_9_lun, header
header = 'Day'+tab+'Time'+tab+'BlockID'+tab+'ESA'+tab
FOR i = 0, 127 DO BEGIN
    header = header+string(i, format = '(I3)')+tab
ENDFOR 
printf, out328_9_lun, header

                                ; get epoch
cdf_control, cdf_cl_id, get_var_info = epoch_cl_info, var = 'epoch_classifier', /zvariable
IF epoch_cl_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, cdf_cl_id, 'epoch_classifier', temp_epoch_cl, rec_count = epoch_cl_info.maxrec+1, /zvariable
    epoch_cl = cdf2utc(temp_epoch_cl, /ccsds)
    
; get data
    cdf_varget, cdf_cl_id, 'block_id_classifier', block_id, rec_count = epoch_cl_info.maxrec+1, /zvariable
    cdf_varget, cdf_cl_id, 'esa_step', esa_step, rec_count = epoch_cl_info.maxrec+1, /zvariable
    cdf_varget, cdf_cl_id, 'classifier_data', classifier_data, rec_count = epoch_cl_info.maxrec+1, /zvariable

; write data
    FOR ii = 0L, epoch_cl_info.maxrec DO BEGIN
        IF read_whole_file EQ 1 OR (epoch_cl[ii] GE start_time AND epoch_cl[ii] LE stop_time) THEN BEGIN 
            IF block_id[ii] NE -1 THEN BEGIN ; ignore records with fill values
                temp_string = strmid(epoch_cl[ii], 0, 10)+tab+strmid(epoch_cl[ii], 11, 12)+tab+$
                              string(block_id[ii])+tab+string(esa_step[ii])
                FOR jj = 0, 127 DO BEGIN
                    temp_string = temp_string+tab+string(classifier_data[jj, ii])
                ENDFOR 
                printf, out328_9_lun, temp_string
            ENDIF
        ENDIF 
    ENDFOR 
ENDIF 
    
; close file
close, out328_9_lun
free_lun, out328_9_lun
END
