; 11/08/2007 Changed header to reflect summing over position.
; 11/15/2007 Added temp_ep to deal with energy peak near edges.
; 11/28/2007 Removed concat_dir.

PRO read_327_cdf
COMMON read_cdf_com

; open file
apid327_st = 'Apid327_' + in_file
if n_elements(out_directory) eq 1 then out327_filename = out_directory+'/'+apid327_st ELSE $
  out327_filename = apid327_st
openw, out327_lun, out327_filename, /get_lun
header = 'Apid327 (He++ TCR) Data (uncompressed decimal) from file: '+in_file+' Instrument: '+instrument_id+$
         ' CdfReader Version: '+string(version)
printf, out327_lun, header
header = 'Day'+tab+'Time'+tab+'Cycle'+tab+'SChan'+tab+'PP'+tab+'DP'+tab+'EP'+tab+'Array'+tab+'ESA'+tab
FOR i = 0, 7 DO BEGIN
    FOR j = -3, 4 DO BEGIN 
        IF i EQ 0 THEN BEGIN
            IF j LT 0 THEN header = header+'P01/03DP'+string(j, format = '(I2)')+tab $
            ELSE header = header+'P01/03DP+'+string(j, format = '(I1)')+tab
        ENDIF ELSE BEGIN 
            IF j LT 0 THEN header = header+'P'+string((i*4), format = '(I2.2)')+'/'+string((i*4+3), format = '(I2.2)')+'DP'+string(j, format = '(I2)')+tab $
            ELSE header = header+'P'+string((i*4), format = '(I2.2)')+'/'+string((i*4+3), format = '(I2.2)')+'DP+'+string(j, format = '(I1)')+tab 
        ENDELSE 
    ENDFOR
ENDFOR 
header = header+'Error'
printf, out327_lun, header

IF epoch1info.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'he++tcr', values, rec_count = epoch1info.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch1info.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch1[ii] GE start_time AND epoch1[ii] LE stop_time) THEN BEGIN 
            header = strmid(epoch1[ii], 0, 10)+tab+strmid(epoch1[ii], 11, 12)+tab+string(cycle1[ii])+tab+$
                     string(schan1[ii])+tab+string(alpha_peak[1, ii])+tab+string(alpha_peak[2, ii])+tab+$
                     string(alpha_peak[0, ii])+tab+string(alpha_peak[3, ii])
            ep = alpha_peak[0, ii]
            IF ep GT 123 THEN temp_ep = 123 ELSE IF ep LT 5 THEN temp_ep = 5 ELSE temp_ep = ep
            FOR kk = 0, 9 DO BEGIN ; esa
                IF array_equal(values[*, *, *, ii], -1) NE 1 THEN BEGIN 
                    temp_string = header+tab+string(temp_ep+kk-5)
                    FOR jj = 0, 7 DO BEGIN ; pos
                        FOR ll = 0, 7 DO BEGIN ; defl
                            temp_string = temp_string+tab+string(values[kk, jj, ll, ii])
                        ENDFOR 
                    ENDFOR
                    temp_string = temp_string+tab+string(error1[ii])
                    printf, out327_lun, temp_string
                ENDIF 
            ENDFOR
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out327_lun
free_lun, out327_lun

END
