; 02/15/07 Fixed order of pressure and heat flux
; 05/01/07 Added reverse moments
; 11/28/2007 Removed concat_dir.

PRO read_325_moment_cdf
COMMON read_cdf_com

; open files
IF apids_wanted[apid325_moment] EQ 1 THEN BEGIN 
    apid325_moment_st = 'Apid325_moment_' + in_file
    if n_elements(out_directory) eq 1 then out325_moment_filename = out_directory+'/'+apid325_moment_st ELSE $
      out325_moment_filename = apid325_moment_st
    openw, out325_moment_lun, out325_moment_filename, /get_lun
    header = 'Apid325 Moment Data from file: '+in_file+' Instrument: '+instrument_id+$
             ' CdfReader Version: '+string(version)+' Uncompressed decimal'
    printf, out325_moment_lun, header
    header = 'Buffer should be 3; Error should be 0; Source: 0=SW-all, 1=SW-H'
    printf, out325_moment_lun, header
    header = 'Day'+tab+'Time'+tab+'Emin'+tab+'Emax'+tab+'SchanConv'+tab+'Source'+tab+$
             'M_N'+tab+'M_Vx'+tab+'M_Vy'+tab+'M_Vz'+tab+'M_Pxx'+tab+'M_Pxy'+tab+'M_Pxz'+tab+'M_Pyy'+tab+'M_Pzy'+tab+'M_Pzz'+tab+$
             'M_Hx'+tab+'M_Hy'+tab+'M_Hz'+tab+'S_N'+tab+'S_Vx'+tab+'S_Vy'+tab+'S_Vz'+tab+'S_Pxx'+tab+'S_Pxy'+tab+'S_Pxz'+tab+$
             'S_Pyy'+tab+'S_Pyz'+tab+'S_Pzz'+tab+'S_Hx'+tab+'S_Hy'+tab+'S_Hz'+tab+'Error'
    printf, out325_moment_lun, header
ENDIF 
IF apids_wanted[apid325_reverse_moment] EQ 1 THEN BEGIN ; open file for apid325_reverse_moment
    apid325_reverse_moment_st = 'Apid325_reverse_moment_' + in_file
    if n_elements(out_directory) eq 1 then out325_reverse_moment_filename = out_directory+'/'+apid325_reverse_moment_st ELSE $
      out325_reverse_moment_filename = apid325_reverse_moment_st
    openw, out325_reverse_moment_lun, out325_reverse_moment_filename, /get_lun
    header = 'Apid325 Converted Moment Data from file: '+in_file+$
             ' Instrument: '+instrument_id+$
             ' CdfReader Version: '+string(version)
    printf, out325_reverse_moment_lun, header
    header = tab+tab+'Spacecraft Coord.'
    printf, out325_reverse_moment_lun, header
    header = 'Day'+tab+'Time'+tab+'Density (1/cm^3)'+tab+'Velocity Total'+tab+'VelocityX (cm/s)'+tab+'VelocityY( cm/s)'+tab+'VelocityZ (cm/s)'
    printf, out325_reverse_moment_lun, header
ENDIF 

IF epoch1info.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'moment_meta', moment_meta, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'density_main', density_main, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'velocity_main', velocity_main, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'heat_flux_main', heat_flux_main, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'temperature_main', temperature_main, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'density_s', density_s, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'velocity_s', velocity_s, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'heat_flux_s', heat_flux_s, rec_count = epoch1info.maxrec+1, /zvariable
    cdf_varget, cdf_id, 'temperature_s', temperature_s, rec_count = epoch1info.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch1info.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch1[ii] GE start_time AND epoch1[ii] LE stop_time) THEN BEGIN 
            IF density_main[ii] NE -1 THEN BEGIN ; skip records with fill values
                temp_string = strmid(epoch1[ii], 0, 10)+tab+strmid(epoch1[ii], 11, 12)
                FOR jj = 0, 3 DO BEGIN
                    temp_string = temp_string+tab+string(moment_meta[jj, ii])
                ENDFOR 
                temp_string = temp_string+tab+string(density_main[ii])
                FOR jj = 0, 2 DO BEGIN 
                    temp_string = temp_string+tab+string(velocity_main[jj, ii])
                ENDFOR 
                FOR jj = 0, 5 DO BEGIN 
                    temp_string = temp_string+tab+string(temperature_main[jj, ii])
                ENDFOR 
                FOR jj = 0, 2 DO BEGIN 
                    temp_string = temp_string+tab+string(heat_flux_main[jj, ii])
                ENDFOR 
                temp_string = temp_string+tab+string(density_s[ii])
                FOR jj = 0, 2 DO BEGIN 
                    temp_string = temp_string+tab+string(velocity_s[jj, ii])
                ENDFOR 
                FOR jj = 0, 5 DO BEGIN 
                    temp_string = temp_string+tab+string(temperature_s[jj, ii])
                ENDFOR  
                FOR jj = 0, 2 DO BEGIN 
                    temp_string = temp_string+tab+string(heat_flux_s[jj, ii])
                ENDFOR 
                temp_string = temp_string+tab+string(error1[ii])
                IF apids_wanted[apid325_moment] EQ 1 THEN printf, out325_moment_lun, temp_string
                IF apids_wanted[apid325_reverse_moment] EQ 1 THEN BEGIN
                    rev_line = strmid(epoch1[ii], 0, 10)+tab+strmid(epoch1[ii], 11, 12)+tab
                    vel_inst = dblarr(3)
                    prefix = table_norm[1]/table_norm[0] ; Bv/Bd in Lynn's document
                    denom = (density_s[ii]/geom[1]) + $ ; Ds/Gs + Dm/Gm
                            (density_main[ii]/geom[0]) 
                    FOR jj = 0, 2 DO BEGIN ; x,y,z
                        numer = (velocity_s[jj, ii]/geom[1]) + $ ; Vx,y,zs/Gs + Vx,y,zm/Gm
                                (velocity_main[jj, ii]/geom[0]) 
                        vel_inst[jj] = prefix * numer / denom
                    ENDFOR
                    vel_spcrft = dblarr(4) ;x,y,z,t
                    vel_spcrft[0] = -1 * vel_inst[0]
                    vel_spcrft[1] = vel_inst[2]
                    vel_spcrft[2] = -1 * vel_inst[1]
                    vel_spcrft[3] = sqrt((vel_spcrft[0]^2)+(vel_spcrft[1]^2)+(vel_spcrft[2]^2))
                    IF moment_meta[3, ii] EQ 0 THEN eff_table = sw_all_eff ELSE eff_table = sw_h_eff
                    found = 0
                    jj = 0
                    WHILE jj LT 32 AND found EQ 0 DO BEGIN ; this takes the lower value
                        IF vel_spcrft[3] GT eff_table[jj, 0] THEN BEGIN
                            efficiency = double(eff_table[jj, 2])
                            found = 1
                        ENDIF ELSE jj = jj + 1
                    ENDWHILE 
                    IF found EQ 0 THEN efficiency = double(eff_table[31, 2])
                                ; density
                    temp_density_main = density_main[ii] * step_var * table_norm[0] / (geom[0] * efficiency)
                    temp_density_s = density_s[ii] * step_var * table_norm[0] / (geom[1] * efficiency)
                    temp_density = temp_density_main + temp_density_s
                    rev_line = rev_line+string(temp_density)+tab+string(vel_spcrft[3])+tab+string(vel_spcrft[0])+tab+$
                               string(vel_spcrft[1])+tab+string(vel_spcrft[2])
                    printf, out325_reverse_moment_lun, rev_line
                ENDIF 
            ENDIF 
        ENDIF 
    ENDFOR 
ENDIF 

; close files
IF apids_wanted[apid325_moment] EQ 1 THEN BEGIN 
    close, out325_moment_lun
    free_lun, out325_moment_lun
ENDIF 
IF apids_wanted[apid325_reverse_moment] EQ 1 THEN BEGIN 
    close, out325_reverse_moment_lun
    free_lun, out325_reverse_moment_lun
ENDIF 

END
