; 11/28/2007 Removed concat_dir.

PRO read_322_cdf
COMMON read_cdf_com

; open file
apid322_st = 'Apid322_' + in_file
if n_elements(out_directory) eq 1 then out322_filename = out_directory+'/'+apid322_st ELSE $
  out322_filename = apid322_st
openw, out322_lun, out322_filename, /get_lun
header = 'Apid322 (WAP Priority SSD rates) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+$
         string(version)
printf, out322_lun, header
header = 'Day'+tab+'Time'+tab+'Cycle'+tab+'ESA'+tab+'SChan'+$
         tab+'NumCount'+tab+'C0'+tab+'C1'+tab+'Error'
printf, out322_lun, header

IF epoch5info_heavy.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'wap_priority_ssd', values, rec_count = epoch5info_heavy.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch5info_heavy.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch5_heavy[ii] GE start_time AND epoch5_heavy[ii] LE stop_time) THEN BEGIN 
            IF values[0, 0, ii] NE -1 THEN BEGIN 
                FOR kk = 0, 127 DO BEGIN ; esa
                    temp_string = strmid(epoch5_heavy[ii], 0, 10)+tab+strmid(epoch5_heavy[ii], 11, 12)+tab+string(cycle5_heavy[ii])+tab+$
                                  string(kk)+tab+string(schan5_heavy[ii])+tab+string(num5[kk, ii])
                    FOR jj = 0, 1 DO BEGIN ; class
                        temp_string = temp_string+tab+string(values[kk, jj, ii])
                    ENDFOR
                    temp_string = temp_string+tab+string(error5_heavy[ii])
                    printf, out322_lun, temp_string
                ENDFOR
            ENDIF 
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out322_lun
free_lun, out322_lun

END
