; 11/28/2007 Removed concat_dir.

PRO read_321_cdf
COMMON read_cdf_com

; open file
apid321_st = 'Apid321_' + in_file
if n_elements(out_directory) eq 1 then out321_filename = out_directory+'/'+apid321_st ELSE $
  out321_filename = apid321_st
openw, out321_lun, out321_filename, /get_lun
header = 'Apid321 (SW Priority rates) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+$
         string(version)
printf, out321_lun, header
header = 'Day'+tab+'Time'+tab+'Cycle'+tab+'ESA'+tab+'SChan'+tab+$
         'NumCount'+tab
FOR j = 0, 3 DO BEGIN           ; 4 Classes
    FOR i = 0, 15 DO BEGIN      ; 16 Defl
        header = header+'C'+string(j, format = '(I1)')+'D'+string(i*2, format = '(I2)')+'/'+string(i*2+1, format = '(I2)')+tab
    ENDFOR 
ENDFOR 
header = header+'Error'
printf, out321_lun, header

IF epoch5info_heavy.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'sw_priority', values, rec_count = epoch5info_heavy.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch5info_heavy.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch5_heavy[ii] GE start_time AND epoch5_heavy[ii] LE stop_time) THEN BEGIN 
            FOR kk = 0, 127 DO BEGIN ; esa
                IF values[kk, 0, 0, ii] NE -1 THEN BEGIN 
                    temp_string = strmid(epoch5_heavy[ii], 0, 10)+tab+strmid(epoch5_heavy[ii], 11, 12)+tab+string(cycle5_heavy[ii])+tab+$
                                  string(kk)+tab+string(schan5_heavy[ii])+tab+string(num5[kk, ii])
                    FOR jj = 0, 3 DO BEGIN ; class
                        FOR ll = 0, 15 DO BEGIN ; defl
                            temp_string = temp_string+tab+string(values[kk, ll, jj, ii])
                        ENDFOR 
                    ENDFOR
                    temp_string = temp_string+tab+string(error5_heavy[ii])
                    printf, out321_lun, temp_string
                ENDIF 
            ENDFOR
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out321_lun
free_lun, out321_lun

END
