; 11/28/2007 Removed concat_dir.

PRO read_31f_cdf
COMMON read_cdf_com

; open file
apid31f_st = 'Apid31F_' + in_file
if n_elements(out_directory) eq 1 then out31f_filename = out_directory+'/'+apid31f_st ELSE $
  out31f_filename = apid31f_st
openw, out31f_lun, out31f_filename, /get_lun
header = 'Apid31F (WAP-SSD-DCR / Supra No E SSD) Data from file: '+in_file+' Instrument: '+instrument_id+$
         ' CdfReader Version: '+string(version)
printf, out31f_lun, header
header = 'Day'+tab+'Time'+tab+'Cycle'+tab+'Class'+tab+'ESA'+tab+'SChan'+tab+'NumCount'+tab
FOR i = 0, 3 DO BEGIN           ; 4 Pos
    header = header+'P'+string(i*2, format = '(I1)')+'/'+string(i*2+1, format = '(I1)')+tab
ENDFOR  
header = header+'Error'
printf, out31f_lun, header

IF epoch5info_heavy.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'wap_ssd_dcr', values, rec_count = epoch5info_heavy.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch5info_heavy.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch5_heavy[ii] GE start_time AND epoch5_heavy[ii] LE stop_time) THEN BEGIN 
            FOR kk = 0, 127 DO BEGIN ; esa
                FOR jj = 0, 6 DO BEGIN ; class
                    IF values[kk, 0, jj, ii] NE -1 THEN BEGIN 
                        temp_string = strmid(epoch5_heavy[ii], 0, 10)+tab+strmid(epoch5_heavy[ii], 11, 12)+tab+$
                                      string(cycle5_heavy[ii])+tab+string(jj)+tab+$
                                      string(kk)+tab+string(schan5_heavy[ii])+tab+string(num5[kk, ii])
                        FOR ll = 0, 3 DO BEGIN ; pos
                            temp_string = temp_string+tab+string(values[kk, ll, jj, ii])
                        ENDFOR 
                        temp_string = temp_string+tab+string(error5_heavy[ii])
                        printf, out31f_lun, temp_string
                    ENDIF 
                ENDFOR
            ENDFOR
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out31f_lun
free_lun, out31f_lun

END
