; 11/28/2007 Removed concat_dir.

PRO read_31c_d_cdf
COMMON read_cdf_com

; open file
apid31c_d_st = 'Apid31C_D_' + in_file
if n_elements(out_directory) eq 1 then out31c_d_filename = out_directory+'/'+apid31c_d_st ELSE $
  out31c_d_filename = apid31c_d_st
openw, out31c_d_lun, out31c_d_filename, /get_lun
header = 'Apid31C_D (SW Z>2 - L) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+string(version)
printf, out31c_d_lun, header
header = 'Day'+tab+'Time'+tab+'Cycle'+tab+'Class'+tab+'ESA'+tab+'SChan'+tab+'NumCount'+tab
FOR i = 0, 7 DO BEGIN           ; 8 Pos
    header = header+'P'+string(i*2, format = '(I2)')+'/'+string(i*2+1, format = '(I2)')+tab
ENDFOR 
header = header+'Error'
printf, out31c_d_lun, header

IF epoch5info_heavy.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'sw_z>2_l', values, rec_count = epoch5info_heavy.maxrec+1, /zvariable

; write data
    temp_t1 = '2006-11-14T16:50:00.000'
    temp_t2 = '2006-11-14T17:09:00.000'
    FOR ii = 0, epoch5info_heavy.maxrec DO BEGIN 
        ;IF epoch5_heavy[ii] GT temp_t1 AND epoch5_heavy[ii] LT temp_t2 THEN stop
        IF read_whole_file EQ 1 OR (epoch5_heavy[ii] GE start_time AND epoch5_heavy[ii] LE stop_time) THEN BEGIN 
            FOR kk = 0, 127 DO BEGIN ; esa
                IF values[kk, 0, 0, ii] NE -1 THEN BEGIN 
                    FOR jj = 0, 7 DO BEGIN ; class
                        temp_string = strmid(epoch5_heavy[ii], 0, 10)+tab+strmid(epoch5_heavy[ii], 11, 12)+tab+$
                                      string(cycle5_heavy[ii])+tab+string(jj+2)+tab+$
                                      string(kk)+tab+string(schan5_heavy[ii])+tab+string(num5[kk, ii])
                        FOR ll = 0, 7 DO BEGIN ; pos
                            temp_string = temp_string+tab+string(values[kk, ll, jj, ii])
                        ENDFOR 
                        temp_string = temp_string+tab+string(error5_heavy[ii])
                        printf, out31c_d_lun, temp_string
                    ENDFOR
                ENDIF 
            ENDFOR
            FOR kk = 0, 127 DO BEGIN ; esa
                FOR jj = 0, 4 DO BEGIN ; class
                    IF values[kk, 0, jj+8, ii] NE -1 THEN BEGIN 
                        temp_string = strmid(epoch5_heavy[ii], 0, 10)+tab+strmid(epoch5_heavy[ii], 11, 12)+tab+$
                                      string(cycle5_heavy[ii])+tab+string(jj+10)+tab+$
                                      string(kk)+tab+string(schan5_heavy[ii])+tab+string(num5[kk, ii])
                        FOR ll = 0, 7 DO BEGIN ; pos
                            temp_string = temp_string+tab+string(values[kk, ll, jj+8, ii])
                        ENDFOR 
                        temp_string = temp_string+tab+string(error5_heavy[ii])
                        printf, out31c_d_lun, temp_string
                    ENDIF 
                ENDFOR
            ENDFOR
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out31c_d_lun
free_lun, out31c_d_lun

END
