; 11/28/2007 Removed concat_dir.

PRO read_31a_b_cdf
COMMON read_cdf_com

; open file
apid31a_b_st = 'Apid31A_B_' + in_file
if n_elements(out_directory) eq 1 then out31a_b_filename = out_directory+'/'+apid31a_b_st ELSE $
  out31a_b_filename = apid31a_b_st
openw, out31a_b_lun, out31a_b_filename, /get_lun
header = 'Apid31A_B (SW Z>2 - H) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+string(version)
printf, out31a_b_lun, header
header = 'Day'+tab+'Time'+tab+'Cycle'+tab+'Class'+tab+'ESA'+tab+'SChan'+tab+'NumCount'+tab
FOR i = 0, 7 DO BEGIN           ; 8 Pos
    FOR j = 0, 7 DO BEGIN       ; D defl
        header = header+'P'+string(i*2, format = '(I2)')+'/'+string(i*2+1, format = '(I2)')+" D"+string(j, format = '(I1)')+tab
    ENDFOR
ENDFOR 
header = header+'Error'
printf, out31a_b_lun, header

IF epoch5info_heavy.maxrec GE 0 THEN BEGIN 
; get data
    cdf_varget, cdf_id, 'sw_z>2_h', values, rec_count = epoch5info_heavy.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch5info_heavy.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch5_heavy[ii] GE start_time AND epoch5_heavy[ii] LE stop_time) THEN BEGIN 
            FOR jj = 0, 1 DO BEGIN ; class
                FOR kk = 0, 127 DO BEGIN ; esa
                    IF values[kk, 0, 0, jj, ii] NE -1 THEN BEGIN 
                        temp_string = strmid(epoch5_heavy[ii], 0, 10)+tab+strmid(epoch5_heavy[ii], 11, 12)+tab+$
                                      string(cycle5_heavy[ii])+tab+string(jj)+tab+$
                                      string(kk)+tab+string(schan5_heavy[ii])+tab+string(num5[kk, ii])
                        FOR ll = 0, 7 DO BEGIN ; pos
                            FOR mm = 0, 7 DO BEGIN ; defl
                                temp_string = temp_string+tab+string(values[kk, ll, mm, jj, ii])
                            ENDFOR
                        ENDFOR 
                        temp_string = temp_string+tab+string(error5_heavy[ii])
                        printf, out31a_b_lun, temp_string
                    ENDIF 
                ENDFOR
            ENDFOR
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out31a_b_lun
free_lun, out31a_b_lun

END
