; 09/05/2007 Changed format so can open in Excel.
; 11/28/2007 Removed concat_dir.

PRO read_318_cdf
COMMON read_cdf_com

; open file
apid318_st = 'Apid318_' + in_file
if n_elements(out_directory) eq 1 then out318_filename = out_directory+'/'+apid318_st ELSE $
  out318_filename = apid318_st
openw, out318_lun, out318_filename, /get_lun
header = 'Apid318 (Memory Dump) Data (hex) from file: '+in_file+' Instrument: '+instrument_id+$
         ' CdfReader Version: '+string(version)
printf, out318_lun, header
header = 'Day'+tab+'Time'+tab+'Device'+tab+'Block'+tab
FOR i = 0, 127 DO BEGIN
    header = header+string((i*2), format = '(I3.3)')+'-'+string((i*2+1), format = '(I3.3)')+tab
ENDFOR 
printf, out318_lun, header

                                ; get epoch
cdf_control, cdf_cl_id, get_var_info = epoch_mem_info, var = 'epoch_memory', /zvariable
IF epoch_mem_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, cdf_cl_id, 'epoch_memory', temp_epoch_mem, rec_count = epoch_mem_info.maxrec+1, /zvariable
    epoch_mem = cdf2utc(temp_epoch_mem, /ccsds)
    
; get data
    cdf_varget, cdf_cl_id, 'device', device, rec_count = epoch_mem_info.maxrec+1, /zvariable
    cdf_varget, cdf_cl_id, 'block_id_memory', block_id, rec_count = epoch_mem_info.maxrec+1, /zvariable
    cdf_varget, cdf_cl_id, 'memory_data', memory_data, rec_count = epoch_mem_info.maxrec+1, /zvariable

; write data
    FOR ii = 0, epoch_mem_info.maxrec DO BEGIN
        IF read_whole_file EQ 1 OR (epoch_mem[ii] GE start_time AND epoch_mem[ii] LE stop_time) THEN BEGIN 
            IF block_id[ii] NE -1 THEN BEGIN ; ignore records with fill values
                temp_string = strmid(epoch_mem[ii], 0, 10)+tab+strmid(epoch_mem[ii], 11, 12)+tab+string(device[ii], format = '(Z2.2)')+tab+$
                              string(block_id[ii], format = '(Z2.2)')
                FOR jj = 0, 127 DO BEGIN
                    temp_string = temp_string+tab+string(memory_data[(jj*2), ii], format = '(Z2.2)')+string(memory_data[(jj*2+1), ii], format = '(Z2.2)')
                ENDFOR 
                printf, out318_lun, temp_string
            ENDIF
        ENDIF 
    ENDFOR 
ENDIF 
    
; close file
close, out318_lun
free_lun, out318_lun
END
