; 11/28/2007 Removed concat_dir.

PRO read_317_cdf
COMMON read_cdf_com

read_mon_indices, apid317_products

; open file
apid317_st = 'Apid317_' + in_file
if n_elements(out_directory) eq 1 then out317_filename = out_directory+'/'+apid317_st ELSE out317_filename = apid317_st
openw, out317_lun, out317_filename, /get_lun
header = 'Apid317 (Mon Rates Full Res) (decimal) from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+$
         string(version)
printf, out317_lun, header
header = 'Day'+tab+'Time'+tab+'ESA'+tab+'DEFL STEP'+tab+$
         'Rate 0'+tab+'Rate 1'+tab+'Rate 2'+tab+'Rate 3'+tab+'Rate 4'+tab+'Rate 5'+tab+'ESA Schan'+tab+$
         'Mode'+tab+'Cycle'+tab+'Error'
printf, out317_lun, header

IF epoch1info.maxrec GE 0 THEN BEGIN 
; get data
    values = lonarr(n_elements(apid317_products), 128, 32, epoch1info.maxrec+1)
    FOR ii = 0, n_elements(apid317_products)-1 DO BEGIN 
        name = apid317_products[ii]+'_full'
        cdf_varget, cdf_id, name, temp_values, rec_count = epoch1info.maxrec+1, /zvariable
        values [ii, *, *, *] = temp_values
    ENDFOR
; write data
    FOR ii = 0, epoch1info.maxrec DO BEGIN 
        IF read_whole_file EQ 1 OR (epoch1[ii] GE start_time AND epoch1[ii] LE stop_time) THEN BEGIN 
            FOR jj = 0, 127 DO BEGIN ; esa
                rate_found = 0
                num_rates = 0
                rate_ids = intarr(6)
                FOR kk = 0, n_elements(apid317_products)-1 DO BEGIN ; rates
                    IF array_equal(values[kk, jj, *, ii], -1) NE 1 THEN BEGIN ; find rates that have valid values
                        IF rate_found EQ 0 THEN BEGIN
                            temp_string = 'Rates'+tab+tab+tab
                            rate_found = 1
                        ENDIF
                        temp_string = temp_string+tab+strupcase(apid317_products[kk])
                        rate_ids[num_rates] = kk
                        num_rates = num_rates+1
                    ENDIF 
                ENDFOR 
                IF rate_found EQ 1 THEN BEGIN 
                    printf, out317_lun, temp_string
                    FOR kk = 0, 31 DO BEGIN ; defl
                        temp_string = strmid(epoch1[ii], 0, 10)+tab+strmid(epoch1[ii], 11, 12)+tab+string(jj)+tab+string(kk)
                        FOR ll = 0, num_rates-1 DO BEGIN 
                            temp_string = temp_string+tab+string(values[rate_ids[ll], jj, kk, ii])
                        ENDFOR
                        FOR ll = num_rates, 5 DO BEGIN
                            temp_string = temp_string+tab
                        ENDFOR 
                        IF num_rates EQ 1 THEN mode = '1' ELSE mode = '2'
                        temp_string = temp_string+tab+string(schan1[ii])+tab+mode+tab+string(cycle1[ii])+tab+string(error1[ii])
                        printf, out317_lun, temp_string
                    ENDFOR
                ENDIF 
            ENDFOR
        ENDIF 
    ENDFOR 
ENDIF 

; close file
close, out317_lun
free_lun, out317_lun

END
