; 11/28/2007 Removed concat_dir.

PRO write_mon_norm_data, record, data_values, resolution, out316_lun
COMMON read_cdf_com
CASE resolution OF
    1: temp_epoch = epoch1[record]
    5: temp_epoch = epoch5_mon[record]
ENDCASE
IF read_whole_file EQ 1 OR (temp_epoch GE start_time AND temp_epoch LE stop_time) THEN BEGIN 
    FOR ii = 0, 31 DO BEGIN     ; esa
        FOR jj = 0, 7 DO BEGIN  ;defl
            CASE resolution OF 
                1: temp_string = strmid(epoch1[record], 0, 10)+tab+strmid(epoch1[record], 11, 12)
                5: temp_string = strmid(epoch5_mon[record], 0, 10)+tab+strmid(epoch5_mon[record], 11, 12)
            ENDCASE 
            IF ii * 4 LT 10 THEN esa_start = string(ii*4, format = '(I1.1)') $
            ELSE IF ii * 4 LT 100 THEN esa_start = string(ii*4, format = '(I2.2)') $
                 ELSE esa_start = string(ii*4, format = '(I3.3)') 
            IF ii*4+3 LT 10 THEN esa_stop = string(ii*4+3, format = '(I1.1)') $
            ELSE IF ii*4+3 LT 100 THEN esa_stop = string(ii*4+3, format = '(I2.2)') $
                 ELSE esa_stop = string(ii*4+3, format = '(I3.3)') 
            IF jj * 4 LT 10 THEN defl_start = string(jj*4, format = '(I1.1)') $
            ELSE IF jj * 4 LT 100 THEN defl_start = string(jj*4, format = '(I2.2)') 
            IF jj*4+3 LT 10 THEN defl_stop = string(jj*4+3, format = '(I1.1)') $
            ELSE IF jj*4+3 LT 100 THEN defl_stop = string(jj*4+3, format = '(I2.2)') 
            temp_string = temp_string+tab+'ESA'+esa_start+'/'+esa_stop+' D'+defl_start+'/'+defl_stop
            FOR kk = 0, n_elements(data_values[*, 0, 0, 0])-1 DO BEGIN
                temp_string = temp_string+tab+string(data_values[kk, ii, jj, record])
            ENDFOR
                                ;IF ii EQ 0 AND jj EQ 0 THEN stop
            CASE resolution OF 
                1: temp_string = temp_string+tab+string(fix(schan1[record]))+tab+'2'+tab+string(fix(cycle1[record]))+tab+string(fix(error1[record]))
                5: temp_string = temp_string+tab+string(fix(schan5_mon[record]))+tab+'1'+tab+string(fix(cycle5_mon[record]))+tab+string(fix(error5_mon[record]))
            ENDCASE 
            printf, out316_lun, temp_string
        ENDFOR
    ENDFOR 
ENDIF 
END 


PRO read_316_cdf
COMMON read_cdf_com

read_mon_indices, apid316_products

; open file
apid316_st = 'Apid316_' + in_file
if n_elements(out_directory) eq 1 then out316_filename = out_directory+'/'+apid316_st ELSE out316_filename = apid316_st
openw, out316_lun, out316_filename, /get_lun
header = 'Apid316 (Mon Rates Norm Res) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+$
         string(version)
printf, out316_lun, header
header = 'Day'+tab+'Time'+tab+'ESA/Defl'+tab+'S_VALID'+tab+'S_E_NOT_REQ'+tab+'S_E_REQ'+tab+'S_NO_POS'+tab+$
         'S_MULT_POS'+tab+'S_NO_E'+tab+'S_MULT_E'+tab+'RA_SAT_A'+tab+'RA_SAT_B'+tab+'RA_SAT_BOTH'+tab+'SSD_SW'+tab+$
         'SSD_ST'+tab+'SF0'+tab+'SFR0'+tab+'STP0'+tab+'RA_TRIG'+tab+'POS1_0'+tab+'POS1_1'+tab+'W_NO_POS'+tab+$
         'W_MULT_POS'+tab+'W_VALID'+tab+'SF2'+tab+'SFR2'+tab+'STP2'+tab+'POS2_0'+tab+'POS2_1'+tab+'POS2_2'+tab+$
         'POS2_3'+tab+'POS3_0'+tab+'POS3_1'+tab+'POS3_2'+tab+'POS3_3'+tab+'ESA_Schan'+tab+'Mode'+tab+'Cycle'+tab+'Error'
printf, out316_lun, header

; get data
IF epoch1info.maxrec GE 0 THEN BEGIN 
    eng_values = lonarr(n_elements(apid316_products), 32, 8, epoch1info.maxrec+1)
    FOR ii = 0, n_elements(apid316_products)-1 DO BEGIN 
        eng_name     = apid316_products[ii]+'_norm_eng'
        cdf_varget, cdf_id, eng_name,     temp_eng_values,     rec_count = epoch1info.maxrec+1, /zvariable
        eng_values    [ii, *, *, *] = temp_eng_values
    ENDFOR
    have_eng = 1
ENDIF ELSE have_eng = 0
IF epoch5info_mon.maxrec GE 0 THEN BEGIN 
    science_values = lonarr(n_elements(apid316_products), 32, 8, epoch5info_mon.maxrec+1)
    FOR ii = 0, n_elements(apid316_products)-1 DO BEGIN 
        science_name = apid316_products[ii]+'_norm_science'
        cdf_varget, cdf_id, science_name, temp_science_values, rec_count = epoch5info_mon.maxrec+1, /zvariable
        science_values[ii, *, *, *] = temp_science_values
    ENDFOR
    have_science = 1
ENDIF ELSE have_science = 0
; find valid records
science_count = 0
IF have_science EQ 1 THEN BEGIN
    FOR ii = 0, epoch5info_mon.maxrec DO BEGIN
        IF array_equal(science_values[0, *, *, ii], -1) NE 1 THEN BEGIN
            IF science_count EQ 0 THEN science_indices = [ii] ELSE science_indices = [science_indices, ii]
            science_count = science_count + 1
        ENDIF
    ENDFOR 
ENDIF 
eng_count = 0
IF have_eng EQ 1 THEN BEGIN
    FOR ii = 0, epoch1info.maxrec DO BEGIN
        IF array_equal(eng_values[0, *, *, ii], -1) NE 1 THEN BEGIN
            IF eng_count EQ 0 THEN eng_indices = [ii] ELSE eng_indices = [eng_indices, ii]
            eng_count = eng_count + 1
        ENDIF
    ENDFOR 
ENDIF 
; write data
eng_next_index = 0
FOR ii = 0, science_count-1 DO BEGIN
    science_epoch = epoch5_mon[science_indices[ii]]
    stop_eng_loop = 0
    WHILE eng_next_index LT eng_count AND stop_eng_loop EQ 0 DO BEGIN 
        eng_epoch = epoch1[eng_indices[eng_next_index]]
        IF eng_epoch LE science_epoch THEN BEGIN 
            write_mon_norm_data, eng_indices[eng_next_index], eng_values, 1, out316_lun
            eng_next_index = eng_next_index + 1
        ENDIF ELSE stop_eng_loop = 1
    ENDWHILE 
    write_mon_norm_data, science_indices[ii], science_values, 5, out316_lun
ENDFOR 
WHILE eng_next_index LT eng_count DO BEGIN ; finish eng 
    eng_epoch = epoch1[eng_indices[eng_next_index]]
    write_mon_norm_data, eng_indices[eng_next_index], eng_values, 1, out316_lun
    eng_next_index = eng_next_index + 1
ENDWHILE 

; close file
close, out316_lun
free_lun, out316_lun

END
