; 03/07/2007 Added checks for selecting by each header
; 06/19/2007 Added column for S channel
; 11/21/2007 Added note about defl reversal to header.
; 11/27/2007 Added pha_space.

PRO read_315_cdf
COMMON read_cdf_com

start_swpd_st    = strcompress(string(start_swpd_wanted), /remove_all)
stop_swpd_st     = strcompress(string(stop_swpd_wanted), /remove_all)
start_quad_st    = strcompress(string(start_quad_wanted), /remove_all)
stop_quad_st     = strcompress(string(stop_quad_wanted), /remove_all)
start_ssd_id_st  = strcompress(string(start_ssd_id_wanted), /remove_all)
stop_ssd_id_st   = strcompress(string(stop_ssd_id_wanted), /remove_all)
start_ssde_st    = strcompress(string(start_ssde_wanted), /remove_all)
stop_ssde_st     = strcompress(string(stop_ssde_wanted), /remove_all)
start_tof_st     = strcompress(string(start_tof_wanted), /remove_all)
stop_tof_st      = strcompress(string(stop_tof_wanted), /remove_all)
start_pos_st     = strcompress(string(start_pos_wanted), /remove_all)
stop_pos_st      = strcompress(string(stop_pos_wanted), /remove_all)
start_portion_st = strcompress(string(start_portion_wanted), /remove_all)
stop_portion_st  = strcompress(string(stop_portion_wanted), /remove_all)
start_pri_st     = strcompress(string(start_pri_wanted), /remove_all)
stop_pri_st      = strcompress(string(stop_pri_wanted), /remove_all)
FOR kk = 0, n_elements(pha_start_esa_wanted)-1 DO BEGIN 
; open file
    start_esa_st = strcompress(string(pha_start_esa_wanted[kk]), /remove_all)
    stop_esa_st = strcompress(string(pha_stop_esa_wanted[kk]), /remove_all)
    apid315_time_st = 'Apid315_time_'+start_esa_st+'_'+stop_esa_st+'_'+in_file
    apid315_space_st = 'Apid315_space_'+start_esa_st+'_'+stop_esa_st+'_'+in_file
    if n_elements(out_directory) eq 1 then out315_time_filename = out_directory+'/'+apid315_time_st ELSE out315_filename = apid315_time_st
    if n_elements(out_directory) eq 1 then out315_space_filename = out_directory+'/'+apid315_space_st ELSE out315_filename = apid315_space_st
    IF apids_wanted[apid315_time] EQ 1 THEN BEGIN 
        openw, out315_time_lun, out315_time_filename, /get_lun
        header = 'Apid315_time (PHA events) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+string(version)+$
                 ' NB: Deflections are reversed on odd ESA steps. ESA steps: '+start_esa_st+'-'+stop_esa_st+' SWPD: '+start_swpd_st+'-'+stop_swpd_st+$
                 ' Quadrant: '+start_quad_st+'-'+stop_quad_st+' SSD_ID: '+start_ssd_id_st+'-'+stop_ssd_id_st+$
                 ' SSDE: '+start_ssde_st+'-'+stop_ssde_st+' TOF: '+start_tof_st+'-'+stop_tof_st+' Position: '+start_pos_st+'-'+stop_pos_st+$
                 ' Section: '+start_portion_st+'-'+stop_portion_st+' Priority: '+start_pri_st+'-'+stop_pri_st
        printf, out315_time_lun, header
        header = 'Day'+tab+'Time'+tab+'SWPE(dec)'+tab+'SWPD(dec)'+tab+'Quadrant'+tab+'SSD_ID(dec)'+$
                 tab+'SSDE(dec)'+tab+'TOF(dec)'+tab+'POS(dec)'+tab+'Section'+tab+'Priority'+tab+'StartESA'+tab+'Cycle'+tab+'Error'+tab+'SChan'
        printf, out315_time_lun, header
    ENDIF 
    IF apids_wanted[apid315_space] EQ 1 THEN BEGIN 
        openw, out315_space_lun, out315_space_filename, /get_lun
        header = 'Apid315_space (PHA events) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+string(version)+$
                 ' NB: Deflections are physical order. ESA steps: '+start_esa_st+'-'+stop_esa_st+' SWPD: '+start_swpd_st+'-'+stop_swpd_st+$
                 ' Quadrant: '+start_quad_st+'-'+stop_quad_st+' SSD_ID: '+start_ssd_id_st+'-'+stop_ssd_id_st+$
                 ' SSDE: '+start_ssde_st+'-'+stop_ssde_st+' TOF: '+start_tof_st+'-'+stop_tof_st+' Position: '+start_pos_st+'-'+stop_pos_st+$
                 ' Section: '+start_portion_st+'-'+stop_portion_st+' Priority: '+start_pri_st+'-'+stop_pri_st
        printf, out315_space_lun, header
        header = 'Day'+tab+'Time'+tab+'SWPE(dec)'+tab+'SWPD(dec)'+tab+'Quadrant'+tab+'SSD_ID(dec)'+$
                 tab+'SSDE(dec)'+tab+'TOF(dec)'+tab+'POS(dec)'+tab+'Section'+tab+'Priority'+tab+'StartESA'+tab+'Cycle'+tab+'Error'+tab+'SChan'
        printf, out315_space_lun, header
    ENDIF 
    
    IF epoch1info.maxrec GE 0 THEN BEGIN 
; get data
        cdf_varget, cdf_id, 'pha', pha, rec_count = epoch1info.maxrec+1, /zvariable
        cdf_varget, cdf_id, 'pha_start_esa', start_esa, rec_count = epoch1info.maxrec+1, /zvariable 
; write data
        FOR ii = 0, epoch1info.maxrec DO BEGIN
            IF read_whole_file EQ 1 OR (epoch1[ii] GE start_time AND epoch1[ii] LE stop_time) THEN BEGIN 
                jj = 0
                fill_found = 0
                WHILE (jj LT 768) AND (fill_found EQ 0) DO BEGIN ; number of possible PHA events in each step
                    IF pha[jj, 0, ii] EQ -1 THEN fill_found = 1 ELSE BEGIN
                        IF pha[jj, 0, ii] GE pha_start_esa_wanted[kk] AND pha[jj, 0, ii] LE pha_stop_esa_wanted[kk] AND $
                          pha[jj, 2, ii] GE start_quad_wanted    AND pha[jj, 2, ii] LE stop_quad_wanted AND $
                          pha[jj, 3, ii] GE start_ssd_id_wanted  AND pha[jj, 3, ii] LE stop_ssd_id_wanted AND $
                          pha[jj, 4, ii] GE start_ssde_wanted    AND pha[jj, 4, ii] LE stop_ssde_wanted AND $
                          pha[jj, 5, ii] GE start_tof_wanted     AND pha[jj, 5, ii] LE stop_tof_wanted AND $
                          pha[jj, 6, ii] GE start_pos_wanted     AND pha[jj, 6, ii] LE stop_pos_wanted AND $
                          pha[jj, 7, ii] GE start_portion_wanted AND pha[jj, 7, ii] LE stop_portion_wanted AND $
                          pha[jj, 8, ii] GE start_pri_wanted     AND pha[jj, 8, ii] LE stop_pri_wanted THEN BEGIN 
                            IF apids_wanted[apid315_time] EQ 1 AND pha[jj, 1, ii] GE start_swpd_wanted AND pha[jj, 1, ii] LE stop_swpd_wanted THEN BEGIN 
                                temp_string = strmid(epoch1[ii], 0, 10)+tab+strmid(epoch1[ii], 11, 12)
                                FOR hh = 0, 8 DO BEGIN ; 9 parts of PHA word
                                    temp_string = temp_string+tab+string(pha[jj, hh, ii])
                                ENDFOR
                                temp_string = temp_string+tab+string(fix(start_esa[ii]))+tab+string(cycle1[ii])+tab+string(error1[ii])+tab+string(schan1[ii])
                                printf, out315_time_lun, temp_string
                            ENDIF 
                            IF apids_wanted[apid315_space] EQ 1 THEN BEGIN ; need to reverse defl.
                                IF pha[jj, 0, ii] MOD 2 EQ 1 THEN pha[jj, 1, ii] = 31-pha[jj, 1, ii]
                                IF  pha[jj, 1, ii] GE start_swpd_wanted AND pha[jj, 1, ii] LE stop_swpd_wanted THEN BEGIN 
                                    temp_string = strmid(epoch1[ii], 0, 10)+tab+strmid(epoch1[ii], 11, 12)
                                    FOR hh = 0, 8 DO BEGIN ; 9 parts of PHA word
                                        temp_string = temp_string+tab+string(pha[jj, hh, ii])
                                    ENDFOR
                                    temp_string = temp_string+tab+$
                                                  string(fix(start_esa[ii]))+tab+string(cycle1[ii])+tab+string(error1[ii])+tab+string(schan1[ii])
                                    printf, out315_space_lun, temp_string
                                ENDIF 
                            ENDIF 
                        ENDIF 
                    ENDELSE 
                    jj = jj + 1
                ENDWHILE 
            ENDIF 
        ENDFOR 
    ENDIF 

; close file
    IF apids_wanted[apid315_time] EQ 1 THEN BEGIN 
        close, out315_time_lun
        free_lun, out315_time_lun
    ENDIF 
    IF apids_wanted[apid315_space] EQ 1 THEN BEGIN 
        close, out315_space_lun
        free_lun, out315_space_lun
    ENDIF 
ENDFOR 

END
