; 11/28/2007 Removed concat_dir.

PRO read_313_cdf
COMMON read_cdf_com

read_313_indices, apid313_products

; open file
apid313_st = 'Apid313_' + in_file
if n_elements(out_directory) eq 1 then out313_filename = out_directory+'/'+apid313_st ELSE out313_filename = apid313_st
openw, out313_lun, out313_filename, /get_lun
header = 'Apid313 (Digital HK) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+string(version)
printf, out313_lun, header
header = 'Day'+tab+'Time'
FOR ii = 0, n_elements(apid313_products)-1 DO BEGIN
    header = header+tab+strupcase(apid313_products[ii])
ENDFOR 
printf, out313_lun, header
    
                                ; get epoch
cdf_control, cdf_hk_id, get_var_info = epoch_hk_info, var = 'epoch_digital', /zvariable
IF epoch_hk_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, cdf_hk_id, 'epoch_digital', temp_epoch_hk, rec_count = epoch_hk_info.maxrec+1, /zvariable
    epoch_hk = cdf2utc(temp_epoch_hk, /ccsds)

; get data
    raw_values = lonarr(n_elements(apid313_products), epoch_hk_info.maxrec+1)
    FOR ii = 0, n_elements(apid313_products)-1 DO BEGIN 
        raw_name = apid313_products[ii]
        cdf_varget, cdf_hk_id, raw_name, temp_raw_values, rec_count = epoch_hk_info.maxrec+1, /zvariable
        raw_values[ii, *] = temp_raw_values
    ENDFOR
; write data
    FOR ii = 0L, epoch_hk_info.maxrec DO BEGIN
        IF read_whole_file EQ 1 OR (epoch_hk[ii] GE start_time AND epoch_hk[ii] LE stop_time) THEN BEGIN 
            IF raw_values[0, ii] NE -1 THEN BEGIN ; ignore records with fill values
                temp_string = strmid(epoch_hk[ii], 0, 10)+tab+strmid(epoch_hk[ii], 11, 12)
                FOR jj = 0, n_elements(apid313_products)-1 DO BEGIN
                    temp_string = temp_string+tab+string(raw_values[jj, ii])
                ENDFOR
                printf, out313_lun, temp_string
            ENDIF
        ENDIF 
    ENDFOR 
ENDIF 
    
; close file
    close, out313_lun
    free_lun, out313_lun
END
