; 11/28/2007 Removed concat_dir.

PRO read_200_cdf
COMMON read_cdf_com

read_200_indices, apid200_products

; open file
apid200_st = 'Apid200_' + in_file
if n_elements(out_directory) eq 1 then out200_filename = out_directory+'/'+apid200_st ELSE out200_filename = apid200_st
openw, out200_lun, out200_filename, /get_lun
header = 'Apid200 (Analog HK) Data from file: '+in_file+' Instrument: '+instrument_id+' CdfReader Version: '+string(version)
printf, out200_lun, header
header = 'Day'+tab+'Time'+tab+'Device Code'+tab+'Block ID'+tab+'LRNM_SPARE(raw data)'+tab+'LRNM_SPARE(Volts)'+tab+$
         'LVC_-12V(raw data)'+tab+'LVC_-12V(Volts)'+tab+'LVC_-5V(raw data)'+tab+'LVC_-5V(Volts)'+tab+$
         'ESA_VM_POS(raw data)'+tab+'ESA_VM_POS(Volts)'+tab+'DFL_1_VM(raw data)'+tab+'DFL_1_VM(Volts)'+tab+$
         'DFL_1_TAP(raw data)'+tab+'DFL_1_TAP(Volts)'+tab+'DFL_2_VM(raw data)'+tab+'DFL_2_VM(Volts)'+tab+$
         'DFL_2_TAP(raw data)'+tab+'DFL_2_TAP(Volts)'+tab+'LVC_+2.5VB(raw data)'+tab+'LVC_+2.5VB(Volts)'+tab+$
         'PAC_CM_DC(raw data)'+tab+'PAC_CM_DC(mA)'+tab+'LVC_+12V(raw data)'+tab+'LVC_+12V(Volts)'+tab+$
         'LRPM_SPARE(raw data)'+tab+'LRPM_SPARE(Volts)'+tab+'LVC_+2.5VA(raw data)'+tab+'LVC_+2.5VA(Volts)'+tab+$
         'LVC_+5V(raw data)'+tab+'LVC_+5V(Volts)'+tab+'DAC_ADC_AVDD(raw data)'+tab+'DAC_ADC_AVDD(Volts)'+tab+$
         'DAC_ADC_DVDD(raw data)'+tab+'DAC_ADC_DVDD(Volts)'+tab+'PAC_VM(raw data)'+tab+'PAC_VM(Volts)'+tab+$
         'CAL_VREF(raw data)'+tab+'CAL_VREF(Volts)'+tab+'PAC_CM_AC(raw data)'+tab+'PAC_CM_AC(?)'+tab+$
         'MCP_VM(raw data)'+tab+'MCP_VM(Volts)'+tab+'MCP_CM_DC(raw data)'+tab+'MCP_CM_DC(mA)'+tab+$
         'MCP_CM_AC(raw data)'+tab+'MCP_CM_AC(?)'+tab+'SSD_CM_DC(raw data)'+tab+'SSD_CM_DC(mA)'+tab+$
         'S_CH_VM(raw data)'+tab+'S_CH_VM(Volts)'+tab+'S_CH_VM_TAP(raw data)'+tab+'S_CH_VM_TAP(Volts)'+tab+$
         'S_CH_CM_DC(raw data)'+tab+'S_CH_CM_DC(mA)'+tab+'ESA_VM_NEG(raw data)'+tab+'ESA_VM_NEG(Volts)'+tab+$
         'ESA_CM_DC(raw data)'+tab+'ESA_CM_DC(mA)'+tab+'DFL_1_CM_DC(raw data)'+tab+'DFL_1_CM_DC(mA)'+tab+$
         'DFL_2_CM_DC(raw data)'+tab+'DFL_2_CM_DC(mA)'+tab+'LVC_+2.5VB_IMON(raw data)'+tab+'LVC_+2.5VB_IMON(mA)'+tab+$
         'LVC_+12V_IMON(raw data)'+tab+'LVC_+12V_IMON(mA)'+tab+'LVC_-12V_IMON(raw data)'+tab+'LVC_-12V_IMON(mA)'+tab+$
         'LVC_+5V_IMON(raw data)'+tab+'LVC_+5V_IMON(mA)'+tab+'LVC_-5V_IMON(raw data)'+tab+'LVC_-5V_IMON(mA)'+tab+$
         'LVC_+2.5VA_IMON(raw data)'+tab+'LVC_+2.5VA_IMON(mA)'+tab+'SSD_BIAS_VM(raw data)'+tab+'SSD_BIAS_VM(Volts)'+tab+$
         'ADC_LU_FLAG(raw data)'+tab+'ADC_LU_FLAG(null)'+tab+'PLUG_ID(raw data)'+tab+'PLUG_ID(enum)'+tab+$
         'ADC_LU_CTR(DAC)(raw data)'+tab+'ADC_LU_CTR(DAC)(null)'+tab+'STATUS(DAC)(raw data)'+tab+'STATUS(DAC)(null)'+tab+$
         '[not used]'+tab+'[not used](null)'+tab+'LOGIC_ADC1_AGND(raw data)'+tab+'LOGIC_ADC1_AGND(Volts)(FM1)'+tab+$
         'LOGIC_ADC0_AGND(raw data)'+tab+'LOGIC_ADC0_AGND(Volts)(FM1)'+tab+'RA_E1(raw data)'+tab+'RA_E1(Volts)(FM1)'+tab+$
         'RA_E0(raw data)'+tab+'RA_E0(Volts)(FM1)'+tab+'TAC2_TSP(raw data)'+tab+'TAC2_TSP(deg C)'+tab+$
         'TAC0_TSP(raw data)'+tab+'TAC0_TSP(deg C)'+tab+'SB1_TSP(raw data)'+tab+'SB1_TSP(none)'+tab+$
         'SB0_TSP(raw data)'+tab+'SB0_TSP(none)'+tab+'TOF_HV1_TSP(raw data)'+tab+'TOF_HV1_TSP(deg C)'+tab+$
         'TOF_HV0_TSP(raw data)'+tab+'TOF_HV0_TSP(deg C)'+tab+'S_C_1_TSP(raw data)'+tab+'S_C_1_TSP(deg C)'+tab+$
         'S_C_0_TSP(raw data)'+tab+'S_C_0_TSP(deg C)'+tab+'LVC1_TSP(raw data)'+tab+'LVC1_TSP(deg C)'+tab+$
         'LVC0_TSP(raw data)'+tab+'LVC0_TSP(deg C)'+tab+'LOGIC_ADC1_VREF(raw data)'+tab+'LOGIC_ADC1_VREF(Volts)'+tab+$
         'LOGIC_ADC0_VREF(raw data)'+tab+'LOGIC_ADC0_VREF(Volts)'+tab+'SSD_STATUS(raw data)'+tab+'SSD_STATUS(null)'+tab+$
         'SSD_V_POS_ANALOG(raw data)'+tab+'SSD_V_POS_ANALOG(Volts)'+tab+'SSD_V_NEG_ANALOG(raw data)'+tab+$
         'SSD_V_NEG_ANALOG(Volts)'+tab+'SSD_HV_BIAS(raw data)'+tab+'SSD_HV_BIAS(Volts)'+tab+'SSD_TC0(raw data)'+tab+$
         'SSD_TC0(deg C)'+tab+'SSD_TC1(raw data)'+tab+'SSD_TC1(deg C)'+tab+'SSD_TC2(raw data)'+tab+'SSD_TC2(deg C)'+tab+$
         'SSD_V_POS_DIG(raw data)'+tab+'SSD_V_POS_DIG(Volts)'+tab+'Power_Warning(Flag)'+tab+'Power_Warning(?)'+tab+$
         'Thruster_Warning(Flag)'+tab+'Thruster_Warning(?)'+tab+'Coarse_Pointing(Flag)'+tab+'Coarse_Pointing(?)'
printf, out200_lun, header    
    
                                ; get epoch
cdf_control, cdf_hk_id, get_var_info = epoch_hk_info, var = 'epoch_analog', /zvariable
IF epoch_hk_info.maxrec GE 0 THEN BEGIN 
    cdf_varget, cdf_hk_id, 'epoch_analog', temp_epoch_hk, rec_count = epoch_hk_info.maxrec+1, /zvariable
    epoch_hk = cdf2utc(temp_epoch_hk, /ccsds)
    
; get data
    raw_values = lonarr(n_elements(apid200_products), epoch_hk_info.maxrec+1)
    eng_values = dblarr(n_elements(apid200_products), epoch_hk_info.maxrec+1)
    cdf_varget, cdf_hk_id, 'device_code', devices, rec_count = epoch_hk_info.maxrec+1, /zvariable
    cdf_varget, cdf_hk_id, 'block_id',  block_ids, rec_count = epoch_hk_info.maxrec+1, /zvariable
    ; if before version 5 don't have power_warning, thruster_warning or coarse_pointing
    IF cdf_version GE 5 THEN num_read = n_elements(apid200_products) ELSE num_read = n_elements(apid200_products)-3 
    FOR ii = 0, num_read-1 DO BEGIN 
        raw_name = apid200_products[ii]+'_raw'
        eng_name = apid200_products[ii]+'_eng'
        cdf_varget, cdf_hk_id, raw_name, temp_raw_values, rec_count = epoch_hk_info.maxrec+1, /zvariable
        raw_values[ii, *] = temp_raw_values
        SWITCH ii OF            ; check for those that don't have conversions
            18:                 ; pac_cm_ac
            21:                 ; mcp_cm_ac
            37:                 ; adc_lu_flag
            38:                 ; plug_id
            39:                 ; adc_lu_ctr
            40:                 ; dac_status
            57:                 ; ssd_status
            65:                 ; power_warning 
            66:                 ; thruster_warning
            67: BEGIN           ; coarse_pointing
                eng_values[ii, *] = -99999.
                BREAK
            END
            ELSE: BEGIN 
                cdf_varget, cdf_hk_id, eng_name, temp_eng_values, rec_count = epoch_hk_info.maxrec+1, /zvariable
                eng_values[ii, *] = temp_eng_values
            END 
        ENDSWITCH 
    ENDFOR
; write data
    FOR ii = 0L, epoch_hk_info.maxrec DO BEGIN
        IF read_whole_file EQ 1 OR (epoch_hk[ii] GE start_time AND epoch_hk[ii] LE stop_time) THEN BEGIN 
            IF devices[ii] NE -1 THEN BEGIN ; ignore records with fill values
                temp_string = strmid(epoch_hk[ii], 0, 10)+tab+strmid(epoch_hk[ii], 11, 12)+tab+string(devices[ii])+tab+string(block_ids[ii])
                FOR jj = 0, num_read-1 DO BEGIN
                    IF jj GE 41 AND jj LE 56 THEN BEGIN
                        IF jj MOD 2 EQ 0 THEN kk = jj - 1 ELSE kk = jj + 1 ; print adc0-agnd-adc1_vref in reverse orders
                    ENDIF ELSE kk = jj
                    temp_string = temp_string+tab+string(raw_values[kk, ii])+tab
                    IF eng_values[kk, ii] EQ -99999 THEN temp_string = temp_string+'-99999' ELSE $
                      temp_string = temp_string+string(eng_values[kk, ii], format = '(F10.3)')
                    IF kk EQ 40 THEN temp_string = temp_string+tab+'0'+tab+'-99999'
                ENDFOR
                printf, out200_lun, temp_string
            ENDIF
        ENDIF 
    ENDFOR 
ENDIF 

; close file
    close, out200_lun
    free_lun, out200_lun
END
