; Lorna Ellis
; 3/13/2007
; zip_copy

; This looks in a directory for ascii files (assumed to be output of
; read_cdf program. It zips each day's worth of data, and copies the
; zipped file to the asciipath directory. It then deletes the ascii
; files.

; parameters:
;    in:  cdfoutpath: directory in which to look for ascii files
;         zippath_a : directory in which to put the zipped files ahead
;                       (assumes year below this)
;         zippath_b : directory in which to put the zipped files behind
;                       (assumes year below this)

; 03/26/2007 Added -j to zip command
; 01/03/2008 Added year to zip name.

PRO zip_copy, cdfoutpath, zippath_a, zippath_b
compile_opt strictarrsubs

temp_st = cdfoutpath+'/*'
files_found = file_search(temp_st, count = num_files)
files_found = file_basename(files_found)
num_days = 0
IF num_files GT 0 THEN BEGIN ; ignore if no files there

    ; find spacecraft, year, and doy 
    FOR ii = 0, num_files-1 DO BEGIN 
        file = files_found[ii]
        st_length = strlen(file)
        sat = strmid(file, st_length-25, 1)
        year_st = strmid(file, st_length-16, 4)
        doy_st = strmid(file, st_length-7, 3)
        end_st = strmid(file, st_length-27, 27)
        IF num_days EQ 0 THEN BEGIN
            sats = [sat]
            years = [year_st]
            doys = [doy_st]
            ends = [end_st]
            num_days = 1
        ENDIF ELSE BEGIN 
            found = 0
            FOR jj = 0, n_elements(sats)-1 DO BEGIN 
                IF sat EQ sats[jj] AND year_st EQ years[jj] AND doy_st EQ doys[jj] THEN found = 1
            ENDFOR 
            IF found EQ 0 THEN BEGIN 
                sats = [sats, sat]
                years = [years, year_st]
                doys = [doys, doy_st]
                ends = [ends, end_st]
                num_days = num_days + 1
            ENDIF 
        ENDELSE 
    ENDFOR 

    ; zip files
    FOR ii = 0, n_elements(sats)-1 DO BEGIN 
        CASE sats[ii] OF
            'A': BEGIN
                prefix = 'ahead_'
                zippath = zippath_a
            END
            'B': BEGIN 
                prefix = 'behind_'
                zippath = zippath_b
            END
        ENDCASE 
        command = 'zip -j '+cdfoutpath+'/'+prefix+years[ii]+'_'+doys[ii]+' '+cdfoutpath+'/*'+ends[ii]
        spawn, command
        command = 'scp '+cdfoutpath+'/'+prefix+years[ii]+'_'+doys[ii]+'.zip '+zippath+'/'+years[ii]+'/"'
        spawn, command
    ENDFOR 
    command = 'rm '+cdfoutpath+'/*'
    spawn, command
ENDIF 

END 
