; Lorna Ellis
; 05/24/2010
; write_old_heavy_v10.pro

; Be careful: temp_data might not be defined. (Add other arguments
; before this).

; This procedure goes back a day to write a heavy value.

; 08/10/2011 Copy CDFs so that ascii will also be updated.

PRO write_old_heavy_v10, old_epoch, spacecraft, cycle_index, prod, version, temp_num_summed = temp_num_summed, $
  temp_schan = temp_schan, temp_cycle = temp_cycle, temp_data = temp_data
compile_opt strictarrsubs

old_struct = time_struct(old_epoch, /epoch)
IF spacecraft EQ 'A' THEN old_dir = '/data1/Spacecraft_A/' ELSE old_dir = '/data2/Spacecraft_B/'
old_dir     = old_dir+'Level1/CDFs/'+string(old_struct.year, format = '(I4.4)')+'/'
old_file    = 'ST'+spacecraft+'_L1_PLA_'+string(old_struct.year, format = '(I4.4)')+$
              string(old_struct.month, format = '(I2.2)')+$
              string(old_struct.date, format = '(I2.2)')+'_'+string(old_struct.doy, format = '(I3.3)')+$
              '_V'+string(version, format = '(I2.2)')
old_hk_file = 'ST'+spacecraft+'_L1_PLA_HK_'+string(old_struct.year, format = '(I4.4)')+$
              string(old_struct.month, format = '(I2.2)')+$
              string(old_struct.date, format = '(I2.2)')+'_'+string(old_struct.doy, format = '(I3.3)')+$
              '_V'+string(version, format = '(I2.2)')
old_cl_file = 'ST'+spacecraft+'_L1_PLA_CL_'+string(old_struct.year, format = '(I4.4)')+$
              string(old_struct.month, format = '(I2.2)')+$
              string(old_struct.date, format = '(I2.2)')+'_'+string(old_struct.doy, format = '(I3.3)')+$
              '_V'+string(version, format = '(I2.2)')
old_sc_file = 'ST'+spacecraft+'_L1_PLA_SC_'+string(old_struct.year, format = '(I4.4)')+$
              string(old_struct.month, format = '(I2.2)')+$
              string(old_struct.date, format = '(I2.2)')+'_'+string(old_struct.doy, format = '(I3.3)')+$
              '_V'+string(version, format = '(I2.2)')
old_path    = old_dir+old_file
old_hk_path = old_dir+old_hk_file
old_cl_path = old_dir+old_cl_file
old_sc_path = old_dir+old_sc_file
old_id   = cdf_open(old_path)
IF keyword_set(temp_schan)      THEN cdf_varput, old_id, 's_chan_'+prod, temp_schan, rec_start = cycle_index ELSE BEGIN
    cdf_varget, old_id, 's_chan_apid319', temp_schan, rec_start = cycle_index
    cdf_varput, old_id, 's_chan_'+prod, temp_schan, rec_start = cycle_index 
ENDELSE 
IF keyword_set(temp_cycle)      THEN cdf_varput, old_id, 'cycle_' +prod, temp_cycle, rec_start = cycle_index ELSE BEGIN 
    cdf_varget, old_id, 'cycle_apid319', temp_cycle, rec_start = cycle_index
    cdf_varput, old_id, 'cycle_'+prod, temp_cycle, rec_start = cycle_index 
ENDELSE 
IF keyword_set(temp_num_summed) THEN cdf_varput, old_id, 'num_summed_'+prod, temp_num_summed, rec_start = cycle_index
IF keyword_set(temp_data)       THEN cdf_varput, old_id, prod, temp_data, rec_start = cycle_index
cdf_close, old_id

command = 'cp '+old_path   +'.cdf ~/Files/'
spawn, command
command = 'cp '+old_hk_path+'.cdf ~/Files/'
spawn, command
command = 'cp '+old_cl_path+'.cdf ~/Files/'
spawn, command
command = 'cp '+old_sc_path+'.cdf ~/Files/'
spawn, command

END 
