; 07/28/2011 Fix bug where skip a cycle.
; 09/29/2011 Take cycle and schan from packets besides 319.
; 10/18/2011 Write new cycle if more than 4.5 minutes.
; 03/03/2014 Change last_epoch_319 (to help check_seq_heavy_v10)

PRO write_cycle_heavy_v10, new_cycle, new_schan, new_epoch
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy

must_write = 1
IF num_cycles5_heavy GE n_elements(cycles5_heavy)-3 THEN BEGIN
    epochs5_heavy = [epochs5_heavy, -1D, -1D, -1D, -1D, -1D, -1D, -1D, -1D, -1D, -1D]
    cycles5_heavy = [cycles5_heavy, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    schan5_heavy = [schan5_heavy, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect5_heavy = [suspect5_heavy, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_319 = [suspect_319, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_31a = [suspect_31a, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_31b = [suspect_31b, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_31c = [suspect_31c, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_31d = [suspect_31d, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_31e = [suspect_31e, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_31f = [suspect_31f, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_320 = [suspect_320, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_321 = [suspect_321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_322 = [suspect_322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    suspect_323 = [suspect_323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_319 = [wrote_319, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_31a = [wrote_31a, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_31b = [wrote_31b, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_31c = [wrote_31c, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_31d = [wrote_31d, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_31e = [wrote_31e, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_31f = [wrote_31f, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_320 = [wrote_320, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_321 = [wrote_321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_322 = [wrote_322, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
    wrote_323 = [wrote_323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1]
ENDIF 
IF num_cycles5_heavy GT 0 THEN BEGIN
    old_epoch = epochs5_heavy[num_cycles5_heavy-1]
    IF abs(old_epoch-new_epoch) GT 270000 THEN BEGIN ; if more than 4.5 minute, write any stored data and reset variables
       cdf_varput, cdf_id, 'epoch_heavy',    new_epoch, rec_start = num_cycles5_heavy
        CASE apid OF 
            '319'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_apid319',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_apid319', new_schan, rec_start = num_cycles5_heavy
            END 
            '31A'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_sw_z>2_h',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_sw_z>2_h', new_schan, rec_start = num_cycles5_heavy
            END 
            '31B'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_sw_z>2_h',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_sw_z>2_h', new_schan, rec_start = num_cycles5_heavy
            END 
            '31C'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_sw_z>2_l',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_sw_z>2_l', new_schan, rec_start = num_cycles5_heavy
            END 
            '31D'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_sw_z>2_l',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_sw_z>2_l', new_schan, rec_start = num_cycles5_heavy
            END 
            '31E'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_wap_ssd_tcr',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_wap_ssd_tcr', new_schan, rec_start = num_cycles5_heavy
            END 
            '31F'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_wap_ssd_dcr',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_wap_ssd_dcr', new_schan, rec_start = num_cycles5_heavy
            END 
            '320'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_wap_nossd_dcr',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_wap_nossd_dcr', new_schan, rec_start = num_cycles5_heavy
            END 
            '321'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_sw_pri',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_sw_pri', new_schan, rec_start = num_cycles5_heavy
            END 
            '322'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_wap_ssd_pri',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_wap_ssd_pri', new_schan, rec_start = num_cycles5_heavy
            END 
            '323'x: BEGIN 
                cdf_varput, cdf_id, 'cycle_wap_nossd_pri',  new_cycle, rec_start = num_cycles5_heavy
                cdf_varput, cdf_id, 's_chan_wap_nossd_pri', new_schan, rec_start = num_cycles5_heavy
            END 
        ENDCASE 
        cycles5_heavy[num_cycles5_heavy] = new_cycle
        schan5_heavy [num_cycles5_heavy] = new_schan
        epochs5_heavy[num_cycles5_heavy] = new_epoch
        num_cycles5_heavy = num_cycles5_heavy + 1
        last_epoch_319 = new_epoch
        IF apid NE '319'x AND telem_vers LE 1 THEN $
          printf, error_lun, timestamp, " Data gap in heavies. apid: ", string(apid, format = '(Z)')
        must_write = 0
    ENDIF ELSE IF abs(old_epoch-new_epoch) LT 30000 THEN BEGIN ; if less than a minute, check if cycle num wrong
        IF cycles5_heavy[num_cycles5_heavy-1] EQ -1 THEN BEGIN 
            cdf_varput, cdf_id, 'cycle_apid319',  new_cycle, rec_start = num_cycles5_heavy-1
            cdf_varput, cdf_id, 's_chan_apid319', new_schan, rec_start = num_cycles5_heavy-1
            cycles5_heavy[num_cycles5_heavy-1] = new_cycle
            schan5_heavy [num_cycles5_heavy-1] = new_schan
            must_write = 0
        ENDIF ELSE IF new_cycle EQ -1 THEN dummy = dummy
    ENDIF 
ENDIF 
IF must_write EQ 1 THEN BEGIN 
    cdf_varput, cdf_id, 'epoch_heavy',    new_epoch, rec_start = num_cycles5_heavy
    cdf_varput, cdf_id, 'cycle_apid319',  new_cycle, rec_start = num_cycles5_heavy
    cdf_varput, cdf_id, 's_chan_apid319', new_schan, rec_start = num_cycles5_heavy
    epochs5_heavy[num_cycles5_heavy] = new_epoch
    cycles5_heavy[num_cycles5_heavy] = new_cycle
    schan5_heavy [num_cycles5_heavy] = new_schan
    num_cycles5_heavy = num_cycles5_heavy + 1
ENDIF 

END     
