; Lorna Ellis
; July 23, 2007
; update_pri_ratio_file.pro

; This program updates a ratio file with the daily ratios fed to it.
; Input: sat_index          : 0=A, 1=B
;        calibrationpath    : string with where to find the calibration file
;        year_array         : array of years (as ints)
;        doy_array          : array of doy to update (as ints)
;        pri_ratio          : array of floats with daily ratios [128 energy, days]
;        ratio_valid        : arroy of ints [days], if have valid ratio, set to 1, otherwise = 0

; 09/24/2007 Added year to ratio filename.

PRO create_pri_ratio_string, year, doy, pri_ratio, ii, temp_string
compile_opt strictarrsubs
tab = STRING(9B)
temp_string = string(year, format = '(I4.4)')+tab+string(doy, format = '(I3.3)')
FOR jj = 0, 127 DO BEGIN 
    IF finite(pri_ratio[jj, ii]) EQ 1 THEN temp_string = temp_string+tab+string(pri_ratio[jj, ii]) $
      ELSE temp_string = temp_string+tab+string(0)
ENDFOR
END 

PRO update_pri_ratio_file, sat_index, calibrationpath, year_array, doy_array, pri_ratio, ratio_valid
compile_opt strictarrsubs

IF sat_index EQ 0 THEN sat = 'A' ELSE sat = 'B'
filename = 'ST'+sat+'_pri_ratio_'+string(year_array[0], format = '(I4.4)')+'.tab'

filepath = calibrationpath + filename

line = ' '
num_days = n_elements(doy_array)

; read file into an array
openr, cal_lun, filepath, /get_lun
readf, cal_lun, line
cal_array = [line]
WHILE eof(cal_lun) EQ 0 DO BEGIN 
    readf, cal_lun, line
    cal_array = [cal_array, line]
ENDWHILE
close_lun, cal_lun
free_lun, cal_lun

; write file
ii = 0 ; index for new days
jj = 0 ; index for days already in file -- 3 header lines
openw, cal_lun, filepath, /get_lun
WHILE jj LT 2 DO BEGIN ; header
    printf, cal_lun, cal_array[jj]
    jj = jj+1
ENDWHILE 
WHILE ii LT num_days DO BEGIN 
    IF jj LT n_elements(cal_array) THEN BEGIN 
        parts = strsplit(cal_array[jj], /extract)
        temp_year = fix(parts[0])
        temp_doy = fix(parts[1])
        temp_ratio = fix(parts[2])
        IF year_array[ii] LT temp_year THEN BEGIN 
            create_pri_ratio_string, year_array[ii], doy_array[ii], pri_ratio, ii, temp_string
            printf, cal_lun, temp_string
            printf, cal_lun, cal_array[jj]
            ii = ii+1
            jj = jj+1
        ENDIF ELSE IF year_array[ii] EQ temp_year THEN BEGIN
            IF doy_array[ii] LT temp_doy THEN BEGIN ; insert doy
                IF ratio_valid[ii] EQ 1 THEN BEGIN 
                    create_pri_ratio_string, year_array[ii], doy_array[ii], pri_ratio, ii, temp_string
                    printf, cal_lun, temp_string
                ENDIF 
                ii = ii+1
            ENDIF ELSE IF doy_array[ii] EQ temp_doy THEN BEGIN ; replace doy
                IF ratio_valid[ii] EQ 1 THEN BEGIN 
                    create_pri_ratio_string, year_array[ii], doy_array[ii], pri_ratio, ii, temp_string
                    printf, cal_lun, temp_string
                ENDIF ELSE BEGIN ; need to put back old on 
                    printf, cal_lun, cal_array[jj]
                ENDELSE 
                ii = ii+1
                jj = jj+1
            ENDIF ELSE BEGIN    ; not yet at right line
                printf, cal_lun, cal_array[jj]
                jj = jj+1
            ENDELSE 
        ENDIF ELSE BEGIN        ; not yet at right line
            printf, cal_lun, cal_array[jj]
            jj = jj+1
        ENDELSE 
    ENDIF ELSE BEGIN ; fill in new lines
        IF ratio_valid[ii] EQ 1 THEN BEGIN 
            create_pri_ratio_string, year_array[ii], doy_array[ii], pri_ratio, ii, temp_string
            printf, cal_lun, temp_string
        ENDIF 
        ii = ii+1
    ENDELSE 
ENDWHILE 
WHILE jj LT n_elements(cal_array) DO BEGIN ; fill in old lines
    printf, cal_lun, cal_array[jj]
    jj = jj+1
ENDWHILE 
close_lun, cal_lun
free_lun, cal_lun

END 
