; Lorna Ellis
; set_com_l0.pro
; Set all common blocks.

; 01/04/07 Removed limits for sw_status1 and opmode.
; 01/23/07 Added pwer_warning, thruster_warning, coarse_pointing
; 02/08/07 Changed dacm_mcp_cm_fs_coarse/fine and
; dacm_pac_cm_fs_coarse/fine to delta limits
; 02/09/07 Changed limits on all dacr products to -3
; 02/09/07 Added esa_cm_dc_static_limits
; 02/13/07 Added dacm_defl_sweep_coarse/fine/dfine_exp_value 
; 09/19/07 Added last_cycle_mode_317
; 01/28/11 Added post_327 variables for new DPU software.
; 06/28/11 Changed name from set_com.pro to set_com_l0.pro.
; 09/04/14 Add dighk_values and dighk_pos_327_values
; 09/17/14 Added Apid370 values
; 12/08/14 Added dighk_val_i

PRO set_com_pha
compile_opt strictarrsubs
COMMON com_pha, apid315_start_esa, pha_last_seq, pha_missed_packet, pha_bytes, pha_events, num_pha_events, pha_missing, first_315, last_epoch_315
apid315_start_esa = -1
;pha_old_timestamp = -1D
pha_last_seq      = -1
pha_missed_packet = 0
pha_bytes         = bytarr(6)
pha_events        = intarr(768, 9)
pha_events[*, *]  = -1
num_pha_events    = 0
pha_missing       = 0L
first_315         = 1
last_epoch_315    = -1D
END 

PRO set_com_mon
compile_opt strictarrsubs
COMMON com_mon, last_seq_316, mon_norm_values, mon_norm_mode, last_seq_317, mon_high_values, mon_high_products, mon_high_mode, mon_high_start_esa, last_cycle_mode_317, apid317rate, apid317defl, apid317esa, first_apid317, missing_316_cycle, first_apid316, last_epoch_316, last_epoch_317
last_seq_316             = -1
mon_norm_values          = lonarr(32, 32, 8) ;32 rates, 32 esa groups, 8 defl groups
mon_norm_values[*, *, *] = -1
mon_norm_mode            = -1
missing_316_cycle        = 0
first_apid316            = 1
last_seq_317             = -1
mon_high_values          = lonarr(6, 64, 32) ;6 rates, 64 esa steps, 32 defl steps
mon_high_values[*, *, *] = -1
mon_high_products        = intarr(6)
mon_high_products[    *] = -1
mon_high_mode            = -1
mon_high_start_esa       = -1
last_cycle_mode_317      = -1
apid317rate              = 0
apid317defl              = 0
apid317esa               = 0
first_apid317            = 1
last_epoch_316           = -1D
last_epoch_317           = -1D
END 

PRO set_com_heavy
compile_opt strictarrsubs
COMMON com_heavy, num_summed, heavy_on_ten, last_seq_319, last_seq_31a, last_seq_31b, last_seq_31c, last_seq_31d, last_seq_31e, last_seq_31f, last_seq_320, last_seq_321, last_seq_322, last_seq_323, swz_h, swz_l, wap_ssd_tcr, wap_ssd_dcr, wap_nossd_dcr, sw_pri, wap_pri_ssd, wap_pri_nossd, last_epoch_319, last_epoch_31a, last_epoch_31b, last_epoch_31c, last_epoch_31d, last_epoch_31e, last_epoch_31f, last_epoch_320, last_epoch_321, last_epoch_322, last_epoch_323, complete_flags
num_summed     = intarr(128)
heavy_on_ten   = 0
complete_flags = 0
last_seq_319   = -1
last_seq_31a   = -1
last_seq_31b   = -1
last_seq_31c   = -1
last_seq_31d   = -1
last_seq_31e   = -1
last_seq_31f   = -1
last_seq_320   = -1
last_seq_321   = -1
last_seq_322   = -1
last_seq_323   = -1
last_epoch_319 = -1
last_epoch_31a = -1
last_epoch_31b = -1
last_epoch_31c = -1
last_epoch_31d = -1
last_epoch_31e = -1
last_epoch_31f = -1
last_epoch_320 = -1
last_epoch_321 = -1
last_epoch_322 = -1
last_epoch_323 = -1
swz_h          = dblarr(128, 8, 8, 2)
swz_l          = dblarr(128, 8, 13)
wap_ssd_tcr    = dblarr(128, 4, 15)
wap_ssd_dcr    = dblarr(128, 4, 7)
wap_nossd_dcr  = dblarr(128, 8, 7)
sw_pri         = dblarr(128, 16, 4)
wap_pri_ssd    = dblarr(128, 2)
wap_pri_nossd  = dblarr(128, 2)
swz_h        [*, *, *] = -1
swz_l        [*, *, *] = -1
wap_ssd_tcr  [*, *, *] = -1
wap_ssd_dcr  [*, *, *] = -1
wap_nossd_dcr[*, *, *] = -1
sw_pri       [*, *, *] = -1
wap_pri_ssd  [   *, *] = -1
wap_pri_nossd[   *, *] = -1
END 

PRO set_com_alph_prot
compile_opt strictarrsubs
COMMON com_alph_prot, last_seq_324, last_seq_325, last_seq_326, last_seq_327, cycle_324_new, cycle_325_new, cycle_326_new, cycle_327_new, alpha_peak_326, alpha_peak_327, proton_peak_324, proton_peak_325, h_alpha, hplus_peak, heplusplus_peak, heplusplus_tcr, error_324, error_325, error_326, error_327, last_epoch_324, last_epoch_325, last_epoch_326, last_epoch_327
last_seq_324 = -1
last_seq_325 = -1
last_seq_326 = -1
last_seq_327 = -1
cycle_324_new = -1
cycle_325_new = -1
cycle_326_new = -1
cycle_327_new = -1
error_324 = -1D
error_325 = -1D
error_326 = -1D
error_327 = -1D
last_epoch_324 = -1
last_epoch_325 = -1
last_epoch_326 = -1
last_epoch_327 = -1
alpha_peak_326 = intarr(4)
alpha_peak_327 = intarr(4)
proton_peak_324 = intarr(4)
proton_peak_325 = intarr(4)
alpha_peak_326 [*] = -1
alpha_peak_327 [*] = -1
proton_peak_324[*] = -1
proton_peak_325[*] = -1
h_alpha         = lonarr(20, 8, 8)
hplus_peak      = lonarr(10, 8, 8)
heplusplus_peak = lonarr(10, 8, 8)
heplusplus_tcr  = lonarr(10, 8, 8)
h_alpha        [*, *, *] = -1
hplus_peak     [*, *, *] = -1
heplusplus_peak[*, *, *] = -1
heplusplus_tcr [*, *, *] = -1
END

PRO set_com_moments
compile_opt strictarrsubs
COMMON com_moments, moments_meta, moments, mom_370, mom_schan_370, mom_source_370, mom_cycle_370, mom_epoch_370, mom_370_i, unscale
moments_meta      = intarr(4)
moments           = lonarr(13, 2) ; 13 moments, Main and S channel
mom_370           = lonarr(13, 2, 1500)
mom_schan_370     = intarr(1500)
mom_source_370    = intarr(1500)
mom_cycle_370     = intarr(1500)
mom_epoch_370     = dblarr(1500)
mom_370_i         = 0
moments_meta  [*] = -1
moments    [*, *] = -1
mom_370    [*, *] = -1
mom_source_370[*] = -1
unscale = (double(2)^16)/'3FFB001'x ; 0x3FFB001 = 4095 * 16383
                                    ; Math.pow(2,16) for bit shifting by 16 bits
	                            ; 4095 for theta normalization to 12 bits
	                            ; 16383 for phi normalization to 14 bits
END 

PRO set_com_hk, conv_file, instrument_id
compile_opt strictarrsubs
COMMON com_hk, hk_products, hk_products_raw, hk_products_eng, hk_conversions, hk_limits, dighk_products, dighk_low_limits, dighk_high_limits, dighk_old_values, first_dighk, old_hk_epoch, old_dighk_epoch, ssd_out_limits, ssd_out_once, power_warning_old, thruster_warning_old, coarse_pointing_old, esa_cm_dc_static_limits, dacm_defl_sweep_coarse_exp_value, dacm_defl_sweep_fine_exp_value, dacm_defl_sweep_dfine_exp_value, dighk_post_327, dighk_values, dighk_post_327_values, dighk_val_i
hk_products = strarr(68)
hk_products_raw = strarr(68)
hk_products_eng = strarr(68)
hk_products = [ $
              'lrnm_spare',       $ ; 0
              'lvc_-12v',         $ ; 1 
              'lvc_-5v',          $ ; 2  
              'esa_vm_pos',       $ ; 3
              'dfl_1_vm',         $ ; 4
              'dfl_1_tap',        $ ; 5
              'dfl_2_vm',         $ ; 6
              'dfl_2_tap',        $ ; 7
              'lvc_+2.5v_b',      $ ; 8
              'pac_cm_dc',        $ ; 9 
              'lvc_+12v',         $ ; 10 
              'lrpm_spare',       $ ; 11
              'lvc_+2.5v_a',      $ ; 12
              'lvc_+5v',          $ ; 13
              'adc_avdd',         $ ; 14
              'adc_dvdd',         $ ; 15
              'pac_vm',           $ ; 16
              'cal_vref',         $ ; 17
              'pac_cm_ac',        $ ; 18 -- no conversion
              'mcp_vm',           $ ; 19 
              'mcp_cm_dc',        $ ; 20
              'mcp_cm_ac',        $ ; 21 -- no conversion
              'ssd_cm_dc',        $ ; 22
              's_ch_vm',          $ ; 23
              's_ch_vm_tap',      $ ; 24
              's_ch_cm_dc',       $ ; 25
              'esa_vm_neg',       $ ; 26
              'esa_cm_dc',        $ ; 27
              'dfl_1_cm_dc',      $ ; 28
              'dfl_2_cm_dc',      $ ; 29
              'lvc_+2.5v_b_imon', $ ; 30
              'lvc_+12v_imon',    $ ; 31
              'lvc_-12v_imon',    $ ; 32
              'lvc_+5v_imon',     $ ; 33
              'lvc_-5v_imon',     $ ; 34
              'lvc_+2.5v_a_imon', $ ; 35
              'ssd_vm',           $ ; 36 -- no conversion
              'plug_id',          $ ; 37 -- no conversion
              'adc_lu_flag',      $ ; 38 -- no conversion
              'dac_status',       $ ; 39 -- no conversion
              'adc_lu_ctr',       $ ; 40 -- no conversion
              'adc0_agnd',        $ ; 41
              'adc1_agnd',        $ ; 42
              'ra_e0',            $ ; 43 
              'ra_e1',            $ ; 44 
              'tac0_tsp',         $ ; 45
              'tac2_tsp',         $ ; 46
              'sb0_tsp',          $ ; 47
              'sb1_tsp',          $ ; 48
              'tof_hv0_tsp',      $ ; 49
              'tof_hv1_tsp',      $ ; 50
              's_c_0_tsp',        $ ; 51
              's_c_1_tsp',        $ ; 52
              'lvc0_tsp',         $ ; 53
              'lvc1_tsp',         $ ; 54
              'adc0_vref',        $ ; 55
              'adc1_vref',        $ ; 56
              'ssd_status',       $ ; 57 -- no conversion
              'ssd_v_pos_analog', $ ; 58
              'ssd_v_neg_analog', $ ; 59
              'ssd_hv_bias',      $ ; 60
              'ssd_tc0',          $ ; 61
              'ssd_tc1',          $ ; 62
              'ssd_tc2',          $ ; 63
              'ssd_v_pos_dig',    $ ; 64
              'power_warning',    $ ; 65 -- no conversion
              'thruster_warning', $ ; 66 -- no conversion
              'coarse_pointing']    ; 67 -- no conversion
; ssd_out_limits is 0 when in limits, otherwise increments consecutive
; cycles out
ssd_out_limits = intarr(8) ; [NA, ssd_v_pos_analog, ssd_v_neg_analog, ssd_hv_bias, ssd_tc0, ssd_tc1, ssd_tc2, ssw_v_pos_dig] 
ssd_out_once = intarr(8) ; indicates number of times we went out of limits for one reading
hk_products_raw = hk_products + '_raw'
hk_products_eng = hk_products + '_eng'
hk_conversions = strarr(68, 13)
hk_limits = fltarr(68, 4)   
esa_cm_dc_static_limits = fltarr(4)
read_apid200_conv2, conv_file, instrument_id
power_warning_old = -1 ; used for delta limit
thruster_warning_old = -1 ; used for delta limit
coarse_pointing_old = -1 ; used for delta limit
dacm_defl_sweep_coarse_exp_value = 'FF'x
dacm_defl_sweep_fine_exp_value = '00'x
dacm_defl_sweep_dfine_exp_value = '00'x
dighk_products = strarr(199)
dighk_products = [ $
                 'dpu_sw_version',                 $ ; 0
                 'cmd_rcvd_cnt',                   $ ; 1
                 'cmd_exec_cnt',                   $ ; 2
                 'cmd_total_err_cnt',              $ ; 3
                 'cmd_parity_err_cnt',             $ ; 4
                 'cmd_frame_err_cnt',              $ ; 5
                 'cmd_illegal_err_cnt',            $ ; 6
                 'ic_status_reg',                  $ ; 7
                 'ic_ctl_reg',                     $ ; 8
                 'lbc_reset_ctl',                  $ ; 9
                 'lbc_mode_ctl',                   $ ; 10
                 'lbc_logic_ctl_a',                $ ; 11
                 'lbc_logic_ctl_b',                $ ; 12
                 'lbc_tac_pwr_ctl',                $ ; 13
                 'lbc_reg_seq',                    $ ; 14
                 'lbc_event_ctl',                  $ ; 15
                 'lbc_rlim_ch',                    $ ; 16
                 'lbc_rlim_hi',                    $ ; 17
                 'lbc_rlim_lo',                    $ ; 18
                 'lbe_pos_ctrl',                   $ ; 19
                 'lbe_pos_disable0',               $ ; 20
                 'lbe_pos_disable2',               $ ; 21
                 'lbe_tac0_ctrl',                  $ ; 22
                 'lbe_tac0_dac',                   $ ; 23
                 'lbe_tac2_ctrl',                  $ ; 24
                 'lbe_tac2_dac',                   $ ; 25
                 'lbe_tac0_under_hi',              $ ; 26
                 'lbe_tac0_under_lo',              $ ; 27
                 'lbe_tac0_over_hi',               $ ; 28
                 'lbe_tac0_over_lo',               $ ; 29
                 'lbe_tac2_under_hi',              $ ; 30
                 'lbe_tac2_under_lo',              $ ; 31
                 'lbe_tac2_over_hi',               $ ; 32
                 'lbe_tac2_over_lo',               $ ; 33
                 'lbe_ssd_ctrl',                   $ ; 34
                 'lbe_ssd_cmd_h',                  $ ; 35
                 'lbe_ssd_cmd_l',                  $ ; 36
                 'lbe_ssd_dis',                    $ ; 37
                 'lbe_ssd_under_hi',               $ ; 38
                 'lbe_ssd_under_lo',               $ ; 39
                 'lbe_ssd_over_hi',                $ ; 40
                 'lbe_ssd_over_lo',                $ ; 41
                 'lbe_sel_ctrl',                   $ ; 42
                 'lbe_trig_mode',                  $ ; 43
                 'lbe_esa_step',                   $ ; 44
                 'lbe_defl_step',                  $ ; 45
                 'lbe_ssd_offset0',                $ ; 46
                 'lbe_ssd_offset1',                $ ; 47
                 'lbe_ssd_offset2',                $ ; 48
                 'lbe_ssd_offset3',                $ ; 49
                 'lbe_ssd_offset4',                $ ; 50
                 'lbe_ssd_offset5',                $ ; 51
                 'lbe_ssd_offset6',                $ ; 52
                 'lbe_ssd_offset7',                $ ; 53
                 'lbe_stim_enable',                $ ; 54
                 'lbe_stim_freq_hi',               $ ; 55
                 'lbe_stim_freq_lo',               $ ; 56
                 'lbe_sel0_window',                $ ; 57
                 'lbe_sel2_window',                $ ; 58
                 'lbe_ssd_offset8',                $ ; 59
                 'lbe_ssd_offset9',                $ ; 60
                 'lbe_ssd_offset10',               $ ; 61
                 'lbe_ssd_offset11',               $ ; 62
                 'lbe_ssd_offset12',               $ ; 63
                 'lbe_ssd_offset13',               $ ; 64
                 'lbe_ssd_offset14',               $ ; 65
                 'lbe_ssd_offset15',               $ ; 66
                 'lbe_pos_ra',                     $ ; 67
                 'dacm_pac_mcp_ssd_ctl_mcp_limit', $ ; 68
                 'dacm_pac_limit',                 $ ; 69
                 'dacm_esa_ctl',                   $ ; 70
                 'dacm_s_ch_ctl',                  $ ; 71
                 'dacm_dfl_1_ctl',                 $ ; 72
                 'dacm_dfl_2_ctl',                 $ ; 73
                 'dacm_control',                   $ ; 74
                 'dacm_status',                    $ ; 75
                 'dacm_adc_lu_ctr',                $ ; 76
                 'dacm_dfl_1_offset',              $ ; 77
                 'dacm_dfl_2_offset',              $ ; 78
                 'dacm_pac_coarse',                $ ; 79
                 'dacm_pac_fine',                  $ ; 80
                 'dacm_pac_cm_fs_coarse',          $ ; 81
                 'dacm_pac_cm_fs_fine',            $ ; 82
                 'dacm_mcp_coarse',                $ ; 83
                 'dacm_mcp_fine',                  $ ; 84
                 'dacm_mcp_cm_fs_coarse',          $ ; 85
                 'dacm_mcp_cm_fs_fine',            $ ; 86
                 'dacm_ssd_coarse',                $ ; 87
                 'dacm_ssd_fine',                  $ ; 88
                 'dacm_esa_coarse',                $ ; 89
                 'dacm_esa_fine',                  $ ; 90
                 'dacm_s_ch_coarse',               $ ; 91
                 'dacm_s_ch_fine',                 $ ; 92
                 'dacm_s_ch_tap_coarse',           $ ; 93
                 'dacm_s_ch_tap_fine',             $ ; 94
                 'dacm_dfl_1_coarse',              $ ; 95
                 'dacm_dfl_1_fine',                $ ; 96
                 'dacm_dfl_1_dfine',               $ ; 97
                 'dacm_dfl_2_coarse',              $ ; 98
                 'dacm_dfl_2_fine',                $ ; 99
                 'dacm_dfl_2_dfine',               $ ; 100
                 'dacr_pac_mcp_ssd_ctl_mcp_limit', $ ; 101
                 'dacr_pac_limit',                 $ ; 102
                 'dacr_esa_ctl',                   $ ; 103
                 'dacr_s_ch_ctl',                  $ ; 104
                 'dacr_dfl_1_ctl',                 $ ; 105
                 'dacr_dfl_2_ctl',                 $ ; 106
                 'dacr_control',                   $ ; 107
                 'dacr_status',                    $ ; 108
                 'dacr_adc_lu_ctr',                $ ; 109
                 'dacr_dfl_1_offset',              $ ; 110
                 'dacr_dfl_2_offset',              $ ; 111
                 'dacr_c_pac_coarse',              $ ; 112
                 'dacr_c_pac_fine',                $ ; 113
                 'dacr_c_pac_cm_fs_coarse',        $ ; 114
                 'dacr_c_pac_cm_fs_fine',          $ ; 115
                 'dacr_c_mcp_coarse',              $ ; 116
                 'dacr_c_mcp_fine',                $ ; 117
                 'dacr_c_mcp_cm_fs_coarse',        $ ; 118
                 'dacr_c_mcp_cm_fs_fine',          $ ; 119
                 'dacr_c_ssd_coarse',              $ ; 120
                 'dacr_c_ssd_fine',                $ ; 121
                 'dacr_c_esa_coarse',              $ ; 122
                 'dacr_c_esa_fine',                $ ; 123
                 'dacr_c_s_ch_coarse',             $ ; 124
                 'dacr_c_s_ch_fine',               $ ; 125
                 'dacr_c_s_ch_tap_coarse',         $ ; 126
                 'dacr_c_s_ch_tap_fine',           $ ; 127
                 'dacr_dfl_1_coarse',              $ ; 128
                 'dacr_dfl_1_fine',                $ ; 129
                 'dacr_dfl_1_dfine',               $ ; 130
                 'dacr_dfl_2_coarse',              $ ; 131
                 'dacr_dfl_2_fine',                $ ; 132
                 'dacr_dfl_2_dfine',               $ ; 133
                 'sw_status1',                     $ ; 134
                 'sw_hv_ramp_status',              $ ; 135
                 'sw_hv_enable_status',            $ ; 136
                 'sw_hv_limit_status',             $ ; 137
                 'sw_eepromchksum',                $ ; 138
                 'hkp_sampletime',                 $ ; 139
                 'pac_discharge_status',           $ ; 140
                 'pac_discharge_cnt',              $ ; 141
                 'pac_discharge_conseccntr',       $ ; 142
                 'pac_discharge_safe_att',         $ ; 143
                 'analog_limit_status',            $ ; 144
                 'analog_lim_pt1_status',          $ ; 145
                 'analog_lim_pt1_id',              $ ; 146
                 'analog_lim_pt1_red',             $ ; 147
                 'analog_lim_pt2_status',          $ ; 148
                 'analog_lim_pt2_id',              $ ; 149
                 'analog_lim_pt2_red',             $ ; 150
                 'analog_lim_pt3_status',          $ ; 151
                 'analog_lim_pt3_id',              $ ; 152
                 'analog_lim_pt3_red',             $ ; 153
                 'analog_lim_pt4_status',          $ ; 154
                 'analog_lim_pt4_id',              $ ; 155
                 'analog_lim_pt4_red',             $ ; 156
                 'analog_lim_pt5_status',          $ ; 157
                 'analog_lim_pt5_id',              $ ; 158
                 'analog_lim_pt5_red',             $ ; 159
                 'analog_lim_pt6_status',          $ ; 160
                 'analog_lim_pt6_id',              $ ; 161
                 'analog_lim_pt6_red',             $ ; 162
                 'analog_lim_pt7_status',          $ ; 163
                 'analog_lim_pt7_id',              $ ; 164
                 'analog_lim_pt7_red',             $ ; 165
                 'analog_lim_pt8_status',          $ ; 166
                 'analog_lim_pt8_id',              $ ; 167
                 'analog_lim_pt8_red',             $ ; 168
                 'analog_lim_pt9_status',          $ ; 169
                 'analog_lim_pt9_id',              $ ; 170
                 'analog_lim_pt9_red',             $ ; 171
                 'analog_lim_pt10_status',         $ ; 172
                 'analog_lim_pt10_id',             $ ; 173
                 'analog_lim_pt10_red',            $ ; 174
                 'analog_lim_pt11_status',         $ ; 175
                 'analog_lim_pt11_id',             $ ; 176
                 'analog_lim_pt11_red',            $ ; 177
                 'analog_lim_pt12_status',         $ ; 178
                 'analog_lim_pt12_id',             $ ; 179
                 'analog_lim_pt12_red',            $ ; 180
                 'analog_lim_pt13_status',         $ ; 181
                 'analog_lim_pt13_id',             $ ; 182
                 'analog_lim_pt13_red',            $ ; 183
                 'analog_lim_pt14_status',         $ ; 184
                 'analog_lim_pt14_id',             $ ; 185
                 'analog_lim_pt14_red',            $ ; 186
                 'analog_lim_pt15_status',         $ ; 187
                 'analog_lim_pt15_id',             $ ; 188
                 'analog_lim_pt15_red',            $ ; 189
                 'opmode',                         $ ; 190
                 'sw_mode',                        $ ; 191
                 'proton_mode',                    $ ; 192
                 'active_supplyid',                $ ; 193
                 'supply_coarse_rb',               $ ; 194
                 'supply_fine_rb',                 $ ; 195
                 'swmaint_supplystat',             $ ; 196
                 'swmaint_pac_coarse',             $ ; 197
                 'swmaint_pac_fine'                $ ; 198
                 ]
dighk_val_i      = 0
dighk_values     = lonarr(199, 1500)
dighk_low_limits = intarr(199)
dighk_low_limits = [ $    ; -1=none, -2=delta(report any change)
                 -2,    $ ;'DPU_SW_VERSION',                 $ ; 0
                 -1,    $ ;'CMD_RCVD_CNT',                   $ ; 1
                 -1,    $ ;'CMD_EXEC_CNT',                   $ ; 2
                 -2,    $ ;'CMD_TOTAL_ERR_CNT',              $ ; 3
                 '00'x, $ ;'CMD_PARITY_ERR_CNT',             $ ; 4
                 '00'x, $ ;'CMD_FRAME_ERR_CNT',              $ ; 5
                 '00'x, $ ;'CMD_ILLEGAL_ERR_CNT',            $ ; 6
                 -2,    $ ;'IC_STATUS_REG',                  $ ; 7
                 -2,    $ ;'IC_CTL_REG',                     $ ; 8
                 -2,    $ ;'LBC_RESET_CTL',                  $ ; 9
                 -2,    $ ;'LBC_MODE_CTL',                   $ ; 10
                 -2,    $ ;'LBC_LOGIC_CTL_A',                $ ; 11
                 -2,    $ ;'LBC_LOGIC_CTL_B',                $ ; 12
                 -2,    $ ;'LBC_TAC_PWR_CTL',                $ ; 13
                 -2,    $ ;'LBC_REG_SEQ',                    $ ; 14
                 -2,    $ ;'LBC_EVENT_CTL',                  $ ; 15
                 -2,    $ ;'LBC_RLIM_CH',                    $ ; 16
                 -2,    $ ;'LBC_RLIM_HI',                    $ ; 17
                 -2,    $ ;'LBC_RLIM_LO',                    $ ; 18
                 -2,    $ ;'LBE_POS_CTRL',                   $ ; 19
                 -2,    $ ;'LBE_POS_DISABLE0',               $ ; 20
                 -2,    $ ;'LBE_POS_DISABLE2',               $ ; 21
                 -2,    $ ;'LBE_TAC0_CTRL',                  $ ; 22
                 -2,    $ ;'LBE_TAC0_DAC',                   $ ; 23
                 -2,    $ ;'LBE_TAC2_CTRL',                  $ ; 24
                 -2,    $ ;'LBE_TAC2_DAC',                   $ ; 25
                 -2,    $ ;'LBE_TAC0_UNDER_HI',              $ ; 26
                 -2,    $ ;'LBE_TAC0_UNDER_LO',              $ ; 27
                 -2,    $ ;'LBE_TAC0_OVER_HI',               $ ; 28
                 -2,    $ ;'LBE_TAC0_OVER_LO',               $ ; 29
                 -2,    $ ;'LBE_TAC2_UNDER_HI',              $ ; 30
                 -2,    $ ;'LBE_TAC2_UNDER_LO',              $ ; 31
                 -2,    $ ;'LBE_TAC2_OVER_HI',               $ ; 32
                 -2,    $ ;'LBE_TAC2_OVER_LO',               $ ; 33
                 -2,    $ ;'LBE_SSD_CTRL',                   $ ; 34
                 -2,    $ ;'LBE_SSD_CMD_H',                  $ ; 35
                 -2,    $ ;'LBE_SSD_CMD_L',                  $ ; 36
                 -2,    $ ;'LBE_SSD_DIS',                    $ ; 37
                 -2,    $ ;'LBE_SSD_UNDER_HI',               $ ; 38
                 -2,    $ ;'LBE_SSD_UNDER_LO',               $ ; 39
                 -2,    $ ;'LBE_SSD_OVER_HI',                $ ; 40
                 -2,    $ ;'LBE_SSD_OVER_LO',                $ ; 41
                 -2,    $ ;'LBE_SEL_CTRL',                   $ ; 42
                 -2,    $ ;'LBE_TRIG_MODE',                  $ ; 43
                 -2,    $ ;'LBE_ESA_STEP',                   $ ; 44
                 -2,    $ ;'LBE_DEFL_STEP',                  $ ; 45
                 '00'x, $ ;'LBE_SSD_OFFSET0',                $ ; 46
                 '00'x, $ ;'LBE_SSD_OFFSET1',                $ ; 47
                 '00'x, $ ;'LBE_SSD_OFFSET2',                $ ; 48
                 '00'x, $ ;'LBE_SSD_OFFSET3',                $ ; 49
                 '00'x, $ ;'LBE_SSD_OFFSET4',                $ ; 50
                 '00'x, $ ;'LBE_SSD_OFFSET5',                $ ; 51
                 '00'x, $ ;'LBE_SSD_OFFSET6',                $ ; 52
                 '00'x, $ ;'LBE_SSD_OFFSET7',                $ ; 53
                 -2,    $ ;'LBE_STIM_ENABLE',                $ ; 54
                 -2,    $ ;'LBE_STIM_FREQ_HI',               $ ; 55
                 -2,    $ ;'LBE_STIM_FREQ_LO',               $ ; 56
                 -2,    $ ;'LBE_SEL0_WINDOW',                $ ; 57
                 -2,    $ ;'LBE_SEL2_WINDOW',                $ ; 58
                 '00'x, $ ;'LBE_SSD_OFFSET8',                $ ; 59
                 '00'x, $ ;'LBE_SSD_OFFSET9',                $ ; 60
                 '00'x, $ ;'LBE_SSD_OFFSET10',               $ ; 61
                 '00'x, $ ;'LBE_SSD_OFFSET11',               $ ; 62
                 '00'x, $ ;'LBE_SSD_OFFSET12',               $ ; 63
                 '00'x, $ ;'LBE_SSD_OFFSET13',               $ ; 64
                 '00'x, $ ;'LBE_SSD_OFFSET14',               $ ; 65
                 '00'x, $ ;'LBE_SSD_OFFSET15',               $ ; 66
                 -2,    $ ;'LBE_POS_RA',                     $ ; 67
                 -2,    $ ;'DACM_PAC_MCP_SSD_CTL_MCP_LIMIT', $ ; 68
                 -2,    $ ;'DACM_PAC_LIMIT',                 $ ; 69
                 -2,    $ ;'DACM_ESA_CTL',                   $ ; 70
                 -2,    $ ;'DACM_S_CH_CTL',                  $ ; 71
                 -2,    $ ;'DACM_DFL_1_CTL',                 $ ; 72
                 -2,    $ ;'DACM_DFL_2_CTL',                 $ ; 73
                 -2,    $ ;'DACM_CONTROL',                   $ ; 74
                 -2,    $ ;'DACM_STATUS',                    $ ; 75
                 -2,    $ ;'DACM_ADC_LU_CTR',                $ ; 76
                 -2,    $ ;'DACM_DFL_1_OFFSET',              $ ; 77
                 -2,    $ ;'DACM_DFL_2_OFFSET',              $ ; 78
                 -1,    $ ;'DACM_PAC_COARSE',                $ ; 79
                 -1,    $ ;'DACM_PAC_FINE',                  $ ; 80
                 -2,    $ ;'DACM_PAC_CM_FS_COARSE',          $ ; 81
                 -2,    $ ;'DACM_PAC_CM_FS_FINE',            $ ; 82
                 '00'x, $ ;'DACM_MCP_COARSE',                $ ; 83
                 -1,    $ ;'DACM_MCP_FINE',                  $ ; 84
                 -2,    $ ;'DACM_MCP_CM_FS_COARSE',          $ ; 85
                 -2,    $ ;'DACM_MCP_CM_FS_FINE',            $ ; 86
                 '00'x, $ ;'DACM_SSD_COARSE',                $ ; 87
                 '00'x, $ ;'DACM_SSD_FINE',                  $ ; 88
                 -1,    $ ;'DACM_ESA_COARSE',                $ ; 89
                 -1,    $ ;'DACM_ESA_FINE',                  $ ; 90
                 -1,    $ ;'DACM_S_CH_COARSE',               $ ; 91
                 -1,    $ ;'DACM_S_CH_FINE',                 $ ; 92
                 -1,    $ ;'DACM_S_CH_TAP_COARSE',           $ ; 93
                 -1,    $ ;'DACM_S_CH_TAP_FINE',             $ ; 94
                 -1,    $ ;'DACM_DFL_1_COARSE',              $ ; 95
                 -1,    $ ;'DACM_DFL_1_FINE',                $ ; 96
                 -1,    $ ;'DACM_DFL_1_DFINE',               $ ; 97
                 -1,    $ ;'DACM_DFL_2_COARSE',              $ ; 98
                 -1,    $ ;'DACM_DFL_2_FINE',                $ ; 99
                 -1,    $ ;'DACM_DFL_2_DFINE',               $ ; 100
                 -3,    $ ;'DACR_PAC_MCP_SSD_CTL_MCP_LIMIT', $ ; 101
                 -3,    $ ;'DACR_PAC_LIMIT',                 $ ; 102
                 -3,    $ ;'DACR_ESA_CTL',                   $ ; 103
                 -3,    $ ;'DACR_S_CH_CTL',                  $ ; 104
                 -3,    $ ;'DACR_DFL_1_CTL',                 $ ; 105
                 -3,    $ ;'DACR_DFL_2_CTL',                 $ ; 106
                 -3,    $ ;'DACR_CONTROL',                   $ ; 107
                 -3,    $ ;'DACR_STATUS',                    $ ; 108
                 -3,    $ ;'DACR_ADC_LU_CTR',                $ ; 109
                 -3,    $ ;'DACR_DFL_1_OFFSET',              $ ; 110
                 -3,    $ ;'DACR_DFL_2_OFFSET',              $ ; 111
                 -3,    $ ;'DACR_C_PAC_COARSE',              $ ; 112
                 -3,    $ ;'DACR_C_PAC_FINE',                $ ; 113
                 -3,    $ ;'DACR_C_PAC_CM_FS_COARSE',        $ ; 114
                 -3,    $ ;'DACR_C_PAC_CM_FS_FINE',          $ ; 115
                 -3,    $ ;'DACR_C_MCP_COARSE',              $ ; 116
                 -3,    $ ;'DACR_C_MCP_FINE',                $ ; 117
                 -3,    $ ;'DACR_C_MCP_CM_FS_COARSE',        $ ; 118
                 -3,    $ ;'DACR_C_MCP_CM_FS_FINE',          $ ; 119
                 -3,    $ ;'DACR_C_SSD_COARSE',              $ ; 120
                 -3,    $ ;'DACR_C_SSD_FINE',                $ ; 121
                 -3,    $ ;'DACR_C_ESA_COARSE',              $ ; 122
                 -3,    $ ;'DACR_C_ESA_FINE',                $ ; 123
                 -3,    $ ;'DACR_C_S_CH_COARSE',             $ ; 124
                 -3,    $ ;'DACR_C_S_CH_FINE',               $ ; 125
                 -3,    $ ;'DACR_C_S_CH_TAP_COARSE',         $ ; 126
                 -3,    $ ;'DACR_C_S_CH_TAP_FINE',           $ ; 127
                 -3,    $ ;'DACR_DFL_1_COARSE',              $ ; 128
                 -3,    $ ;'DACR_DFL_1_FINE',                $ ; 129
                 -3,    $ ;'DACR_DFL_1_DFINE',               $ ; 130
                 -3,    $ ;'DACR_DFL_2_COARSE',              $ ; 131
                 -3,    $ ;'DACR_DFL_2_FINE',                $ ; 132
                 -3,    $ ;'DACR_DFL_2_DFINE',               $ ; 133
                 -1,    $ ;'SW_STATUS1',                     $ ; 134
                 '00'x, $ ;'SW_HV_RAMP_STATUS',              $ ; 135
                 '00'x, $ ;'SW_HV_ENABLE_STATUS',            $ ; 136
                 '00'x, $ ;'SW_HV_LIMIT_STATUS',             $ ; 137
                 -2,    $ ;'SW_EEPROMCHKSUM',                $ ; 138
                 -1,    $ ;'HKP_SAMPLETIME',                 $ ; 139
                 -2,    $ ;'PAC_DISCHARGE_STATUS',           $ ; 140
                 -2,    $ ;'PAC_DISCHARGE_CNT',              $ ; 141
                 -2,    $ ;'PAC_DISCHARGE_CONSECCNTR',       $ ; 142
                 -2,    $ ;'PAC_DISCHARGE_SAFE_ATT',         $ ; 143
                 -2,    $ ;'ANALOG_LIMIT_STATUS',            $ ; 144
                 -2,    $ ;'ANALOG_LIM_PT1_STATUS',          $ ; 145
                 -2,    $ ;'ANALOG_LIM_PT1_ID',              $ ; 146
                 -2,    $ ;'ANALOG_LIM_PT1_RED',             $ ; 147
                 -2,    $ ;'ANALOG_LIM_PT2_STATUS',          $ ; 148
                 -2,    $ ;'ANALOG_LIM_PT2_ID',              $ ; 149
                 -2,    $ ;'ANALOG_LIM_PT2_RED',             $ ; 150
                 -2,    $ ;'ANALOG_LIM_PT3_STATUS',          $ ; 151
                 -2,    $ ;'ANALOG_LIM_PT3_ID',              $ ; 152
                 -2,    $ ;'ANALOG_LIM_PT3_RED',             $ ; 153
                 -2,    $ ;'ANALOG_LIM_PT4_STATUS',          $ ; 154
                 -2,    $ ;'ANALOG_LIM_PT4_ID',              $ ; 155
                 -2,    $ ;'ANALOG_LIM_PT4_RED',             $ ; 156
                 -2,    $ ;'ANALOG_LIM_PT5_STATUS',          $ ; 157
                 -2,    $ ;'ANALOG_LIM_PT5_ID',              $ ; 158
                 -2,    $ ;'ANALOG_LIM_PT5_RED',             $ ; 159
                 -2,    $ ;'ANALOG_LIM_PT6_STATUS',          $ ; 160
                 -2,    $ ;'ANALOG_LIM_PT6_ID',              $ ; 161
                 -2,    $ ;'ANALOG_LIM_PT6_RED',             $ ; 162
                 -2,    $ ;'ANALOG_LIM_PT7_STATUS',          $ ; 163
                 -2,    $ ;'ANALOG_LIM_PT7_ID',              $ ; 164
                 -2,    $ ;'ANALOG_LIM_PT7_RED',             $ ; 165
                 -2,    $ ;'ANALOG_LIM_PT8_STATUS',          $ ; 166
                 -2,    $ ;'ANALOG_LIM_PT8_ID',              $ ; 167
                 -2,    $ ;'ANALOG_LIM_PT8_RED',             $ ; 168
                 -2,    $ ;'ANALOG_LIM_PT9_STATUS',          $ ; 169
                 -2,    $ ;'ANALOG_LIM_PT9_ID',              $ ; 170
                 -2,    $ ;'ANALOG_LIM_PT9_RED',             $ ; 171
                 -2,    $ ;'ANALOG_LIM_PT10_STATUS',         $ ; 172
                 -2,    $ ;'ANALOG_LIM_PT10_ID',             $ ; 173
                 -2,    $ ;'ANALOG_LIM_PT10_RED',            $ ; 174
                 -2,    $ ;'ANALOG_LIM_PT11_STATUS',         $ ; 175
                 -2,    $ ;'ANALOG_LIM_PT11_ID',             $ ; 176
                 -2,    $ ;'ANALOG_LIM_PT11_RED',            $ ; 177
                 -2,    $ ;'ANALOG_LIM_PT12_STATUS',         $ ; 178
                 -2,    $ ;'ANALOG_LIM_PT12_ID',             $ ; 179
                 -2,    $ ;'ANALOG_LIM_PT12_RED',            $ ; 180
                 -2,    $ ;'ANALOG_LIM_PT13_STATUS',         $ ; 181
                 -2,    $ ;'ANALOG_LIM_PT13_ID',             $ ; 182
                 -2,    $ ;'ANALOG_LIM_PT13_RED',            $ ; 183
                 -2,    $ ;'ANALOG_LIM_PT14_STATUS',         $ ; 184
                 -2,    $ ;'ANALOG_LIM_PT14_ID',             $ ; 185
                 -2,    $ ;'ANALOG_LIM_PT14_RED',            $ ; 186
                 -2,    $ ;'ANALOG_LIM_PT15_STATUS',         $ ; 187
                 -2,    $ ;'ANALOG_LIM_PT15_ID',             $ ; 188
                 -2,    $ ;'ANALOG_LIM_PT15_RED',            $ ; 189
                 -1,    $ ;'OPMODE',                         $ ; 190
                 -2,    $ ;'SW_MODE',                        $ ; 191
                 -2,    $ ;'PROTON_MODE',                    $ ; 192
                 -1,    $ ;'ACTIVE_SUPPLYID',                $ ; 193
                 -1,    $ ;'SUPPLY_COARSE_RB',               $ ; 194
                 -1,    $ ;'SUPPLY_FINE_RB',                 $ ; 195
                 -2,    $ ;'SWMAINT_SUPPLYSTAT',             $ ; 196
                 -1,    $ ;'SWMAINT_PAC_COARSE',             $ ; 197
                 -1     $ ;'SWMAINT_PAC_FINE'                $ ; 198
                 ]
dighk_high_limits = intarr(199)
dighk_high_limits = [ $    ; -1=none, -2=delta(report any change)
                 -2,    $ ;'DPU_SW_VERSION',                 $ ; 0
                 -1,    $ ;'CMD_RCVD_CNT',                   $ ; 1
                 -1,    $ ;'CMD_EXEC_CNT',                   $ ; 2
                 -2,    $ ;'CMD_TOTAL_ERR_CNT',              $ ; 3
                 '00'x, $ ;'CMD_PARITY_ERR_CNT',             $ ; 4
                 '00'x, $ ;'CMD_FRAME_ERR_CNT',              $ ; 5
                 '00'x, $ ;'CMD_ILLEGAL_ERR_CNT',            $ ; 6
                 -2,    $ ;'IC_STATUS_REG',                  $ ; 7
                 -2,    $ ;'IC_CTL_REG',                     $ ; 8
                 -2,    $ ;'LBC_RESET_CTL',                  $ ; 9
                 -2,    $ ;'LBC_MODE_CTL',                   $ ; 10
                 -2,    $ ;'LBC_LOGIC_CTL_A',                $ ; 11
                 -2,    $ ;'LBC_LOGIC_CTL_B',                $ ; 12
                 -2,    $ ;'LBC_TAC_PWR_CTL',                $ ; 13
                 -2,    $ ;'LBC_REG_SEQ',                    $ ; 14
                 -2,    $ ;'LBC_EVENT_CTL',                  $ ; 15
                 -2,    $ ;'LBC_RLIM_CH',                    $ ; 16
                 -2,    $ ;'LBC_RLIM_HI',                    $ ; 17
                 -2,    $ ;'LBC_RLIM_LO',                    $ ; 18
                 -2,    $ ;'LBE_POS_CTRL',                   $ ; 19
                 -2,    $ ;'LBE_POS_DISABLE0',               $ ; 20
                 -2,    $ ;'LBE_POS_DISABLE2',               $ ; 21
                 -2,    $ ;'LBE_TAC0_CTRL',                  $ ; 22
                 -2,    $ ;'LBE_TAC0_DAC',                   $ ; 23
                 -2,    $ ;'LBE_TAC2_CTRL',                  $ ; 24
                 -2,    $ ;'LBE_TAC2_DAC',                   $ ; 25
                 -2,    $ ;'LBE_TAC0_UNDER_HI',              $ ; 26
                 -2,    $ ;'LBE_TAC0_UNDER_LO',              $ ; 27
                 -2,    $ ;'LBE_TAC0_OVER_HI',               $ ; 28
                 -2,    $ ;'LBE_TAC0_OVER_LO',               $ ; 29
                 -2,    $ ;'LBE_TAC2_UNDER_HI',              $ ; 30
                 -2,    $ ;'LBE_TAC2_UNDER_LO',              $ ; 31
                 -2,    $ ;'LBE_TAC2_OVER_HI',               $ ; 32
                 -2,    $ ;'LBE_TAC2_OVER_LO',               $ ; 33
                 -2,    $ ;'LBE_SSD_CTRL',                   $ ; 34
                 -2,    $ ;'LBE_SSD_CMD_H',                  $ ; 35
                 -2,    $ ;'LBE_SSD_CMD_L',                  $ ; 36
                 -2,    $ ;'LBE_SSD_DIS',                    $ ; 37
                 -2,    $ ;'LBE_SSD_UNDER_HI',               $ ; 38
                 -2,    $ ;'LBE_SSD_UNDER_LO',               $ ; 39
                 -2,    $ ;'LBE_SSD_OVER_HI',                $ ; 40
                 -2,    $ ;'LBE_SSD_OVER_LO',                $ ; 41
                 -2,    $ ;'LBE_SEL_CTRL',                   $ ; 42
                 -2,    $ ;'LBE_TRIG_MODE',                  $ ; 43
                 -2,    $ ;'LBE_ESA_STEP',                   $ ; 44
                 -2,    $ ;'LBE_DEFL_STEP',                  $ ; 45
                 '20'x, $ ;'LBE_SSD_OFFSET0',                $ ; 46
                 '20'x, $ ;'LBE_SSD_OFFSET1',                $ ; 47
                 '20'x, $ ;'LBE_SSD_OFFSET2',                $ ; 48
                 '20'x, $ ;'LBE_SSD_OFFSET3',                $ ; 49
                 '20'x, $ ;'LBE_SSD_OFFSET4',                $ ; 50
                 '20'x, $ ;'LBE_SSD_OFFSET5',                $ ; 51
                 '20'x, $ ;'LBE_SSD_OFFSET6',                $ ; 52
                 '20'x, $ ;'LBE_SSD_OFFSET7',                $ ; 53
                 -2,    $ ;'LBE_STIM_ENABLE',                $ ; 54
                 -2,    $ ;'LBE_STIM_FREQ_HI',               $ ; 55
                 -2,    $ ;'LBE_STIM_FREQ_LO',               $ ; 56
                 -2,    $ ;'LBE_SEL0_WINDOW',                $ ; 57
                 -2,    $ ;'LBE_SEL2_WINDOW',                $ ; 58
                 '20'x, $ ;'LBE_SSD_OFFSET8',                $ ; 59
                 '20'x, $ ;'LBE_SSD_OFFSET9',                $ ; 60
                 '20'x, $ ;'LBE_SSD_OFFSET10',               $ ; 61
                 '20'x, $ ;'LBE_SSD_OFFSET11',               $ ; 62
                 '20'x, $ ;'LBE_SSD_OFFSET12',               $ ; 63
                 '20'x, $ ;'LBE_SSD_OFFSET13',               $ ; 64
                 '20'x, $ ;'LBE_SSD_OFFSET14',               $ ; 65
                 '20'x, $ ;'LBE_SSD_OFFSET15',               $ ; 66
                 -2,    $ ;'LBE_POS_RA',                     $ ; 67
                 -2,    $ ;'DACM_PAC_MCP_SSD_CTL_MCP_LIMIT', $ ; 68
                 -2,    $ ;'DACM_PAC_LIMIT',                 $ ; 69
                 -2,    $ ;'DACM_ESA_CTL',                   $ ; 70
                 -2,    $ ;'DACM_S_CH_CTL',                  $ ; 71
                 -2,    $ ;'DACM_DFL_1_CTL',                 $ ; 72
                 -2,    $ ;'DACM_DFL_2_CTL',                 $ ; 73
                 -2,    $ ;'DACM_CONTROL',                   $ ; 74
                 -2,    $ ;'DACM_STATUS',                    $ ; 75
                 -2,    $ ;'DACM_ADC_LU_CTR',                $ ; 76
                 -2,    $ ;'DACM_DFL_1_OFFSET',              $ ; 77
                 -2,    $ ;'DACM_DFL_2_OFFSET',              $ ; 78
                 -1,    $ ;'DACM_PAC_COARSE',                $ ; 79
                 -1,    $ ;'DACM_PAC_FINE',                  $ ; 80
                 -2,    $ ;'DACM_PAC_CM_FS_COARSE',          $ ; 81
                 -2,    $ ;'DACM_PAC_CM_FS_FINE',            $ ; 82
                 'C0'x, $ ;'DACM_MCP_COARSE',                $ ; 83
                 -1,    $ ;'DACM_MCP_FINE',                  $ ; 84
                 -2,    $ ;'DACM_MCP_CM_FS_COARSE',          $ ; 85
                 -2,    $ ;'DACM_MCP_CM_FS_FINE',            $ ; 86
                 'FF'x, $ ;'DACM_SSD_COARSE',                $ ; 87
                 'DE'x, $ ;'DACM_SSD_FINE',                  $ ; 88
                 -1,    $ ;'DACM_ESA_COARSE',                $ ; 89
                 -1,    $ ;'DACM_ESA_FINE',                  $ ; 90
                 -1,    $ ;'DACM_S_CH_COARSE',               $ ; 91
                 -1,    $ ;'DACM_S_CH_FINE',                 $ ; 92
                 -1,    $ ;'DACM_S_CH_TAP_COARSE',           $ ; 93
                 -1,    $ ;'DACM_S_CH_TAP_FINE',             $ ; 94
                 -1,    $ ;'DACM_DFL_1_COARSE',              $ ; 95
                 -1,    $ ;'DACM_DFL_1_FINE',                $ ; 96
                 -1,    $ ;'DACM_DFL_1_DFINE',               $ ; 97
                 -1,    $ ;'DACM_DFL_2_COARSE',              $ ; 98
                 -1,    $ ;'DACM_DFL_2_FINE',                $ ; 99
                 -1,    $ ;'DACM_DFL_2_DFINE',               $ ; 100
                 -3,    $ ;'DACR_PAC_MCP_SSD_CTL_MCP_LIMIT', $ ; 101
                 -3,    $ ;'DACR_PAC_LIMIT',                 $ ; 102
                 -3,    $ ;'DACR_ESA_CTL',                   $ ; 103
                 -3,    $ ;'DACR_S_CH_CTL',                  $ ; 104
                 -3,    $ ;'DACR_DFL_1_CTL',                 $ ; 105
                 -3,    $ ;'DACR_DFL_2_CTL',                 $ ; 106
                 -3,    $ ;'DACR_CONTROL',                   $ ; 107
                 -3,    $ ;'DACR_STATUS',                    $ ; 108
                 -3,    $ ;'DACR_ADC_LU_CTR',                $ ; 109
                 -3,    $ ;'DACR_DFL_1_OFFSET',              $ ; 110
                 -3,    $ ;'DACR_DFL_2_OFFSET',              $ ; 111
                 -3,    $ ;'DACR_C_PAC_COARSE',              $ ; 112
                 -3,    $ ;'DACR_C_PAC_FINE',                $ ; 113
                 -3,    $ ;'DACR_C_PAC_CM_FS_COARSE',        $ ; 114
                 -3,    $ ;'DACR_C_PAC_CM_FS_FINE',          $ ; 115
                 -3,    $ ;'DACR_C_MCP_COARSE',              $ ; 116
                 -3,    $ ;'DACR_C_MCP_FINE',                $ ; 117
                 -3,    $ ;'DACR_C_MCP_CM_FS_COARSE',        $ ; 118
                 -3,    $ ;'DACR_C_MCP_CM_FS_FINE',          $ ; 119
                 -3,    $ ;'DACR_C_SSD_COARSE',              $ ; 120
                 -3,    $ ;'DACR_C_SSD_FINE',                $ ; 121
                 -3,    $ ;'DACR_C_ESA_COARSE',              $ ; 122
                 -3,    $ ;'DACR_C_ESA_FINE',                $ ; 123
                 -3,    $ ;'DACR_C_S_CH_COARSE',             $ ; 124
                 -3,    $ ;'DACR_C_S_CH_FINE',               $ ; 125
                 -3,    $ ;'DACR_C_S_CH_TAP_COARSE',         $ ; 126
                 -3,    $ ;'DACR_C_S_CH_TAP_FINE',           $ ; 127
                 -3,    $ ;'DACR_DFL_1_COARSE',              $ ; 128
                 -3,    $ ;'DACR_DFL_1_FINE',                $ ; 129
                 -3,    $ ;'DACR_DFL_1_DFINE',               $ ; 130
                 -3,    $ ;'DACR_DFL_2_COARSE',              $ ; 131
                 -3,    $ ;'DACR_DFL_2_FINE',                $ ; 132
                 -3,    $ ;'DACR_DFL_2_DFINE',               $ ; 133
                 -1,    $ ;'SW_STATUS1',                     $ ; 134
                 '02'x, $ ;'SW_HV_RAMP_STATUS',              $ ; 135
                 '01'x, $ ;'SW_HV_ENABLE_STATUS',            $ ; 136
                 '01'x, $ ;'SW_HV_LIMIT_STATUS',             $ ; 137
                 -2,    $ ;'SW_EEPROMCHKSUM',                $ ; 138
                 -1,    $ ;'HKP_SAMPLETIME',                 $ ; 139
                 -2,    $ ;'PAC_DISCHARGE_STATUS',           $ ; 140
                 -2,    $ ;'PAC_DISCHARGE_CNT',              $ ; 141
                 -2,    $ ;'PAC_DISCHARGE_CONSECCNTR',       $ ; 142
                 -2,    $ ;'PAC_DISCHARGE_SAFE_ATT',         $ ; 143
                 -2,    $ ;'ANALOG_LIMIT_STATUS',            $ ; 144
                 -2,    $ ;'ANALOG_LIM_PT1_STATUS',          $ ; 145
                 -2,    $ ;'ANALOG_LIM_PT1_ID',              $ ; 146
                 -2,    $ ;'ANALOG_LIM_PT1_RED',             $ ; 147
                 -2,    $ ;'ANALOG_LIM_PT2_STATUS',          $ ; 148
                 -2,    $ ;'ANALOG_LIM_PT2_ID',              $ ; 149
                 -2,    $ ;'ANALOG_LIM_PT2_RED',             $ ; 150
                 -2,    $ ;'ANALOG_LIM_PT3_STATUS',          $ ; 151
                 -2,    $ ;'ANALOG_LIM_PT3_ID',              $ ; 152
                 -2,    $ ;'ANALOG_LIM_PT3_RED',             $ ; 153
                 -2,    $ ;'ANALOG_LIM_PT4_STATUS',          $ ; 154
                 -2,    $ ;'ANALOG_LIM_PT4_ID',              $ ; 155
                 -2,    $ ;'ANALOG_LIM_PT4_RED',             $ ; 156
                 -2,    $ ;'ANALOG_LIM_PT5_STATUS',          $ ; 157
                 -2,    $ ;'ANALOG_LIM_PT5_ID',              $ ; 158
                 -2,    $ ;'ANALOG_LIM_PT5_RED',             $ ; 159
                 -2,    $ ;'ANALOG_LIM_PT6_STATUS',          $ ; 160
                 -2,    $ ;'ANALOG_LIM_PT6_ID',              $ ; 161
                 -2,    $ ;'ANALOG_LIM_PT6_RED',             $ ; 162
                 -2,    $ ;'ANALOG_LIM_PT7_STATUS',          $ ; 163
                 -2,    $ ;'ANALOG_LIM_PT7_ID',              $ ; 164
                 -2,    $ ;'ANALOG_LIM_PT7_RED',             $ ; 165
                 -2,    $ ;'ANALOG_LIM_PT8_STATUS',          $ ; 166
                 -2,    $ ;'ANALOG_LIM_PT8_ID',              $ ; 167
                 -2,    $ ;'ANALOG_LIM_PT8_RED',             $ ; 168
                 -2,    $ ;'ANALOG_LIM_PT9_STATUS',          $ ; 169
                 -2,    $ ;'ANALOG_LIM_PT9_ID',              $ ; 170
                 -2,    $ ;'ANALOG_LIM_PT9_RED',             $ ; 171
                 -2,    $ ;'ANALOG_LIM_PT10_STATUS',         $ ; 172
                 -2,    $ ;'ANALOG_LIM_PT10_ID',             $ ; 173
                 -2,    $ ;'ANALOG_LIM_PT10_RED',            $ ; 174
                 -2,    $ ;'ANALOG_LIM_PT11_STATUS',         $ ; 175
                 -2,    $ ;'ANALOG_LIM_PT11_ID',             $ ; 176
                 -2,    $ ;'ANALOG_LIM_PT11_RED',            $ ; 177
                 -2,    $ ;'ANALOG_LIM_PT12_STATUS',         $ ; 178
                 -2,    $ ;'ANALOG_LIM_PT12_ID',             $ ; 179
                 -2,    $ ;'ANALOG_LIM_PT12_RED',            $ ; 180
                 -2,    $ ;'ANALOG_LIM_PT13_STATUS',         $ ; 181
                 -2,    $ ;'ANALOG_LIM_PT13_ID',             $ ; 182
                 -2,    $ ;'ANALOG_LIM_PT13_RED',            $ ; 183
                 -2,    $ ;'ANALOG_LIM_PT14_STATUS',         $ ; 184
                 -2,    $ ;'ANALOG_LIM_PT14_ID',             $ ; 185
                 -2,    $ ;'ANALOG_LIM_PT14_RED',            $ ; 186
                 -2,    $ ;'ANALOG_LIM_PT15_STATUS',         $ ; 187
                 -2,    $ ;'ANALOG_LIM_PT15_ID',             $ ; 188
                 -2,    $ ;'ANALOG_LIM_PT15_RED',            $ ; 189
                 -1,    $ ;'OPMODE',                         $ ; 190
                 -2,    $ ;'SW_MODE',                        $ ; 191
                 -2,    $ ;'PROTON_MODE',                    $ ; 192
                 -1,    $ ;'ACTIVE_SUPPLYID',                $ ; 193
                 -1,    $ ;'SUPPLY_COARSE_RB',               $ ; 194
                 -1,    $ ;'SUPPLY_FINE_RB',                 $ ; 195
                 -2,    $ ;'SWMAINT_SUPPLYSTAT',             $ ; 196
                 -1,    $ ;'SWMAINT_PAC_COARSE',             $ ; 197
                 -1     $ ;'SWMAINT_PAC_FINE'                $ ; 198
                 ]
dighk_old_values = lonarr(199)
first_dighk = 1
;spchk_products = strarr(10)
;spchk_products = [ $
 ;                'pl_ebox_tmp',         $ ; 0
  ;               'pl_pwr_cur',          $ ; 1
   ;              'pl_pwr_cur_att',      $ ; 2
    ;             'pl_pwr_cur_btt',      $ ; 3
     ;            'pl_pwr_vt',           $ ; 4
      ;           'pl_surv_pwr_cur',     $ ; 5
       ;          'pl_surv_pwr_cur_att', $ ; 6
        ;         'pl_surv_pwr_cur_btt', $ ; 7
         ;        'pl_surv_pwr_vt',      $ ; 8
          ;       'pl_tof_tmp_conv'      $ ; 9
           ;      ]
;spchk_conversions = strarr(10, 13)
;read_spacecraft_conv, conv_file, instrument_id
old_hk_epoch = -1D
old_dighk_epoch = -1D
dighk_post_327_values = lonarr(30, 1500)
dighk_post_327 = strarr(30)
dighk_post_327 = [ $
                 'apid315_disabled', $ ; 00
                 'apid316_disabled', $ ; 01
                 'apid317_disabled', $ ; 02
                 'apid318_disabled', $ ; 03
                 'apid319_disabled', $ ; 04
                 'apid31a_disabled', $ ; 05
                 'apid31b_disabled', $ ; 06
                 'apid31c_disabled', $ ; 07
                 'apid31d_disabled', $ ; 08
                 'apid31e_disabled', $ ; 09
                 'apid31f_disabled', $ ; 10
                 'apid320_disabled', $ ; 11
                 'apid321_disabled', $ ; 12
                 'apid322_disabled', $ ; 13
                 'apid323_disabled', $ ; 14
                 'apid324_disabled', $ ; 15
                 'apid325_disabled', $ ; 16
                 'apid326_disabled', $ ; 17
                 'apid327_disabled', $ ; 18
                 'apid319_accum'   , $ ; 19
                 'apid31a_accum'   , $ ; 20
                 'apid31b_accum'   , $ ; 21
                 'apid31c_accum'   , $ ; 22
                 'apid31d_accum'   , $ ; 23
                 'apid31e_accum'   , $ ; 24
                 'apid31f_accum'   , $ ; 25
                 'apid320_accum'   , $ ; 26
                 'apid321_accum'   , $ ; 27
                 'apid322_accum'   , $ ; 28
                 'apid323_accum'     $ ; 29
                 ]
END 

PRO set_share2
compile_opt strictarrsubs
COMMON share2, suspect_315, suspect_316_1, suspect_316_5, suspect_317, suspect_319, suspect_31a, suspect_31b, suspect_31c, suspect_31d, suspect_31e, suspect_31f, suspect_320, suspect_321, suspect_322, suspect_323, suspect_324, suspect_325, suspect_326, suspect_327, wrote_315, wrote_316_1, wrote_316_5, wrote_317, wrote_319, wrote_31a, wrote_31b, wrote_31c, wrote_31d, wrote_31e, wrote_31f, wrote_320, wrote_321, wrote_322, wrote_323, wrote_324, wrote_325, wrote_326, wrote_327, wrote_370, cycle_315, cycle_316, cycle_317, cycle_319, cycle_31a, cycle_31b, cycle_31c, cycle_31d, cycle_31e, cycle_31f, cycle_320, cycle_321, cycle_322, cycle_323, cycle_324, cycle_325, cycle_326, cycle_327, cycle_370, schan_315, schan_316, schan_317, schan_319, schan_31a, schan_31b, schan_31c, schan_31d, schan_31e, schan_31f, schan_320, schan_321, schan_322, schan_323, schan_324, schan_325, schan_326, schan_327, schan_370
suspect_315 = intarr(1450)
suspect_316_1 = intarr(1450)
suspect_316_5 = intarr(300)
suspect_317 = intarr(1450)
suspect_319 = intarr(300) 
suspect_31a = intarr(300)
suspect_31b = intarr(300)
suspect_31c = intarr(300)
suspect_31d = intarr(300)
suspect_31e = intarr(300)
suspect_31f = intarr(300)
suspect_320 = intarr(300)
suspect_321 = intarr(300)
suspect_322 = intarr(300)
suspect_323 = intarr(300)
suspect_324 = intarr(1450)
suspect_325 = intarr(1450)
suspect_326 = intarr(1450)
suspect_327 = intarr(1450)
wrote_315 = intarr(1450)
wrote_316_1 = intarr(1450)
wrote_316_5 = intarr(300)
wrote_317 = intarr(1450)
wrote_319 = intarr(300)
wrote_31a = intarr(300)
wrote_31b = intarr(300)
wrote_31c = intarr(300)
wrote_31d = intarr(300)
wrote_31e = intarr(300)
wrote_31f = intarr(300)
wrote_320 = intarr(300)
wrote_321 = intarr(300)
wrote_322 = intarr(300)
wrote_323 = intarr(300)
wrote_324 = intarr(1450)
wrote_325 = intarr(1450)
wrote_326 = intarr(1450)
wrote_327 = intarr(1450)
wrote_370 = intarr(1450)
cycle_315 = -1
cycle_316 = -1
cycle_317 = -1
cycle_319 = -1
cycle_31a = -1
cycle_31b = -1
cycle_31c = -1
cycle_31d = -1
cycle_31e = -1
cycle_31f = -1
cycle_320 = -1
cycle_321 = -1
cycle_322 = -1
cycle_323 = -1
cycle_324 = -1
cycle_325 = -1
cycle_326 = -1
cycle_327 = -1
cycle_370 = -1
schan_315 = -1
schan_316 = -1
schan_317 = -1
schan_319 = -1
schan_31a = -1
schan_31b = -1
schan_31c = -1
schan_31d = -1
schan_31e = -1
schan_31f = -1
schan_320 = -1
schan_321 = -1
schan_322 = -1
schan_323 = -1
schan_324 = -1
schan_325 = -1
schan_326 = -1
schan_327 = -1
schan_370 = -1
END 

PRO set_com_l0
compile_opt strictarrsubs
COMMON share1
conv_file = '/data1/Conversions.properties'
;conv_file = '/Users/lornaellis/Conversions.properties'
dpu_post_327          = -1 ; 0 if before 328, 1 if after
pkt_epoch             = -1D
epochs1               = dblarr(1450)
epochs5_mon           = dblarr(300)
epochs5_heavy         = dblarr(300)
cycles1               = intarr(1450)
cycles5_mon           = intarr(300)
cycles5_heavy         = intarr(300)
schan1                = intarr(1450)
schan5_mon            = intarr(300)
schan5_heavy          = intarr(300)
error_cycles          = intarr(1450)
suspect1              = intarr(1450)
suspect5_heavy        = intarr(300)
suspect5_mon          = intarr(300)
epochs1      [*]      = -1
epochs5_mon  [*]      = -1
epochs5_heavy[*]      = -1
cycles1      [*]      = -1
cycles5_mon  [*]      = -1
cycles5_heavy[*]      = -1
schan1       [*]      = -1
schan5_mon   [*]      = -1
schan5_heavy [*]      = -1
num_cycles1           = 0
num_cycles5_mon       = 0
num_cycles5_heavy     = 0
num_analog_cycles     = 0L
num_digital_cycles    = 0L
num_classifier_cycles = 0L
num_memory_cycles     = 0L
apid                  = -1
timestamp             = ' '
set_share2
set_com_pha
set_com_mon
set_com_heavy
set_com_alph_prot
set_com_moments
set_com_hk, conv_file, instrument_id
END 

