; Lorna Ellis
; send_hk.pro
; 01/22/2015

; This sends the monthly hk plot.

PRO send_hk
compile_opt strictarrsubs

time  = systime(1)              ; UTC, seconds since 1970
ts    = time_string(time)

year  = fix(strmid(ts, 0, 4))
month = fix(strmid(ts, 5, 2))
day   = fix(strmid(ts, 8, 2))

IF day EQ 1 THEN BEGIN
    month = month - 1
    IF month EQ 0 THEN BEGIN
        month = 12
        year  = year - 1
    ENDIF 
ENDIF 

year_st  = string(year,  format = '(I4.4)')
month_st = string(month, format = '(I2.2)')

plot_dir = '/nfs/fijidata1/Plots/HK_Monthly/'
plots = ['ESA_DFL_SCHAN', 'LVC', 'PAC_MCP_SSD', 'Temps']
sats  = ['A']
;sats  = ['A', 'B']

;addresses = ['lellis@spam.sr.unh.edu', 'lorna.ellis@unh.edu'] 
addresses = ['lellis@spam.sr.unh.edu', 'popecki@atlas.sr.unh.edu', 'tgalvin@atlas.sr.unh.edu', $
             'john.gaidos@unh.edu', 'dfhplastic@gmail.com']

dir  = plot_dir+plots[0]+'/'
plot = 'ST'+sats[0]+'_PLA_hk_'+year_st+month_st+'_'+plots[0]+'.png'
path = dir+plot
found = file_test(path)
IF found EQ 0 THEN BEGIN
    month = month-1
    IF month EQ 0 THEN BEGIN
        year  = year-1
        month = 12
    ENDIF 
    year_st  = string(year,  format = '(I4.4)')
    month_st = string(month, format = '(I2.2)')
ENDIF 

FOR sat_i = 0, 0 DO BEGIN
    string  = 'ST'+sats[sat_i]+' HK Plots'
    command = 'mutt -s "'+string+'" -a '
    FOR plot_i = 0, 3 DO BEGIN 
        dir  = plot_dir+plots[plot_i]+'/'
        plot = 'ST'+sats[sat_i]+'_PLA_hk_'+year_st+month_st+'_'+plots[plot_i]+'.png'
        path = dir+plot
        command = command + ' '+path
    ENDFOR 
    FOR add_i = 0, n_elements(addresses)-1 DO BEGIN 
        command = command + ' -c ' + addresses[add_i]
    ENDFOR 
    command = command + ' <  /home/lorna/Level1/IDL/empty.txt'
    spawn, command
ENDFOR 
END 
