; Catherine Walker and Lorna Ellis
; July 2006
; read_apid200_conv2

; Modified from read_apid200_conv 8/15/06

; This file finds conversions for analog houskeeping. It uses
; the Conversion.properties file. At the moment, this file takes
; a brute-force approach; so if the format of a conversion
; changes, this may have to change as well. I may fix this
; someday. At the moment, each value has a _conv array. The
; first element in the array says if it is a 'formula', 'enumeration',
; or 'null'. The difference between 'formula' and 'formula1' is
; only the output format (scientific notation or not). The second
; element (and every other element after that) is a operator. The
; third (and every other element after that) is a value. 

; 01/04/06 Added ssd_out_limit and ssd_out_once
; 01/18/07 Changed upper limits for esa_cm_dc
; 01/23/07 Added pwer_warning, thruster_warning, coarse_pointing
; 02/06/07 Changed limits for mcp_vm, mcp_cm_dc per Mark Popecki
; 02/09/07 Added esa_cm_dc_statis_limits
; 02/23/07 Changed yellow limit for lvc_p12v_imon
; 05/12/07 Changed yellow limit for mcp_vm
; 04/05/10 Changed yellow limit for lvc_p12v_imon
; 04/27/11 Changed yellow & red limits for mcp_vm and mcp_cm_dc

PRO read_apid200_conv2, conversion_file, instrument_id
compile_opt strictarrsubs
COMMON com_hk
line = ' '
CASE instrument_id OF 
    'FM1': BEGIN
        inst_id1 = 'A'
        inst_id2 = '1'
    END 
    'FM2': BEGIN
        inst_id1 = 'B'
        inst_id2 = '2'
    END 
    'EM': BEGIN
        inst_id1 = 'E'
        inst_id2 = 'E'
    END
    ELSE: BREAK
ENDCASE 
openr, conv_lun, conversion_file, /get_lun
num_found = 0
lrnm_spare       = 0
lvc_n12v         = 1
lvc_n5v          = 2
esa_vm_pos       = 3
dfl_1_vm         = 4
dfl_1_tap        = 5
dfl_2_vm         = 6
dfl_2_tap        = 7
lvc_p2_5v_b      = 8
pac_cm_dc        = 9
lvc_p12v         = 10
lrpm_spare       = 11
lvc_p2_5v_a      = 12
lvc_p5v          = 13
adc_avdd         = 14
adc_dvdd         = 15
pac_vm           = 16
cal_vref         = 17
pac_cm_ac        = 18
mcp_vm           = 19
mcp_cm_dc        = 20
mcp_cm_ac        = 21
ssd_cm_dc        = 22
s_ch_vm          = 23
s_ch_vm_tap      = 24
s_ch_cm_dc       = 25
esa_vm_neg       = 26
esa_cm_dc        = 27
dfl_1_cm_dc      = 28
dfl_2_cm_dc      = 29
lvc_p2_5v_b_imon = 30
lvc_p12v_imon    = 31
lvc_n12v_imon    = 32
lvc_p5v_imon     = 33
lvc_n5v_imon     = 34
lvc_p2_5v_a_imon = 35
ssd_bias_vm      = 36
plug_id          = 37
adc_lu_flag      = 38
dac_status       = 39
adc_lu_ctr       = 40
adc0_agnd        = 41
adc1_agnd        = 42
ra_e0            = 43
ra_e1            = 44
tac0_tsp         = 45
tac2_tsp         = 46
sb0_tsp          = 47
sb1_tsp          = 48
tof_hv0_tsp      = 49
tof_hv1_tsp      = 50
s_c_0_tsp        = 51
s_c_1_tsp        = 52
lvc0_tsp         = 53
lvc1_tsp         = 54
adc0_vref        = 55
adc1_vref        = 56
ssd_status       = 57
ssd_v_pos_analog = 58
ssd_v_neg_analog = 59
ssd_hv_bias      = 60
ssd_tc0          = 61
ssd_tc1          = 62
ssd_tc2          = 63
ssd_v_pos_dig    = 64
power_warning    = 65
thruster_warning = 66
coarse_pointing  = 67
my_min = !values.f_nan
my_max = !values.f_nan
hk_limits[lvc_n12v,         *] = [  -13.50,   -13.00,   -11.80,   -11.50] ;   // "LVC_-12V"
hk_limits[lvc_n5v,          *] = [   -5.80,    -5.70,    -4.80,    -4.75] ;   // "LVC_-5V"
hk_limits[lvc_p12v,         *] = [   11.50,    11.80,    13.40,    13.80] ;   // "LVC_+12V"
hk_limits[lvc_p5v,          *] = [    4.50,     4.70,     5.30,     5.50] ;   // "LVC_+5V"
hk_limits[lvc_p2_5v_a,      *] = [    2.25,     2.30,     2.60,     2.70] ;   // "LVC_+2.5VA"
hk_limits[lvc_p2_5v_b,      *] = [    2.25,     2.30,     2.60,     2.70] ;   // "LVC_+2.5VB"
hk_limits[lvc_n12v_imon,    *] = [   10.00,    25.00,    70.00,    75.00] ;   // "LVC_-12V_IMON"
hk_limits[lvc_n5v_imon,     *] = [   50.00,    70.00,   700.00,   750.00] ;   // "LVC_-5V_IMON"
hk_limits[lvc_p12v_imon,    *] = [   50.00,   100.00,   470.00,   500.00] ;   // "LVC_+12V_IMON"
hk_limits[lvc_p5v_imon,     *] = [  100.00,   200.00,   750.00,   825.00] ;   // "LVC_+5V_IMON"
hk_limits[lvc_p2_5v_a_imon, *] = [  175.00,   200.00,   300.00,   325.00] ;   // "LVC_+2.5VA_IMON"
hk_limits[lvc_p2_5v_b_imon, *] = [  200.00,   250.00,   325.00,   350.00] ;   // "LVC_+2.5VB_IMON"
hk_limits[pac_vm,           *] = [  my_min,   my_min, 25000.00, 27000.00] ;   // "PAC_VM"
hk_limits[pac_cm_dc,        *] = [  my_min,   my_min,    40.00,    50.00] ;   // "PAC_CM_DC"
hk_limits[esa_vm_pos,       *] = [  my_min,   my_min,  6000.00,  6100.00] ;   // "ESA_VM_POS"
hk_limits[esa_vm_neg,       *] = [-6100.00, -6000.00,   my_max,   my_max] ;   // "ESA_VM_NEG"
hk_limits[esa_cm_dc,        *] = [  my_min,   my_min,    68.00,    72.00] ;   // "ESA_CM_DC" -- if sweeping (check lbc_logic_ctl_a)
esa_cm_dc_static_limits[    *] = [  my_min,   my_min,    25.00,    35.00] ;   // "ESA_CM_DC" -- if not sweeping
hk_limits[mcp_vm,           *] = [    0.00,   500.00,  3350.00,  3400.00] ;   // "MCP_VM"
hk_limits[mcp_cm_dc,        *] = [  my_min,   my_min,    58.00,    63.00] ;   // "MCP_CM_DC"
hk_limits[ssd_bias_vm,      *] = [   50.00,    60.00,   125.00,   150.00] ;   // "SSD_BIAS_VM"
hk_limits[ssd_cm_dc,        *] = [  my_min,   my_min,   150.00,   160.00] ;   // "SSD_CM_DC"
hk_limits[s_ch_vm,          *] = [-5100.00, -5000.00,   my_max,   my_max] ;   // "S_CH_VM"
hk_limits[s_ch_vm_tap,      *] = [-3500.00, -3400.00,   my_max,   my_max] ;   // "S_CH_VM_TAP"
hk_limits[s_ch_cm_dc,       *] = [  my_min,   my_min,    30.00,    40.00] ;   // "S_CH_CM_DC"
hk_limits[dfl_1_vm,         *] = [  my_min,   my_min,  6800.00,  6900.00] ;   // "DFL_1_VM"
hk_limits[dfl_1_tap,        *] = [  my_min,   my_min,  3100.00,  3200.00] ;   // "DFL_1_TAP"
hk_limits[dfl_1_cm_dc,      *] = [  my_min,   my_min,    35.00,    45.00] ;   // "DFL_1_CM_DC"
hk_limits[dfl_2_vm,         *] = [  my_min,   my_min,  6800.00,  6900.00] ;   // "DFL_2_VM"
hk_limits[dfl_2_tap,        *] = [  my_min,   my_min,  3100.00,  3200.00] ;   // "DFL_2_TAP"
hk_limits[dfl_2_cm_dc,      *] = [  my_min,   my_min,    35.00,    45.00] ;   // "DFL_2_CM_DC"
hk_limits[ssd_status,       *] = [  my_min,   my_min,   my_max,   my_max] ;   // "SSD_STATUS"
hk_limits[ssd_v_pos_analog, *] = [    6.10,     6.40,     7.00,     7.30] ;   // "SSD_V_POS_ANALOG"
hk_limits[ssd_v_neg_analog, *] = [   -7.30,    -7.00,    -6.40,    -6.10] ;   // "SSD_V_NEG_ANALOG"
hk_limits[ssd_hv_bias,      *] = [   75.00,    85.00,   100.00,   110.00] ;   // "SSD_HV_BIAS"
hk_limits[ssd_tc0,          *] = [  -30.00,   -25.00,    30.00,    35.00] ;   // "SSD_TC0"
hk_limits[ssd_tc1,          *] = [  -30.00,   -25.00,    30.00,    35.00] ;   // "SSD_TC1"
hk_limits[ssd_tc2,          *] = [  -30.00,   -25.00,    30.00,    35.00] ;   // "SSD_TC2"
hk_limits[ssd_v_pos_dig,    *] = [    4.80,     5.30,     6.00,     6.30] ;   // "SSD_V_POS_DIG"
hk_limits[tac0_tsp,         *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "TAC0_TSP"
hk_limits[tac2_tsp,         *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "TAC2_TSP"
hk_limits[sb0_tsp,          *] = [  my_min,   my_min,   my_max,   my_max] ;   // "SB0_TSP"
hk_limits[sb1_tsp,          *] = [  my_min,   my_min,   my_max,   my_max] ;   // "SB1_TSP"
hk_limits[tof_hv0_tsp,      *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "TOF_HV0_TSP"
hk_limits[tof_hv1_tsp,      *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "TOF_HV1_TSP"
hk_limits[s_c_0_tsp,        *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "S_C_0_TSP"
hk_limits[s_c_1_tsp,        *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "S_C_1_TSP"
hk_limits[lvc0_tsp,         *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "LVC0_TSP"
hk_limits[lvc1_tsp,         *] = [  -30.00,   -25.00,    55.00,    60.00] ;   // "LVC1_TSP"
hk_limits[cal_vref,         *] = [  my_min,   my_min,   my_max,   my_max] ;   // "CAL_VREF"
hk_limits[adc_lu_flag,      *] = [  my_min,   my_min,   my_max,   my_max] ;   // "ADC_LU_FLAG"
hk_limits[plug_id,          *] = [  my_min,   my_min,   my_max,   my_max] ;   // "PLUG_ID"
hk_limits[dac_status,       *] = [  my_min,   my_min,   my_max,   my_max] ;   // "STATUS_DAC"
hk_limits[adc_lu_ctr,       *] = [  my_min,   my_min,   my_max,   my_max] ;   // "DAC_ADC_LU_CTR"
hk_limits[adc_avdd,         *] = [  my_min,   my_min,   my_max,   my_max] ;   // "DAC_ADC_AVDD"
hk_limits[adc_dvdd,         *] = [  my_min,   my_min,   my_max,   my_max] ;   // "DAC_ADC_DVDD"
hk_limits[adc0_vref,        *] = [  my_min,   my_min,   my_max,   my_max] ;   // "LOGIC_ADC0_VREF"
hk_limits[adc1_vref,        *] = [  my_min,   my_min,   my_max,   my_max] ;   // "LOGIC_ADC1_VREF" 
hk_limits[lrnm_spare,       *] = [  my_min,   my_min,   my_max,   my_max] ;   // "LRNM_SPARE"
hk_limits[lrpm_spare,       *] = [  my_min,   my_min,   my_max,   my_max] ;   // "LRPM_SPARE"
hk_limits[pac_cm_ac,        *] = [  my_min,   my_min,   my_max,   my_max] ;   // "PAC_CM_AC"
hk_limits[adc0_agnd,        *] = [  my_min,   my_min,   my_max,   my_max] ;   // "ADC0_AGND"
hk_limits[adc1_agnd,        *] = [  my_min,   my_min,   my_max,   my_max] ;   // "ADC1_AGND"
hk_limits[ra_e0,            *] = [  my_min,   my_min,   my_max,   my_max] ;   // "RA_E0"
hk_limits[ra_e1,            *] = [  my_min,   my_min,   my_max,   my_max] ;   // "RA_E1"
find1 = 'CAL_VREF.'+inst_id1
find2 = 'CAL_VREF.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 1) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[cal_vref, 0] = 'formula1'
            hk_conversions[cal_vref, 1] = parts[4]
            hk_conversions[cal_vref, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[cal_vref, 3] = parts[6]
            hk_conversions[cal_vref, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE 
find1 = 'DAC_ADC_AVDD.'+inst_id1
find2 = 'DAC_ADC_AVDD.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 2) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc_avdd, 0] = 'formula1'
                hk_conversions[adc_avdd, 1] = parts[4]
                hk_conversions[adc_avdd, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[adc_avdd, 3] = parts[6]
                hk_conversions[adc_avdd, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 2) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc_avdd, 0] = 'formula1'
                hk_conversions[adc_avdd, 1] = parts[4]
                hk_conversions[adc_avdd, 2] = parts[5]
                hk_conversions[adc_avdd, 3] = parts[7]
                hk_conversions[adc_avdd, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'DAC_ADC_DVDD.'+inst_id1
find2 = 'DAC_ADC_DVDD.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 3) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc_dvdd, 0] = 'formula1'
                hk_conversions[adc_dvdd, 1] = parts[4]
                hk_conversions[adc_dvdd, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[adc_dvdd, 3] = parts[6]
                hk_conversions[adc_dvdd, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 3) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc_dvdd, 0] = 'formula1'
                hk_conversions[adc_dvdd, 1] = parts[4]
                hk_conversions[adc_dvdd, 2] = parts[5]
                hk_conversions[adc_dvdd, 3] = parts[7]
                hk_conversions[adc_dvdd, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'DFL_1_CM_DC.'+inst_id1
find2 = 'DFL_1_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 4) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_1_cm_dc, 0] = 'formula1'
                hk_conversions[dfl_1_cm_dc, 1] = parts[4]
                hk_conversions[dfl_1_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_1_cm_dc, 3] = parts[6]
                hk_conversions[dfl_1_cm_dc, 4] = parts[7]
                hk_conversions[dfl_1_cm_dc, 5] = parts[12]
                hk_conversions[dfl_1_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[dfl_1_cm_dc, 7] = parts[14]
                hk_conversions[dfl_1_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 4) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_1_cm_dc, 0] = 'formula1'
                hk_conversions[dfl_1_cm_dc, 1] = parts[4]
                hk_conversions[dfl_1_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_1_cm_dc, 3] = parts[6]
                hk_conversions[dfl_1_cm_dc, 4] = parts[7]
                hk_conversions[dfl_1_cm_dc, 5] = parts[12]
                hk_conversions[dfl_1_cm_dc, 6] = parts[11]
                hk_conversions[dfl_1_cm_dc, 7] = parts[14]
                hk_conversions[dfl_1_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'DFL_1_TAP.'+inst_id1
find2 = 'DFL_1_TAP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 5) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_1_tap, 0] = 'formula1'
                hk_conversions[dfl_1_tap, 1] = parts[4]
                hk_conversions[dfl_1_tap, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[dfl_1_tap, 3] = parts[6]
                hk_conversions[dfl_1_tap, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 5) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_1_tap, 0] = 'formula1'
                hk_conversions[dfl_1_tap, 1] = parts[4]
                hk_conversions[dfl_1_tap, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_1_tap, 3] = parts[6]
                hk_conversions[dfl_1_tap, 4] = parts[7]
                hk_conversions[dfl_1_tap, 5] = parts[12]
                hk_conversions[dfl_1_tap, 6] = strmid(parts[11], 2, strlen(parts[11])-2)
                hk_conversions[dfl_1_tap, 7] = parts[14]
                hk_conversions[dfl_1_tap, 8] = strmid(parts[15], 0, strlen(parts[15])-1)
                hk_conversions[dfl_1_tap, 9] = '*'
                hk_conversions[dfl_1_tap, 10] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'DFL_1_VM.'+inst_id1
find2 = 'DFL_1_VM.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 6) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_1_vm, 0] = 'formula1'
                hk_conversions[dfl_1_vm, 1] = parts[4]
                hk_conversions[dfl_1_vm, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[dfl_1_vm, 3] = parts[6]
                hk_conversions[dfl_1_vm, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 6) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_1_vm, 0] = 'formula1'
                hk_conversions[dfl_1_vm, 1] = parts[4]
                hk_conversions[dfl_1_vm, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_1_vm, 3] = parts[6]
                hk_conversions[dfl_1_vm, 4] = parts[7]
                hk_conversions[dfl_1_vm, 5] = parts[12]
                hk_conversions[dfl_1_vm, 6] = strmid(parts[11], 2, strlen(parts[11])-2)
                hk_conversions[dfl_1_vm, 7] = parts[14]
                hk_conversions[dfl_1_vm, 8] = strmid(parts[15], 0, strlen(parts[15])-1)
                hk_conversions[dfl_1_vm, 9] = '*'
                hk_conversions[dfl_1_vm, 10] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'DFL_2_CM_DC.'+inst_id1
find2 = 'DFL_2_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 7) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_2_cm_dc, 0] = 'formula1'
                hk_conversions[dfl_2_cm_dc, 1] = parts[4]
                hk_conversions[dfl_2_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_2_cm_dc, 3] = parts[6]
                hk_conversions[dfl_2_cm_dc, 4] = parts[7]
                hk_conversions[dfl_2_cm_dc, 5] = parts[12]
                hk_conversions[dfl_2_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[dfl_2_cm_dc, 7] = parts[14]
                hk_conversions[dfl_2_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 7) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_2_cm_dc, 0] = 'formula1'
                hk_conversions[dfl_2_cm_dc, 1] = parts[4]
                hk_conversions[dfl_2_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_2_cm_dc, 3] = parts[6]
                hk_conversions[dfl_2_cm_dc, 4] = parts[7]
                hk_conversions[dfl_2_cm_dc, 5] = parts[12]
                hk_conversions[dfl_2_cm_dc, 6] = parts[11]
                hk_conversions[dfl_2_cm_dc, 7] = parts[14]
                hk_conversions[dfl_2_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'DFL_2_TAP.'+inst_id1
find2 = 'DFL_2_TAP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 8) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_2_tap, 0] = 'formula1'
                hk_conversions[dfl_2_tap, 1] = parts[4]
                hk_conversions[dfl_2_tap, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[dfl_2_tap, 3] = parts[6]
                hk_conversions[dfl_2_tap, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 8) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_2_tap, 0] = 'formula1'
                hk_conversions[dfl_2_tap, 1] = parts[4]
                hk_conversions[dfl_2_tap, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_2_tap, 3] = parts[6]
                hk_conversions[dfl_2_tap, 4] = parts[7]
                hk_conversions[dfl_2_tap, 5] = parts[12]
                hk_conversions[dfl_2_tap, 6] = strmid(parts[11], 2, strlen(parts[11])-2)
                hk_conversions[dfl_2_tap, 7] = parts[14]
                hk_conversions[dfl_2_tap, 8] = strmid(parts[15], 0, strlen(parts[15])-1)
                hk_conversions[dfl_2_tap, 9] = '*'
                hk_conversions[dfl_2_tap, 10] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'DFL_2_VM.'+inst_id1
find2 = 'DFL_2_VM.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 9) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_2_vm, 0] = 'formula1'
                hk_conversions[dfl_2_vm, 1] = parts[4]
                hk_conversions[dfl_2_vm, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[dfl_2_vm, 3] = parts[6]
                hk_conversions[dfl_2_vm, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 9) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[dfl_2_vm, 0] = 'formula1'
                hk_conversions[dfl_2_vm, 1] = parts[4]
                hk_conversions[dfl_2_vm, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[dfl_2_vm, 3] = parts[6]
                hk_conversions[dfl_2_vm, 4] = parts[7]
                hk_conversions[dfl_2_vm, 5] = parts[12]
                hk_conversions[dfl_2_vm, 6] = strmid(parts[11], 2, strlen(parts[11])-2)
                hk_conversions[dfl_2_vm, 7] = parts[14]
                hk_conversions[dfl_2_vm, 8] = strmid(parts[15], 0, strlen(parts[15])-1)
                hk_conversions[dfl_2_vm, 9] = '*'
                hk_conversions[dfl_2_vm, 10] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'ESA_CM_DC.'+inst_id1
find2 = 'ESA_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 10) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[esa_cm_dc, 0] = 'formula1'
                hk_conversions[esa_cm_dc, 1] = parts[4]
                hk_conversions[esa_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[esa_cm_dc, 3] = parts[6]
                hk_conversions[esa_cm_dc, 4] = parts[7]
                hk_conversions[esa_cm_dc, 5] = parts[12]
                hk_conversions[esa_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[esa_cm_dc, 7] = parts[14]
                hk_conversions[esa_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 10) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[esa_cm_dc, 0] = 'formula1'
                hk_conversions[esa_cm_dc, 1] = parts[4]
                hk_conversions[esa_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[esa_cm_dc, 3] = parts[6]
                hk_conversions[esa_cm_dc, 4] = parts[7]
                hk_conversions[esa_cm_dc, 5] = parts[12]
                hk_conversions[esa_cm_dc, 6] = parts[11]
                hk_conversions[esa_cm_dc, 7] = parts[14]
                hk_conversions[esa_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'ESA_VM_NEG.'+inst_id1
find2 = 'ESA_VM_NEG.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 11) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[esa_vm_neg, 0] = 'formula1'
                hk_conversions[esa_vm_neg, 1] = parts[4]
                hk_conversions[esa_vm_neg, 2] = strmid(parts[3], 3, strlen(parts[3])-3)
                hk_conversions[esa_vm_neg, 3] = parts[6]
                hk_conversions[esa_vm_neg, 4] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[esa_vm_neg, 5] = '*'
                hk_conversions[esa_vm_neg, 6] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 11) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[esa_vm_neg, 0] = 'formula1'
                hk_conversions[esa_vm_neg, 1] = parts[4]
                hk_conversions[esa_vm_neg, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[esa_vm_neg, 3] = parts[6]
                hk_conversions[esa_vm_neg, 4] = parts[7]
                hk_conversions[esa_vm_neg, 5] = parts[12]
                hk_conversions[esa_vm_neg, 6] = strmid(parts[11], 2, strlen(parts[11])-2)
                hk_conversions[esa_vm_neg, 7] = parts[14]
                hk_conversions[esa_vm_neg, 8] = strmid(parts[15], 0, strlen(parts[15])-1)
                hk_conversions[esa_vm_neg, 9] = '*'
                hk_conversions[esa_vm_neg, 10] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'ESA_VM_POS.'+inst_id1
find2 = 'ESA_VM_POS.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 12) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[esa_vm_pos, 0] = 'formula1'
                hk_conversions[esa_vm_pos, 1] = parts[4]
                hk_conversions[esa_vm_pos, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[esa_vm_pos, 3] = parts[6]
                hk_conversions[esa_vm_pos, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 12) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[esa_vm_pos, 0] = 'formula1'
                hk_conversions[esa_vm_pos, 1] = parts[4]
                hk_conversions[esa_vm_pos, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[esa_vm_pos, 3] = parts[6]
                hk_conversions[esa_vm_pos, 4] = parts[7]
                hk_conversions[esa_vm_pos, 5] = parts[12]
                hk_conversions[esa_vm_pos, 6] = parts[11]
                hk_conversions[esa_vm_pos, 7] = parts[14]
                hk_conversions[esa_vm_pos, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LOGIC_ADC0_AGND.'+inst_id1
find2 = 'LOGIC_ADC0_AGND.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 13) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[adc0_agnd, 0] = 'formula1'
            hk_conversions[adc0_agnd, 1] = parts[4]
            hk_conversions[adc0_agnd, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
            hk_conversions[adc0_agnd, 3] = parts[6]
            hk_conversions[adc0_agnd, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE 
find1 = 'LOGIC_ADC0_VREF.'+inst_id1
find2 = 'LOGIC_ADC0_VREF.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 14) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc0_vref, 0] = 'formula1'
                hk_conversions[adc0_vref, 1] = parts[4]
                hk_conversions[adc0_vref, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[adc0_vref, 3] = parts[6]
                hk_conversions[adc0_vref, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 14) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc0_vref, 0] = 'formula1'
                hk_conversions[adc0_vref, 1] = parts[4]
                hk_conversions[adc0_vref, 2] = parts[5]
                hk_conversions[adc0_vref, 3] = parts[6]
                hk_conversions[adc0_vref, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'LOGIC_ADC1_AGND.'+inst_id1
find2 = 'LOGIC_ADC1_AGND.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 15) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[adc1_agnd, 0] = 'formula1'
            hk_conversions[adc1_agnd, 1] = parts[4]
            hk_conversions[adc1_agnd, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
            hk_conversions[adc1_agnd, 3] = parts[6]
            hk_conversions[adc1_agnd, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'LOGIC_ADC1_VREF.'+inst_id1
find2 = 'LOGIC_ADC1_VREF.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 16) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc1_vref, 0] = 'formula1'
                hk_conversions[adc1_vref, 1] = parts[4]
                hk_conversions[adc1_vref, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[adc1_vref, 3] = parts[6]
                hk_conversions[adc1_vref, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 16) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[adc1_vref, 0] = 'formula1'
                hk_conversions[adc1_vref, 1] = parts[4]
                hk_conversions[adc1_vref, 2] = parts[5]
                hk_conversions[adc1_vref, 3] = parts[6]
                hk_conversions[adc1_vref, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'LRNM_SPARE.'+inst_id1
find2 = 'LRNM_SPARE.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 17) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lrnm_spare, 0] = 'formula1'
                hk_conversions[lrnm_spare, 1] = parts[4]
                hk_conversions[lrnm_spare, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lrnm_spare, 3] = parts[6]
                hk_conversions[lrnm_spare, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 17) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lrnm_spare, 0] = 'formula1'
                hk_conversions[lrnm_spare, 1] = '*'
                hk_conversions[lrnm_spare, 2] = '1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LRPM_SPARE.'+inst_id1
find2 = 'LRPM_SPARE.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 18) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lrpm_spare, 0] = 'formula1'
                hk_conversions[lrpm_spare, 1] = parts[4]
                hk_conversions[lrpm_spare, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lrpm_spare, 3] = parts[6]
                hk_conversions[lrpm_spare, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 18) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lrpm_spare, 0] = 'formula1'
                hk_conversions[lrpm_spare, 1] = parts[4]
                hk_conversions[lrpm_spare, 2] = parts[5]
                hk_conversions[lrpm_spare, 3] = parts[7]
                hk_conversions[lrpm_spare, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LVC0_TSP.'+inst_id1
find2 = 'LVC0_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 19) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc0_tsp, 0] = 'formula1'
                hk_conversions[lvc0_tsp, 1] = parts[4]
                hk_conversions[lvc0_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[lvc0_tsp, 3] = parts[6]
                hk_conversions[lvc0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 19) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc0_tsp, 0] = 'formula1'
                hk_conversions[lvc0_tsp, 1] = parts[4]
                hk_conversions[lvc0_tsp, 2] = parts[5]
                hk_conversions[lvc0_tsp, 3] = parts[6]
                hk_conversions[lvc0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LVC1_TSP.'+inst_id1
find2 = 'LVC1_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 20) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc1_tsp, 0] = 'formula1'
                hk_conversions[lvc1_tsp, 1] = parts[4]
                hk_conversions[lvc1_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[lvc1_tsp, 3] = parts[6]
                hk_conversions[lvc1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 20) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc1_tsp, 0] = 'formula1'
                hk_conversions[lvc1_tsp, 1] = parts[4]
                hk_conversions[lvc1_tsp, 2] = parts[5]
                hk_conversions[lvc1_tsp, 3] = parts[6]
                hk_conversions[lvc1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LVC_+12V.'+inst_id1
find2 = 'LVC_+12V.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 21) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p12v, 0] = 'formula1'
                hk_conversions[lvc_p12v, 1] = parts[4]
                hk_conversions[lvc_p12v, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lvc_p12v, 3] = parts[6]
                hk_conversions[lvc_p12v, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 21) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p12v, 0] = 'formula1'
                hk_conversions[lvc_p12v, 1] = parts[4]
                hk_conversions[lvc_p12v, 2] = parts[5]
                hk_conversions[lvc_p12v, 3] = parts[7]
                hk_conversions[lvc_p12v, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LVC_+12V_IMON.'+inst_id1
find2 = 'LVC_+12V_IMON.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 22) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_p12v_imon, 0] = 'formula1'
            hk_conversions[lvc_p12v_imon, 1] = parts[4]
            hk_conversions[lvc_p12v_imon, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[lvc_p12v_imon, 3] = parts[6]
            hk_conversions[lvc_p12v_imon, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'LVC_+2.5VA.'+inst_id1
find2 = 'LVC_+2.5VA.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 23) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p2_5v_a, 0] = 'formula1'
                hk_conversions[lvc_p2_5v_a, 1] = parts[4]
                hk_conversions[lvc_p2_5v_a, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lvc_p2_5v_a, 3] = parts[6]
                hk_conversions[lvc_p2_5v_a, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE   
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 23) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p2_5v_a, 0] = 'formula1'
                hk_conversions[lvc_p2_5v_a, 1] = parts[4]
                hk_conversions[lvc_p2_5v_a, 2] = parts[5]
                hk_conversions[lvc_p2_5v_a, 3] = parts[7]
                hk_conversions[lvc_p2_5v_a, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LVC_+2.5VA_IMON.'+inst_id1
find2 = 'LVC_+2.5VA_IMON.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 24) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_p2_5v_a_imon, 0] = 'formula1'
            hk_conversions[lvc_p2_5v_a_imon, 1] = parts[4]
            hk_conversions[lvc_p2_5v_a_imon, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[lvc_p2_5v_a_imon, 3] = parts[6]
            hk_conversions[lvc_p2_5v_a_imon, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'LVC_+2.5VB.'+inst_id1
find2 = 'LVC_+2.5VB.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 25) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p2_5v_b, 0] = 'formula1'
                hk_conversions[lvc_p2_5v_b, 1] = parts[4]
                hk_conversions[lvc_p2_5v_b, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lvc_p2_5v_b, 3] = parts[6]
                hk_conversions[lvc_p2_5v_b, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 25) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p2_5v_b, 0] = 'formula1'
                hk_conversions[lvc_p2_5v_b, 1] = parts[4]
                hk_conversions[lvc_p2_5v_b, 2] = parts[5]
                hk_conversions[lvc_p2_5v_b, 3] = parts[7]
                hk_conversions[lvc_p2_5v_b, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'LVC_+2.5VB_IMON.'+inst_id1
find2 = 'LVC_+2.5VB_IMON.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 26) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p2_5v_b_imon, 0] = 'formula1'
                hk_conversions[lvc_p2_5v_b_imon, 1] = parts[4]
                hk_conversions[lvc_p2_5v_b_imon, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lvc_p2_5v_b_imon, 3] = parts[6]
                hk_conversions[lvc_p2_5v_b_imon, 4] = parts[7]
                num_found = num_found + 1
            ENDIF
        ENDIF
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 26) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p2_5v_b_imon, 0] = 'formula1'
                hk_conversions[lvc_p2_5v_b_imon, 1] = parts[4]
                hk_conversions[lvc_p2_5v_b_imon, 2] = parts[5]
                hk_conversions[lvc_p2_5v_b_imon, 3] = parts[7]
                hk_conversions[lvc_p2_5v_b_imon, 4] = parts[8]
                num_found = num_found + 1
            ENDIF
        ENDIF
    ENDWHILE
ENDELSE
find1 = 'LVC_+5V.'+inst_id1
find2 = 'LVC_+5V.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 27) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p5v, 0] = 'formula1'
                hk_conversions[lvc_p5v, 1] = parts[4]
                hk_conversions[lvc_p5v, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[lvc_p5v, 3] = parts[6]
                hk_conversions[lvc_p5v, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE   
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 27) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[lvc_p5v, 0] = 'formula1'
                hk_conversions[lvc_p5v, 1] = parts[4]
                hk_conversions[lvc_p5v, 2] = parts[5]
                hk_conversions[lvc_p5v, 3] = parts[7]
                hk_conversions[lvc_p5v, 4] = parts[8]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'LVC_+5V_IMON.'+inst_id1
find2 = 'LVC_+5V_IMON.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 28) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_p5v_imon, 0] = 'formula1'
            hk_conversions[lvc_p5v_imon, 1] = parts[4]
            hk_conversions[lvc_p5v_imon, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[lvc_p5v_imon, 3] = parts[6]
            hk_conversions[lvc_p5v_imon, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'LVC_-12V.'+inst_id1
find2 = 'LVC_-12V.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 29) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_n12v, 0] = 'formula1'
            hk_conversions[lvc_n12v, 1] = parts[4]
            hk_conversions[lvc_n12v, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[lvc_n12v, 3] = '*'
            hk_conversions[lvc_n12v, 4] = '-1'
            hk_conversions[lvc_n12v, 5] = parts[6]
            hk_conversions[lvc_n12v, 6] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'LVC_-12V_IMON.'+inst_id1
find2 = 'LVC_-12V_IMON.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 30) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_n12v_imon, 0] = 'formula1'
            hk_conversions[lvc_n12v_imon, 1] = parts[4]
            hk_conversions[lvc_n12v_imon, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[lvc_n12v_imon, 3] = parts[6]
            hk_conversions[lvc_n12v_imon, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'LVC_-5V.'+inst_id1
find2 = 'LVC_-5V.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 31) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_n5v, 0] = 'formula1'
            hk_conversions[lvc_n5v, 1] = parts[4]
            hk_conversions[lvc_n5v, 2] = strmid(parts(5), 0, strlen(parts[5])-1)
            hk_conversions[lvc_n5v, 3] = '*'
            hk_conversions[lvc_n5v, 4] = '-1'
            hk_conversions[lvc_n5v, 5] = parts[6]
            hk_conversions[lvc_n5v, 6] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE  
find1 = 'LVC_-5V_IMON.'+inst_id1
find2 = 'LVC_-5V_IMON.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 32) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[lvc_n5v_imon, 0] = 'formula1'
            hk_conversions[lvc_n5v_imon, 1] = parts[4]
            hk_conversions[lvc_n5v_imon, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
            hk_conversions[lvc_n5v_imon, 3] = parts[6]
            hk_conversions[lvc_n5v_imon, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'MCP_CM_DC.'+inst_id1
find2 = 'MCP_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 33) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[mcp_cm_dc, 0] = 'formula1'
                hk_conversions[mcp_cm_dc, 1] = parts[4]
                hk_conversions[mcp_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[mcp_cm_dc, 3] = parts[6]
                hk_conversions[mcp_cm_dc, 4] = parts[7]
                hk_conversions[mcp_cm_dc, 5] = parts[12]
                hk_conversions[mcp_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[mcp_cm_dc, 7] = parts[14]
                hk_conversions[mcp_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 33) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[mcp_cm_dc, 0] = 'formula1'
                hk_conversions[mcp_cm_dc, 1] = parts[4]
                hk_conversions[mcp_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[mcp_cm_dc, 3] = parts[6]
                hk_conversions[mcp_cm_dc, 4] = parts[7]
                hk_conversions[mcp_cm_dc, 5] = parts[12]
                hk_conversions[mcp_cm_dc, 6] = parts[11]
                hk_conversions[mcp_cm_dc, 7] = parts[14]
                hk_conversions[mcp_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'MCP_VM.'+inst_id1
find2 = 'MCP_VM.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 34) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[mcp_vm, 0] = 'formula1'
                hk_conversions[mcp_vm, 1] = parts[4]
                hk_conversions[mcp_vm, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[mcp_vm, 3] = parts[6]
                hk_conversions[mcp_vm, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 34) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[mcp_vm, 0] = 'formula1'
                hk_conversions[mcp_vm, 1] = 'px'
                hk_conversions[mcp_vm, 2] = parts[3]
                hk_conversions[mcp_vm, 3] = parts[10]
                hk_conversions[mcp_vm, 4] = parts[9]
                hk_conversions[mcp_vm, 5] = parts[12]
                hk_conversions[mcp_vm, 6] = parts[13]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'PAC_CM_DC.'+inst_id1
find2 = 'PAC_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 35) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[pac_cm_dc, 0] = 'formula1'
                hk_conversions[pac_cm_dc, 1] = parts[4]
                hk_conversions[pac_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[pac_cm_dc, 3] = parts[6]
                hk_conversions[pac_cm_dc, 4] = parts[7]
                hk_conversions[pac_cm_dc, 5] = 'py'
                hk_conversions[pac_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[pac_cm_dc, 7] = parts[18]
                hk_conversions[pac_cm_dc, 8] = strmid(parts[17], 1, strlen(parts[17])-1)
                hk_conversions[pac_cm_dc, 9] = '*'
                hk_conversions[pac_cm_dc, 10] = '-1'
                hk_conversions[pac_cm_dc, 11] = parts[20]
                hk_conversions[pac_cm_dc, 12] = parts[21]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 35) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[pac_cm_dc, 0] = 'formula1'
                hk_conversions[pac_cm_dc, 1] = parts[4]
                hk_conversions[pac_cm_dc, 2] = parts[5]
                hk_conversions[pac_cm_dc, 3] = parts[7]
                hk_conversions[pac_cm_dc, 4] = parts[8]
                hk_conversions[pac_cm_dc, 5] = 'py'
                hk_conversions[pac_cm_dc, 6] = parts[12]
                hk_conversions[pac_cm_dc, 7] = parts[19]
                hk_conversions[pac_cm_dc, 8] = parts[18]
                hk_conversions[pac_cm_dc, 9] = '*'
                hk_conversions[pac_cm_dc, 10] = '-1'
                hk_conversions[pac_cm_dc, 11] = parts[21]
                hk_conversions[pac_cm_dc, 12] = parts[22]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'PAC_VM.'+inst_id1
find2 = 'PAC_VM.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 36) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[pac_vm, 0] = 'formula1'
                hk_conversions[pac_vm, 1] = parts[4]
                hk_conversions[pac_vm, 2] = strmid(parts[3], 3, strlen(parts[3])-3)
                hk_conversions[pac_vm, 3] = parts[6]
                hk_conversions[pac_vm, 4] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[pac_vm, 5] = '*'
                hk_conversions[pac_vm, 6] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 36) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[pac_vm, 0] = 'formula1'
                hk_conversions[pac_vm, 1] = parts[4]
                hk_conversions[pac_vm, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[pac_vm, 3] = parts[6]
                hk_conversions[pac_vm, 4] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[pac_vm, 5] = '*'
                hk_conversions[pac_vm, 6] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'RA_E0.'+inst_id1
find2 = 'RA_E0.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 37) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[ra_e0, 0] = 'formula1'
            hk_conversions[ra_e0, 1] = parts[4]
            hk_conversions[ra_e0, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
            hk_conversions[ra_e0, 3] = parts[6]
            hk_conversions[ra_e0, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'RA_E1.'+inst_id1
find2 = 'RA_E1.'+inst_id2
WHILE (eof(conv_lun) EQ 0) AND (num_found LT 38) DO BEGIN 
    readf, conv_lun, line
    IF strlen(line) GT 10 THEN BEGIN 
        prefix = strmid(line, 0, strlen(find1))
        IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
            parts = strsplit(line, /extract)
            hk_conversions[ra_e1, 0] = 'formula1'
            hk_conversions[ra_e1, 1] = parts[4]
            hk_conversions[ra_e1, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
            hk_conversions[ra_e1, 3] = parts[6]
            hk_conversions[ra_e1, 4] = parts[7]
            num_found = num_found + 1
        ENDIF 
    ENDIF 
ENDWHILE
find1 = 'SB0_TSP.'+inst_id1
find2 = 'SB0_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 39) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[sb0_tsp, 0] = 'formula1'
                hk_conversions[sb0_tsp, 1] = parts[4]
                hk_conversions[sb0_tsp, 2] = parts[5]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE   
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 39) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[sb0_tsp, 0] = 'formula1'
                hk_conversions[sb0_tsp, 1] = parts[4]
                hk_conversions[sb0_tsp, 2] = parts[5]
                hk_conversions[sb0_tsp, 3] = parts[6]
                hk_conversions[sb0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'SB1_TSP.'+inst_id1
find2 = 'SB1_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 40) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[sb1_tsp, 0] = 'formula1'
                hk_conversions[sb1_tsp, 1] = parts[4]
                hk_conversions[sb1_tsp, 2] = parts[5]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 40) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[sb1_tsp, 0] = 'formula1'
                hk_conversions[sb1_tsp, 1] = parts[4]
                hk_conversions[sb1_tsp, 2] = parts[5]
                hk_conversions[sb1_tsp, 3] = parts[6]
                hk_conversions[sb1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'SSD_BIAS_VM.'+inst_id1
find2 = 'SSD_BIAS_VM.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 41) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_bias_vm, 0] = 'formula1'
                hk_conversions[ssd_bias_vm, 1] = 'px'
                hk_conversions[ssd_bias_vm, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[ssd_bias_vm, 3] = parts[10]
                hk_conversions[ssd_bias_vm, 4] = strmid(parts[9], 1, strlen(parts[9])-1)
                hk_conversions[ssd_bias_vm, 5] = parts[12]
                hk_conversions[ssd_bias_vm, 6] = parts[13]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 41) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_bias_vm, 0] = 'formula1'
                hk_conversions[ssd_bias_vm, 1] = parts[4]
                hk_conversions[ssd_bias_vm, 2] = parts[5]
                hk_conversions[ssd_bias_vm, 3] = parts[6]
                hk_conversions[ssd_bias_vm, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'SSD_CM_DC.'+inst_id1
find2 = 'SSD_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 42) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_cm_dc, 0] = 'formula1'
                hk_conversions[ssd_cm_dc, 1] = parts[4]
                hk_conversions[ssd_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_cm_dc, 3] = parts[6]
                hk_conversions[ssd_cm_dc, 4] = parts[7]
                hk_conversions[ssd_cm_dc, 5] = parts[12]
                hk_conversions[ssd_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[ssd_cm_dc, 7] = parts[14]
                hk_conversions[ssd_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE     
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 42) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_cm_dc, 0] = 'formula1'
                hk_conversions[ssd_cm_dc, 1] = parts[4]
                hk_conversions[ssd_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_cm_dc, 3] = parts[6]
                hk_conversions[ssd_cm_dc, 4] = parts[7]
                hk_conversions[ssd_cm_dc, 5] = parts[12]
                hk_conversions[ssd_cm_dc, 6] = parts[11]
                hk_conversions[ssd_cm_dc, 7] = parts[14]
                hk_conversions[ssd_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'SSD_HV_BIAS.'+inst_id1
find2 = 'SSD_HV_BIAS.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 43) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_hv_bias, 0] = 'formula1'
                hk_conversions[ssd_hv_bias, 1] = parts[6]
                hk_conversions[ssd_hv_bias, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_hv_bias, 3] = parts[4] 
                hk_conversions[ssd_hv_bias, 4] = parts[3]
                hk_conversions[ssd_hv_bias, 5] = parts[8]
                hk_conversions[ssd_hv_bias, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE     
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 43) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_hv_bias, 0] = 'formula1'
                hk_conversions[ssd_hv_bias, 1] = parts[4]
                hk_conversions[ssd_hv_bias, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_hv_bias, 3] = parts[6] 
                hk_conversions[ssd_hv_bias, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE 
ENDELSE
find1 = 'SSD_TC0.'+inst_id1
find2 = 'SSD_TC0.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 44) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_tc0, 0] = 'formula1'
                hk_conversions[ssd_tc0, 1] = parts[6]
                hk_conversions[ssd_tc0, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_tc0, 3] = parts[4]
                hk_conversions[ssd_tc0, 4] = parts[3]
                hk_conversions[ssd_tc0, 5] = parts[8]
                hk_conversions[ssd_tc0, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE    
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 44) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_tc0, 0] = 'formula1'
                hk_conversions[ssd_tc0, 1] = parts[4]
                hk_conversions[ssd_tc0, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_tc0, 3] = parts[6]
                hk_conversions[ssd_tc0, 4] = parts[7]
                hk_conversions[ssd_tc0, 5] = parts[8]
                hk_conversions[ssd_tc0, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'SSD_TC1.'+inst_id1
find2 = 'SSD_TC1.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 45) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_tc1, 0] = 'formula1'
                hk_conversions[ssd_tc1, 1] = parts[6]
                hk_conversions[ssd_tc1, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_tc1, 3] = parts[4]
                hk_conversions[ssd_tc1, 4] = parts[3]
                hk_conversions[ssd_tc1, 5] = parts[8]
                hk_conversions[ssd_tc1, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 45) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_tc1, 0] = 'formula1'
                hk_conversions[ssd_tc1, 1] = parts[4]
                hk_conversions[ssd_tc1, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_tc1, 3] = parts[6]
                hk_conversions[ssd_tc1, 4] = parts[7]
                hk_conversions[ssd_tc1, 5] = parts[8]
                hk_conversions[ssd_tc1, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'SSD_TC2.'+inst_id1
find2 = 'SSD_TC2.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 46) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_tc2, 0] = 'formula1'
                hk_conversions[ssd_tc2, 1] = parts[6]
                hk_conversions[ssd_tc2, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_tc2, 3] = parts[4]
                hk_conversions[ssd_tc2, 4] = parts[3]
                hk_conversions[ssd_tc2, 5] = parts[8]
                hk_conversions[ssd_tc2, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE    
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 46) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_tc2, 0] = 'formula1'
                hk_conversions[ssd_tc2, 1] = parts[4]
                hk_conversions[ssd_tc2, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_tc2, 3] = parts[6]
                hk_conversions[ssd_tc2, 4] = parts[7]
                hk_conversions[ssd_tc2, 5] = parts[8]
                hk_conversions[ssd_tc2, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'SSD_V_NEG_ANALOG.'+inst_id1
find2 = 'SSD_V_NEG_ANALOG.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 47) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_v_neg_analog, 0] = 'formula1'
                hk_conversions[ssd_v_neg_analog, 1] = parts[8]
                hk_conversions[ssd_v_neg_analog, 2] = strmid(parts[9], 0, strlen(parts[9])-1)
                hk_conversions[ssd_v_neg_analog, 3] = parts[4]
                hk_conversions[ssd_v_neg_analog, 4] = strmid(parts[5], 1, strlen(parts[5])-1)
                hk_conversions[ssd_v_neg_analog, 5] = parts[10]
                hk_conversions[ssd_v_neg_analog, 6] = strmid(parts[11], 0, strlen(parts[11])-1)
                hk_conversions[ssd_v_neg_analog, 7] = '*'
                hk_conversions[ssd_v_neg_analog, 8] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 47) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_v_neg_analog, 0] = 'formula1'
                hk_conversions[ssd_v_neg_analog, 1] = parts[6]
                hk_conversions[ssd_v_neg_analog, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_v_neg_analog, 3] = parts[8]
                hk_conversions[ssd_v_neg_analog, 4] = parts[9]
                hk_conversions[ssd_v_neg_analog, 5] = parts[10]
                hk_conversions[ssd_v_neg_analog, 6] = strmid(parts[11], 0, strlen(parts[11])-1)
                hk_conversions[ssd_v_neg_analog, 7] = '*'
                hk_conversions[ssd_v_neg_analog, 8] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'SSD_V_POS_ANALOG.'+inst_id1
find2 = 'SSD_V_POS_ANALOG.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 48) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_v_pos_analog, 0] = 'formula1'
                hk_conversions[ssd_v_pos_analog, 1] = parts[6]
                hk_conversions[ssd_v_pos_analog, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_v_pos_analog, 3] = parts[4]
                hk_conversions[ssd_v_pos_analog, 4] = parts[3]
                hk_conversions[ssd_v_pos_analog, 5] = parts[8]
                hk_conversions[ssd_v_pos_analog, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 48) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_v_pos_analog, 0] = 'formula1'
                hk_conversions[ssd_v_pos_analog, 1] = parts[4]
                hk_conversions[ssd_v_pos_analog, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_v_pos_analog, 3] = parts[6]
                hk_conversions[ssd_v_pos_analog, 4] = parts[7]
                hk_conversions[ssd_v_pos_analog, 5] = parts[8]
                hk_conversions[ssd_v_pos_analog, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'SSD_V_POS_DIG.'+inst_id1
find2 = 'SSD_V_POS_DIG.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 49) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_v_pos_dig, 0] = 'formula1'
                hk_conversions[ssd_v_pos_dig, 1] = parts[6]
                hk_conversions[ssd_v_pos_dig, 2] = strmid(parts[7], 0, strlen(parts[7])-1)
                hk_conversions[ssd_v_pos_dig, 3] = parts[4]
                hk_conversions[ssd_v_pos_dig, 4] = parts[3]
                hk_conversions[ssd_v_pos_dig, 5] = parts[8]
                hk_conversions[ssd_v_pos_dig, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE   
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 49) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[ssd_v_pos_dig, 0] = 'formula1'
                hk_conversions[ssd_v_pos_dig, 1] = parts[4]
                hk_conversions[ssd_v_pos_dig, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[ssd_v_pos_dig, 3] = parts[6]
                hk_conversions[ssd_v_pos_dig, 4] = parts[7]
                hk_conversions[ssd_v_pos_dig, 5] = parts[8]
                hk_conversions[ssd_v_pos_dig, 6] = parts[9]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'S_CH_CM_DC.'+inst_id1
find2 = 'S_CH_CM_DC.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 50) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_ch_cm_dc, 0] = 'formula1'
                hk_conversions[s_ch_cm_dc, 1] = parts[4]
                hk_conversions[s_ch_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[s_ch_cm_dc, 3] = parts[6]
                hk_conversions[s_ch_cm_dc, 4] = parts[7]
                hk_conversions[s_ch_cm_dc, 5] = parts[12]
                hk_conversions[s_ch_cm_dc, 6] = strmid(parts[11], 1, strlen(parts[11])-1)
                hk_conversions[s_ch_cm_dc, 7] = parts[14]
                hk_conversions[s_ch_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 50) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_ch_cm_dc, 0] = 'formula1'
                hk_conversions[s_ch_cm_dc, 1] = parts[4]
                hk_conversions[s_ch_cm_dc, 2] = strmid(parts[5], 0, strlen(parts[5])-1)
                hk_conversions[s_ch_cm_dc, 3] = parts[6]
                hk_conversions[s_ch_cm_dc, 4] = parts[7]
                hk_conversions[s_ch_cm_dc, 5] = parts[12]
                hk_conversions[s_ch_cm_dc, 6] = parts[11]
                hk_conversions[s_ch_cm_dc, 7] = parts[14]
                hk_conversions[s_ch_cm_dc, 8] = parts[15]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'S_CH_VM.'+inst_id1
find2 = 'S_CH_VM.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 51) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_ch_vm, 0] = 'formula1'
                hk_conversions[s_ch_vm, 1] = parts[4]
                hk_conversions[s_ch_vm, 2] = strmid(parts[3], 3, strlen(parts[3])-3)
                hk_conversions[s_ch_vm, 3] = parts[6]
                hk_conversions[s_ch_vm, 4] = parts[7]
                hk_conversions[s_ch_vm, 5] = '*'
                hk_conversions[s_ch_vm, 6] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 51) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_ch_vm, 0] = 'formula1'
                hk_conversions[s_ch_vm, 1] = parts[4]
                hk_conversions[s_ch_vm, 2] = parts[5]
                hk_conversions[s_ch_vm, 3] = parts[6]
                hk_conversions[s_ch_vm, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'S_CH_VM_TAP.'+inst_id1
find2 = 'S_CH_VM_TAP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 52) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_ch_vm_tap, 0] = 'formula1'
                hk_conversions[s_ch_vm_tap, 1] = parts[4]
                hk_conversions[s_ch_vm_tap, 2] = strmid(parts[3], 3, strlen(parts[3])-3)
                hk_conversions[s_ch_vm_tap, 3] = parts[6]
                hk_conversions[s_ch_vm_tap, 4] = parts[7]
                hk_conversions[s_ch_vm_tap, 5] = '*'
                hk_conversions[s_ch_vm_tap, 6] = '-1'
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 52) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_ch_vm_tap, 0] = 'formula1'
                hk_conversions[s_ch_vm_tap, 1] = parts[4]
                hk_conversions[s_ch_vm_tap, 2] = parts[5]
                hk_conversions[s_ch_vm_tap, 3] = parts[6]
                hk_conversions[s_ch_vm_tap, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'S_C_0_TSP.'+inst_id1
find2 = 'S_C_0_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 53) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_c_0_tsp, 0] = 'formula1'
                hk_conversions[s_c_0_tsp, 1] = parts[4]
                hk_conversions[s_c_0_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[s_c_0_tsp, 3] = parts[6]
                hk_conversions[s_c_0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 53) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_c_0_tsp, 0] = 'formula1'
                hk_conversions[s_c_0_tsp, 1] = parts[4]
                hk_conversions[s_c_0_tsp, 2] = parts[5]
                hk_conversions[s_c_0_tsp, 3] = parts[6]
                hk_conversions[s_c_0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'S_C_1_TSP.'+inst_id1
find2 = 'S_C_1_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 54) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_c_1_tsp, 0] = 'formula1'
                hk_conversions[s_c_1_tsp, 1] = parts[4]
                hk_conversions[s_c_1_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[s_c_1_tsp, 3] = parts[6]
                hk_conversions[s_c_1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 54) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[s_c_1_tsp, 0] = 'formula1'
                hk_conversions[s_c_1_tsp, 1] = parts[4]
                hk_conversions[s_c_1_tsp, 2] = parts[5]
                hk_conversions[s_c_1_tsp, 3] = parts[6]
                hk_conversions[s_c_1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'TAC0_TSP.'+inst_id1
find2 = 'TAC0_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 55) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tac0_tsp, 0] = 'formula1'
                hk_conversions[tac0_tsp, 1] = parts[4]
                hk_conversions[tac0_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[tac0_tsp, 3] = parts[6]
                hk_conversions[tac0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 55) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tac0_tsp, 0] = 'formula1'
                hk_conversions[tac0_tsp, 1] = parts[4]
                hk_conversions[tac0_tsp, 2] = parts[5]
                hk_conversions[tac0_tsp, 3] = parts[6]
                hk_conversions[tac0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'TAC2_TSP.'+inst_id1
find2 = 'TAC2_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 56) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tac2_tsp, 0] = 'formula1'
                hk_conversions[tac2_tsp, 1] = parts[4]
                hk_conversions[tac2_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[tac2_tsp, 3] = parts[6]
                hk_conversions[tac2_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 56) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tac2_tsp, 0] = 'formula1'
                hk_conversions[tac2_tsp, 1] = parts[4]
                hk_conversions[tac2_tsp, 2] = parts[5]
                hk_conversions[tac2_tsp, 3] = parts[6]
                hk_conversions[tac2_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'TOF_HV0_TSP.'+inst_id1
find2 = 'TOF_HV0_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 57) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tof_hv0_tsp, 0] = 'formula1'
                hk_conversions[tof_hv0_tsp, 1] = parts[4]
                hk_conversions[tof_hv0_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[tof_hv0_tsp, 3] = parts[6]
                hk_conversions[tof_hv0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 57) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tof_hv0_tsp, 0] = 'formula1'
                hk_conversions[tof_hv0_tsp, 1] = parts[4]
                hk_conversions[tof_hv0_tsp, 2] = parts[5]
                hk_conversions[tof_hv0_tsp, 3] = parts[6]
                hk_conversions[tof_hv0_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
find1 = 'TOF_HV1_TSP.'+inst_id1
find2 = 'TOF_HV1_TSP.'+inst_id2
IF (inst_id1 EQ 'A') OR (inst_id1 EQ 'B') OR (inst_id2 EQ '1') OR (inst_id2 EQ '2') THEN BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 58) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tof_hv1_tsp, 0] = 'formula1'
                hk_conversions[tof_hv1_tsp, 1] = parts[4]
                hk_conversions[tof_hv1_tsp, 2] = strmid(parts[3], 1, strlen(parts[3])-1)
                hk_conversions[tof_hv1_tsp, 3] = parts[6]
                hk_conversions[tof_hv1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDIF ELSE BEGIN
    WHILE (eof(conv_lun) EQ 0) AND (num_found LT 58) DO BEGIN 
        readf, conv_lun, line
        IF strlen(line) GT 10 THEN BEGIN 
            prefix = strmid(line, 0, strlen(find1))
            IF (prefix EQ find1) OR (prefix EQ find2) THEN BEGIN 
                parts = strsplit(line, /extract)
                hk_conversions[tof_hv1_tsp, 0] = 'formula1'
                hk_conversions[tof_hv1_tsp, 1] = parts[4]
                hk_conversions[tof_hv1_tsp, 2] = parts[5]
                hk_conversions[tof_hv1_tsp, 3] = parts[6]
                hk_conversions[tof_hv1_tsp, 4] = parts[7]
                num_found = num_found + 1
            ENDIF 
        ENDIF 
    ENDWHILE
ENDELSE
IF num_found NE 58 THEN BEGIN 
    print, 'ERROR: read_apid200_conv: not all found'
ENDIF 
close, conv_lun
free_lun, conv_lun
END 
