; 09/17/2014 Created from read_325.pro
; 03/10/2020 Check that data in right day

PRO remove_bad_370, bad_data
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_moments
mom_epoch_370 [mom_370_i] = 0
mom_schan_370 [mom_370_i] = 0
mom_source_370[mom_370_i] = 0
mom_cycle_370 [mom_370_i] = 0
mom_370 [*, *, mom_370_i] = 0
bad_data = 1
END 

PRO read_370, packet, sat, time_st
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_moments

; 370 moments are off by 90 seconds!!!! (hk off by 30 sec.)
pkt_epoch = pkt_epoch - (90000) 
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr,  temporary, bytarr
bytarr    = [bytarr, packet.dat]
sum       = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, error_lun, timestamp, ' Apid370: Error with checksum.'
ENDIF ELSE BEGIN 
    seq  = fix(packet.dat[12-11+1])
    stat = fix(packet.dat[13-11-1])
    temp = ishft(stat, -1)
    IF temp AND 1B EQ 1 THEN BEGIN
       print, error_lun, timestamp, 'Apid370: error set.'
    endif else IF time_string(pkt_epoch, /epoch) lt time_st then begin
                                ; previous day
       dummy = dummy
    ENDIF ELSE BEGIN 
       mom_schan_370 [mom_370_i] = fix(packet.dat[16-11+1])
        mom_source_370[mom_370_i] = fix(packet.dat[17-11-1])
        mom_cycle_370 [mom_370_i] = fix(packet.dat[79-11-1])-1
        mom_epoch_370 [mom_370_i] = pkt_epoch
;IF timestamp GE '2014-08-05T16:00:00.000' AND timestamp LE '2014-08-05T16:10:00.000' THEN stop

                                ; get moments data
        FOR i = 0, 1 DO BEGIN   ; main and s channel (i*2)
            FOR j = 0, 12 DO BEGIN ; 13 moments
                index                    = 22-11+(i*26)+(j*2)
                lsb                      = long(packet.dat[index+1])
                msb                      = long(packet.dat[index+1-1])
                comp_value               = (ishft(msb, 8)) OR lsb
                uncompress_moment, comp_value, uncomp_value
                unscale_value            = uncomp_value * unscale
                mom_370[j, i, mom_370_i] = unscale_value
            ENDFOR 
        ENDFOR 
        bad_data = 0
        IF array_equal(mom_370[*, *, mom_370_i], 0) EQ 1 THEN BEGIN
            remove_bad_370, bad_data
        ENDIF 
        IF mom_370_i GT 0 THEN BEGIN
            IF array_equal(mom_370[*, *, mom_370_i], mom_370[*, *, mom_370_i-1]) EQ 1 THEN BEGIN 
                remove_bad_370, bad_data
            ENDIF 
        ENDIF 
        IF bad_data EQ 0 THEN mom_370_i = mom_370_i + 1
    ENDELSE 
ENDELSE 

END 
