; 03/20/2007 Added cycle
PRO read_329, packet, clcdf_id
compile_opt strictarrsubs
COMMON share1

                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, error_lun, 'Error with checksum, apid 329, time:', timestamp
ENDIF ELSE BEGIN 
    index = -11
    epoch = anytim2cdf(timestamp)
    cycle = fix(packet.dat[index+12+1])
    block = fix(packet.dat[index+13-1])
    esa = long(packet.dat[index+14+1])
    data = lonarr(128)
    FOR j = 0, 127 DO BEGIN     ; 128 bytes of compressed data
        temp_index = index+15+(j*2)
        value = ishft(long(packet.dat[temp_index-1]), 8) OR long(packet.dat[temp_index+1])
        data[j] = value
    ENDFOR
    cdf_varput, clcdf_id, 'epoch_classifier', epoch, rec_start = num_classifier_cycles
    cdf_varput, clcdf_id, 'cycle', cycle, rec_start = num_classifier_cycles
    cdf_varput, clcdf_id, 'block_id_classifier', (block+i), rec_start = num_classifier_cycles
    cdf_varput, clcdf_id, 'esa_step', esa, rec_start = num_classifier_cycles
    cdf_varput, clcdf_id, 'classifier_data', data, rec_start = num_classifier_cycles
    num_classifier_cycles = num_classifier_cycles + 1
ENDELSE 
END 
