; 03/20/2007 Added cycle

PRO read_328, packet, clcdf_id
compile_opt strictarrsubs
COMMON share1

                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, error_lun, 'Error with checksum, apid 328, time:', timestamp
ENDIF ELSE BEGIN 
    index = -11
    epoch = anytim2cdf(timestamp)
    cycle = fix(packet.dat[index+12+1])
    block = fix(packet.dat[index+13-1])
    esa = long(packet.dat[index+14+1])
    data = lonarr(128)
    FOR i = 0, 1 DO BEGIN ; two blocks per packet
        FOR j = 0, 127 DO BEGIN ; 128 bytes of compressed data
            temp_index = index+15+(i*128)+j
            IF temp_index MOD 2 EQ 0 THEN temp_index = temp_index-1 ELSE temp_index = temp_index+1
            uncompress8, packet.dat[temp_index], value
            data[j] = value
        ENDFOR
        cdf_varput, clcdf_id, 'epoch_classifier', epoch, rec_start = num_classifier_cycles
        cdf_varput, clcdf_id, 'cycle', cycle, rec_start = num_classifier_cycles
        cdf_varput, clcdf_id, 'block_id_classifier', (block+i), rec_start = num_classifier_cycles
        cdf_varput, clcdf_id, 'esa_step', esa, rec_start = num_classifier_cycles
        cdf_varput, clcdf_id, 'classifier_data', data, rec_start = num_classifier_cycles
        num_classifier_cycles = num_classifier_cycles + 1
    ENDFOR 
ENDELSE 
END 
