; 09/20/2007 Changed format of error message
; 09/18/2012 Added spacecraft.

PRO read_327, packet, sat
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_alph_prot
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 327'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    ;temp_t = '2006-11-14T17:08:00.000'
    ;temp_t2 = '2006-11-14T17:10:00.000'
    ;IF timestamp GT temp_t AND timestamp LT temp_t2 THEN stop
                                ; check seq
    IF (seq EQ 0 AND last_seq_327 NE 2 AND last_seq_327 NE -1) OR $
      (seq NE 0 AND last_seq_327 NE -1 AND last_seq_327 NE seq-1) THEN BEGIN 
        timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
        printf, error_lun, timestamp, ' Missing 327 packet', last_seq_327, seq
        check_seq1, back_cycles
        IF seq NE 0 THEN cycle_327_new = -1
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(heplusplus_tcr, -1) NE 1 THEN BEGIN 
                IF wrote_327[num_cycles1-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_327: processing error'
                    suspect_327[num_cycles1-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_327[num_cycles1-back_cycles] = 1
                    write_327, 0, back_cycles
                ENDELSE 
            ENDIF 
        ENDIF 
    ENDIF
    last_epoch_327 = pkt_epoch
    last_seq_327 = seq

    IF seq EQ 0 THEN BEGIN 
        error = fix(packet.dat[1+1])
        cycle_327_new = fix(packet.dat[2-1])
        IF error EQ 1 THEN printf, error_lun, timestamp, ' Error byte set in apid 327.'
        error_327 = error
        IF timestamp LT '2012-08-17T00:00:00.000' THEN BEGIN 
            IF timestamp EQ '2012-08-16T14:39:19.336' AND sat EQ 'B' THEN write_cycle1, cycle_327_new, -1, pkt_epoch
        ENDIF 
    ENDIF ELSE BEGIN 
        IF seq EQ 1 THEN BEGIN 
            schan_327 = fix(packet.dat[2-1])
            IF schan_327 EQ 255 THEN schan_327 = 0
            IF timestamp LT '2018-10-09T00:00:00.000' THEN BEGIN 
                IF (timestamp EQ '2013-01-13T22:24:40.582' AND sat EQ 'A') OR $
                  (timestamp EQ '2013-01-13T23:07:40.582' AND sat EQ 'A') OR $
                  (timestamp EQ '2013-01-19T10:12:29.973' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-03-04T10:16:30.988' AND sat EQ 'B') OR $ 
                  (timestamp EQ '2013-03-06T18:51:31.070' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-08-12T19:38:08.348' AND sat EQ 'B') OR $
                  (timestamp EQ '2014-05-31T19:41:03.461' AND sat EQ 'B') OR $
                  (timestamp EQ '2014-06-20T00:29:41.184' AND sat EQ 'A') OR $
                  (timestamp EQ '2014-07-08T19:43:12.031' AND sat EQ 'B') OR $
                  (timestamp EQ '2014-07-08T20:22:12.039' AND sat EQ 'B') OR $
                  (timestamp EQ '2016-05-09T01:54:12.293' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-05-29T17:07:10.258' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-09-20T13:30:02.113' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-09-20T13:45:02.113' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:30:52.969' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:31:52.969' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:50:52.965' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:56:52.965' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:58:52.965' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-01-14T08:02:35.934' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-04-28T12:21:30.598' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-10-08T19:05:09.719' AND sat EQ 'A') $
                  THEN write_cycle1, cycle_327_new, schan_327, last_epoch_327 
            ENDIF 
            IF (num_cycles1 EQ 0) THEN write_cycle1, cycle_327_new, schan_327, last_epoch_327 $
            ELSE IF (cycles1[num_cycles1-1] EQ cycle_327) THEN write_cycle1, cycle_327_new, schan_327, last_epoch_327 $
                 ELSE check_cycle1, cycle_327_new, schan_327
            IF error_327 EQ 1 THEN set_error, cycle_327_new
            cycle_327 = cycle_327_new
            alpha_peak_327[1] = fix(packet.dat[3+1]) ; pp
        ENDIF ELSE BEGIN                 
            IF seq EQ 2 THEN BEGIN 
                alpha_peak_327[2] = fix(packet.dat[1+1]) ; dp
                alpha_peak_327[0] = fix(packet.dat[2-1]) ; ep
                alpha_peak_327[3] = fix(packet.dat[3+1]) ; array
            ENDIF 
        ENDELSE 
    ENDELSE 

    ; get data
    first_esa = seq*4
    IF seq EQ 2 THEN num_rows = 2 ELSE num_rows = 4
    FOR i = 0, num_rows-1 DO BEGIN ; 4 esa steps per packet
        FOR j = 0, 7 DO BEGIN   ; 8 pos 
            FOR k = 0, 7 DO BEGIN ; 8 defl
                index = (i*64)+(j*8)+k+4
                IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value $
                ELSE uncompress8, packet.dat[index+1], value 
                heplusplus_tcr[(first_esa+i), j, k] = value
            ENDFOR 
        ENDFOR
    ENDFOR 

    ; end of cycle
    ;IF timestamp GT temp_t AND timestamp LT temp_t2 THEN stop
    IF seq EQ 2 THEN BEGIN 
        write_327, 0, 1
        alpha_peak_327[*] = -1
        heplusplus_tcr[*, *, *] = -1
    ENDIF 

ENDELSE 
END 
