; Jan. 31, 2007 added unscale factor to moments
; 09/20/2007 Changed format of error message
; 02/16/2011 Set to fill when invalid buffer state.
; 06/01/2011 Add sat argument
; 10/22/2014 Added check for when moments are all zero.

PRO read_325, packet, sat
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_alph_prot
COMMON com_moments
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
    printf, error_lun, 'Error with checksum, apid 325, time:', timestamp
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    ;IF timestamp GE '2014-07-08T19:49:00.000' THEN stop
                                ; check seq
    IF (seq EQ 0 AND last_seq_325 NE 2 AND last_seq_325 NE -1) OR $
      (seq NE 0 AND last_seq_325 NE -1 AND last_seq_325 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 325 packet', last_seq_325, seq
        check_seq1, back_cycles
        IF seq NE 0 THEN cycle_325_new = -1
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(hplus_peak, -1) NE 1 THEN BEGIN 
                IF wrote_325[num_cycles1-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_325: processing error'
                    suspect_325[num_cycles1-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_325[num_cycles1-back_cycles] = 1
                    write_325, 0, back_cycles
                ENDELSE 
            ENDIF 
        ENDIF 
    ENDIF
    last_epoch_325 = pkt_epoch
    last_seq_325 = seq

    IF seq EQ 0 THEN BEGIN 
        error = fix(packet.dat[1+1])
        cycle_325_new = fix(packet.dat[2-1])
        IF error EQ 1 THEN printf, error_lun, timestamp, ' Error byte set in apid 325'
        error_325 = error
    ENDIF ELSE BEGIN 
        IF seq EQ 1 THEN BEGIN 
            schan_325 = fix(packet.dat[2-1])
            IF schan_325 EQ 255 THEN schan_325 = 0
            just_wrote = 0
            ;IF timestamp GE '2016-09-20T13:25:02.117' THEN stop
            IF timestamp LT '2019-02-06T00:00:00.000' THEN BEGIN 
                IF (timestamp EQ '2011-04-29T07:02:15.234' AND sat EQ 'B') OR $
                  (timestamp EQ '2012-12-31T00:24:41.680' AND sat EQ 'A') OR $
                  (timestamp EQ '2013-01-14T02:37:40.578' AND sat EQ 'A') OR $
                  (timestamp EQ '2013-01-19T03:54:29.988' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-01-19T09:48:29.973' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-01-19T10:37:29.973' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-03-04T09:06:30.988' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-03-04T10:08:30.988' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-03-06T10:17:36.813' AND sat EQ 'A') OR $
                  (timestamp EQ '2013-08-12T16:40:08.316' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-08-12T16:41:08.316' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-08-12T19:58:08.348' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-08-12T20:21:08.352' AND sat EQ 'B') OR $
                  (timestamp EQ '2013-12-16T05:44:07.270' AND sat EQ 'A') OR $
                  (timestamp EQ '2014-02-28T01:31:56.949' AND sat EQ 'A') OR $
                  (timestamp EQ '2014-05-31T19:40:03.461' AND sat EQ 'B') OR $
                  (timestamp EQ '2014-05-31T19:44:03.465' AND sat EQ 'B') OR $
                  (timestamp EQ '2014-05-31T19:46:03.465' AND sat EQ 'B') OR $
                  (timestamp EQ '2015-12-28T07:19:20.520' AND sat EQ 'A') THEN $
                  write_cycle1, cycle_325, schan_325, last_epoch_325
                IF (timestamp EQ '2014-07-08T19:49:12.031' AND sat EQ 'B') OR $
                  (timestamp EQ '2014-07-08T22:35:12.063' AND sat EQ 'B') OR $
                  (timestamp EQ '2016-02-24T00:35:16.215' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-04-16T07:27:13.020' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-05-08T20:15:12.313' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-05-08T21:13:12.309' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-05-08T22:38:12.305' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-05-08T23:25:12.301' AND sat EQ 'A') OR $ 
                  (timestamp EQ '2016-09-20T12:36:02.117' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-09-20T13:25:02.117' AND sat EQ 'A') OR $
                  (timestamp EQ '2016-09-20T13:31:02.113' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:40:52.969' AND sat EQ 'A') OR $
                  (timestamp EQ '2017-02-14T11:44:52.969' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-01-14T08:00:35.934' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-01-14T10:46:35.922' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-01-14T10:56:35.922' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-01-14T11:00:35.918' AND sat EQ 'A') OR $
                  (timestamp EQ '2018-01-14T11:05:35.918' AND sat EQ 'A') OR $ 
                  (timestamp EQ '2018-05-28T15:14:29.105' AND sat EQ 'A') OR $
                  (timestamp EQ '2019-02-04T23:26:05.832' AND sat EQ 'A') OR $
                  (timestamp EQ '2019-02-05T00:31:05.832' AND sat EQ 'A') THEN BEGIN 
                    write_cycle1, cycle_325_new, schan_325, last_epoch_325
                    just_wrote = 1
                ENDIF 
            ENDIF 
            ;IF timestamp GE '2016-09-20T13:25:02.117' THEN stop
            IF (num_cycles1 EQ 0) THEN write_cycle1, cycle_325_new, schan_325, last_epoch_325 $
            ELSE IF just_wrote EQ 1 THEN dummy = dummy $
            ELSE IF (cycles1[num_cycles1-1] EQ cycle_325) THEN write_cycle1, cycle_325_new, schan_325, last_epoch_325 $
                 ELSE check_cycle1, cycle_325_new, schan_325
            IF error_325 EQ 1 THEN set_error, cycle_325_new
            cycle_325 = cycle_325_new 
            proton_peak_325[1] = fix(packet.dat[3+1]) ; pp
            ;IF timestamp GE '2016-09-20T13:25:02.117' THEN stop
        ENDIF ELSE BEGIN                 
            IF seq EQ 2 THEN BEGIN 
                proton_peak_325[2] = fix(packet.dat[1+1]) ; dp
                proton_peak_325[0] = fix(packet.dat[2-1]) ; ep
                proton_peak_325[3] = fix(packet.dat[3+1]) ; array
            ENDIF 
        ENDELSE 
    ENDELSE 

    ; get data
    first_esa = seq*4
    IF seq EQ 2 THEN num_rows = 2 ELSE num_rows = 4
    FOR i = 0, num_rows-1 DO BEGIN ; 4 esa steps per packet
        FOR j = 0, 7 DO BEGIN   ; 8 pos 
            FOR k = 0, 7 DO BEGIN ; 8 defl
                index = (i*64)+(j*8)+k+4
                IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value $
                ELSE uncompress8, packet.dat[index+1], value 
                hplus_peak[(first_esa+i), j, k] = value
            ENDFOR 
        ENDFOR
    ENDFOR 
                                ; get moments data
    IF seq EQ 2 THEN BEGIN 
        buffer = fix(packet.dat[203-11-1])
        IF buffer NE 3 THEN BEGIN 
            printf, error_lun, timestamp, ' Invalid buffer state for moments ', buffer 
            moments[*, *] = -1
        ENDIF ELSE BEGIN 
            emin = fix(packet.dat[211-11-1])
            emax = fix(packet.dat[212-11+1])
            source = fix(packet.dat[216-11+1])
            lsb = long(packet.dat[217-11-1])
            msb = long(packet.dat[217-11+1+1])
            schan_conv = (ishft(msb, 8)) OR lsb
            moments_meta[0] = emin
            moments_meta[1] = emax
            moments_meta[2] = schan_conv
            moments_meta[3] = source
            FOR i = 0, 1 DO BEGIN ; main and s channel (i*2)
                FOR j = 0, 12 DO BEGIN ; 13 moments
                    index = 219-11+(i*26)+(j*2)
                    lsb = long(packet.dat[index-1])
                    msb = long(packet.dat[index+1+1])
                    comp_value = (ishft(msb, 8)) OR lsb
                    uncompress_moment, comp_value, uncomp_value
                    unscale_value = uncomp_value * unscale
                    moments[j, i] = unscale_value
                ENDFOR 
            ENDFOR 
        ENDELSE 
    ENDIF 
    ;IF timestamp GE '2013-01-19T09:47:29.973' THEN stop

    ; end of cycle
    IF seq EQ 2 THEN BEGIN 
        write_325, 0, 1
        write_moments, 0
        proton_peak_325[*] = -1
        hplus_peak[*, *, *] = -1
    ENDIF 
    ;IF timestamp GE '2016-09-20T13:25:02.117' THEN stop
ENDELSE 
END 
