; 09/26/2007 Changed format of error statement.
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.
; 09/27/2011 Fix bug with back_cycles eq -1.
; 12/20/2012 Fix bug with missing packets.
; 09/09/2014 Check for telem_vers le 1

PRO read_322, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 322'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    IF seq EQ 0 THEN BEGIN 
        cycle_322 = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid322 "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN write_cycle5_heavy, cycle_322, schan_322, pkt_epoch $
            ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_322) THEN write_cycle5_heavy, cycle_322, schan_322, pkt_epoch $
                 ELSE check_cycle5_heavy, cycle_322, schan_322, version
        ENDIF ELSE BEGIN 
            schan_322 = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_322, schan_322, '322', cycle_index, back_day, version
            IF num_cycles5_heavy EQ 0 AND telem_vers GE 1 THEN write_cycle_heavy_v10, cycle_322, schan_322, pkt_epoch
            IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_322, schan_322, pkt_epoch
            ENDIF ELSE IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_wap_ssd_pri', schan_322, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_wap_ssd_pri',  cycle_322, rec_start = cycle_index
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'wap_ssd_pri', temp_schan = schan_322, temp_cycle = cycle_322
        ENDELSE 
    ENDIF ELSE printf, error_lun, timestamp, " Invalid sequence number in apid322 "
                                ;read data
    FOR i = 0, 127 DO BEGIN     ; 128 ESA per packet
        FOR j = 0, 1 DO BEGIN   ; 2 classes per esa step 
            index = 4+(i*2)+j
            IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value $
            ELSE uncompress8, packet.dat[index+1], value
            wap_pri_ssd[i, j] = value
        ENDFOR 
    ENDFOR 
    IF dpu_post_327 EQ 0 THEN BEGIN 
        cdf_varput, cdf_id, 'wap_priority_ssd', wap_pri_ssd, rec_start = num_cycles5_heavy-1
    ENDIF ELSE BEGIN
        find_heavy_start, sat, pkt_epoch, cycle_322, schan_322, '322', cycle_index, back_day, version
        IF back_day EQ 0 THEN cdf_varput, cdf_id, 'wap_priority_ssd', wap_pri_ssd, rec_start = cycle_index ELSE $
          IF back_day EQ -1 THEN printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_322: processing error2' $
          ELSE write_old_heavy_v10, old_epoch, sat, -1, schan_322, cycle_322, cycle_index, 'wap_priority_ssd', wap_pri_ssd
    ENDELSE 
    wap_pri_ssd[*, *] = -1
ENDELSE 
END 
