; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 Changed format of error statement.
; 11/05/2207 Added check for if num_cycles5_heavy eq 0 for seq 31.
; 01/27/2010 Added checks for A on 12/20/2009.
; 02/02/2010 Added checks for B on 12/22/2009.
; 05/06/2010 Added checks for B on 04/05/2010.
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.
; 09/27/2011 Fix bug with back_cycles eq -1.
; 12/20/2012 Fix bug with write_old_heavy.pro
; 10/03/2014 Fix bug when first packet in sidelobe.
; 09/28/2015 Remove -1 from rec_start when writing old data.

PRO read_321, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum    = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 321'
 ENDIF ELSE BEGIN
    seq = fix(packet.dat[0])
                                ; check seq
    IF (seq EQ 0 AND last_seq_321 NE 31 AND last_seq_321 NE -1) OR $
      (seq NE 0 AND last_seq_321 NE -1 AND last_seq_321 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 321 packet.', last_seq_321, seq
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(sw_pri, -1) NE 1 THEN BEGIN 
                IF wrote_321[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_321: processing error'
                    suspect_321[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_321[num_cycles5_heavy-back_cycles] = 1
                    cdf_varput, cdf_id, 'sw_priority', sw_pri, rec_start = num_cycles5_heavy-back_cycles
                    wrote_321[num_cycles5_heavy-back_cycles] = 1
                    sw_pri[*, *, *] = -1
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_321 THEN BEGIN ; missed cycle 0
            IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch ELSE $
              write_cycle_heavy_v10, -1, -1, pkt_epoch 
        ENDIF 
    ENDIF
    IF (timestamp EQ '2010-04-05T03:31:46.984' AND sat EQ 'B' AND seq EQ 09) THEN write_cycle5_heavy, -1, -1, pkt_epoch ; missed cycle 0 
    last_seq_321 = seq
    last_epoch_321 = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_321 = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid321 "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN BEGIN 
                IF version LT 10 THEN write_cycle5_heavy, cycle_321, schan_321, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_321, schan_321, pkt_epoch 
            ENDIF ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_321) THEN BEGIN 
                IF version LT 10 THEN write_cycle5_heavy, cycle_321, schan_321, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_321, schan_321, pkt_epoch 
            ENDIF ELSE check_cycle5_heavy, cycle_321, schan_321, version
        ENDIF ELSE BEGIN 
           schan_321 = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_321, schan_321, '321', cycle_index, back_day
            IF num_cycles5_heavy EQ 0 AND telem_vers GE 1 THEN write_cycle_heavy_v10, cycle_322, schan_322, pkt_epoch
            IF back_day EQ -1 THEN BEGIN
                write_cycle_heavy_v10, cycle_321, schan_321, pkt_epoch
            ENDIF ELSE IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_sw_pri', schan_321, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_sw_pri',  cycle_321, rec_start = cycle_index
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'sw_pri', temp_schan = schan_321, temp_cycle = cycle_321
        ENDELSE 
    ENDIF 
                                ;read data
    FOR i = 0, 3 DO BEGIN       ; 4 ESA per packet
        FOR j = 0, 3 DO BEGIN   ; 4 classes per esa step 
            FOR k = 0, 15 DO BEGIN ; 16 defl
                IF i MOD 2 EQ 0 THEN index = 4+(i*64)+(j*16)+k ELSE index = 4+(i*64)+(j*16)+15-k
                IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value $
                ELSE uncompress8, packet.dat[index+1], value
                sw_pri[(seq*4)+i, k, j] = value
            ENDFOR
        ENDFOR 
    ENDFOR 

    IF (timestamp EQ '2009-12-20T21:59:12.211' AND sat EQ 'A' AND seq EQ 26) OR $
      (timestamp EQ '2009-12-20T22:04:12.211' AND sat EQ 'A' AND seq EQ 07) OR $
      (timestamp EQ '2009-12-22T11:39:57.156' AND sat EQ 'B' AND seq EQ 21) OR $
      (timestamp EQ '2010-04-05T03:11:46.984' AND sat EQ 'B' AND seq EQ 05) $
      THEN BEGIN 
        suspect_321[num_cycles5_heavy-1] = 1
        cdf_varput, cdf_id, 'sw_priority', sw_pri, rec_start = num_cycles5_heavy-1
        wrote_321[num_cycles5_heavy-1] = 1
        sw_pri[*, *, *] = -1
    ENDIF 
    IF seq EQ 31 THEN BEGIN
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF num_cycles5_heavy EQ 0 THEN BEGIN
               temp_rec_start = 0
                write_cycle5_heavy, cycle_321, schan_321, pkt_epoch
            ENDIF ELSE temp_rec_start = num_cycles5_heavy-1
            cdf_varput, cdf_id, 'sw_priority', sw_pri, rec_start = num_cycles5_heavy-1
            wrote_321[num_cycles5_heavy-1] = 1
        ENDIF ELSE BEGIN
            find_heavy_start, sat, pkt_epoch, cycle_321, schan_321, '321', cycle_index, back_day
            ;IF timestamp GE '2013-01-19T03:53:29.988' THEN stop
            IF back_day EQ 0 THEN cdf_varput, cdf_id, 'sw_priority', sw_pri, rec_start = cycle_index ELSE $
              IF back_day EQ -1 THEN printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_321: processing error2' $
              ELSE write_old_heavy_v10, pkt_epoch, sat, -1, cycle_index, 'sw_priority', temp_schan = schan_321, temp_cycle = cycle_321
        ENDELSE 
        sw_pri[*, *, *] = -1
    ENDIF 
ENDELSE 
END 
