; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 Changed format of error statement.
; 09/04/2009 Add check for if num_cycles5_heavy eq 0.
; 01/27/2010 Added checks for A on 12/20/2009.
; 05/24/2011 Add info for dpu_post_327.
; 07/05/2011 Put in check for B for 07/02/2011.
; 07/08/2011 Check when don't yet have epoch.
; 09/27/2011 Fix bug with back_cycles eq -1.
; 10/12/2011 Check which version when writing first cycle.
; 12/20/2012 Fix bug with missing packets.
; 09/28/2015 Remove -1 from rec_start when writing old data.

PRO read_320, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 320'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
                                ; check seq
    IF (seq EQ 0 AND last_seq_320 NE 27 AND last_seq_320 NE -1) OR $
      (seq NE 0 AND last_seq_320 NE -1 AND last_seq_320 NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 320 packet', last_seq_320, seq
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN 
            IF array_equal(wap_nossd_dcr, -1) NE 1 THEN BEGIN 
                IF wrote_320[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_320: processing error'
                    suspect_320[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_320[num_cycles5_heavy-back_cycles] = 1
                    cdf_varput, cdf_id, 'wap_no_ssd_dcr', wap_nossd_dcr, rec_start = num_cycles5_heavy-back_cycles
                    wrote_320[num_cycles5_heavy-back_cycles] = 1
                    wap_nossd_dcr[*, *, *] = -1
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_320 THEN $
          IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch $ ; missed cycle 0
            ELSE write_cycle_heavy_v10, -1, -1, pkt_epoch
    ENDIF
    IF (sat EQ 'B') AND (timestamp EQ '2011-07-02T07:46:38.563') THEN BEGIN
        write_cycle_heavy_v10, -1, -1, pkt_epoch
        cycle_320 = -1
        schan_320 = -1
    ENDIF 
    last_seq_320 = seq
    last_epoch_320 = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_320 = packet.dat[1+1]
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid320 "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN BEGIN
                IF version LT 10 THEN write_cycle5_heavy, cycle_320, schan_320, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_320, schan_320, pkt_epoch 
            ENDIF ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_320) THEN BEGIN
                IF version LT 10 THEN write_cycle5_heavy, cycle_320, schan_320, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_320, schan_320, pkt_epoch 
            ENDIF ELSE check_cycle5_heavy, cycle_320, schan_320, version
        ENDIF ELSE BEGIN 
            schan_320 = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_320, schan_320, '320', cycle_index, back_day
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_wap_nossd_dcr', schan_320, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_wap_nossd_dcr',  cycle_320, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_320, schan_320, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'wap_nossd_dcr', temp_schan = schan_320, temp_cycle = cycle_320
        ENDELSE 
    ENDIF 
    IF num_cycles5_heavy EQ 0 THEN BEGIN 
        IF version LT 10 THEN write_cycle5_heavy, cycle_320, schan_320, pkt_epoch $
          ELSE write_cycle_heavy_v10, cycle_320, schan_320, pkt_epoch 
    ENDIF 
        
                                ; find starting place
    CASE 1 OF 
        (seq MOD 7 EQ 0): BEGIN
            esa = (seq / 7 ) * 32
            class = 0
        END
        (seq MOD 7 EQ 1): BEGIN
            esa = (seq / 7 ) * 32 + 4
            class = 4
        END
        (seq MOD 7 EQ 2): BEGIN
            esa = (seq / 7 ) * 32 + 9
            class = 1
        END
        (seq MOD 7 EQ 3): BEGIN
            esa = (seq / 7 ) * 32 + 13
            class = 5
        END
        (seq MOD 7 EQ 4): BEGIN
            esa = (seq / 7 ) * 32 + 18
            class = 2
        END
        (seq MOD 7 EQ 5): BEGIN
            esa = (seq / 7 ) * 32 + 22
            class = 6
        END
        (seq MOD 7 EQ 6): BEGIN
            esa = (seq / 7 ) * 32 + 27
            class = 3
        END
    ENDCASE 
    pos = 0
                                ;read data
    FOR i = 0, 255 DO BEGIN     ; 256 values per packet
        IF i MOD 2 EQ 0 THEN uncompress8, packet.dat[i+4-1], value ELSE uncompress8, packet.dat[i+4+1], value
        wap_nossd_dcr[esa, pos, class] = value
        pos = pos + 1
        IF pos EQ 8 THEN BEGIN
            pos = 0
            class = class + 1
        ENDIF
        IF class EQ 7 THEN BEGIN
            class = 0
            esa = esa + 1
        ENDIF 
    ENDFOR 

    IF (timestamp EQ '2009-12-20T21:54:12.211' AND sat EQ 'A' AND seq EQ 0) THEN BEGIN 
        cdf_varput, cdf_id, 'wap_no_ssd_dcr', wap_nossd_dcr, rec_start = num_cycles5_heavy-1
        suspect_320[num_cycles5_heavy-1] = 1
        wrote_320[num_cycles5_heavy-1] = 1
        wap_nossd_dcr[*, *, *] = -1
    ENDIF 
    IF seq EQ 27 THEN BEGIN 
        IF dpu_post_327 EQ 0 THEN BEGIN 
            cdf_varput, cdf_id, 'wap_no_ssd_dcr', wap_nossd_dcr, rec_start = num_cycles5_heavy-1
            wrote_320[num_cycles5_heavy-1] = 1
        ENDIF ELSE BEGIN
            IF timestamp LT '2011-07-03T00:00:00.000' THEN BEGIN 
                IF ((sat EQ 'B') AND (timestamp EQ '2011-07-02T07:46:38.563')) THEN dummy = dummy ELSE BEGIN 
                    find_heavy_start, sat, pkt_epoch, cycle_320, schan_320, '320', cycle_index, back_day
                    IF back_day EQ 0 THEN cdf_varput, cdf_id, 'wap_no_ssd_dcr', wap_nossd_dcr, rec_start = cycle_index ELSE $
                      write_old_heavy_v10, old_epoch, sat, -1, schan_320, cycle_320, cycle_index, 'wap_no_ssd_dcr', wap_nossd_dcr
                ENDELSE 
            ENDIF ELSE BEGIN 
                find_heavy_start, sat, pkt_epoch, cycle_320, schan_320, '320', cycle_index, back_day
                IF back_day EQ 0 THEN cdf_varput, cdf_id, 'wap_no_ssd_dcr', wap_nossd_dcr, rec_start = cycle_index ELSE $
                  IF back_day EQ -1 THEN printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_320: processing error2' $
                  ELSE write_old_heavy_v10, old_epoch, sat, -1, schan_320, cycle_320, cycle_index, 'wap_no_ssd_dcr', wap_nossd_dcr
            ENDELSE 
        ENDELSE 
        wap_nossd_dcr[*, *, *] = -1
    ENDIF 
ENDELSE 
END 
