; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 Changed format of error statement.
; 05/06/2010 Don't write if partial cycle at beginning of day.
; 05/24/2011 Add info for dpu_post_327.
; 07/05/2011 Put in check for B for 07/02/2011.
; 07/08/2011 Check when don't yet have epoch.
; 09/27/2011 Fix bug with back_cycles eq -1.
; 12/20/2012 Fix bug with missing packets.
; 09/28/2015 Remove -1 from rec_start when writing old data.

PRO read_31f, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 31F'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    ;temp_t = '2006-11-14T17:09:00.000'
    ;IF timestamp GT temp_t AND timestamp LT temp_t2 THEN stop
    ;IF timestamp GT temp_t THEN stop

                                ; check seq
    IF (seq EQ 0 AND last_seq_31f NE 13 AND last_seq_31f NE -1) OR $
      (seq NE 0 AND last_seq_31f NE -1 AND last_seq_31f NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 31F packet', last_seq_31f, seq
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(wap_ssd_dcr, -1) NE 1 THEN BEGIN 
                IF wrote_31f[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31f: processing error'
                    suspect_31f[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    cdf_varput, cdf_id, 'wap_ssd_dcr', wap_ssd_dcr, rec_start = num_cycles5_heavy-back_cycles
                    wrote_31f[num_cycles5_heavy-back_cycles] = 1
                    wap_ssd_dcr[*, *, *] = -1
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_31f THEN BEGIN ; missed cycle 0
            IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch ELSE $
              write_cycle_heavy_v10, -1, -1, pkt_epoch 
        ENDIF 
    ENDIF
    last_seq_31f = seq
    last_epoch_31f = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_31f = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid31F "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN BEGIN 
                IF version LT 10 THEN write_cycle5_heavy, cycle_31f, schan_31f, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_31f, schan_31f, pkt_epoch 
            ENDIF ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_31f) THEN BEGIN 
                IF version LT 10 THEN write_cycle5_heavy, cycle_31f, schan_31f, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_31f, schan_31f, pkt_epoch 
            ENDIF ELSE check_cycle5_heavy, cycle_31f, schan_31f, version
        ENDIF ELSE BEGIN 
            schan_31f = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_31f, schan_31f, '31f', cycle_index, back_day
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_wap_ssd_dcr', schan_31f, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_wap_ssd_dcr',  cycle_31f, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_31f, schan_31f, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'wap_ssd_dcr', temp_schan = schan_31f, temp_cycle = cycle_31f
        ENDELSE 
    ENDIF 
                                ; find starting place
    esa = seq * 9
    IF seq GT 6 THEN esa = esa + 1
    class = fix(seq)
    IF seq GT 6 THEN class = class - 7
    pos = 0
                                ;read data
    FOR i = 0, 255 DO BEGIN     ; 256 values per packet
        IF i MOD 2 EQ 0 THEN uncompress8, packet.dat[i+4-1], value ELSE uncompress8, packet.dat[i+4+1], value
        wap_ssd_dcr[esa, pos, class] = value
        pos = pos + 1
        IF pos EQ 4 THEN BEGIN
            pos = 0
            class = class + 1
        ENDIF
        IF class EQ 7 THEN BEGIN
            class = 0
            esa = esa + 1
        ENDIF 
    ENDFOR 
    IF seq EQ 13 THEN BEGIN 
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF num_cycles5_heavy GT 0 THEN BEGIN 
                cdf_varput, cdf_id, 'wap_ssd_dcr', wap_ssd_dcr, rec_start = num_cycles5_heavy-1
                wrote_31f[num_cycles5_heavy-1] = 1
            ENDIF 
        ENDIF ELSE BEGIN
            IF timestamp LT '2011-07-03T00:00:00.000' THEN BEGIN 
                IF ((sat EQ 'B') AND (timestamp EQ '2011-07-02T07:16:38.563')) OR $
                  ((sat EQ 'B') AND (timestamp EQ '2011-07-02T21:21:38.563')) THEN dummy = dummy ELSE BEGIN 
                    find_heavy_start, sat, pkt_epoch, cycle_31f, schan_31f, '31f', cycle_index, back_day
                    IF back_day EQ 0 THEN cdf_varput, cdf_id, 'wap_ssd_dcr', wap_ssd_dcr, rec_start = cycle_index ELSE $
                      write_old_heavy_v10, old_epoch, sat, -1, schan_31f, cycle_31f, cycle_index, 'wap_ssd_dcr', wap_ssd_dcr
                ENDELSE 
            ENDIF ELSE BEGIN 
                find_heavy_start, sat, pkt_epoch, cycle_31f, schan_31f, '31f', cycle_index, back_day
                IF back_day EQ 0 THEN cdf_varput, cdf_id, 'wap_ssd_dcr', wap_ssd_dcr, rec_start = cycle_index ELSE $
                  IF back_day EQ -1 THEN printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31f: processing error2' $
                  ELSE write_old_heavy_v10, old_epoch, sat, -1, schan_31f, cycle_31f, cycle_index, 'wap_ssd_dcr', wap_ssd_dcr
            ENDELSE 
        ENDELSE 
        wap_ssd_dcr[*, *, *] = -1
    ENDIF 
ENDELSE 
END 
