; 04/18/2007 LBE added line for missed cycle 0
; 06/04/2007 LBE added line to add cycle if num_cycles5_heavy eq 0
; 09/26/2007 Changed format of error statement.
; 02/02/2010 Added write for 12/22/09 on B.
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.
; 07/19/2011 Check for back_cycles eq 0.
; 09/27/2011 Fix bug with back_cycles eq -1.
; 12/20/2012 Fix bug with missing packets.
; 09/28/2015 Remove -1 from rec_start when writing old data.

PRO read_31e, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 31E'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
                                ; check seq
    IF (seq EQ 0 AND last_seq_31e NE 29 AND last_seq_31e NE -1) OR $
      (seq NE 0 AND last_seq_31e NE -1 AND last_seq_31e NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 31E packet', last_seq_31e, seq
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(wap_ssd_tcr, -1) NE 1 THEN BEGIN 
                IF wrote_31e[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31e: processing error'
                    suspect_31e[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_31e[num_cycles5_heavy-back_cycles] = 1
                    cdf_varput, cdf_id, 'wap_ssd_tcr', wap_ssd_tcr, rec_start = num_cycles5_heavy-back_cycles
                    wrote_31e[num_cycles5_heavy-back_cycles] = 1
                    wap_ssd_tcr[*, *, *] = -1
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_31e AND back_cycles NE 0 THEN BEGIN ; missed cycle 0
            IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch ELSE $
              write_cycle_heavy_v10, -1, -1, pkt_epoch 
        ENDIF 
    ENDIF
    last_seq_31e = seq
    last_epoch_31e = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_31e = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timetamp, " Invalid compression in apid31E "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN BEGIN 
                IF version LT 10 THEN write_cycle5_heavy, cycle_31e, schan_31e, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_31e, schan_31e, pkt_epoch 
            ENDIF ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_31e) THEN BEGIN 
                IF version LT 10 THEN write_cycle5_heavy, cycle_31e, schan_31e, pkt_epoch ELSE $
                  write_cycle_heavy_v10, cycle_31e, schan_31e, pkt_epoch 
            ENDIF ELSE check_cycle5_heavy, cycle_31e, schan_31e, version
        ENDIF ELSE BEGIN 
            schan_31e = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_31e, schan_31e, '31e', cycle_index, back_day
            ;IF timestamp GE '2011-09-14T15:58:09.746' THEN stop
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_wap_ssd_tcr', schan_31e, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_wap_ssd_tcr',  cycle_31e, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_31e, schan_31e, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'wap_ssd_tcr', $
                                   temp_schan = schan_31e, temp_cycle = cycle_31e
            ;IF timestamp EQ '2011-08-26T16:52:34.891' THEN stop
        ENDELSE 
    ENDIF 
                                ; find starting place
    esa = seq * 4
    CASE 1 OF 
        (seq GE 0 AND seq LE 3): class = seq * 4
        (seq GE 4 AND seq LE 7): BEGIN
            esa = esa + 1
            class = (seq MOD 4) * 4 + 1
        END 
        (seq GE 8 AND seq LE 11): BEGIN
            esa = esa + 2
            class = (seq MOD 4) * 4 + 2
        END 
        (seq GE 12 AND seq LE 14): BEGIN
            esa = esa + 3
            class = (seq MOD 4) * 4 + 3
        END 
        (seq GE 15 AND seq LE 18): BEGIN
            esa = esa + 4
            class = ((seq+1) MOD 4) * 4 
        END 
        (seq GE 19 AND seq LE 22): BEGIN
            esa = esa + 5
            class = ((seq+1) MOD 4) * 4 + 1
        END 
        (seq GE 23 AND seq LE 26): BEGIN
            esa = esa + 6
            class = ((seq+1) MOD 4) * 4 + 2
        END 
        (seq GE 27 AND seq LE 29): BEGIN
            esa = esa + 7
            class = ((seq+1) MOD 4) * 4 + 3
        END 
    ENDCASE 
    pos = 0
    
                                ;read data
    FOR i = 0, 255 DO BEGIN     ; 256 values per packet
        IF i MOD 2 EQ 0 THEN uncompress8, packet.dat[i+4-1], value ELSE uncompress8, packet.dat[i+4+1], value
        wap_ssd_tcr[esa, pos, class] = value
        pos = pos + 1
        IF pos EQ 4 THEN BEGIN
            pos = 0
            class = class + 1
        ENDIF
        IF class EQ 15 THEN BEGIN
            class = 0
            esa = esa + 1
        ENDIF 
    ENDFOR 

    IF (timestamp EQ '2009-12-22T03:19:57.207' AND sat EQ 'B' AND seq EQ 18) THEN BEGIN 
        cdf_varput, cdf_id, 'wap_ssd_tcr', wap_ssd_tcr, rec_start = num_cycles5_heavy-1
        wrote_31e  [num_cycles5_heavy-1] = 1
        suspect_31e[num_cycles5_heavy-1] = 1
        wap_ssd_tcr[*, *, *] = -1
    ENDIF 
    IF seq EQ 29 THEN BEGIN 
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF num_cycles5_heavy EQ 0 THEN write_cycle5_heavy, cycle_31e, schan_31e, pkt_epoch
            cdf_varput, cdf_id, 'wap_ssd_tcr', wap_ssd_tcr, rec_start = num_cycles5_heavy-1
            wrote_31e[num_cycles5_heavy-1] = 1
        ENDIF ELSE BEGIN
            ;IF timestamp EQ '2011-10-13T15:55:25.762' THEN stop
            find_heavy_start, sat, pkt_epoch, cycle_31e, schan_31e, '31e', cycle_index, back_day
            IF back_day EQ 0 THEN cdf_varput, cdf_id, 'wap_ssd_tcr', wap_ssd_tcr, rec_start = cycle_index ELSE $
              IF back_day EQ -1 THEN printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31e: processing error2' $
              ELSE write_old_heavy_v10, old_epoch, sat, -1, schan_31e, cycle_31e, cycle_index, 'wap_ssd_tcr', wap_ssd_tcr
        ENDELSE 
        wap_ssd_tcr[*, *, *] = -1
    ENDIF 
ENDELSE 
END 
