; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 LBE Changed format of error messages
; 01/27/2010 Added check for A on 12/20/2009.
; 01/29/2010 Added check for A on 12/21/2009.
; 01/04/2011 Added check for A on 11/22/2010.
; 03/23/2011 Added check for B on 02/19/2011.
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.
; 09/01/2011 Added check for B on 07/30/2011.
; 09/27/2011 Fix bug with back_cycles eq -1.
; 09/28/2015 Remove -1 from rec_start when writing old data.

PRO read_31d, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 31D'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    IF timestamp EQ '2010-11-22T04:08:32.691' AND sat EQ 'A' THEN write_cycle5_heavy, -1, -1, pkt_epoch
    IF timestamp EQ '2011-02-19T03:38:11.324' AND sat EQ 'B' AND seq EQ 1 THEN write_cycle5_heavy, -1, -1, pkt_epoch
    ;IF timestamp GE '2011-11-13T16:53:12.426' THEN stop

                                ; check seq
    IF (seq EQ 0 AND last_seq_31d NE 19 AND last_seq_31d NE -1) OR $
      (seq NE 0 AND last_seq_31d NE -1 AND last_seq_31d NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 31D packet.', last_seq_31d, seq
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(swz_l, -1) NE 1 THEN BEGIN 
                IF wrote_31d[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31d: processing error'
                    suspect_31d[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_31d[num_cycles5_heavy-back_cycles] = 1
                    cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = num_cycles5_heavy-back_cycles
                    wrote_31d[num_cycles5_heavy-back_cycles] = 1
                    swz_l[*, *, *] = -1
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_31d THEN $
          IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch $ ; missed cycle 0
            ELSE write_cycle_heavy_v10, -1, -1, pkt_epoch
    ENDIF
    last_seq_31d = seq
    last_epoch_31d = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_31d = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid31D "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN write_cycle5_heavy, cycle_31d, schan_31d, pkt_epoch $
            ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_31d) THEN write_cycle5_heavy, cycle_31d, schan_31d, pkt_epoch $
                 ELSE check_cycle5_heavy, cycle_31d, schan_31d, version
        ENDIF ELSE BEGIN 
            schan_31d = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_31d, schan_31d, '31d', cycle_index, back_day
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_sw_z>2_l', schan_31d, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_sw_z>2_l',  cycle_31d, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_31d, schan_31d, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'sw_z>2_l', temp_schan = schan_31d, temp_cycle = cycle_31d
        ENDELSE 
    ENDIF 
    ; get data
    esa = seq * 6
    CASE 1 OF 
        (seq GE 3 AND seq LE 4): esa = esa + 1
        (seq GE 5 AND seq LE 7): esa = esa + 2
        (seq GE 8 AND seq LE 9): esa = esa + 3
        (seq GE 10 AND seq LE 12): esa = esa + 4
        (seq GE 13 AND seq LE 14): esa = esa + 5
        (seq GE 15 AND seq LE 17): esa = esa + 6
        (seq GE 18 AND seq LE 19): esa = esa + 7
        ELSE: BREAK
    ENDCASE 
    CASE 1 OF
        (seq MOD 5 EQ 0): class = 0
        (seq MOD 5 EQ 1): class = 2
        (seq MOD 5 EQ 2): class = 4
        (seq MOD 5 EQ 3): class = 1
        (seq MOD 5 EQ 4): class = 3
    ENDCASE
    pos = 0
    ;temp_t = '2006-11-14T16:54:00.000'
    ;temp_t2 = '2006-11-14T17:00:00.000'
    ;IF timestamp GT temp_t AND timestamp LT temp_t2 THEN stop
                            
                                ;read data
    FOR i = 0, 255 DO BEGIN     ; 256 values per packet
        IF i MOD 2 EQ 0 THEN uncompress8, packet.dat[i+4-1], value ELSE uncompress8, packet.dat[i+4+1], value
        swz_l[esa, pos, (class+8)] = value
        pos = pos + 1
        IF pos EQ 8 THEN BEGIN
            pos = 0
            class = class + 1
        ENDIF
        IF class EQ 5 THEN BEGIN
            class = 0
            esa = esa + 1
        ENDIF 
    ENDFOR 

    IF (timestamp EQ '2009-12-20T21:59:12.211' AND sat EQ 'A' AND seq EQ 13) OR $
      (timestamp EQ '2009-12-21T06:04:12.148' AND sat EQ 'A' AND seq EQ 17) $
      THEN BEGIN 
        cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = num_cycles5_heavy-1
        suspect_31d[num_cycles5_heavy-1] = 1
        wrote_31d[num_cycles5_heavy-1] = 1
        swz_l[*, *, *] = -1
    ENDIF 
    ;IF timestamp EQ '2011-09-14T15:48:09.746' THEN print, '31D ', seq, ' ', esa
    IF seq EQ 19 THEN BEGIN 
        IF dpu_post_327 EQ 0 THEN BEGIN 
            cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = num_cycles5_heavy-1
            wrote_31d[num_cycles5_heavy-1] = 1
        ENDIF ELSE BEGIN
            find_heavy_start, sat, pkt_epoch, cycle_31d, schan_31d, '31d', cycle_index, back_day
            ;IF timestamp GE '2011-11-13T16:53:12.426' THEN stop
            IF back_day EQ -1 THEN dummy = dummy ELSE $  ; not found at all
              IF back_day EQ 0 THEN cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = cycle_index ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, schan_31d, cycle_31d, cycle_index, 'sw_z>2_l', swz_l
            ;IF timestamp GE '2011-10-13T21:34:25.711' THEN stop
            IF (timestamp EQ '2011-07-30T02:35:38.305' AND sat EQ 'B' AND seq EQ 19) OR $
              (timestamp EQ '2011-07-30T02:55:38.305' AND sat EQ 'B' AND seq EQ 19) THEN $
              cdf_varput, cdf_id, 'error_sw_z>2_l', 1, rec_start = cycle_index 
        ENDELSE 
        swz_l[*, *, *] = -1
    ENDIF 
    ;IF timestamp GT temp_t THEN stop
ENDELSE 
END 
