; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 Changed format of error statement.
; 08/18/2009 Added write for 07/13/09 on B, added sat.
; 10/14/2009 Added write for 09/13/09 on A.
; 10/19/2009 Added write for 09/16/09 on B.
; 10/20/2009 Added write for 09/18/09 on B.
; 11/09/2009 Added write for 10/09/09 on B.
; 01/28/2010 Added write for 12/23/09 on B.
; 09/01/2010 Added write for 07/28/10 on B.
; 09/07/2010 Added write for 08/06/10 on A.
; 11/09/2010 Added write for 10/08/10 on A.
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.
; 09/01/2011 Added check for B on 07/30/2011
; 09/27/2011 Fix bug with back_cycles eq -1.
; 09/28/2015 Remove -1 from rec_start when writing old data.

PRO read_31c, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 31C'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    ;IF timestamp GE '2011-11-13T16:53:12.426' THEN stop
                                ; check seq
    just_wrote = 0
    IF (seq EQ 0 AND last_seq_31c NE 31 AND last_seq_31c NE -1) OR $
      (seq NE 0 AND last_seq_31c NE -1 AND last_seq_31c NE seq-1) OR $
      (seq EQ 0 AND last_seq_31d NE 19 AND last_seq_31d NE -1) THEN BEGIN 
        printf, error_lun, timestamp, " Missing 31C packet. Last C: ", string(last_seq_31c, format = '(I2.2)'), $
                " Last D: ", string(last_seq_31d, format = '(I2.2)'), " Current: ", $
                string(seq, format = '(I2.2)')
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF wrote_31c[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31c: processing error'
                suspect_31c[num_cycles5_heavy-back_cycles] = 1
            ENDIF ELSE IF array_equal(swz_l, -1) NE 1 THEN BEGIN 
                suspect_31c[num_cycles5_heavy-back_cycles] = 1
                cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = num_cycles5_heavy-back_cycles
                wrote_31c[num_cycles5_heavy-back_cycles] = 1
                swz_l[*, *, *] = -1
                last_seq_31d = 19 ; fake this so don't double-write        
            ENDIF 
        ENDIF 
        IF seq LE last_seq_31c THEN $
          IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch $ ; missed cycle 0
            ELSE write_cycle_heavy_v10, -1, -1, pkt_epoch
    ENDIF 
    last_seq_31c = seq
    last_epoch_31c = pkt_epoch

    ;IF timestamp GT '2011-10-13T21:39:00.000' THEN stop
    IF seq EQ 0 THEN BEGIN 
        cycle_31c = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timetampe, " Invalid compression in apid31C "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF just_wrote EQ 0 THEN BEGIN 
                IF (num_cycles5_heavy EQ 0) THEN write_cycle5_heavy, cycle_31c, schan_31c, pkt_epoch $
                ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_31c) $
                  THEN write_cycle5_heavy, cycle_31c, schan_31c, pkt_epoch $
                     ELSE check_cycle5_heavy, cycle_31c, schan_31c, version
            ENDIF 
        ENDIF ELSE BEGIN 
            schan_31c = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_31c, schan_31c, '31c', cycle_index, back_day
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_sw_z>2_l', schan_31c, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_sw_z>2_l',  cycle_31c, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_31c, schan_31c, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'sw_z>2_l', temp_schan = schan_31c, temp_cycle = cycle_31c
        ENDELSE 
            
    ENDIF 

    ; get data
    first_esa = seq * 4
    FOR i = 0, 3 DO BEGIN       ; 4 ESA per packet
        FOR l = 0, 7 DO BEGIN   ; 8 Classes
            FOR j = 0, 7 DO BEGIN ; 8 Pos
                index = 4+(i*64)+(l*8)+j 
                IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value $
                ELSE uncompress8, packet.dat[index+1], value
                swz_l[(first_esa+i), j, l] = value
            ENDFOR 
        ENDFOR 
    ENDFOR 
    IF (timestamp EQ '2009-12-23T18:11:56.965' AND sat EQ 'B' AND seq EQ 19) OR $
      (timestamp EQ '2011-07-30T01:00:38.316' AND sat EQ 'B' AND seq EQ 21) $
      THEN BEGIN 
        cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = num_cycles5_heavy-1
        wrote_31c  [num_cycles5_heavy-1] = 1
        suspect_31c[num_cycles5_heavy-1] = 1
        swz_l[*, *, *] = -1
    ENDIF 
    IF seq EQ 31 AND $
      ((timestamp EQ '2009-07-13T10:03:49.797' AND sat EQ 'B') OR $
       (timestamp EQ '2009-09-13T12:24:25.121' AND sat EQ 'A') OR $
       (timestamp EQ '2009-09-13T12:24:25.121' AND sat EQ 'A') OR $
       (timestamp EQ '2009-09-16T14:45:27.828' AND sat EQ 'B') OR $
       (timestamp EQ '2009-09-18T00:17:27.418' AND sat EQ 'B') OR $
       (timestamp EQ '2009-10-09T23:32:19.453' AND sat EQ 'B') OR $
       (timestamp EQ '2010-07-28T17:37:37.594' AND sat EQ 'B') OR $
       (timestamp EQ '2010-08-06T15:29:45.094' AND sat EQ 'A') OR $
       (timestamp EQ '2010-10-08T12:46:37.594' AND sat EQ 'A') OR $
       (timestamp EQ '2010-10-08T13:16:37.590' AND sat EQ 'A') OR $
       (timestamp EQ '2011-02-15T03:33:25.488' AND sat EQ 'A')) $
      THEN BEGIN 
        cdf_varput, cdf_id, 'sw_z>2_l', swz_l, rec_start = num_cycles5_heavy-1
        wrote_31c[num_cycles5_heavy-1] = 1
        swz_l[*, *, *] = -1
    ENDIF 
    ;IF timestamp GE '2011-11-13T16:53:12.426' THEN stop
ENDELSE 
END 
