; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 Changed format of error statement.
; 09/05/2008 Added check on num_cycles5_heavy under seq 31.
; 03/18/2010 Added sat argument, added check for B on 02/13/2010
; 07/06/2010 Added check for A on 05/30/2010
; 12/01/2010 Added write_cycle for A for 10/29/2010
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.
; 12/20/2012 Fix bug with missing packets.

PRO read_31b, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 31B'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
    ;IF timestamp GE '2010-10-29T22:53:36.145' THEN stop
    IF timestamp EQ '2010-10-29T22:58:36.145' AND sat EQ 'A' THEN write_cycle5_heavy, -1, -1, pkt_epoch
                                ; check seq
    IF (seq EQ 0 AND last_seq_31b NE 31 AND last_seq_31b NE -1) OR $
      (seq NE 0 AND last_seq_31b NE -1 AND last_seq_31b NE seq-1) THEN BEGIN 
        printf, error_lun, timestamp, ' Missing 31B packet. Last A: ', string(last_seq_31a, format = '(I2.2)'), ' Last B: ', $
                string(last_seq_31b, format = '(I2.2)'), ' Current: ', string(seq, format = '(I2.2)')
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(swz_h, -1) NE 1 THEN BEGIN 
                IF wrote_31b[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31b: processing error'
                    suspect_31b[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_31b[num_cycles5_heavy-back_cycles] = 1
                    cdf_varput, cdf_id, 'sw_z>2_h', swz_h, rec_start = num_cycles5_heavy-back_cycles
                    wrote_31b[num_cycles5_heavy-back_cycles] = 1
                    swz_h[*, *, *, *] = -1
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_31b THEN $
          IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch $ ; missed cycle 0
            ELSE write_cycle_heavy_v10, -1, -1, pkt_epoch
    ENDIF
    last_seq_31b = seq
    last_epoch_31b = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_31b = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid31B "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN write_cycle5_heavy, cycle_31b, schan_31b, pkt_epoch $
             ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_31b) THEN write_cycle5_heavy, cycle_31b, schan_31b, pkt_epoch $
                 ELSE check_cycle5_heavy, cycle_31b, schan_31b, version
        ENDIF ELSE BEGIN 
            schan_31b = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_31b, schan_31b, '31b', cycle_index, back_day
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_sw_z>2_h', schan_31b, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_sw_z>2_h',  cycle_31b, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_31b, schan_31b, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'sw_z>2_h', temp_schan = schan_31b, temp_cycle = cycle_31b
        ENDELSE 
    ENDIF 
    ; get data
    first_esa = seq * 4
    FOR i = 0, 3 DO BEGIN       ; 4 ESA per packet
        FOR j = 0, 7 DO BEGIN   ; 8 Pos
            FOR k = 0, 7 DO BEGIN ; 8 defl
                IF i MOD 2 EQ 0 THEN index = 4+(i*64)+(j*8)+k ELSE index = 4+(i*64)+(j*8)+7-k
                IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value ELSE $
                  uncompress8, packet.dat[index+1], value
                swz_h[(first_esa+i), j, k, 1] = value
            ENDFOR
        ENDFOR 
    ENDFOR 

    IF timestamp EQ '2010-02-13T01:24:49.125' AND sat EQ 'B' OR $
      timestamp EQ '2010-05-30T00:09:52.137' AND sat EQ 'A' $
      THEN suspect_31b[num_cycles5_heavy-1] = 1
    IF seq EQ 31 THEN BEGIN 
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF num_cycles5_heavy GT 0 THEN BEGIN 
                cdf_varput, cdf_id, 'sw_z>2_h', swz_h, rec_start = num_cycles5_heavy-1
                wrote_31b[num_cycles5_heavy-1] = 1
            ENDIF ELSE BEGIN 
                IF num_cycles5_heavy EQ 0 THEN BEGIN 
                    cdf_varput, cdf_id, 'sw_z>2_h', swz_h, rec_start = 0
                    wrote_31b[num_cycles5_heavy] = 1
                ENDIF 
                printf, error_lun, timestamp, 'Check sequencing for 31B.'
            ENDELSE 
        ENDIF ELSE BEGIN
            find_heavy_start, sat, pkt_epoch, cycle_31b, schan_31b, '31b', cycle_index, back_day
            IF back_day EQ 0 THEN cdf_varput, cdf_id, 'sw_z>2_h', swz_h, rec_start = cycle_index ELSE $
              IF back_day EQ -1 THEN printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31b: processing error2' $
              ELSE write_old_heavy_v10, old_epoch, sat, -1, schan_31b, cycle_31b, cycle_index, 'sw_z>2_h', swz_h
        ENDELSE 
        swz_h[*, *, *, *] = -1
    ENDIF 
ENDELSE 
END 
