; 04/18/2007 LBE added line for missed cycle 0
; 09/26/2007 Changed format of error statement.
; 05/24/2011 Add info for dpu_post_327.
; 07/08/2011 Check when don't yet have epoch.

PRO read_31a, packet, sat, version
compile_opt strictarrsubs
COMMON share1
COMMON share2
COMMON com_heavy
                                ; check checksum
temporary = packet.pkt
host_to_ieee, temporary
load_bytarr, temporary, bytarr
bytarr = [bytarr, packet.dat]
sum = total(bytarr)
IF sum MOD 256 NE 0 THEN BEGIN 
    printf, error_lun, timestamp, ' Error with checksum, apid 31A'
ENDIF ELSE BEGIN 
    seq = fix(packet.dat[0])
                                ; check seq
    IF (seq EQ 0 AND last_seq_31a NE 31 AND last_seq_31a NE -1) OR $
      (seq NE 0 AND last_seq_31a NE -1 AND last_seq_31a NE seq-1) OR $
      (seq EQ 0 AND last_seq_31b NE 31 AND last_seq_31b NE -1) THEN BEGIN 
        timestamp = parse_stereo_pkt(packet, /PKT_DATE, /ccsds) ; /ccsds is for anytim2utc
        printf, error_lun, timestamp, ' Missing 31A packet. Last A: ', string(last_seq_31a, format = '(I2.2)'), ' Last B: ', $
                string(last_seq_31b, format = '(I2.2)'), ' Current: ', string(seq, format = '(I2.2)')
                                ; NB: if seq 0 is missing, we didn't
; get the cycle count, and didn't check for a cycle change.
        IF version LT 10 THEN check_seq_heavy, back_cycles ELSE check_seq_heavy_v10, back_cycles
        IF back_cycles NE -1 THEN BEGIN             
            IF array_equal(swz_h, -1) NE 1 THEN BEGIN 
                IF wrote_31a[num_cycles5_heavy-back_cycles] EQ 1 THEN BEGIN
                    printf, error_lun, timestamp, ' ', string(apid, format = '(Z)'), ' read_31a: processing error'
                    suspect_31a[num_cycles5_heavy-back_cycles] = 1
                ENDIF ELSE BEGIN 
                    suspect_31a[num_cycles5_heavy-back_cycles] = 1
                    cdf_varput, cdf_id, 'sw_z>2_h', swz_h, rec_start = num_cycles5_heavy-back_cycles
                    swz_h    [*, *, *, *] = -1
                    wrote_31a[num_cycles5_heavy-back_cycles] = 1
                    last_seq_31b = 31 ; fake this so don't double-write
                ENDELSE 
            ENDIF 
        ENDIF 
        IF seq LE last_seq_31a THEN $
          IF version LT 10 THEN write_cycle5_heavy, -1, -1, pkt_epoch $ ; missed cycle 0
            ELSE write_cycle_heavy_v10, -1, -1, pkt_epoch
    ENDIF 
    last_seq_31a = seq
    last_epoch_31a = pkt_epoch

    IF seq EQ 0 THEN BEGIN 
        cycle_31a = fix(packet.dat[1+1])
        IF fix(packet.dat[2-1]) NE 1 THEN printf, error_lun, timestamp, " Invalid compression in apid31A "
        IF dpu_post_327 EQ 0 THEN BEGIN 
            IF (num_cycles5_heavy EQ 0) THEN write_cycle5_heavy, cycle_31a, schan_31a, pkt_epoch $
            ELSE IF (cycles5_heavy[num_cycles5_heavy-1] NE cycle_31a) THEN write_cycle5_heavy, cycle_31a, schan_31a, pkt_epoch $
                 ELSE check_cycle5_heavy, cycle_31a, schan_31a, version
        ENDIF ELSE BEGIN 
            schan_31a = fix(packet.dat[3+1])
            find_heavy_start, sat, pkt_epoch, cycle_31a, schan_31a, '31a', cycle_index, back_day
            IF back_day EQ 0 THEN BEGIN 
                cdf_varput, cdf_id, 's_chan_sw_z>2_h', schan_31a, rec_start = cycle_index
                cdf_varput, cdf_id, 'cycle_sw_z>2_h',  cycle_31a, rec_start = cycle_index
            ENDIF ELSE IF back_day EQ -1 THEN BEGIN 
                write_cycle_heavy_v10, cycle_31a, schan_31a, pkt_epoch
            ENDIF ELSE $
              write_old_heavy_v10, old_epoch, sat, -1, cycle_index, 'sw_z>2_h', temp_schan = schan_31a, temp_cycle = cycle_31a
        ENDELSE 
    ENDIF 
                                ; get data
    first_esa = seq * 4
    FOR i = 0, 3 DO BEGIN       ; 4 ESA per packet
        FOR j = 0, 7 DO BEGIN   ; 8 Pos
            FOR k = 0, 7 DO BEGIN ; 8 defl
                IF i MOD 2 EQ 0 THEN index = 4+(i*64)+(j*8)+k ELSE index = 4+(i*64)+(j*8)+7-k
                IF index MOD 2 EQ 0 THEN uncompress8, packet.dat[index-1], value ELSE $
                  uncompress8, packet.dat[index+1], value
                swz_h[(first_esa+i), j, k, 0] = value
            ENDFOR
        ENDFOR 
    ENDFOR 
    ; write at end of cycle comes from apid 31b
ENDELSE 
END 
